/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.Cube;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class MedianCut {
    static final int MAXCOLORS = 256;
    static final int HSIZE = 32768;
    private int[] hist;
    private int[] histPtr;
    private Cube[] list;
    private int[] pixels32;
    private int width;
    private int height;
    private IndexColorModel cm;

    public MedianCut(BufferedImage bufferedImage) {
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.pixels32 = bufferedImage.getRGB(0, 0, this.width, this.height, null, 0, this.width);
        this.hist = new int[32768];
        for (int i = 0; i < this.width * this.height; ++i) {
            int n;
            int n2 = n = this.rgb(this.pixels32[i]);
            this.hist[n2] = this.hist[n2] + 1;
        }
    }

    int getColorCount() {
        int n = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.hist[i] <= 0) continue;
            ++n;
        }
        return n;
    }

    Color getModalColor() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.hist[i] <= n) continue;
            n = this.hist[i];
            n2 = i;
        }
        return new Color(this.red(n2), this.green(n2), this.blue(n2));
    }

    private final int rgb(int n) {
        int n2 = (n & 0xF80000) >> 19;
        int n3 = (n & 0xF800) >> 6;
        int n4 = (n & 0xF8) << 7;
        return n4 | n3 | n2;
    }

    private final int red(int n) {
        return (n & 0x1F) << 3;
    }

    private final int green(int n) {
        return n >> 2 & 0xF8;
    }

    private final int blue(int n) {
        return n >> 7 & 0xF8;
    }

    public BufferedImage convert(int n) {
        return this.convertToByte(n);
    }

    public IndexColorModel buildColorModel(int n) {
        this.convertToByte(n);
        return this.cm;
    }

    public BufferedImage convertToByte(int n) {
        int n2;
        int n3 = 0;
        this.list = new Cube[256];
        this.histPtr = new int[32768];
        int n4 = 0;
        Cube cube = new Cube();
        int n5 = 0;
        for (n2 = 0; n2 <= Short.MAX_VALUE; ++n2) {
            if (this.hist[n2] == 0) continue;
            this.histPtr[n5++] = n2;
            cube.count += this.hist[n2];
        }
        cube.lower = 0;
        cube.upper = n5 - 1;
        cube.level = 0;
        this.Shrink(cube);
        this.list[n4++] = cube;
        while (n4 < n) {
            int n6 = 255;
            int n7 = -1;
            for (int i = 0; i <= n4 - 1; ++i) {
                if (this.list[i].lower == this.list[i].upper || this.list[i].level >= n6) continue;
                n6 = this.list[i].level;
                n7 = i;
            }
            if (n7 == -1) break;
            cube = this.list[n7];
            int n8 = cube.rmax - cube.rmin;
            int n9 = cube.gmax - cube.gmin;
            int n10 = cube.bmax - cube.bmin;
            if (n8 >= n9 && n8 >= n10) {
                n3 = 0;
            }
            if (n9 >= n8 && n9 >= n10) {
                n3 = 1;
            }
            if (n10 >= n8 && n10 >= n9) {
                n3 = 2;
            }
            this.reorderColors(this.histPtr, cube.lower, cube.upper, n3);
            this.quickSort(this.histPtr, cube.lower, cube.upper);
            this.restoreColorOrder(this.histPtr, cube.lower, cube.upper, n3);
            int n11 = 0;
            for (n2 = cube.lower; n2 <= cube.upper - 1 && n11 < cube.count / 2; n11 += this.hist[n5], ++n2) {
                n5 = this.histPtr[n2];
            }
            int n12 = n2;
            Cube cube2 = new Cube();
            cube2.lower = cube.lower;
            cube2.upper = n12 - 1;
            cube2.count = n11;
            cube2.level = cube.level + 1;
            this.Shrink(cube2);
            this.list[n7] = cube2;
            Cube cube3 = new Cube();
            cube3.lower = n12;
            cube3.upper = cube.upper;
            cube3.count = cube.count - n11;
            cube3.level = cube.level + 1;
            this.Shrink(cube3);
            this.list[n4++] = cube3;
        }
        this.makeInverseMap(this.hist, n4);
        return this.makeImage();
    }

    void Shrink(Cube cube) {
        int n = 255;
        int n2 = 0;
        int n3 = 255;
        int n4 = 0;
        int n5 = 255;
        int n6 = 0;
        for (int i = cube.lower; i <= cube.upper; ++i) {
            int n7 = this.histPtr[i];
            int n8 = this.red(n7);
            int n9 = this.green(n7);
            int n10 = this.blue(n7);
            if (n8 > n2) {
                n2 = n8;
            }
            if (n8 < n) {
                n = n8;
            }
            if (n9 > n4) {
                n4 = n9;
            }
            if (n9 < n3) {
                n3 = n9;
            }
            if (n10 > n6) {
                n6 = n10;
            }
            if (n10 >= n5) continue;
            n5 = n10;
        }
        cube.rmin = n;
        cube.rmax = n2;
        cube.gmin = n3;
        cube.gmax = n4;
        cube.bmin = n5;
        cube.bmax = n6;
    }

    void makeInverseMap(int[] nArray, int n) {
        int n2;
        int n3;
        Cube cube;
        int n4;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (n4 = 0; n4 <= n - 1; ++n4) {
            int n5;
            int n6;
            int n7;
            cube = this.list[n4];
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (n3 = cube.lower; n3 <= cube.upper; ++n3) {
                n2 = this.histPtr[n3];
                n7 = this.red(n2);
                f3 += (float)n7 * (float)nArray[n2];
                n6 = this.green(n2);
                f2 += (float)n6 * (float)nArray[n2];
                n5 = this.blue(n2);
                f += (float)n5 * (float)nArray[n2];
            }
            n7 = (int)(f3 / (float)cube.count);
            n6 = (int)(f2 / (float)cube.count);
            n5 = (int)(f / (float)cube.count);
            if (n7 == 248 && n6 == 248 && n5 == 248) {
                n5 = 255;
                n6 = 255;
                n7 = 255;
            }
            byArray[n4] = (byte)n7;
            byArray2[n4] = (byte)n6;
            byArray3[n4] = (byte)n5;
        }
        this.cm = new IndexColorModel(8, n, byArray, byArray2, byArray3);
        for (n4 = 0; n4 <= n - 1; ++n4) {
            cube = this.list[n4];
            for (n3 = cube.lower; n3 <= cube.upper; ++n3) {
                n2 = this.histPtr[n3];
                nArray[n2] = n4;
            }
        }
    }

    void reorderColors(int[] nArray, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                for (int i = n; i <= n2; ++i) {
                    int n4 = nArray[i];
                    int n5 = n4 & 0x1F;
                    nArray[i] = n5 << 10 | n4 >> 5;
                }
                break;
            }
            case 1: {
                for (int i = n; i <= n2; ++i) {
                    int n6 = nArray[i];
                    int n7 = n6 & 0x1F;
                    int n8 = n6 >> 5 & 0x1F;
                    int n9 = n6 >> 10;
                    nArray[i] = n8 << 10 | n9 << 5 | n7;
                }
                break;
            }
        }
    }

    void restoreColorOrder(int[] nArray, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                for (int i = n; i <= n2; ++i) {
                    int n4 = nArray[i];
                    int n5 = n4 >> 10;
                    nArray[i] = (n4 & 0x3FF) << 5 | n5;
                }
                break;
            }
            case 1: {
                for (int i = n; i <= n2; ++i) {
                    int n6 = nArray[i];
                    int n7 = n6 & 0x1F;
                    int n8 = n6 >> 10;
                    int n9 = n6 >> 5 & 0x1F;
                    nArray[i] = n9 << 10 | n8 << 5 | n7;
                }
                break;
            }
        }
    }

    void quickSort(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = nArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && nArray[n3] < n5) {
                    ++n3;
                }
                while (n4 > n && nArray[n4] > n5) {
                    --n4;
                }
                if (n3 > n4) continue;
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quickSort(nArray, n, n4);
            }
            if (n3 < n2) {
                this.quickSort(nArray, n3, n2);
            }
        }
    }

    BufferedImage makeImage() {
        byte[] byArray = new byte[this.width * this.height];
        for (int i = 0; i < this.width * this.height; ++i) {
            int n = this.rgb(this.pixels32[i]);
            byArray[i] = (byte)this.hist[n];
        }
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, 1, this.width, new int[]{0});
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBufferByte, null);
        return new BufferedImage(this.cm, writableRaster, false, null);
    }
}

