/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.SizeOption;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class Symbol {
    protected static final String NATO = "NATO Unit Symbols";
    protected static final String[] SYMBOL_SETS = new String[]{"NATO Unit Symbols"};
    protected String symbolSetName;
    protected String symbolName1;
    protected String symbolName2;
    protected String symbolSize;

    public Symbol(String string, String string2, String string3, String string4) {
        this.symbolSetName = string;
        this.symbolName1 = string2;
        this.symbolName2 = string3;
        this.symbolSize = string4;
    }

    public void draw(Graphics graphics, Rectangle rectangle, Color color, Color color2, Color color3, float f) {
        if (this.symbolSetName.equals(NATO)) {
            NatoUnitSymbolSet.draw(this.symbolName1, this.symbolName2, graphics, rectangle, color, color2, color3, f, this.symbolSize);
        }
    }

    public static class NatoUnitSymbolSet {
        protected static final String SZ_NONE = "None";
        protected static final String SZ_INSTALLATION = "Installation";
        protected static final String SZ_TEAM = "Team";
        protected static final String SZ_SQUAD = "Squad";
        protected static final String SZ_SECTION = "Section";
        protected static final String SZ_PLATOON = "Platoon";
        protected static final String SZ_ECHELON = "Echelon";
        protected static final String SZ_COMPANY = "Company";
        protected static final String SZ_BATTALION = "Battalion";
        protected static final String SZ_REGIMENT = "Regiment";
        protected static final String SZ_BRIGADE = "Brigade";
        protected static final String SZ_DIVISION = "Division";
        protected static final String SZ_CORPS = "Corps";
        protected static final String SZ_ARMY = "Army";
        protected static final String SZ_ARMY_GROUP = "Army Group";
        protected static final String SZ_REGION = "Region";
        protected static final String NONE = "None";
        protected static final String AIRBORNE = "Airborne";
        protected static final String AIR_DEFENCE = "Air Defence";
        protected static final String AIR_FORCE = "Air Force";
        protected static final String ANTI_TANK = "Anti Tank";
        protected static final String ARMORED = "Armored";
        protected static final String ARMY_AVIATION = "Army Aviation";
        protected static final String ARTILLERY = "Artillery";
        protected static final String COMMANDO = "Commando";
        protected static final String ENGINEERS = "Engineers";
        protected static final String GLIDER = "Glider-Borne";
        protected static final String GUERILLA = "Guerilla";
        protected static final String INFANTRY = "Infantry";
        protected static final String MARINES = "Marines";
        protected static final String MOUNTAIN = "Mountain";
        protected static final String NAVY = "";
        protected static final String RECON = "Cavalry/Recon";
        protected static final String INSTALLATION_SYMBOL = "m";
        protected static final String TEAM_SYMBOL = "o";
        protected static final String SQUAD_SYMBOL = "s";
        protected static final String COMPANY_SYMBOL = "i";
        protected static final String BRIGADE_SYMBOL = "x";
        protected static String[] sizeNames;
        protected static final SizeOption[] SIZES;

        protected static final String[] getSymbolNames() {
            return new String[]{"None", INFANTRY, RECON, ARMORED, ARTILLERY, ENGINEERS, AIRBORNE, AIR_DEFENCE, AIR_FORCE, ANTI_TANK, ARMY_AVIATION, COMMANDO, GLIDER, GUERILLA, MOUNTAIN, NAVY};
        }

        protected static String[] getSymbolSizes() {
            if (sizeNames == null) {
                sizeNames = new String[SIZES.length];
                for (int i = 0; i < SIZES.length; ++i) {
                    NatoUnitSymbolSet.sizeNames[i] = SIZES[i].getName();
                }
            }
            return sizeNames;
        }

        protected static SizeOption findSize(String string) {
            for (int i = 0; i < SIZES.length; ++i) {
                if (!string.equals(SIZES[i].getName())) continue;
                return SIZES[i];
            }
            return SIZES[0];
        }

        protected static void draw(String string, String string2, Graphics graphics, Rectangle rectangle, Color color, Color color2, Color color3, float f, String string3) {
            if (color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics.setColor(color);
            BasicStroke basicStroke = new BasicStroke(f, 1, 1);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(basicStroke);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color3);
            NatoUnitSymbolSet.drawSize(graphics, string3, rectangle);
            graphics.setColor(color);
            NatoUnitSymbolSet.draw(graphics, f, string, rectangle, false);
            NatoUnitSymbolSet.draw(graphics, f, string2, rectangle, true);
        }

        protected static void draw(Graphics graphics, float f, String string, Rectangle rectangle, boolean bl) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            BasicStroke basicStroke = new BasicStroke(f, 1, 1);
            graphics2D.setStroke(basicStroke);
            int n = rectangle.x;
            int n2 = rectangle.x + rectangle.width / 2 + 1;
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y;
            int n5 = rectangle.y + rectangle.height / 2;
            int n6 = rectangle.y + rectangle.height;
            if (!string.equals("None")) {
                if (string.equals(AIRBORNE)) {
                    int n7 = n2 - rectangle.width / 4;
                    int n8 = n4 + rectangle.height * 4 / 5 + 1;
                    graphics2D.draw(new Arc2D.Double(n7, n8, rectangle.width / 4, rectangle.height / 4, 0.0, 180.0, 0));
                    graphics2D.draw(new Arc2D.Double(n2, n8, rectangle.width / 4, rectangle.height / 4, 0.0, 180.0, 0));
                } else if (string.equals(AIR_DEFENCE)) {
                    graphics2D.draw(new Arc2D.Double(n, n4 + rectangle.height / 4, rectangle.width, (double)rectangle.height * 1.5, 0.0, 180.0, 0));
                } else if (string.equals(AIR_FORCE)) {
                    int n9 = (int)((double)rectangle.width * 0.15);
                    int n10 = (int)((double)rectangle.width * 0.2);
                    int n11 = (int)((double)rectangle.height * 0.35);
                    graphics.drawLine(n2 - n10, n4 + n11, n2 + n10, n6 - n11);
                    graphics.drawLine(n2 + n10, n4 + n11, n2 - n10, n6 - n11);
                    graphics2D.draw(new Arc2D.Double(n2 - n10 - n9, n4 + n11, n9 * 2, rectangle.height - 2 * n11, 90.0, 180.0, 0));
                    graphics2D.draw(new Arc2D.Double(n2 + n10 - n9, n4 + n11, n9 * 2, rectangle.height - 2 * n11, 270.0, 180.0, 0));
                } else if (string.equals(ANTI_TANK)) {
                    graphics.drawLine(n, n6, n2, n4);
                    graphics.drawLine(n2, n4, n3, n6);
                } else if (string.equals(ARMORED)) {
                    int n12 = (int)((double)rectangle.height * 0.25);
                    int n13 = (int)((double)rectangle.width * 0.15);
                    int n14 = (int)((double)rectangle.width * 0.2);
                    graphics.drawLine(n + n13 + n14, n4 + n12, n3 - n13 - n14, n4 + n12);
                    graphics.drawLine(n + n13 + n14, n6 - n12, n3 - n13 - n14, n6 - n12);
                    graphics2D.draw(new Arc2D.Double(n + n13, n4 + n12, n14 * 2, rectangle.height - n12 * 2, 90.0, 180.0, 0));
                    graphics2D.draw(new Arc2D.Double(n3 - n13 - 2 * n14, n4 + n12, n14 * 2, rectangle.height - n12 * 2, 270.0, 180.0, 0));
                } else if (string.equals(ARMY_AVIATION)) {
                    int n15 = (int)((double)rectangle.height * 0.25);
                    int n16 = (int)((double)rectangle.height * 0.33);
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(n + n15, n4 + n16);
                    generalPath.lineTo(n3 - n16, n6 - n16);
                    generalPath.lineTo(n3 - n16, n4 + n16);
                    generalPath.lineTo(n + n15, n6 - n16);
                    generalPath.closePath();
                    graphics2D.draw(generalPath);
                } else if (string.equals(ARTILLERY)) {
                    int n17 = rectangle.height / 5;
                    int n18 = bl ? (int)((double)rectangle.height * 0.2) : 0;
                    graphics.fillOval(n2 - n17, n5 - n17 + n18, n17 * 2, n17 * 2);
                } else if (string.equals(COMMANDO)) {
                    graphics.drawLine(n, n4, n3, n6);
                    graphics.drawLine(n, n6, n3, n4);
                    int n19 = (int)((double)rectangle.width / 2.5);
                    int n20 = (int)((double)rectangle.height / 2.5);
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(n, n4);
                    generalPath.lineTo(n + n19, n4);
                    generalPath.lineTo(n + n19, n4 + n20);
                    generalPath.lineTo(n, n4);
                    generalPath.moveTo(n3, n4);
                    generalPath.lineTo(n3 - n19, n4);
                    generalPath.lineTo(n3 - n19, n4 + n20);
                    generalPath.lineTo(n3, n4);
                    graphics2D.fill(generalPath);
                } else if (string.equals(ENGINEERS)) {
                    BasicStroke basicStroke2 = (BasicStroke)graphics2D.getStroke();
                    BasicStroke basicStroke3 = new BasicStroke(basicStroke2.getLineWidth() * 1.2f, 1, 1);
                    graphics2D.setStroke(basicStroke3);
                    int n21 = (int)((double)rectangle.height * 0.2);
                    int n22 = bl ? n6 - n21 - 1 : n4 + (rectangle.height - n21) / 2;
                    int n23 = n22 + n21;
                    int n24 = n2 - rectangle.width / 5;
                    int n25 = n2 + rectangle.width / 5;
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(n24, n23);
                    generalPath.lineTo(n24, n22);
                    generalPath.lineTo(n25, n22);
                    generalPath.lineTo(n25, n23);
                    generalPath.moveTo(n2, n23);
                    generalPath.lineTo(n2, n22);
                    graphics2D.draw(generalPath);
                } else if (string.equals(GLIDER)) {
                    graphics.drawLine(n + (n2 - n) / 3, n5, n3 - (n2 - n) / 3, n5);
                } else if (string.equals(GUERILLA)) {
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(n, n4);
                    generalPath.lineTo(n3, n6);
                    generalPath.lineTo(n3, n4);
                    generalPath.lineTo(n, n6);
                    generalPath.lineTo(n, n4);
                    graphics2D.fill(generalPath);
                } else if (string.equals(INFANTRY)) {
                    graphics.drawLine(n, n4, n3, n6);
                    graphics.drawLine(n, n6, n3, n4);
                } else if (!string.equals(MARINES)) {
                    if (string.equals(MOUNTAIN)) {
                        int n26 = rectangle.width / 6;
                        GeneralPath generalPath = new GeneralPath();
                        generalPath.moveTo(n2, n5);
                        generalPath.lineTo(n2 + n26, n6);
                        generalPath.lineTo(n2 - n26, n6);
                        generalPath.closePath();
                        graphics2D.fill(generalPath);
                    } else if (string.equals(NAVY)) {
                        int n27 = (int)((double)rectangle.height * 0.2);
                        int n28 = (int)((double)rectangle.height * 0.15);
                        int n29 = (int)((double)rectangle.width * 0.15);
                        int n30 = (int)((double)rectangle.width * 0.3);
                        graphics.drawLine(n2, n4 + n27, n2, n6 - n27);
                        graphics.drawLine(n2 - n29, n4 + n27 + n28, n2 + n29, n4 + n27 + n28);
                        graphics2D.draw(new Arc2D.Double(n2 - n30, n4 + n27, n30 * 2, rectangle.height - 2 * n27, 225.0, 90.0, 0));
                    } else if (string.equals(RECON)) {
                        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y);
                    }
                }
            }
        }

        protected static void drawSize(Graphics graphics, String string, Rectangle rectangle) {
            if (string.equals("None") || string.equals(NAVY)) {
                return;
            }
            SizeOption sizeOption = NatoUnitSymbolSet.findSize(string);
            String string2 = sizeOption.getType();
            int n = sizeOption.getCount();
            int n2 = rectangle.height / 3;
            int n3 = n <= 4 ? rectangle.width / 5 : rectangle.width / 7;
            int n4 = rectangle.width / 15;
            BufferedImage bufferedImage = NatoUnitSymbolSet.buildSizeImage(graphics, n, string2, n3, n2, n4);
            int n5 = rectangle.x + rectangle.width / 2 - bufferedImage.getWidth() / 2 + n4;
            int n6 = rectangle.y - n2 - 1;
            graphics.drawImage(bufferedImage, n5, n6, null);
        }

        public static BufferedImage buildSizeImage(String string, int n, int n2, int n3) {
            SizeOption sizeOption = NatoUnitSymbolSet.findSize(string);
            String string2 = sizeOption.getType();
            int n4 = sizeOption.getCount();
            BufferedImage bufferedImage = NatoUnitSymbolSet.createImage(n4, n, n2, n3);
            Graphics graphics = bufferedImage.getGraphics();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setBackground(null);
            graphics.setColor(Color.BLACK);
            return NatoUnitSymbolSet.buildSizeImage(graphics, n4, string2, n, n2, n3);
        }

        protected static BufferedImage createImage(int n, int n2, int n3, int n4) {
            int n5 = n2 * n + n4 * (n - 1) + 1;
            if (n5 < 1) {
                n5 = n2;
            }
            BufferedImage bufferedImage = new BufferedImage(n5, n3 + 1, 2);
            return bufferedImage;
        }

        public static BufferedImage buildSizeImage(Graphics graphics, int n, String string, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            BufferedImage bufferedImage = string.equals(INSTALLATION_SYMBOL) ? NatoUnitSymbolSet.createImage(n, n2 * 3, n3, n4) : NatoUnitSymbolSet.createImage(n, n2, n3, n4);
            Graphics graphics2 = bufferedImage.getGraphics();
            Graphics2D graphics2D2 = (Graphics2D)graphics2;
            graphics2.setColor(graphics.getColor());
            graphics2D2.setBackground(null);
            graphics2D2.setStroke(graphics2D.getStroke());
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                if (string.equals(TEAM_SYMBOL)) {
                    int n6 = n2 / 2;
                    graphics2.drawOval(n5, n3 / 3, n6 * 2, n6 * 2);
                    graphics2.drawLine(n5, n3, n5 + n2, 0);
                } else if (string.equals(SQUAD_SYMBOL)) {
                    int n7 = n2 / 2;
                    graphics2.fillOval(n5, n3 / 3, n7 * 2, n7 * 2);
                } else if (string.equals(COMPANY_SYMBOL)) {
                    graphics2.drawLine(n5 + n2 / 2, 0, n5 + n2 / 2, n3);
                } else if (string.equals(BRIGADE_SYMBOL)) {
                    BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1);
                    graphics2D.setStroke(basicStroke);
                    graphics2.drawLine(n5, 0, n5 + n2, n3);
                    graphics2.drawLine(n5, n3, n5 + n2, 0);
                } else if (string.equals(INSTALLATION_SYMBOL)) {
                    graphics2.fillRect(n5, n3 / 2, n5 + 3 * n2, n3);
                }
                n5 += n2 + n4;
            }
            return bufferedImage;
        }

        static {
            SIZES = new SizeOption[]{new SizeOption("None", 0, NAVY), new SizeOption(SZ_INSTALLATION, 1, INSTALLATION_SYMBOL), new SizeOption(SZ_TEAM, 1, TEAM_SYMBOL), new SizeOption(SZ_SQUAD, 1, SQUAD_SYMBOL), new SizeOption(SZ_SECTION, 2, SQUAD_SYMBOL), new SizeOption(SZ_PLATOON, 3, SQUAD_SYMBOL), new SizeOption(SZ_ECHELON, 4, SQUAD_SYMBOL), new SizeOption(SZ_COMPANY, 1, COMPANY_SYMBOL), new SizeOption(SZ_BATTALION, 2, COMPANY_SYMBOL), new SizeOption(SZ_REGIMENT, 3, COMPANY_SYMBOL), new SizeOption(SZ_BRIGADE, 1, BRIGADE_SYMBOL), new SizeOption(SZ_DIVISION, 2, BRIGADE_SYMBOL), new SizeOption(SZ_CORPS, 3, BRIGADE_SYMBOL), new SizeOption(SZ_ARMY, 4, BRIGADE_SYMBOL), new SizeOption(SZ_ARMY_GROUP, 5, BRIGADE_SYMBOL), new SizeOption(SZ_REGION, 6, BRIGADE_SYMBOL)};
        }
    }
}

