/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.Symbol;
import VASSAL.build.module.gamepieceimage.SymbolItemInstance;
import VASSAL.configure.StringEnum;
import VASSAL.tools.SequenceEncoder;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

public class SymbolItem
extends Item {
    public static final String TYPE = "Symbol";
    protected static final String SET = "set";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String LINE_WIDTH = "linewidth";
    protected String symbolSet = "";
    protected int height = 30;
    protected int width = 40;
    protected double lineWidth = 1.0;
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$SymbolItem$SetConfig;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public SymbolItem() {
    }

    public SymbolItem(GamePieceLayout gamePieceLayout) {
        super(gamePieceLayout);
        this.width = this.getLayout().getLayoutWidth() / 2;
        this.height = (int)((double)this.width * 0.75);
    }

    public SymbolItem(GamePieceLayout gamePieceLayout, String string) {
        this(gamePieceLayout);
        this.setConfigureName(string);
    }

    public String[] getAttributeDescriptions() {
        String[] stringArray = new String[]{"Symbol Set:  ", "Width:  ", "Height:  ", "Line Width:  "};
        String[] stringArray2 = super.getAttributeDescriptions();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, 2);
        System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
        System.arraycopy(stringArray2, 2, stringArray3, stringArray.length + 2, stringArray2.length - 2);
        return stringArray3;
    }

    public Class[] getAttributeTypes() {
        Class[] classArray = new Class[]{class$VASSAL$build$module$gamepieceimage$SymbolItem$SetConfig == null ? (class$VASSAL$build$module$gamepieceimage$SymbolItem$SetConfig = SymbolItem.class$("VASSAL.build.module.gamepieceimage.SymbolItem$SetConfig")) : class$VASSAL$build$module$gamepieceimage$SymbolItem$SetConfig, class$java$lang$Integer == null ? (class$java$lang$Integer = SymbolItem.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = SymbolItem.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = SymbolItem.class$("java.lang.Double")) : class$java$lang$Double};
        Class[] classArray2 = super.getAttributeTypes();
        Class[] classArray3 = new Class[classArray.length + classArray2.length];
        System.arraycopy(classArray2, 0, classArray3, 0, 2);
        System.arraycopy(classArray, 0, classArray3, 2, classArray.length);
        System.arraycopy(classArray2, 2, classArray3, classArray.length + 2, classArray2.length - 2);
        return classArray3;
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{SET, WIDTH, HEIGHT, LINE_WIDTH};
        String[] stringArray2 = super.getAttributeNames();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, 2);
        System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
        System.arraycopy(stringArray2, 2, stringArray3, stringArray.length + 2, stringArray2.length - 2);
        return stringArray3;
    }

    public void setAttribute(String string, Object object) {
        if (!SET.equals(string)) {
            if (WIDTH.equals(string)) {
                if (object instanceof String) {
                    object = new Integer((String)object);
                }
                this.width = (Integer)object;
            } else if (HEIGHT.equals(string)) {
                if (object instanceof String) {
                    object = new Integer((String)object);
                }
                this.height = (Integer)object;
            } else if (LINE_WIDTH.equals(string)) {
                if (object instanceof String) {
                    object = new Double(Double.parseDouble((String)object));
                }
                this.lineWidth = (Double)object;
            } else {
                super.setAttribute(string, object);
            }
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    public String getAttributeValueString(String string) {
        if (SET.equals(string)) {
            return this.symbolSet;
        }
        if (WIDTH.equals(string)) {
            return this.width + "";
        }
        if (HEIGHT.equals(string)) {
            return this.height + "";
        }
        if (LINE_WIDTH.equals(string)) {
            return this.lineWidth + "";
        }
        return super.getAttributeValueString(string);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void draw(Graphics graphics, GamePieceImage gamePieceImage) {
        SymbolItemInstance symbolItemInstance = null;
        if (gamePieceImage != null) {
            symbolItemInstance = gamePieceImage.getSymbolInstance(this.getConfigureName());
        }
        Symbol symbol = null;
        if (symbolItemInstance == null) {
            symbol = new Symbol("NATO Unit Symbols", "Infantry", "None", "Division");
            symbolItemInstance = new SymbolItemInstance();
        } else {
            symbol = new Symbol("NATO Unit Symbols", symbolItemInstance.getSymbol1(), symbolItemInstance.getSymbol2(), symbolItemInstance.getSize());
        }
        Point point = this.layout.getPosition(this);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.getWidth(), this.getHeight());
        if (this.getRotation() != 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(this.getRotation()), this.layout.getPosition((Item)this).x, this.layout.getPosition((Item)this).y);
            graphics2D.transform(affineTransform);
        }
        if (this.isAntialias()) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        symbol.draw(graphics, rectangle, symbolItemInstance.getFgColor().getColor(), symbolItemInstance.getBgColor().getColor(), symbolItemInstance.getSizeColor().getColor(), (float)this.lineWidth);
    }

    public String getType() {
        return TYPE;
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public static Item decode(GamePieceLayout gamePieceLayout, String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        SymbolItem symbolItem = new SymbolItem(gamePieceLayout);
        decoder.nextToken();
        symbolItem.width = decoder.nextInt(54);
        symbolItem.height = decoder.nextInt(54);
        symbolItem.lineWidth = decoder.nextDouble(1.0);
        return symbolItem;
    }

    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(TYPE, ';');
        sequenceEncoder.append(this.width);
        sequenceEncoder.append(this.height);
        sequenceEncoder.append(this.lineWidth);
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(sequenceEncoder.getValue(), '|');
        sequenceEncoder2.append(super.encode());
        return sequenceEncoder2.getValue();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SetConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return Symbol.SYMBOL_SETS;
        }
    }
}

