/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.Visualizable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Visualizer
extends JPanel {
    protected static final int OFFSET = 20;
    protected Visualizable observer;
    protected JPanel visPanel;

    public Visualizer() {
    }

    public Visualizer(Visualizable visualizable) {
        this.observer = visualizable;
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.visPanel = new JPanel(){

            public void paint(Graphics graphics) {
                graphics.clearRect(0, 0, Visualizer.this.observer.getVisualizerWidth(), Visualizer.this.observer.getVisualizerHeight());
                graphics.drawImage(Visualizer.this.observer.getVisualizerImage(), 0, 0, this);
            }
        };
        this.add((Component)this.visPanel, "Center");
    }

    public void setObserver(Visualizable visualizable) {
        this.observer = visualizable;
        this.rebuild();
        this.refresh();
    }

    public void rebuild() {
        if (this.observer != null) {
            this.observer.rebuildVisualizerImage();
            this.refresh();
        }
    }

    public void refresh() {
        if (this.observer != null) {
            int n = this.observer.getVisualizerWidth();
            int n2 = this.observer.getVisualizerHeight();
            this.visPanel.setSize(n, n2);
            this.visPanel.setPreferredSize(new Dimension(n, n2));
            this.setSize(n + 20, n2 + 20);
            this.setPreferredSize(new Dimension(n + 20, n2 + 20));
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.pack();
            }
            this.repaint();
        }
    }
}

