/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.BoardSlot;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.Configurer;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BoardPicker
extends JDialog
implements ActionListener,
GameComponent,
Configurable,
CommandEncoder,
ValidityChecker {
    public static final String ID = "BoardPicker";
    protected Vector possibleBoards = new Vector();
    protected Vector currentBoards = null;
    private Dimension psize = new Dimension(350, 125);
    private double slotScale = 0.2;
    protected JTextField status;
    protected JButton cancelButton;
    protected Map map;
    protected JPanel slotPanel;
    protected String version = "0.0";
    protected int nx = 1;
    protected int ny = 1;
    protected JToolBar controls;
    protected JButton addRowButton;
    protected JButton addColumnButton;
    protected boolean allowMultiple = false;
    protected int maxColumns;
    protected String title = "Choose Boards";
    protected String addRowButtonText = "Add row";
    protected String addColumnButtonText = "Add column";
    protected String boardPrompt = "Select board";
    protected String defaultSetup;
    protected Vector multipleButtons;
    public static final String SCALE = "slotScale";
    public static final String SLOT_HEIGHT = "slotHeight";
    public static final String SLOT_WIDTH = "slotWidth";
    public static final String SETUP = "setup";
    public static final String DIALOG_TITLE = "title";
    public static final String ADD_ROW_BUTTON_TEXT = "addRowText";
    public static final String ADD_COLUMN_BUTTON_TEXT = "addColumnText";
    public static final String BOARD_PROMPT = "boardPrompt";
    public static final String MAX_COLUMNS = "maxColumns";
    private JButton clearButton;
    private JButton okButton;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$Board;

    public BoardPicker() {
        super((Frame)null, true);
    }

    protected void initComponents() {
        this.multipleButtons = new Vector();
        this.setTitle(this.title);
        this.status = new JTextField("");
        this.status.setEditable(false);
        this.slotPanel = new JPanel();
        this.controls = new JToolBar();
        this.controls.setFloatable(false);
        this.controls.setLayout(new BoxLayout(this.controls, 1));
        this.okButton = this.addButton("Ok");
        this.cancelButton = this.addButton("Cancel");
        this.addRowButton = this.addButton(this.addRowButtonText);
        this.multipleButtons.addElement(this.addRowButton);
        this.addColumnButton = this.addButton(this.addColumnButtonText);
        this.multipleButtons.addElement(this.addColumnButton);
        this.clearButton = this.addButton("Clear");
        this.multipleButtons.addElement(this.clearButton);
        this.setAllowMultiple(this.allowMultiple);
        this.getContentPane().add("North", this.status);
        JPanel jPanel = new JPanel();
        jPanel.add(this.controls);
        this.getContentPane().add("West", jPanel);
        this.getContentPane().add("Center", new ScrollPane(this.slotPanel));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BoardPicker.this.cancel();
            }
        });
        this.reset();
        ((Component)this).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
    }

    public Dimension getDefaultSlotSize() {
        return this.psize;
    }

    public double getSlotScale() {
        return this.slotScale;
    }

    public void warn(String string) {
        if (this.status != null) {
            this.status.setText(string);
        }
    }

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.setBoardPicker(this);
        Enumeration enumeration = this.possibleBoards.elements();
        while (enumeration.hasMoreElements()) {
            ((Board)enumeration.nextElement()).setMap(this.map);
        }
    }

    public void build(Element element) {
        if (element == null) {
            Board board = new Board();
            board.build(null);
            board.addTo(this);
        } else {
            Object object;
            NodeList nodeList = element.getElementsByTagName(SETUP);
            if (nodeList.getLength() > 0) {
                object = (Element)nodeList.item(0);
                this.defaultSetup = Builder.getText((Element)object);
                Node node = object.getNextSibling();
                element.removeChild((Node)object);
                Builder.build(element, this);
                element.insertBefore((Node)object, node);
            } else {
                Builder.build(element, this);
            }
            try {
                this.psize = new Dimension(Integer.parseInt(element.getAttribute(SLOT_WIDTH)), Integer.parseInt(element.getAttribute(SLOT_HEIGHT)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.slotScale = Double.valueOf(element.getAttribute(SCALE));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxColumns = Integer.parseInt(element.getAttribute(MAX_COLUMNS));
            }
            catch (Exception exception) {
                this.maxColumns = 0;
            }
            object = element.getAttribute(DIALOG_TITLE);
            if (object != null && ((String)object).length() > 0) {
                this.title = object;
            }
            if ((object = element.getAttribute(ADD_ROW_BUTTON_TEXT)) != null && ((String)object).length() > 0) {
                this.addRowButtonText = object;
            }
            if ((object = element.getAttribute(ADD_COLUMN_BUTTON_TEXT)) != null && ((String)object).length() > 0) {
                this.addColumnButtonText = object;
            }
            if ((object = element.getAttribute(BOARD_PROMPT)) != null && ((String)object).length() > 0) {
                this.boardPrompt = object;
            }
        }
    }

    public void validate(Buildable buildable, ValidationReport validationReport) {
        if (this.possibleBoards.size() == 0) {
            validationReport.addWarning("Must define at least one board in " + ConfigureTree.getConfigureName(this.map));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration enumeration = this.possibleBoards.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Board)) continue;
            Board board = (Board)e;
            if (hashSet.contains(board.getName())) {
                validationReport.addWarning("More than one board named '" + board.getName() + "' in " + ConfigureTree.getConfigureName(this.map));
            }
            hashSet.add(board.getName());
            board.validate(board, validationReport);
        }
    }

    private String getDefaultSetup() {
        Board board;
        String string = this.defaultSetup;
        if ((this.defaultSetup == null || this.defaultSetup.length() == 0) && this.possibleBoards.size() == 1 && this.possibleBoards.firstElement() instanceof Board && !"true".equals((board = (Board)this.possibleBoards.firstElement()).getAttributeValueString("reversible"))) {
            Vector<Board> vector = new Vector<Board>();
            vector.addElement(board);
            string = this.encode(new SetBoards(this, vector));
        }
        return string;
    }

    public void add(Buildable buildable) {
        this.possibleBoards.addElement(buildable);
    }

    public void remove(Buildable buildable) {
        this.possibleBoards.removeElement(buildable);
    }

    public void removeFrom(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return "Map Boards";
    }

    public String getConfigureName() {
        return null;
    }

    public String getBoardDelimiter() {
        return "bd\t";
    }

    public HelpFile getHelpFile() {
        return null;
    }

    public Configurer getConfigurer() {
        return new Config();
    }

    public Configurable[] getConfigureComponents() {
        Configurable[] configurableArray = new Configurable[this.possibleBoards.size()];
        for (int i = 0; i < this.possibleBoards.size(); ++i) {
            configurableArray[i] = (Board)this.possibleBoards.elementAt(i);
        }
        return configurableArray;
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$module$map$boardPicker$Board == null ? (class$VASSAL$build$module$map$boardPicker$Board = BoardPicker.class$("VASSAL.build.module.map.boardPicker.Board")) : class$VASSAL$build$module$map$boardPicker$Board};
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void setBoards(Enumeration enumeration) {
        Board board;
        this.reset();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            board = (Board)iterator.next();
            if (board.relativePosition().x > this.nx - 1) {
                this.addColumn();
            }
            if (board.relativePosition().y <= this.ny - 1) continue;
            this.addRow();
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            board = (Board)iterator.next();
            this.getSlot(board.relativePosition().x + this.nx * board.relativePosition().y).setBoard(board);
        }
        this.pack();
    }

    public void pack() {
        super.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width - this.getLocation().x;
        int n2 = dimension.height - this.getLocation().y;
        ((Component)this).setSize(Math.min(this.getSize().width, n), Math.min(this.getSize().height, n2));
    }

    protected void selectBoards() {
        if (this.currentBoards != null) {
            this.setBoards(this.currentBoards.elements());
        } else {
            this.reset();
        }
        this.cancelButton.setVisible(false);
        ((Component)this).setVisible(true);
        this.cancelButton.setVisible(true);
        this.defaultSetup = this.currentBoards != null && this.currentBoards.size() > 0 ? this.encode(new SetBoards(this, this.currentBoards)) : null;
    }

    public Enumeration getCurrentBoards() {
        return this.currentBoards == null ? Collections.enumeration(Collections.EMPTY_LIST) : this.currentBoards.elements();
    }

    public String[] getAllowableBoardNames() {
        String[] stringArray = new String[this.possibleBoards.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Board)this.possibleBoards.elementAt(i)).getName();
        }
        return stringArray;
    }

    public Board getBoard(String string) {
        Enumeration enumeration = this.possibleBoards.elements();
        while (enumeration.hasMoreElements()) {
            Board board = (Board)enumeration.nextElement();
            if (!board.getName().equals(string)) continue;
            return board;
        }
        this.warn("Board " + string + " not found");
        return null;
    }

    public void setup(boolean bl) {
        if (bl) {
            if (this.currentBoards == null) {
                Command command;
                String string = this.getDefaultSetup();
                if (string != null && (command = this.decode(string)) != null) {
                    command.execute();
                }
                if ((this.currentBoards == null || this.currentBoards.size() == 0) && this.possibleBoards.size() > 0) {
                    this.reset();
                    ((Component)this).setVisible(true);
                }
            }
            this.map.setBoards(this.getCurrentBoards());
        } else {
            this.currentBoards = null;
        }
    }

    public Command getRestoreCommand() {
        return new SetBoards(this, this.currentBoards);
    }

    protected JButton addButton(String string) {
        return this.addButton(string, -1);
    }

    protected JButton addButton(String string, int n) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        this.controls.add(jButton, null, n);
        return jButton;
    }

    protected void addRow() {
        this.slotPanel.setLayout(new GridLayout(++this.ny, this.nx));
        for (int i = 0; i < this.nx; ++i) {
            this.slotPanel.add((Component)new BoardSlot(this, this.boardPrompt), -1);
        }
        this.slotPanel.revalidate();
        this.pack();
    }

    protected void addColumn() {
        this.slotPanel.setLayout(new GridLayout(this.ny, ++this.nx));
        for (int i = 0; i < this.ny; ++i) {
            this.slotPanel.add((Component)new BoardSlot(this, this.boardPrompt), (i + 1) * this.nx - 1);
        }
        this.slotPanel.revalidate();
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.addColumnButton == actionEvent.getSource()) {
            if (this.maxColumns == 0 || this.nx < this.maxColumns) {
                this.addColumn();
            } else {
                this.addRow();
            }
        } else if (this.addRowButton == actionEvent.getSource()) {
            this.addRow();
        } else if (this.clearButton == actionEvent.getSource()) {
            this.reset();
        } else if (this.okButton == actionEvent.getSource()) {
            this.currentBoards = new Vector(this.getBoardsFromControls());
            ((Component)this).setVisible(false);
        } else if (this.cancelButton == actionEvent.getSource()) {
            this.cancel();
        }
    }

    protected void cancel() {
        GameModule.getGameModule().getGameState().setup(false);
        ((Component)this).setVisible(false);
    }

    public Vector pickBoards() {
        return new Vector(this.getBoardsFromControls());
    }

    public List getBoardsFromControls() {
        ArrayList<Board> arrayList = new ArrayList<Board>();
        if (this.controls != null) {
            for (int i = 0; i < this.nx; ++i) {
                for (int j = 0; j < this.ny; ++j) {
                    Board board;
                    BoardSlot boardSlot = this.getSlot(i + this.nx * j);
                    if (boardSlot == null || (board = boardSlot.getBoard()) == null) continue;
                    board.relativePosition().move(i, j);
                    arrayList.add(board);
                }
            }
        }
        return arrayList;
    }

    public void reset() {
        if (this.controls == null) {
            this.initComponents();
        } else {
            this.warn("");
            this.removeAllBoards();
            this.slotPanel.add((Component)new BoardSlot(this, this.boardPrompt), 0);
            this.pack();
        }
    }

    public int getRowCount() {
        return this.ny;
    }

    public int getColumnCount() {
        return this.ny;
    }

    public BoardSlot getNeighbor(BoardSlot boardSlot, int n, int n2) {
        int n3;
        int n4 = -1;
        int n5 = -1;
        block0: for (n3 = 0; n3 < this.nx; ++n3) {
            for (int i = 0; i < this.ny; ++i) {
                if (this.getSlot(n3 + i * this.nx) == boardSlot) {
                    n4 = n3;
                    n5 = i;
                    continue block0;
                }
                if (n4 >= 0 && n5 >= 0) continue block0;
            }
        }
        if ((n4 += n) < 0 || n4 >= this.nx || (n5 += n2) < 0 || n5 >= this.ny) {
            return null;
        }
        n3 = n4 + n5 * this.nx;
        if (n3 < 0 || n3 >= this.nx * this.ny) {
            return null;
        }
        return this.getSlot(n3);
    }

    public BoardSlot getSlot(int n) {
        return n >= 0 && n < this.slotPanel.getComponentCount() ? (BoardSlot)this.slotPanel.getComponent(n) : null;
    }

    public void repaintAll() {
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                this.getSlot(i + this.nx * j).repaint();
            }
        }
    }

    protected void removeAllBoards() {
        this.slotPanel.removeAll();
        this.slotPanel.setLayout(new GridLayout(1, 1));
        this.ny = 1;
        this.nx = 1;
    }

    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public void setAllowMultiple(boolean bl) {
        this.allowMultiple = bl;
        if (this.multipleButtons != null) {
            Enumeration enumeration = this.multipleButtons.elements();
            while (enumeration.hasMoreElements()) {
                ((JButton)enumeration.nextElement()).setVisible(this.allowMultiple);
            }
        }
    }

    public Element getBuildElement(Document document) {
        Object object;
        Element element = document.createElement(this.getClass().getName());
        element.setAttribute(SLOT_WIDTH, String.valueOf(this.psize.width));
        element.setAttribute(SLOT_HEIGHT, String.valueOf(this.psize.height));
        element.setAttribute(SCALE, String.valueOf(this.getSlotScale()));
        element.setAttribute(DIALOG_TITLE, this.title);
        element.setAttribute(ADD_ROW_BUTTON_TEXT, this.addRowButtonText);
        element.setAttribute(ADD_COLUMN_BUTTON_TEXT, this.addColumnButtonText);
        element.setAttribute(BOARD_PROMPT, this.boardPrompt);
        if (this.maxColumns > 0) {
            element.setAttribute(MAX_COLUMNS, String.valueOf(this.maxColumns));
        }
        if (this.defaultSetup != null) {
            object = document.createElement(SETUP);
            object.appendChild(document.createTextNode(this.defaultSetup));
            element.appendChild((Node)object);
        }
        object = this.possibleBoards.elements();
        while (object.hasMoreElements()) {
            Board board = (Board)object.nextElement();
            element.appendChild(board.getBuildElement(document));
        }
        return element;
    }

    public Command decode(String string) {
        if (string.startsWith(this.map.getId() + ID) || string.startsWith(this.map.getConfigureName() + ID)) {
            Vector<Board> vector = new Vector<Board>();
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
            while (decoder.hasMoreTokens()) {
                SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), '/');
                String string2 = decoder2.nextToken();
                boolean bl = false;
                if (decoder2.hasMoreTokens()) {
                    bl = "rev".equals(decoder2.nextToken());
                }
                Point point = new Point(decoder.nextInt(0), decoder.nextInt(0));
                Board board = this.getBoard(string2);
                if (board == null) continue;
                if (vector.contains(board)) {
                    board = board.copy();
                }
                board.setReversed(bl);
                board.relativePosition().move(point.x, point.y);
                vector.addElement(board);
            }
            return new SetBoards(this, vector);
        }
        return null;
    }

    public String encode(Command command) {
        if (command instanceof SetBoards && this.map != null && ((SetBoards)command).target == this) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(this.map.getIdentifier() + ID, '\t');
            Vector vector = ((SetBoards)command).bds;
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Board board = (Board)enumeration.nextElement();
                    SequenceEncoder sequenceEncoder2 = new SequenceEncoder(board.getName(), '/');
                    if (board.isReversed()) {
                        sequenceEncoder2.append("rev");
                    }
                    sequenceEncoder.append(sequenceEncoder2.getValue());
                    sequenceEncoder.append("" + board.relativePosition().x).append("" + board.relativePosition().y);
                }
            }
            return sequenceEncoder.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ double access$402(BoardPicker boardPicker, double d) {
        boardPicker.slotScale = d;
        return boardPicker.slotScale;
    }

    private class Config
    extends Configurer {
        private JPanel controls = new JPanel();
        private JButton selectButton;
        private IntConfigurer width;
        private IntConfigurer height;
        private DoubleConfigurer scale;
        private StringConfigurer title;
        private StringConfigurer prompt;

        public Config() {
            super(null, null);
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.title = new StringConfigurer(null, "Dialog Title:  ", BoardPicker.this.title);
            this.title.addPropertyChangeListener(new PropertyChangeListener(this, BoardPicker.this){
                private final /* synthetic */ BoardPicker val$this$0;
                private final /* synthetic */ Config this$1;
                {
                    this.this$1 = config;
                    this.val$this$0 = boardPicker;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        Config.access$200((Config)this.this$1).title = (String)propertyChangeEvent.getNewValue();
                        if (Config.access$300(this.this$1) != null) {
                            Config.access$200(this.this$1).setTitle(Config.access$200((Config)this.this$1).title);
                        }
                    }
                }
            });
            this.controls.add(this.title.getControls());
            this.prompt = new StringConfigurer(null, "\"Select Boards\" prompt:  ", BoardPicker.this.boardPrompt);
            this.prompt.addPropertyChangeListener(new PropertyChangeListener(this, BoardPicker.this){
                private final /* synthetic */ BoardPicker val$this$0;
                private final /* synthetic */ Config this$1;
                {
                    this.this$1 = config;
                    this.val$this$0 = boardPicker;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        Config.access$200((Config)this.this$1).boardPrompt = (String)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this.controls.add(this.prompt.getControls());
            this.scale = new DoubleConfigurer(null, "Cell scale factor:  ", new Double(BoardPicker.this.slotScale));
            this.scale.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Config this$1;
                {
                    this.this$1 = config;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        BoardPicker.access$402(Config.access$200(this.this$1), (Double)propertyChangeEvent.getNewValue());
                    }
                }
            });
            this.controls.add(this.scale.getControls());
            this.width = new IntConfigurer(null, "Cell width:  ", new Integer(((BoardPicker)BoardPicker.this).psize.width));
            this.width.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Config this$1;
                {
                    this.this$1 = config;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        BoardPicker.access$500((BoardPicker)Config.access$200((Config)this.this$1)).width = (Integer)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this.controls.add(this.width.getControls());
            this.height = new IntConfigurer(null, "Cell height:  ", new Integer(((BoardPicker)BoardPicker.this).psize.height));
            this.height.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Config this$1;
                {
                    this.this$1 = config;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        BoardPicker.access$500((BoardPicker)Config.access$200((Config)this.this$1)).height = (Integer)propertyChangeEvent.getNewValue();
                    }
                }
            });
            this.controls.add(this.height.getControls());
            this.selectButton = new JButton("Select Default Board Setup");
            this.selectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Config this$1;
                {
                    this.this$1 = config;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Config.access$200(this.this$1).selectBoards();
                }
            });
            this.controls.add(this.selectButton);
        }

        public Component getControls() {
            return this.controls;
        }

        public String getValueString() {
            return null;
        }

        public void setValue(String string) {
        }

        static /* synthetic */ BoardPicker access$200(Config config) {
            return config.BoardPicker.this;
        }

        static /* synthetic */ JPanel access$300(Config config) {
            return config.controls;
        }
    }

    public static class SetBoards
    extends Command {
        private Vector bds;
        private BoardPicker target;

        public SetBoards(BoardPicker boardPicker, Vector vector) {
            this.target = boardPicker;
            this.bds = vector;
        }

        protected void executeCommand() {
            this.target.currentBoards = this.bds;
            if (GameModule.getGameModule().getGameState().isGameStarted()) {
                this.target.map.setBoards(this.target.getCurrentBoards());
                this.target.map.getView().revalidate();
            }
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

