/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.Deck;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.tools.UniqueIdManager;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class DrawPile
extends SetupStack {
    protected Deck dummy = new Deck();
    protected boolean reshufflable;
    protected Deck myDeck;
    private VisibilityCondition colorVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isDrawOutline();
        }
    };
    private VisibilityCondition reshuffleVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.reshufflable;
        }
    };
    private VisibilityCondition faceDownFormatVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.getFaceDownOption().equals(DrawPile.USE_MENU);
        }
    };
    private VisibilityCondition reverseFormatVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isReversible();
        }
    };
    private VisibilityCondition shuffleFormatVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.getShuffleOption().equals(DrawPile.USE_MENU);
        }
    };
    protected static UniqueIdManager idMgr = new UniqueIdManager("Deck");
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String ALLOW_MULTIPLE = "allowMultiple";
    public static final String ALLOW_SELECT = "allowSelect";
    public static final String FACE_DOWN = "faceDown";
    public static final String DRAW_FACE_UP = "drawFaceUp";
    public static final String FACE_DOWN_REPORT_FORMAT = "faceDownFormat";
    public static final String SHUFFLE = "shuffle";
    public static final String SHUFFLE_REPORT_FORMAT = "shuffleFormat";
    public static final String SHUFFLE_HOTKEY = "shuffleHotkey";
    public static final String REVERSIBLE = "reversible";
    public static final String REVERSE_REPORT_FORMAT = "reverseFormat";
    public static final String DRAW = "draw";
    public static final String COLOR = "color";
    public static final String RESHUFFLABLE = "reshufflable";
    public static final String RESHUFFLE_COMMAND = "reshuffleCommand";
    public static final String RESHUFFLE_TARGET = "reshuffleTarget";
    public static final String RESHUFFLE_MESSAGE = "reshuffleMessage";
    public static final String RESHUFFLE_HOTKEY = "reshuffleHotkey";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String CAN_SAVE = "canSave";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String USE_MENU = "Via right-click Menu";
    public static final String COMMAND_NAME = "commandName";
    public static final String DECK_NAME = "deckName";
    static /* synthetic */ Class class$VASSAL$build$module$map$DrawPile;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$SetupStack$OwningBoardPrompt;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$VASSAL$build$module$map$DrawPile$Prompt;
    static /* synthetic */ Class class$VASSAL$build$module$map$DrawPile$FormattedStringConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$VASSAL$build$module$map$DrawPile$AssignedDeckPrompt;
    static /* synthetic */ Class class$VASSAL$build$widget$CardSlot;

    public void addTo(Buildable buildable) {
        super.addTo(buildable);
        idMgr.add(this);
    }

    protected JPopupMenu buildPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu.getComponentCount() > 0 ? jPopupMenu : null;
    }

    public static DrawPile findDrawPile(String string) {
        return (DrawPile)idMgr.findInstance(string);
    }

    public String[] getAttributeNames() {
        return new String[]{"name", "owningBoard", "x", "y", WIDTH, HEIGHT, ALLOW_MULTIPLE, ALLOW_SELECT, FACE_DOWN, DRAW_FACE_UP, FACE_DOWN_REPORT_FORMAT, SHUFFLE, SHUFFLE_REPORT_FORMAT, SHUFFLE_HOTKEY, REVERSIBLE, REVERSE_REPORT_FORMAT, DRAW, COLOR, RESHUFFLABLE, RESHUFFLE_COMMAND, RESHUFFLE_MESSAGE, RESHUFFLE_HOTKEY, RESHUFFLE_TARGET, CAN_SAVE};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Belongs to board:  ", "X position:  ", "Y position:  ", "Width:  ", "Height:  ", "Allow Multiple Cards to be Drawn", "Allow Specific Cards to be Drawn", "Contents are Face-down:  ", "Draw new cards face up", "Face-down Report Format", "Re-shuffle:  ", "Re-shuffle Report Format:  ", "Re-shuffle Hot Key:  ", "Reversible", "Reverse Report Format", "Draw Outline when empty", "Color:  ", "Include command to send entire deck to another deck", "Send Menu text:  ", "Send Report Format:  ", "Send Hot Key:  ", "Name of deck to send to:  ", "Can be saved-to/loaded-from a file"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = DrawPile.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$SetupStack$OwningBoardPrompt == null ? (class$VASSAL$build$module$map$SetupStack$OwningBoardPrompt = DrawPile.class$("VASSAL.build.module.map.SetupStack$OwningBoardPrompt")) : class$VASSAL$build$module$map$SetupStack$OwningBoardPrompt, class$java$lang$Integer == null ? (class$java$lang$Integer = DrawPile.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = DrawPile.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = DrawPile.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = DrawPile.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DrawPile.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DrawPile.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$map$DrawPile$Prompt == null ? (class$VASSAL$build$module$map$DrawPile$Prompt = DrawPile.class$("VASSAL.build.module.map.DrawPile$Prompt")) : class$VASSAL$build$module$map$DrawPile$Prompt, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DrawPile.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$map$DrawPile$FormattedStringConfig == null ? (class$VASSAL$build$module$map$DrawPile$FormattedStringConfig = DrawPile.class$("VASSAL.build.module.map.DrawPile$FormattedStringConfig")) : class$VASSAL$build$module$map$DrawPile$FormattedStringConfig, class$VASSAL$build$module$map$DrawPile$Prompt == null ? (class$VASSAL$build$module$map$DrawPile$Prompt = DrawPile.class$("VASSAL.build.module.map.DrawPile$Prompt")) : class$VASSAL$build$module$map$DrawPile$Prompt, class$VASSAL$build$module$map$DrawPile$FormattedStringConfig == null ? (class$VASSAL$build$module$map$DrawPile$FormattedStringConfig = DrawPile.class$("VASSAL.build.module.map.DrawPile$FormattedStringConfig")) : class$VASSAL$build$module$map$DrawPile$FormattedStringConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = DrawPile.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DrawPile.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$map$DrawPile$FormattedStringConfig == null ? (class$VASSAL$build$module$map$DrawPile$FormattedStringConfig = DrawPile.class$("VASSAL.build.module.map.DrawPile$FormattedStringConfig")) : class$VASSAL$build$module$map$DrawPile$FormattedStringConfig, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DrawPile.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$awt$Color == null ? (class$java$awt$Color = DrawPile.class$("java.awt.Color")) : class$java$awt$Color, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DrawPile.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = DrawPile.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$DrawPile$FormattedStringConfig == null ? (class$VASSAL$build$module$map$DrawPile$FormattedStringConfig = DrawPile.class$("VASSAL.build.module.map.DrawPile$FormattedStringConfig")) : class$VASSAL$build$module$map$DrawPile$FormattedStringConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = DrawPile.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$VASSAL$build$module$map$DrawPile$AssignedDeckPrompt == null ? (class$VASSAL$build$module$map$DrawPile$AssignedDeckPrompt = DrawPile.class$("VASSAL.build.module.map.DrawPile$AssignedDeckPrompt")) : class$VASSAL$build$module$map$DrawPile$AssignedDeckPrompt, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DrawPile.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    }

    public String getAttributeValueString(String string) {
        if (WIDTH.equals(string)) {
            return "" + this.dummy.getSize().width;
        }
        if (HEIGHT.equals(string)) {
            return "" + this.dummy.getSize().height;
        }
        if (FACE_DOWN.equals(string)) {
            return this.dummy.getFaceDownOption();
        }
        if (DRAW_FACE_UP.equals(string)) {
            return String.valueOf(this.dummy.isDrawFaceUp());
        }
        if (SHUFFLE.equals(string)) {
            return this.dummy.getShuffleOption();
        }
        if (REVERSIBLE.equals(string)) {
            return "" + this.dummy.isReversible();
        }
        if (ALLOW_MULTIPLE.equals(string)) {
            return "" + this.dummy.isAllowMultipleDraw();
        }
        if (ALLOW_SELECT.equals(string)) {
            return "" + this.dummy.isAllowSelectDraw();
        }
        if (DRAW.equals(string)) {
            return "" + this.dummy.isDrawOutline();
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.dummy.getOutlineColor());
        }
        if (RESHUFFLABLE.equals(string)) {
            return "" + (this.dummy.getReshuffleCommand().length() > 0);
        }
        if (RESHUFFLE_COMMAND.equals(string)) {
            return this.dummy.getReshuffleCommand();
        }
        if (RESHUFFLE_TARGET.equals(string)) {
            return this.dummy.getReshuffleTarget();
        }
        if (RESHUFFLE_MESSAGE.equals(string)) {
            return this.dummy.getReshuffleMsgFormat();
        }
        if (RESHUFFLE_HOTKEY.equals(string)) {
            return HotKeyConfigurer.encode(this.dummy.getReshuffleKey());
        }
        if (SHUFFLE_REPORT_FORMAT.equals(string)) {
            return this.dummy.getShuffleMsgFormat();
        }
        if (SHUFFLE_HOTKEY.equals(string)) {
            return HotKeyConfigurer.encode(this.dummy.getShuffleKey());
        }
        if (REVERSE_REPORT_FORMAT.equals(string)) {
            return this.dummy.getReverseMsgFormat();
        }
        if (FACE_DOWN_REPORT_FORMAT.equals(string)) {
            return this.dummy.getFaceDownMsgFormat();
        }
        if (CAN_SAVE.equals(string)) {
            return String.valueOf(this.dummy.isPersistable());
        }
        return super.getAttributeValueString(string);
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.dummy.getSize().width = (Integer)object;
        } else if (HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.dummy.getSize().height = (Integer)object;
        } else if (FACE_DOWN.equals(string)) {
            this.dummy.setFaceDownOption((String)object);
        } else if (DRAW_FACE_UP.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setDrawFaceUp(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setDrawFaceUp("true".equals(object));
            }
        } else if (CAN_SAVE.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setPersistable(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setPersistable("true".equals(object));
            }
        } else if (SHUFFLE.equals(string)) {
            this.dummy.setShuffleOption((String)object);
        } else if (REVERSIBLE.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setReversible(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setReversible("true".equals(object));
            }
        } else if (ALLOW_MULTIPLE.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setAllowMultipleDraw(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setAllowMultipleDraw("true".equals(object));
            }
        } else if (ALLOW_SELECT.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setAllowSelectDraw(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setAllowSelectDraw("true".equals(object));
            }
        } else if (DRAW.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setDrawOutline(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setDrawOutline("true".equals(object));
            }
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.dummy.setOutlineColor((Color)object);
        } else if (RESHUFFLABLE.equals(string)) {
            boolean bl = this.reshufflable = "true".equals(object) || Boolean.TRUE.equals(object);
            if (!this.reshufflable) {
                this.dummy.setReshuffleCommand("");
            }
        } else if (RESHUFFLE_COMMAND.equals(string)) {
            this.dummy.setReshuffleCommand((String)object);
        } else if (RESHUFFLE_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.dummy.setReshuffleKey((KeyStroke)object);
        } else if (RESHUFFLE_TARGET.equals(string)) {
            this.dummy.setReshuffleTarget((String)object);
        } else if (RESHUFFLE_MESSAGE.equals(string)) {
            this.dummy.setReshuffleMsgFormat((String)object);
        } else if (REVERSE_REPORT_FORMAT.equals(string)) {
            this.dummy.setReverseMsgFormat((String)object);
        } else if (SHUFFLE_REPORT_FORMAT.equals(string)) {
            this.dummy.setShuffleMsgFormat((String)object);
        } else if (SHUFFLE_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.dummy.setShuffleKey((KeyStroke)object);
        } else if (FACE_DOWN_REPORT_FORMAT.equals(string)) {
            this.dummy.setFaceDownMsgFormat((String)object);
        } else if ("name".equals(string)) {
            this.dummy.setDeckName((String)object);
            super.setAttribute(string, object);
        } else {
            super.setAttribute(string, object);
        }
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (COLOR.equals(string)) {
            return this.colorVisibleCondition;
        }
        if (RESHUFFLE_COMMAND.equals(string) || RESHUFFLE_MESSAGE.equals(string) || RESHUFFLE_TARGET.equals(string) || RESHUFFLE_HOTKEY.equals(string)) {
            return this.reshuffleVisibleCondition;
        }
        if (FACE_DOWN_REPORT_FORMAT.equals(string)) {
            return this.faceDownFormatVisibleCondition;
        }
        if (SHUFFLE_REPORT_FORMAT.equals(string) || SHUFFLE_HOTKEY.equals(string)) {
            return this.shuffleFormatVisibleCondition;
        }
        if (REVERSE_REPORT_FORMAT.equals(string)) {
            return this.reverseFormatVisibleCondition;
        }
        return null;
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$widget$CardSlot == null ? (class$VASSAL$build$widget$CardSlot = DrawPile.class$("VASSAL.build.widget.CardSlot")) : class$VASSAL$build$widget$CardSlot};
    }

    public Point getPosition() {
        Point point = new Point(this.pos);
        Board board = this.map.getBoardByName(this.owningBoardName);
        if (board != null) {
            point.translate(board.bounds().x, board.bounds().y);
        }
        return point;
    }

    public Map getMap() {
        return this.map;
    }

    public Rectangle boundingBox() {
        return this.myDeck == null ? null : this.myDeck.boundingBox();
    }

    public Command addToContents(GamePiece gamePiece) {
        return this.map.placeOrMerge(gamePiece, this.myDeck == null ? this.getPosition() : this.myDeck.getPosition());
    }

    protected Stack initializeContents() {
        Stack stack = super.initializeContents();
        this.myDeck = new Deck(this.getDeckType());
        Enumeration enumeration = stack.getPieces();
        while (enumeration.hasMoreElements()) {
            this.myDeck.add((GamePiece)enumeration.nextElement());
        }
        this.myDeck.setFaceDown(!NEVER.equals(this.dummy.getFaceDownOption()));
        return this.myDeck;
    }

    protected boolean placeNonStackingSeparately() {
        return false;
    }

    protected String getDeckType() {
        return this.dummy.getType();
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Deck.htm");
    }

    public static String getConfigureTypeName() {
        return "Deck";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FormattedStringConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{DrawPile.DECK_NAME, DrawPile.COMMAND_NAME});
        }
    }

    public static class AssignedDeckPrompt
    extends StringEnum {
        public static final String NONE = "<none>";

        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(NONE);
            Enumeration enumeration = GameModule.getGameModule().getGameState().getGameComponentsEnum();
            while (enumeration.hasMoreElements()) {
                Map map;
                GameComponent gameComponent = (GameComponent)enumeration.nextElement();
                if (gameComponent == null || !(gameComponent instanceof Map) || (map = (Map)gameComponent) == null) continue;
                Enumeration enumeration2 = map.getComponents(class$VASSAL$build$module$map$DrawPile == null ? DrawPile.class$("VASSAL.build.module.map.DrawPile") : class$VASSAL$build$module$map$DrawPile);
                while (enumeration2.hasMoreElements()) {
                    DrawPile drawPile = (DrawPile)enumeration2.nextElement();
                    if (drawPile.getConfigureName() == null) continue;
                    arrayList.add(drawPile.getConfigureName());
                }
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            return stringArray;
        }
    }

    public static class Prompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{DrawPile.ALWAYS, DrawPile.NEVER, DrawPile.USE_MENU};
        }
    }
}

