/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.Command;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.GamePiece;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.ScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlobalMap
extends JPanel
implements AutoConfigurable,
GameComponent,
Drawable {
    protected Map map;
    protected double scale = 0.19444444;
    protected Color rectColor = Color.black;
    protected LaunchButton launch;
    protected JWindow f;
    protected CounterDetailViewer mouseOverViewer;
    protected View view;
    protected JPanel borderPanel;
    protected JScrollPane scroll;
    protected boolean scrollVisible;
    protected static final String SCALE = "scale";
    protected static final String COLOR = "color";
    protected static final String HOTKEY = "hotkey";
    protected static final String ICON_NAME = "icon";
    protected static final String TOOLTIP = "tooltip";
    protected static final String BUTTON_TEXT = "buttonText";
    protected static final String DEFAULT_ICON = "/images/overview.gif";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$GlobalMap$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$VASSAL$build$module$map$CounterDetailViewer;

    public GlobalMap() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalMap.this.setWindowVisible(!GlobalMap.this.f.isVisible());
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON_NAME, actionListener);
        this.launch.setAttribute(TOOLTIP, "Show/Hide overview window");
        this.launch.setAttribute(HOTKEY, KeyStroke.getKeyStroke(79, 3));
        this.view = new View();
        this.view.addMouseListener(this.view);
        this.scroll = new ScrollPane(this.view);
        this.borderPanel = new JPanel(new BorderLayout());
        this.borderPanel.setBorder(BorderFactory.createEtchedBorder(0));
        this.borderPanel.add((Component)this.scroll, "Center");
    }

    private void initWindow() {
        this.f = new JWindow(SwingUtilities.getWindowAncestor(this.map.getView()));
        this.f.getContentPane().add(this.borderPanel);
        this.view.setSize(this.getPreferredSize());
        this.view.setPreferredSize(this.getPreferredSize());
        this.scroll.setPreferredSize(this.getViewableSize());
        this.f.pack();
        this.map.getView().addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                GlobalMap.this.adjustWindowLocation();
            }

            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                GlobalMap.this.adjustWindowLocation();
            }
        });
    }

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.mouseOverViewer = new CounterViewer();
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addKeyStrokeSource(new KeyStrokeSource(this.view, 0));
        this.map.addDrawComponent(this);
        this.map.getToolBar().add(this.launch);
        if (SwingUtilities.getWindowAncestor(this.map.getView()) != null) {
            this.initWindow();
        } else {
            this.f = new JWindow();
            this.map.getView().addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if (SwingUtilities.getWindowAncestor(GlobalMap.this.map.getView()) != null) {
                        GlobalMap.this.initWindow();
                        GlobalMap.this.map.getView().removeHierarchyListener(this);
                    }
                }
            });
        }
    }

    public void add(Buildable buildable) {
    }

    public void remove(Buildable buildable) {
    }

    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.removeDrawComponent(this);
        this.map.getToolBar().remove(this.launch);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        if (this.f != null) {
            this.f.dispose();
        }
    }

    public void build(Element element) {
        AutoConfigurable.Util.buildAttributes(element, this);
    }

    public String[] getAttributeNames() {
        return new String[]{TOOLTIP, BUTTON_TEXT, ICON_NAME, HOTKEY, SCALE, COLOR};
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (SCALE.equals(string)) {
            if (object instanceof String) {
                object = Double.valueOf((String)object);
            }
            this.scale = (Double)object;
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.rectColor = (Color)object;
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    public String getAttributeValueString(String string) {
        if (SCALE.equals(string)) {
            return "" + this.scale;
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.rectColor);
        }
        return this.launch.getAttributeValueString(string);
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Tooltip text", "Button text", "Button icon", "Hotkey to show/hide", "Scale factor", "Visible rectangle highlight color"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = GlobalMap.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = GlobalMap.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$GlobalMap$IconConfig == null ? (class$VASSAL$build$module$map$GlobalMap$IconConfig = GlobalMap.class$("VASSAL.build.module.map.GlobalMap$IconConfig")) : class$VASSAL$build$module$map$GlobalMap$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = GlobalMap.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$Double == null ? (class$java$lang$Double = GlobalMap.class$("java.lang.Double")) : class$java$lang$Double, class$java$awt$Color == null ? (class$java$awt$Color = GlobalMap.class$("java.awt.Color")) : class$java$awt$Color};
    }

    public void draw(Graphics graphics, Map map) {
        this.view.repaint();
    }

    public boolean drawAboveCounters() {
        return false;
    }

    public Point componentCoordinates(Point point) {
        point = new Point(point.x - this.map.getEdgeBuffer().width, point.y - this.map.getEdgeBuffer().height);
        point.x = (int)((double)point.x * this.scale);
        point.y = (int)((double)point.y * this.scale);
        return point;
    }

    public Point mapCoordinates(Point point) {
        point = new Point((int)Math.round((double)point.x / this.scale), (int)Math.round((double)point.y / this.scale));
        point.translate(this.map.getEdgeBuffer().width, this.map.getEdgeBuffer().height);
        return point;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    public Command getRestoreCommand() {
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)((double)(this.map.mapSize().width - 2 * this.map.getEdgeBuffer().width) * this.scale), (int)((double)(this.map.mapSize().height - 2 * this.map.getEdgeBuffer().height) * this.scale));
    }

    public Dimension getViewableSize() {
        Dimension dimension = this.getPreferredSize();
        Rectangle rectangle = this.map.getView().getVisibleRect();
        rectangle.width -= 2 * this.borderPanel.getBorder().getBorderInsets((Component)this.borderPanel).right;
        rectangle.height -= 2 * this.borderPanel.getBorder().getBorderInsets((Component)this.borderPanel).bottom;
        this.setScrollVisible(false);
        if (rectangle.width > 0 && rectangle.width < dimension.width) {
            dimension.width = rectangle.width;
            this.setScrollVisible(true);
        } else {
            dimension.width += 1 - this.map.getBoardPicker().getColumnCount();
        }
        if (rectangle.height > 0 && rectangle.height < dimension.height) {
            dimension.height = rectangle.height;
            this.setScrollVisible(true);
        } else {
            dimension.height += 1 - this.map.getBoardPicker().getRowCount();
        }
        return dimension;
    }

    public boolean isScrollVisible() {
        return this.scrollVisible;
    }

    public void setScrollVisible(boolean bl) {
        this.scrollVisible = bl;
    }

    public void setup(boolean bl) {
        if (!bl) {
            ((Component)this.f).setVisible(false);
        } else {
            this.scroll.setPreferredSize(this.getViewableSize());
        }
        if (bl && this.map.getComponents(class$VASSAL$build$module$map$CounterDetailViewer == null ? (class$VASSAL$build$module$map$CounterDetailViewer = GlobalMap.class$("VASSAL.build.module.map.CounterDetailViewer")) : class$VASSAL$build$module$map$CounterDetailViewer).hasMoreElements()) {
            this.view.addMouseMotionListener(this.mouseOverViewer);
            this.f.addKeyListener(this.mouseOverViewer);
        } else {
            this.view.removeMouseMotionListener(this.mouseOverViewer);
            this.f.removeKeyListener(this.mouseOverViewer);
        }
    }

    public void setWindowVisible(boolean bl) {
        if (bl) {
            this.adjustWindowLocation();
        }
        ((Component)this.f).setVisible(bl);
    }

    protected void adjustWindowLocation() {
        if (this.map.getView().isShowing()) {
            Point point = this.map.getView().getLocationOnScreen();
            point.translate(this.map.getView().getVisibleRect().x, this.map.getView().getVisibleRect().y);
            ((Component)this.f).setLocation(point);
            ((Component)this.f).setSize(this.getViewableSize());
            this.view.setSize(this.getPreferredSize());
            this.view.setPreferredSize(this.getPreferredSize());
            this.scroll.setPreferredSize(this.getViewableSize());
            this.scroll.setSize(this.getViewableSize());
            if (this.isScrollVisible()) {
                this.scroll.setHorizontalScrollBarPolicy(32);
                this.scroll.setVerticalScrollBarPolicy(22);
            } else {
                this.scroll.setHorizontalScrollBarPolicy(31);
                this.scroll.setVerticalScrollBarPolicy(21);
            }
            this.f.invalidate();
            this.f.pack();
        }
    }

    public static String getConfigureTypeName() {
        return "Overview Window";
    }

    public String getConfigureName() {
        return null;
    }

    public Configurer getConfigurer() {
        return new AutoConfigurer(this);
    }

    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "OverviewWindow");
    }

    public Element getBuildElement(Document document) {
        return AutoConfigurable.Util.getBuildElement(document, this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class View
    extends JPanel
    implements MouseListener {
        protected View() {
        }

        public void paint(Graphics graphics) {
            Point point;
            graphics.clearRect(0, 0, GlobalMap.this.getViewableSize().width, GlobalMap.this.getViewableSize().height);
            GlobalMap.this.map.drawBoards(graphics, -Math.round((float)GlobalMap.this.scale * (float)GlobalMap.this.map.getEdgeBuffer().width), -Math.round((float)GlobalMap.this.scale * (float)GlobalMap.this.map.getEdgeBuffer().height), GlobalMap.this.scale, this);
            GamePiece[] gamePieceArray = GlobalMap.this.map.getPieces();
            for (int i = 0; i < gamePieceArray.length; ++i) {
                point = GlobalMap.this.componentCoordinates(gamePieceArray[i].getPosition());
                gamePieceArray[i].draw(graphics, point.x, point.y, this, GlobalMap.this.scale);
            }
            GlobalMap.this.mouseOverViewer.draw(graphics, GlobalMap.this.map);
            graphics.setColor(GlobalMap.this.rectColor);
            Rectangle rectangle = GlobalMap.this.map.getView().getVisibleRect();
            point = GlobalMap.this.map.mapCoordinates(rectangle.getLocation());
            point = GlobalMap.this.componentCoordinates(point);
            int n = (int)(GlobalMap.this.scale * (double)rectangle.width / GlobalMap.this.map.getZoom());
            int n2 = (int)(GlobalMap.this.scale * (double)rectangle.height / GlobalMap.this.map.getZoom());
            graphics.drawRect(point.x, point.y, n, n2);
            graphics.drawRect(point.x - 1, point.y - 1, n + 2, n2 + 2);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            GlobalMap.this.map.centerAt(GlobalMap.this.mapCoordinates(mouseEvent.getPoint()));
            GlobalMap.this.map.repaint();
        }
    }

    protected class CounterViewer
    extends CounterDetailViewer {
        public CounterViewer() {
            this.map = GlobalMap.this.map;
        }

        public void draw(Graphics graphics, Map map) {
            if (this.currentMousePosition != null) {
                this.draw(graphics, this.currentMousePosition.getPoint(), GlobalMap.this);
            }
        }

        protected List getDisplayablePieces() {
            Point point = this.currentMousePosition.getPoint();
            Point point2 = GlobalMap.this.map.componentCoordinates(GlobalMap.this.mapCoordinates(point));
            this.currentMousePosition.translatePoint(point2.x - point.x, point2.y - point.y);
            List list = super.getDisplayablePieces();
            this.currentMousePosition.translatePoint(point.x - point2.x, point.y - point2.y);
            return list;
        }

        protected double getZoom() {
            return GlobalMap.this.scale;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, GlobalMap.DEFAULT_ICON);
        }
    }
}

