/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.Command;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.LaunchButton;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HidePiecesButton
extends JPanel
implements MouseListener,
AutoConfigurable,
GameComponent,
Drawable {
    protected boolean piecesVisible = false;
    protected Map map;
    protected LaunchButton launch;
    protected String showingIcon;
    protected String hiddenIcon;
    public static final String DEFAULT_SHOWING_ICON = "/images/globe_unselected.gif";
    public static final String DEFAULT_HIDDEN_ICON = "/images/globe_selected.gif";
    public static final String HOTKEY = "hotkey";
    public static final String HIDDEN_ICON = "hiddenIcon";
    public static final String SHOWING_ICON = "showingIcon";
    public static final String LAUNCH_ICON = "icon";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "buttonText";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$VASSAL$build$module$map$HidePiecesButton$ShowingIconConfig;
    static /* synthetic */ Class class$VASSAL$build$module$map$HidePiecesButton$HiddenIconConfig;

    public HidePiecesButton() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HidePiecesButton.this.setPiecesVisible(!HidePiecesButton.this.piecesVisible);
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, LAUNCH_ICON, actionListener);
        this.launch.setAttribute(TOOLTIP, "Hide all pieces on this map");
        this.addMouseListener(this);
    }

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map.addDrawComponent(this);
        this.map.getToolBar().add(this.launch);
    }

    protected void setPiecesVisible(boolean bl) {
        this.map.setPiecesVisible(bl);
        this.launch.setAttribute(LAUNCH_ICON, bl ? this.showingIcon : this.hiddenIcon);
        this.piecesVisible = bl;
        this.map.repaint();
    }

    public void add(Buildable buildable) {
    }

    public void remove(Buildable buildable) {
    }

    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.removeDrawComponent(this);
        this.map.getToolBar().remove(this.launch);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    public void setAttribute(String string, Object object) {
        if (SHOWING_ICON.equals(string)) {
            this.showingIcon = (String)object;
        } else if (HIDDEN_ICON.equals(string)) {
            this.hiddenIcon = (String)object;
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    public void build(Element element) {
        AutoConfigurable.Util.buildAttributes(element, this);
    }

    public String[] getAttributeNames() {
        return new String[]{TOOLTIP, BUTTON_TEXT, HOTKEY, SHOWING_ICON, HIDDEN_ICON};
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        return null;
    }

    public String getAttributeValueString(String string) {
        String string2 = null;
        string2 = HIDDEN_ICON.equals(string) ? this.hiddenIcon : (SHOWING_ICON.equals(string) ? this.showingIcon : this.launch.getAttributeValueString(string));
        return string2;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Tooltip text", "Button Text", "Hotkey", "Icon when pieces are showing", "Icon when pieces are hidden"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = HidePiecesButton.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = HidePiecesButton.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = HidePiecesButton.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$VASSAL$build$module$map$HidePiecesButton$ShowingIconConfig == null ? (class$VASSAL$build$module$map$HidePiecesButton$ShowingIconConfig = HidePiecesButton.class$("VASSAL.build.module.map.HidePiecesButton$ShowingIconConfig")) : class$VASSAL$build$module$map$HidePiecesButton$ShowingIconConfig, class$VASSAL$build$module$map$HidePiecesButton$HiddenIconConfig == null ? (class$VASSAL$build$module$map$HidePiecesButton$HiddenIconConfig = HidePiecesButton.class$("VASSAL.build.module.map.HidePiecesButton$HiddenIconConfig")) : class$VASSAL$build$module$map$HidePiecesButton$HiddenIconConfig};
    }

    public void draw(Graphics graphics, Map map) {
        this.repaint();
    }

    public boolean drawAboveCounters() {
        return false;
    }

    public void paint(Graphics graphics) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    public Command getRestoreCommand() {
        return null;
    }

    public void setup(boolean bl) {
        if (bl) {
            this.setPiecesVisible(true);
        }
    }

    public static String getConfigureTypeName() {
        return "Hide Pieces Button";
    }

    public String getConfigureName() {
        return null;
    }

    public Configurer getConfigurer() {
        return new AutoConfigurer(this);
    }

    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "HidePieces");
    }

    public Element getBuildElement(Document document) {
        return AutoConfigurable.Util.getBuildElement(document, this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class HiddenIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, HidePiecesButton.DEFAULT_HIDDEN_ICON);
        }
    }

    public static class ShowingIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, HidePiecesButton.DEFAULT_SHOWING_ICON);
        }
    }
}

