/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;

public class HighlightLastMoved
extends AbstractConfigurable
implements Drawable,
MouseListener,
GameComponent {
    public static final String COLOR = "color";
    public static final String THICKNESS = "thickness";
    protected ColoredBorder highlighter = new ColoredBorder(Color.RED, 2);
    protected GamePiece lastMoved;
    protected static java.util.Map instances = new HashMap();
    private boolean enabled;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$lang$Integer;

    public String[] getAttributeDescriptions() {
        return new String[]{"Color", "Thickness"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$awt$Color == null ? (class$java$awt$Color = HighlightLastMoved.class$("java.awt.Color")) : class$java$awt$Color, class$java$lang$Integer == null ? (class$java$lang$Integer = HighlightLastMoved.class$("java.lang.Integer")) : class$java$lang$Integer};
    }

    public String[] getAttributeNames() {
        return new String[]{COLOR, THICKNESS};
    }

    public void setAttribute(String string, Object object) {
        if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.highlighter.setColor((Color)object);
        } else if (THICKNESS.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.highlighter.setThickness((Integer)object);
        }
    }

    public String getAttributeValueString(String string) {
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.highlighter.getColor());
        }
        if (THICKNESS.equals(string)) {
            return String.valueOf(this.highlighter.getThickness());
        }
        return null;
    }

    public void addTo(Buildable buildable) {
        Map map = (Map)buildable;
        map.addDrawComponent(this);
        map.addLocalMouseListener(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        instances.put(map, this);
        this.validator = new SingleChildInstance(map, this.getClass());
    }

    public void removeFrom(Buildable buildable) {
        Map map = (Map)buildable;
        map.removeDrawComponent(this);
        map.removeLocalMouseListener(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        instances.remove(map);
    }

    public void draw(Graphics graphics, Map map) {
        if (this.lastMoved != null) {
            if (this.lastMoved.getMap() == map) {
                this.highlighter.draw(this.lastMoved, graphics, (int)((double)this.lastMoved.getPosition().x * map.getZoom()), (int)((double)this.lastMoved.getPosition().y * map.getZoom()), map.getView(), map.getZoom());
            } else {
                this.lastMoved = null;
            }
        }
    }

    public void setup(boolean bl) {
        this.enabled = bl;
        this.lastMoved = null;
    }

    public Command getRestoreCommand() {
        return null;
    }

    public static void setLastMoved(GamePiece gamePiece) {
        HighlightLastMoved highlightLastMoved = (HighlightLastMoved)instances.get(gamePiece.getMap());
        if (highlightLastMoved != null) {
            highlightLastMoved.setLastMovedPiece(gamePiece);
        }
    }

    public void setLastMovedPiece(GamePiece gamePiece) {
        if (this.enabled) {
            this.lastMoved = gamePiece.getParent() instanceof Stack ? gamePiece.getParent() : gamePiece;
            if (this.lastMoved.getMap() != null) {
                this.lastMoved.getMap().getPieceCollection().moveToFront(this.lastMoved);
            }
        }
    }

    public boolean drawAboveCounters() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastMoved = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "LastMoveHighlighter");
    }

    public static String getConfigureTypeName() {
        return "Last Move Highlighter";
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

