/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.tools.BackgroundTask;
import VASSAL.tools.FileChooser;
import VASSAL.tools.LaunchButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;

public class ImageSaver
extends AbstractConfigurable {
    protected LaunchButton launch;
    protected Map map;
    protected boolean promptToSplit = false;
    protected static final String DEFAULT_ICON = "/images/camera.gif";
    protected static final String HOTKEY = "hotkey";
    protected static final String BUTTON_TEXT = "buttonText";
    protected static final String TOOLTIP = "tooltip";
    protected static final String ICON_NAME = "icon";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$ImageSaver$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$java$awt$Frame;

    public ImageSaver() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageSaver.this.writeMapAsImage();
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON_NAME, actionListener);
        this.launch.setAttribute(TOOLTIP, "Save Map as PNG file");
        this.launch.setAttribute(BUTTON_TEXT, "");
        this.launch.setAttribute(ICON_NAME, DEFAULT_ICON);
    }

    public ImageSaver(Map map) {
        this.map = map;
    }

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().add(this.launch);
    }

    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().remove(this.launch);
        this.map.getToolBar().revalidate();
    }

    public String[] getAttributeNames() {
        return new String[]{TOOLTIP, BUTTON_TEXT, ICON_NAME, HOTKEY};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Tooltip Text", "Button Text", "Toolbar button icon", "Hotkey"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = ImageSaver.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ImageSaver.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$ImageSaver$IconConfig == null ? (class$VASSAL$build$module$map$ImageSaver$IconConfig = ImageSaver.class$("VASSAL.build.module.map.ImageSaver$IconConfig")) : class$VASSAL$build$module$map$ImageSaver$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = ImageSaver.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke};
    }

    public void setAttribute(String string, Object object) {
        this.launch.setAttribute(string, object);
    }

    public String getAttributeValueString(String string) {
        return this.launch.getAttributeValueString(string);
    }

    public void writeMapAsImage() {
        Object object;
        int n = 1;
        if (this.promptToSplit) {
            object = JOptionPane.showInputDialog("Divide map into how many sections?\n(Using more sections requires less memory)");
            if (object == null) {
                return;
            }
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object = GameModule.getGameModule().getFileChooser();
        ((FileChooser)object).setSelectedFile(new File(((FileChooser)object).getCurrentDirectory(), GameModule.getGameModule().getGameName() + "Map.png"));
        if (((FileChooser)object).showSaveDialog(this.map.getView()) == 0) {
            final int n2 = n;
            final String string = ((FileChooser)object).getSelectedFile().getPath();
            final JWindow jWindow = new JWindow((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = ImageSaver.class$("java.awt.Frame")) : class$java$awt$Frame, this.map.getView()));
            final JLabel jLabel = new JLabel("Saving Map Image ...");
            jLabel.setFont(new Font("Dialog", 0, 48));
            jLabel.setBackground(Color.white);
            jLabel.setForeground(Color.black);
            jLabel.setBorder(new BevelBorder(0, Color.lightGray, Color.darkGray));
            jWindow.getContentPane().setBackground(Color.white);
            jWindow.getContentPane().add(jLabel);
            jWindow.pack();
            Rectangle rectangle = this.map.getView().getTopLevelAncestor().getBounds();
            ((Component)jWindow).setLocation(rectangle.x + rectangle.width / 2 - jWindow.getSize().width / 2, rectangle.y + rectangle.height / 2 - jWindow.getSize().height / 2);
            BackgroundTask backgroundTask = new BackgroundTask(){
                private Throwable error;

                public void doFirst() {
                    try {
                        OutputStream[] outputStreamArray = new FileOutputStream[n2];
                        for (int i = 0; i < n2; ++i) {
                            String string2 = string;
                            if (n2 > 1) {
                                string2 = string.lastIndexOf(".") >= 0 ? string.substring(0, string.lastIndexOf(".")) + (i + 1) + string.substring(string.lastIndexOf(".")) : string + (i + 1);
                            }
                            outputStreamArray[i] = new FileOutputStream(string2);
                        }
                        ImageSaver.this.writeImage(outputStreamArray);
                    }
                    catch (Throwable throwable) {
                        this.error = throwable;
                    }
                }

                public void doLater() {
                    if (this.error instanceof OutOfMemoryError) {
                        JOptionPane.showMessageDialog(ImageSaver.this.map.getView().getTopLevelAncestor(), "Insufficient memory\nZooming out will reduce memory requirements\nOtherwise, try again and you will be prompted to split the map\ninto a number of sections", "Error saving map image", 0);
                        ImageSaver.this.promptToSplit = true;
                    } else if (this.error != null) {
                        this.error.printStackTrace();
                        String string2 = this.error.getMessage();
                        if (string2 == null || string2.length() == 0) {
                            string2 = this.error.getClass().getName();
                            string2 = string2.substring(string2.lastIndexOf(".") + 1);
                        }
                        JOptionPane.showMessageDialog(ImageSaver.this.map.getView().getTopLevelAncestor(), string2, "Error saving map image", 0);
                    }
                    jWindow.dispose();
                }
            };
            Timer timer = new Timer(1000, new ActionListener(){
                boolean toggle;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.toggle) {
                        jLabel.setText("Saving Map Image");
                    } else {
                        jLabel.setText("Saving Map Image ...");
                    }
                    this.toggle = !this.toggle;
                }
            });
            ((Component)jWindow).setVisible(true);
            backgroundTask.start();
            timer.start();
        }
    }

    public void writeImage(OutputStream[] outputStreamArray) throws IOException {
        Dimension dimension = this.map.getEdgeBuffer();
        int n = (int)((double)(this.map.mapSize().width - 2 * dimension.width) * this.map.getZoom());
        int n2 = (int)((double)(this.map.mapSize().height - 2 * dimension.height) * this.map.getZoom());
        for (int i = 0; i < outputStreamArray.length; ++i) {
            int n3 = n2 / outputStreamArray.length;
            if (i == outputStreamArray.length - 1) {
                n3 = n2 - n3 * (outputStreamArray.length - 1);
            }
            Image image = this.map.getView().createImage(n, n3);
            Graphics graphics = image.getGraphics();
            this.map.paint(graphics, -((int)(this.map.getZoom() * (double)dimension.width)), -((int)(this.map.getZoom() * (double)dimension.height)) + n3 * i);
            try {
                MediaTracker mediaTracker = new MediaTracker(this.map.getView());
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.writePNG(image, outputStreamArray[i]);
            outputStreamArray[i].close();
        }
    }

    private void writePNG(Image image, OutputStream outputStream) throws IOException {
        if (!(image instanceof RenderedImage)) {
            throw new IOException("Bad image type");
        }
        ImageIO.write((RenderedImage)((Object)image), "png", outputStream);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "ImageCapture");
    }

    public static String getConfigureTypeName() {
        return "Image Capture Tool";
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ImageSaver.DEFAULT_ICON);
        }
    }
}

