/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.Drawable;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyBufferer
extends MouseAdapter
implements Buildable,
MouseMotionListener,
Drawable {
    protected Map map;
    protected Rectangle selection;
    protected Point anchor;
    protected Color color = Color.black;
    protected int thickness = 3;

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.addLocalMouseListener(this);
        this.map.getView().addMouseMotionListener(this);
        this.map.addDrawComponent(this);
    }

    public void add(Buildable buildable) {
    }

    public Element getBuildElement(Document document) {
        return document.createElement(this.getClass().getName());
    }

    public void build(Element element) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.isConsumed()) {
            return;
        }
        GamePiece gamePiece = this.map.findPiece(mouseEvent.getPoint(), PieceFinder.PIECE_IN_STACK);
        EventFilter eventFilter = null;
        if (gamePiece != null) {
            eventFilter = (EventFilter)gamePiece.getProperty("selectEventFilter");
        }
        boolean bl2 = bl = eventFilter != null && eventFilter.rejectEvent(mouseEvent);
        if (gamePiece != null && !bl) {
            if (!KeyBuffer.getBuffer().contains(gamePiece)) {
                if (!mouseEvent.isShiftDown()) {
                    KeyBuffer.getBuffer().clear();
                }
                KeyBuffer.getBuffer().add(gamePiece);
            }
            if (gamePiece.getParent() != null) {
                this.map.getPieceCollection().moveToFront(gamePiece.getParent());
            } else {
                this.map.getPieceCollection().moveToFront(gamePiece);
            }
        } else {
            KeyBuffer.getBuffer().clear();
            this.anchor = this.map.componentCoordinates(mouseEvent.getPoint());
            this.selection = new Rectangle(this.anchor.x, this.anchor.y, 0, 0);
            if (this.map.getHighlighter() instanceof ColoredBorder) {
                ColoredBorder coloredBorder = (ColoredBorder)this.map.getHighlighter();
                this.color = coloredBorder.getColor();
                this.thickness = Math.max(1, (int)Math.round(this.map.getZoom() * (double)coloredBorder.getThickness()));
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.selection != null) {
            this.selection.setLocation(this.map.mapCoordinates(this.selection.getLocation()));
            this.selection.width = (int)((double)this.selection.width / this.map.getZoom());
            this.selection.height = (int)((double)this.selection.height / this.map.getZoom());
            PieceVisitorDispatcher pieceVisitorDispatcher = this.createDragSelector();
            KeyBuffer.getBuffer().clear();
            this.map.apply(pieceVisitorDispatcher);
        }
        this.selection = null;
    }

    protected PieceVisitorDispatcher createDragSelector() {
        return new PieceVisitorDispatcher(new DeckVisitor(){

            public Object visitDeck(Deck deck) {
                return null;
            }

            public Object visitStack(Stack stack) {
                block2: {
                    block3: {
                        if (stack.topPiece() == null) break block2;
                        if (!stack.isExpanded()) break block3;
                        Point[] pointArray = new Point[stack.getPieceCount()];
                        KeyBufferer.this.map.getStackMetrics().getContents(stack, pointArray, null, null, stack.getPosition().x, stack.getPosition().y);
                        for (int i = 0; i < pointArray.length; ++i) {
                            if (!KeyBufferer.this.selection.contains(pointArray[i])) continue;
                            KeyBuffer.getBuffer().add(stack.getPieceAt(i));
                        }
                        break block2;
                    }
                    if (!KeyBufferer.this.selection.contains(stack.getPosition())) break block2;
                    int n = stack.getPieceCount();
                    for (int i = 0; i < n; ++i) {
                        KeyBuffer.getBuffer().add(stack.getPieceAt(i));
                    }
                }
                return null;
            }

            public Object visitDefault(GamePiece gamePiece) {
                if (gamePiece.getProperty("selectEventFilter") == null && KeyBufferer.this.selection.contains(gamePiece.getPosition()) && !Boolean.TRUE.equals(gamePiece.getProperty("Invisible"))) {
                    KeyBuffer.getBuffer().add(gamePiece);
                }
                return null;
            }
        });
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selection != null) {
            this.selection.x = Math.min(mouseEvent.getX(), this.anchor.x);
            this.selection.y = Math.min(mouseEvent.getY(), this.anchor.y);
            this.selection.width = Math.abs(mouseEvent.getX() - this.anchor.x);
            this.selection.height = Math.abs(mouseEvent.getY() - this.anchor.y);
            this.map.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void draw(Graphics graphics, Map map) {
        if (this.selection != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(this.thickness));
            graphics2D.setColor(this.color);
            graphics2D.drawRect(this.selection.x, this.selection.y, this.selection.width, this.selection.height);
            graphics2D.setStroke(stroke);
        }
    }

    public boolean drawAboveCounters() {
        return true;
    }
}

