/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.LaunchButton;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.KeyStroke;

public class LOS_Thread
extends AbstractConfigurable
implements MouseListener,
MouseMotionListener,
Drawable,
Configurable {
    public static final String SNAP_LOS = "snapLOS";
    public static final String LOS_COLOR = "threadColor";
    public static final String HOTKEY = "hotkey";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON_NAME = "iconName";
    public static final String LABEL = "label";
    public static final String DRAW_RANGE = "drawRange";
    public static final String HIDE_COUNTERS = "hideCounters";
    public static final String HIDE_OPACITY = "hideOpacity";
    public static final String RANGE_BACKGROUND = "rangeBg";
    public static final String RANGE_FOREGROUND = "rangeFg";
    public static final String RANGE_SCALE = "scale";
    public static final String RANGE_ROUNDING = "round";
    public static final String ROUND_UP = "Up";
    public static final String ROUND_DOWN = "Down";
    public static final String ROUND_OFF = "Nearest whole number";
    public static Font RANGE_FONT = new Font("Dialog", 0, 11);
    public static final String DEFAULT_ICON = "/images/thread.gif";
    protected boolean retainAfterRelease = false;
    protected long lastRelease = 0L;
    protected Map map;
    protected LaunchButton launch;
    protected KeyStroke hotkey;
    protected Point anchor;
    protected Point arrow;
    protected boolean visible = false;
    protected boolean drawRange;
    protected int rangeScale;
    protected double rangeRounding = 0.5;
    protected boolean hideCounters;
    protected int hideOpacity = 0;
    protected String fixedColor;
    protected Color threadColor = Color.black;
    protected Color rangeFg = Color.white;
    protected Color rangeBg = Color.black;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$LOS_Thread$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$VASSAL$build$module$map$LOS_Thread$RoundingOptions;
    static /* synthetic */ Class class$java$awt$Color;

    public LOS_Thread() {
        this.anchor = new Point(0, 0);
        this.arrow = new Point(0, 0);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LOS_Thread.this.launch();
            }
        };
        this.launch = new LaunchButton("Thread", TOOLTIP, LABEL, HOTKEY, ICON_NAME, actionListener);
        this.launch.setAttribute(ICON_NAME, DEFAULT_ICON);
        this.launch.setAttribute(TOOLTIP, "Show LOS Thread");
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getView().addMouseMotionListener(this);
        this.map.addDrawComponent(this);
        this.map.getToolBar().add(this.launch);
        GameModule.getGameModule().getPrefs().addOption(this.getAttributeValueString(LABEL), new BooleanConfigurer(SNAP_LOS, "Snap Thread to grid"));
        if (this.fixedColor == null) {
            ColorConfigurer colorConfigurer = new ColorConfigurer(LOS_COLOR, "Thread Color");
            GameModule.getGameModule().getPrefs().addOption(this.getAttributeValueString(LABEL), colorConfigurer);
            colorConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LOS_Thread.this.threadColor = (Color)propertyChangeEvent.getNewValue();
                }
            });
            colorConfigurer.fireUpdate();
        }
    }

    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.removeDrawComponent(this);
        this.map.getToolBar().remove(this.launch);
    }

    public String[] getAttributeNames() {
        return new String[]{TOOLTIP, LABEL, ICON_NAME, HOTKEY, DRAW_RANGE, RANGE_SCALE, RANGE_ROUNDING, HIDE_COUNTERS, HIDE_OPACITY, LOS_COLOR, RANGE_FOREGROUND, RANGE_BACKGROUND};
    }

    public void setAttribute(String string, Object object) {
        if (DRAW_RANGE.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.drawRange = (Boolean)object;
        } else if (RANGE_SCALE.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.rangeScale = (Integer)object;
        } else if (RANGE_ROUNDING.equals(string)) {
            this.rangeRounding = ROUND_UP.equals(object) ? 1.0 : (ROUND_DOWN.equals(object) ? 0.0 : 0.5);
        } else if (HIDE_COUNTERS.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.hideCounters = (Boolean)object;
        } else if (HIDE_OPACITY.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.setTransparency((Integer)object);
        } else if (RANGE_FOREGROUND.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.rangeFg = (Color)object;
        } else if (RANGE_BACKGROUND.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.rangeBg = (Color)object;
        } else if (LOS_COLOR.equals(string)) {
            if (object instanceof Color) {
                object = ColorConfigurer.colorToString((Color)object);
            }
            this.fixedColor = (String)object;
            this.threadColor = ColorConfigurer.stringToColor(this.fixedColor);
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    protected void setTransparency(int n) {
        this.hideOpacity = n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    public String getAttributeValueString(String string) {
        if (DRAW_RANGE.equals(string)) {
            return "" + this.drawRange;
        }
        if (RANGE_SCALE.equals(string)) {
            return "" + this.rangeScale;
        }
        if (RANGE_ROUNDING.equals(string)) {
            if (this.rangeRounding == 1.0) {
                return ROUND_UP;
            }
            if (this.rangeRounding == 0.0) {
                return ROUND_DOWN;
            }
            return ROUND_OFF;
        }
        if (HIDE_COUNTERS.equals(string)) {
            return "" + this.hideCounters;
        }
        if (HIDE_OPACITY.equals(string)) {
            return String.valueOf(this.hideOpacity);
        }
        if (RANGE_FOREGROUND.equals(string)) {
            return ColorConfigurer.colorToString(this.rangeFg);
        }
        if (RANGE_BACKGROUND.equals(string)) {
            return ColorConfigurer.colorToString(this.rangeBg);
        }
        if (LOS_COLOR.equals(string)) {
            return this.fixedColor;
        }
        return this.launch.getAttributeValueString(string);
    }

    public void setup(boolean bl) {
        this.launch.setEnabled(bl);
    }

    public void draw(Graphics graphics, Map map) {
        if (!this.visible) {
            return;
        }
        graphics.setColor(this.threadColor);
        Point point = this.map.componentCoordinates(this.anchor);
        Point point2 = this.map.componentCoordinates(this.arrow);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        if (this.drawRange) {
            if (this.rangeScale > 0) {
                int n = (int)(this.rangeRounding + this.anchor.getLocation().distance(this.arrow.getLocation()) / (double)this.rangeScale);
                this.drawRange(graphics, n);
            } else {
                Board board = this.map.findBoard(this.anchor);
                if (board != null && board.getGrid() != null) {
                    this.drawRange(graphics, board.getGrid().range(this.anchor, this.arrow));
                }
            }
        }
    }

    public boolean drawAboveCounters() {
        return true;
    }

    protected void launch() {
        if (!this.visible) {
            this.map.pushMouseListener(this);
            if (this.hideCounters) {
                this.map.setPieceOpacity((float)this.hideOpacity / 100.0f);
                this.map.repaint();
            }
            this.visible = true;
            this.anchor.move(0, 0);
            this.arrow.move(0, 0);
            this.retainAfterRelease = false;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.visible) {
            Point point = mouseEvent.getPoint();
            if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(SNAP_LOS))) {
                point = this.map.snapTo(point);
            }
            this.anchor = point;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.retainAfterRelease) {
            this.retainAfterRelease = false;
        } else if (mouseEvent.getWhen() != this.lastRelease) {
            this.visible = false;
            this.map.setPieceOpacity(1.0f);
            this.map.popMouseListener();
            this.map.repaint();
        }
        this.lastRelease = mouseEvent.getWhen();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.visible) {
            this.retainAfterRelease = true;
            Point point = mouseEvent.getPoint();
            if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(SNAP_LOS))) {
                point = this.map.componentCoordinates(this.map.snapTo(this.map.mapCoordinates(point)));
            }
            this.arrow = this.map.mapCoordinates(point);
            this.map.repaint();
        }
    }

    public void drawRange(Graphics graphics, int n) {
        Point point = this.map.componentCoordinates(this.arrow);
        Point point2 = this.map.componentCoordinates(this.anchor);
        graphics.setColor(Color.black);
        graphics.setFont(RANGE_FONT);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i >= 1; i /= 10) {
            stringBuffer.append("8");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("8");
        }
        int n2 = fontMetrics.stringWidth(" Range  " + stringBuffer.toString());
        int n3 = fontMetrics.getAscent() + 2;
        int n4 = point.x - point2.x;
        int n5 = point.y - point2.y;
        int n6 = point.x + (int)((double)((n2 / 2 + 20) * n4) / Math.sqrt(n4 * n4 + n5 * n5));
        int n7 = point.y + (int)((double)((n3 / 2 + 20) * n5) / Math.sqrt(n4 * n4 + n5 * n5));
        graphics.fillRect(n6 - n2 / 2, n7 + n3 / 2 - fontMetrics.getAscent(), n2, n3);
        graphics.setColor(Color.white);
        graphics.drawString("Range " + n, n6 - n2 / 2 + fontMetrics.stringWidth(" "), n7 + n3 / 2);
    }

    public static String getConfigureTypeName() {
        return "Line of Sight Thread";
    }

    public String getConfigureName() {
        return null;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "LOS");
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Tooltip text", "Button text", "Button Icon", "Hotkey", "Draw Range", "Pixels per range unit", "Round fractions", "Hide Pieces while drawing", "Opacity of hidden pieces (0-100%)", "Thread color"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = LOS_Thread.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = LOS_Thread.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$LOS_Thread$IconConfig == null ? (class$VASSAL$build$module$map$LOS_Thread$IconConfig = LOS_Thread.class$("VASSAL.build.module.map.LOS_Thread$IconConfig")) : class$VASSAL$build$module$map$LOS_Thread$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = LOS_Thread.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$Boolean == null ? (class$java$lang$Boolean = LOS_Thread.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = LOS_Thread.class$("java.lang.Integer")) : class$java$lang$Integer, class$VASSAL$build$module$map$LOS_Thread$RoundingOptions == null ? (class$VASSAL$build$module$map$LOS_Thread$RoundingOptions = LOS_Thread.class$("VASSAL.build.module.map.LOS_Thread$RoundingOptions")) : class$VASSAL$build$module$map$LOS_Thread$RoundingOptions, class$java$lang$Boolean == null ? (class$java$lang$Boolean = LOS_Thread.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = LOS_Thread.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$awt$Color == null ? (class$java$awt$Color = LOS_Thread.class$("java.awt.Color")) : class$java$awt$Color};
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        VisibilityCondition visibilityCondition = null;
        if (RANGE_SCALE.equals(string) || RANGE_ROUNDING.equals(string)) {
            visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return LOS_Thread.this.drawRange;
                }
            };
        } else if (HIDE_OPACITY.equals(string)) {
            visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return LOS_Thread.this.hideCounters;
                }
            };
        }
        return visibilityCondition;
    }

    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class RoundingOptions
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{LOS_Thread.ROUND_UP, LOS_Thread.ROUND_DOWN, LOS_Thread.ROUND_OFF};
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, LOS_Thread.DEFAULT_ICON);
        }
    }
}

