/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.UniqueIdManager;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.ImageIcon;

public class MapShader
extends AbstractConfigurable
implements GameComponent,
Drawable,
UniqueIdManager.Identifyable {
    public static final String NAME = "name";
    public static final String ALWAYS_ON = "alwaysOn";
    public static final String STARTS_ON = "startsOn";
    public static final String HOT_KEY = "hotkey";
    public static final String ICON = "icon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TOOLTIP = "tooltip";
    public static final String BOARDS = "boards";
    public static final String BOARD_LIST = "boardList";
    public static final String ALL_BOARDS = "Yes";
    public static final String EXC_BOARDS = "No, exclude Boards in list";
    public static final String INC_BOARDS = "No, only shade Boards in List";
    protected static UniqueIdManager idMgr = new UniqueIdManager("MapShader");
    protected LaunchButton launch;
    protected boolean alwaysOn = false;
    protected boolean startsOn = false;
    protected String boardSelection = "Yes";
    protected String[] boardList = new String[0];
    protected boolean shadingVisible;
    protected Map map;
    protected String id;
    protected Area boardClip = null;
    public static final String TYPE = "type";
    public static final String DRAW_OVER = "drawOver";
    public static final String PATTERN = "pattern";
    public static final String COLOR = "color";
    public static final String IMAGE = "image";
    public static final String OPACITY = "opacity";
    public static final String BORDER = "border";
    public static final String BORDER_COLOR = "borderColor";
    public static final String BORDER_WIDTH = "borderWidth";
    public static final String BORDER_OPACITY = "borderOpacity";
    public static final String BG_TYPE = "Background";
    public static final String FG_TYPE = "Foreground";
    public static final String TYPE_25_PERCENT = "25%";
    public static final String TYPE_50_PERCENT = "50%";
    public static final String TYPE_75_PERCENT = "75%";
    public static final String TYPE_SOLID = "100% (Solid)";
    public static final String TYPE_IMAGE = "Custom Image";
    protected String imageName;
    protected Color color = Color.BLACK;
    protected String type = "Foreground";
    protected boolean drawOver = false;
    protected String pattern = "25%";
    protected int opacity = 100;
    protected boolean border = false;
    protected Color borderColor = Color.BLACK;
    protected int borderWidth = 1;
    protected int borderOpacity = 100;
    protected Area shape;
    protected BufferedImage shadePattern = null;
    protected Rectangle patternRect = new Rectangle();
    protected TexturePaint texture = null;
    protected AlphaComposite composite = null;
    protected AlphaComposite borderComposite = null;
    protected BasicStroke stroke = null;
    static /* synthetic */ Class class$VASSAL$build$module$map$MapShader$ShadedPiece;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$VASSAL$build$module$map$MapShader$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$VASSAL$build$module$map$MapShader$BoardPrompt;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$MapShader$TypePrompt;
    static /* synthetic */ Class class$VASSAL$build$module$map$MapShader$PatternPrompt;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$lang$Integer;

    public void draw(Graphics graphics, Map map) {
        if (this.shadingVisible) {
            double d = map.getZoom();
            this.buildStroke(d);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            Color color = graphics2D.getColor();
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setComposite(this.getComposite());
            graphics2D.setColor(this.getColor());
            graphics2D.setPaint(this.getTexture());
            Area area = this.getShadeShape(map);
            if (d != 1.0) {
                area = new Area(AffineTransform.getScaleInstance(d, d).createTransformedShape(area));
            }
            graphics2D.fill(area);
            if (this.border) {
                graphics2D.setComposite(this.getBorderComposite());
                graphics2D.setStroke(this.getStroke(map.getZoom()));
                graphics2D.setColor(this.getBorderColor());
                graphics2D.draw(area);
            }
            graphics2D.setComposite(composite);
            graphics2D.setColor(color);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    protected AlphaComposite getComposite() {
        if (this.composite == null) {
            this.buildComposite();
        }
        return this.composite;
    }

    protected void buildComposite() {
        this.composite = AlphaComposite.getInstance(3, (float)this.opacity / 100.0f);
    }

    protected AlphaComposite getBorderComposite() {
        if (this.borderComposite == null) {
            this.borderComposite = this.buildBorderComposite();
        }
        return this.borderComposite;
    }

    protected AlphaComposite buildBorderComposite() {
        return AlphaComposite.getInstance(3, (float)this.borderOpacity / 100.0f);
    }

    protected Area getShadeShape(Map map) {
        Area area = this.type.equals(FG_TYPE) ? new Area() : new Area(this.getBoardClip());
        GamePiece[] gamePieceArray = map.getPieces();
        for (int i = 0; i < gamePieceArray.length; ++i) {
            this.checkPiece(area, gamePieceArray[i]);
        }
        return area;
    }

    protected void checkPiece(Area area, GamePiece gamePiece) {
        if (gamePiece instanceof Stack) {
            Stack stack = (Stack)gamePiece;
            for (int i = 0; i < stack.getPieceCount(); ++i) {
                this.checkPiece(area, stack.getPieceAt(i));
            }
        } else {
            Area area2;
            ShadedPiece shadedPiece = (ShadedPiece)((Object)Decorator.getDecorator(gamePiece, class$VASSAL$build$module$map$MapShader$ShadedPiece == null ? (class$VASSAL$build$module$map$MapShader$ShadedPiece = MapShader.class$("VASSAL.build.module.map.MapShader$ShadedPiece")) : class$VASSAL$build$module$map$MapShader$ShadedPiece));
            if (shadedPiece != null && (area2 = shadedPiece.getArea(this)) != null) {
                if (this.type.equals(FG_TYPE)) {
                    area.add(area2);
                } else {
                    area.subtract(area2);
                }
            }
        }
    }

    protected BufferedImage getShadePattern() {
        if (this.shadePattern == null) {
            this.buildShadePattern();
        }
        return this.shadePattern;
    }

    protected Rectangle getPatternRect() {
        return this.patternRect;
    }

    protected void buildShadePattern() {
        Object object;
        this.shadePattern = null;
        if (this.pattern.equals(TYPE_IMAGE) && this.imageName != null) {
            try {
                object = GameModule.getGameModule().getDataArchive().getCachedImage(this.imageName);
                if (object instanceof BufferedImage) {
                    this.shadePattern = (BufferedImage)object;
                } else {
                    ImageIcon imageIcon = new ImageIcon((Image)object);
                    if (imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0) {
                        this.shadePattern = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
                        this.shadePattern.createGraphics().drawImage((Image)object, 0, 0, null);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.shadePattern == null) {
            this.shadePattern = new BufferedImage(2, 2, 6);
            object = this.shadePattern.createGraphics();
            ((Graphics)object).setColor(this.color);
            if (this.pattern.equals(TYPE_25_PERCENT)) {
                ((Graphics)object).drawLine(0, 0, 0, 0);
            } else if (this.pattern.equals(TYPE_50_PERCENT)) {
                ((Graphics)object).drawLine(0, 0, 0, 0);
                ((Graphics)object).drawLine(1, 1, 1, 1);
            } else if (this.pattern.equals(TYPE_75_PERCENT)) {
                ((Graphics)object).drawLine(0, 0, 1, 0);
                ((Graphics)object).drawLine(1, 1, 1, 1);
            } else {
                ((Graphics)object).drawLine(0, 0, 1, 0);
                ((Graphics)object).drawLine(0, 1, 1, 1);
            }
        }
        this.patternRect = new Rectangle(0, 0, this.shadePattern.getWidth(), this.shadePattern.getHeight());
    }

    protected BasicStroke getStroke(double d) {
        if (this.stroke == null) {
            this.buildStroke(d);
        }
        return this.stroke;
    }

    protected void buildStroke(double d) {
        float f = (float)((double)this.borderWidth * d);
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.stroke = new BasicStroke(f, 1, 1);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    protected TexturePaint getTexture() {
        if (this.texture == null) {
            this.buildTexture();
        }
        return this.texture;
    }

    protected void buildTexture() {
        this.texture = new TexturePaint(this.getShadePattern(), this.getPatternRect());
    }

    public Color getColor() {
        return this.color;
    }

    public boolean drawAboveCounters() {
        return this.drawOver;
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, ALWAYS_ON, STARTS_ON, TOOLTIP, BUTTON_TEXT, ICON, HOT_KEY, BOARDS, BOARD_LIST, TYPE, DRAW_OVER, PATTERN, COLOR, IMAGE, OPACITY, BORDER, BORDER_COLOR, BORDER_WIDTH, BORDER_OPACITY};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = MapShader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MapShader.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MapShader.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = MapShader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MapShader.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$MapShader$IconConfig == null ? (class$VASSAL$build$module$map$MapShader$IconConfig = MapShader.class$("VASSAL.build.module.map.MapShader$IconConfig")) : class$VASSAL$build$module$map$MapShader$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = MapShader.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$VASSAL$build$module$map$MapShader$BoardPrompt == null ? (class$VASSAL$build$module$map$MapShader$BoardPrompt = MapShader.class$("VASSAL.build.module.map.MapShader$BoardPrompt")) : class$VASSAL$build$module$map$MapShader$BoardPrompt, array$Ljava$lang$String == null ? (array$Ljava$lang$String = MapShader.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$VASSAL$build$module$map$MapShader$TypePrompt == null ? (class$VASSAL$build$module$map$MapShader$TypePrompt = MapShader.class$("VASSAL.build.module.map.MapShader$TypePrompt")) : class$VASSAL$build$module$map$MapShader$TypePrompt, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MapShader.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$map$MapShader$PatternPrompt == null ? (class$VASSAL$build$module$map$MapShader$PatternPrompt = MapShader.class$("VASSAL.build.module.map.MapShader$PatternPrompt")) : class$VASSAL$build$module$map$MapShader$PatternPrompt, class$java$awt$Color == null ? (class$java$awt$Color = MapShader.class$("java.awt.Color")) : class$java$awt$Color, class$java$awt$Image == null ? (class$java$awt$Image = MapShader.class$("java.awt.Image")) : class$java$awt$Image, class$java$lang$Integer == null ? (class$java$lang$Integer = MapShader.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MapShader.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$awt$Color == null ? (class$java$awt$Color = MapShader.class$("java.awt.Color")) : class$java$awt$Color, class$java$lang$Integer == null ? (class$java$lang$Integer = MapShader.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = MapShader.class$("java.lang.Integer")) : class$java$lang$Integer};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Shading Always On?  ", "Shading Starts turned on?  ", "Tooltip Text:  ", "Button text:  ", "Button Icon:  ", "Hotkey:  ", "All boards in map get Shaded?  ", "Board List:  ", "Type:  ", "Draw Shade on top of Counters?  ", "Shade Pattern:  ", "Color:  ", "Image:  ", "Opacity(%)", "Border?  ", "Border Color:  ", "Border Width:  ", "Border opacity(%)"};
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public MapShader() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapShader.this.toggleShading();
            }
        };
        this.launch = new LaunchButton("Shade", TOOLTIP, BUTTON_TEXT, HOT_KEY, ICON, actionListener);
        this.launch.setEnabled(false);
        this.setLaunchButtonVisibility();
        this.setConfigureName("Shading");
        this.reset();
    }

    public void reset() {
        this.shadingVisible = this.isAlwaysOn() || this.isStartsOn();
    }

    protected void toggleShading() {
        this.setShadingVisibility(!this.shadingVisible);
    }

    public void setShadingVisibility(boolean bl) {
        this.shadingVisible = bl;
        this.map.repaint();
    }

    protected boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    protected boolean isStartsOn() {
        return this.startsOn;
    }

    protected Map getMap() {
        return this.map;
    }

    public Area getBoardClip() {
        this.buildBoardClip();
        return this.boardClip;
    }

    protected void buildBoardClip() {
        if (this.boardClip == null) {
            this.boardClip = new Area();
            Enumeration enumeration = this.map.getAllBoards();
            while (enumeration.hasMoreElements()) {
                int n;
                Board board = (Board)enumeration.nextElement();
                String string = board.getName();
                boolean bl = false;
                if (this.boardSelection.equals(ALL_BOARDS)) {
                    bl = true;
                } else if (this.boardSelection.equals(EXC_BOARDS)) {
                    bl = true;
                    for (n = 0; n < this.boardList.length && bl; ++n) {
                        bl = !this.boardList[n].equals(string);
                    }
                } else if (this.boardSelection.equals(INC_BOARDS)) {
                    for (n = 0; n < this.boardList.length && !bl; ++n) {
                        bl = this.boardList[n].equals(string);
                    }
                }
                if (!bl) continue;
                this.boardClip.add(new Area(board.bounds()));
            }
        }
    }

    public void setLaunchButtonVisibility() {
        this.launch.setVisible(!this.isAlwaysOn());
    }

    public void setup(boolean bl) {
        this.launch.setEnabled(bl);
        if (!bl) {
            this.boardClip = null;
        }
    }

    public Command getRestoreCommand() {
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            if (this.launch.getAttributeValueString(TOOLTIP) == null) {
                this.launch.setAttribute(TOOLTIP, (String)object);
            }
        } else if (ALWAYS_ON.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.alwaysOn = (Boolean)object;
            this.setLaunchButtonVisibility();
            this.reset();
        } else if (STARTS_ON.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.startsOn = (Boolean)object;
            this.setLaunchButtonVisibility();
            this.reset();
        } else if (BOARDS.equals(string)) {
            this.boardSelection = (String)object;
        } else if (BOARD_LIST.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.boardList = object;
        } else if (TYPE.equals(string)) {
            this.type = (String)object;
        } else if (DRAW_OVER.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.drawOver = (Boolean)object;
        } else if (PATTERN.equals(string)) {
            this.pattern = (String)object;
            this.buildShadePattern();
            this.buildTexture();
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.color = (Color)object;
            this.buildShadePattern();
            this.buildTexture();
        } else if (IMAGE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.imageName = (String)object;
            this.buildShadePattern();
            this.buildTexture();
        } else if (BORDER.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.border = (Boolean)object;
        } else if (BORDER_COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.borderColor = (Color)object;
        } else if (BORDER_WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.borderWidth = (Integer)object;
            if (this.borderWidth < 0) {
                this.borderWidth = 0;
            }
            this.stroke = null;
        } else if (OPACITY.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.opacity = (Integer)object;
            if (this.opacity < 0 || this.opacity > 100) {
                this.opacity = 100;
            }
            this.buildComposite();
        } else if (BORDER_OPACITY.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.borderOpacity = (Integer)object;
            if (this.borderOpacity < 0 || this.borderOpacity > 100) {
                this.borderOpacity = 100;
            }
            this.buildBorderComposite();
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName() + "";
        }
        if (ALWAYS_ON.equals(string)) {
            return String.valueOf(this.isAlwaysOn());
        }
        if (STARTS_ON.equals(string)) {
            return String.valueOf(this.isStartsOn());
        }
        if (BOARDS.equals(string)) {
            return this.boardSelection + "";
        }
        if (BOARD_LIST.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.boardList);
        }
        if (TYPE.equals(string)) {
            return this.type + "";
        }
        if (DRAW_OVER.equals(string)) {
            return String.valueOf(this.drawOver);
        }
        if (PATTERN.equals(string)) {
            return this.pattern + "";
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (IMAGE.equals(string)) {
            return this.imageName;
        }
        if (BORDER.equals(string)) {
            return String.valueOf(this.border);
        }
        if (BORDER_COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.borderColor);
        }
        if (BORDER_WIDTH.equals(string)) {
            return this.borderWidth + "";
        }
        if (OPACITY.equals(string)) {
            return this.opacity + "";
        }
        if (BORDER_OPACITY.equals(string)) {
            return this.borderOpacity + "";
        }
        return this.launch.getAttributeValueString(string);
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (ICON.equals(string) || HOT_KEY.equals(string) || BUTTON_TEXT.equals(string) || STARTS_ON.equals(string) || TOOLTIP.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !MapShader.this.isAlwaysOn();
                }
            };
        }
        if (BOARD_LIST.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !MapShader.this.boardSelection.equals(MapShader.ALL_BOARDS);
                }
            };
        }
        if (COLOR.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !MapShader.this.pattern.equals(MapShader.TYPE_IMAGE);
                }
            };
        }
        if (IMAGE.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return MapShader.this.pattern.equals(MapShader.TYPE_IMAGE);
                }
            };
        }
        if (BORDER_COLOR.equals(string) || BORDER_WIDTH.equals(string) || BORDER_OPACITY.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return MapShader.this.border;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    public static String getConfigureTypeName() {
        return "Map Shading";
    }

    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.launch);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        this.map.removeDrawComponent(this);
        idMgr.remove(this);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "MapShading");
    }

    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.launch.setAlignmentY(0.0f);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map = (Map)buildable;
        this.map.addDrawComponent(this);
        idMgr.add(this);
        this.validator = idMgr;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ShadedPiece {
        public Area getArea(MapShader var1);
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ((MapShader)autoConfigurable).launch.getAttributeValueString(MapShader.ICON));
        }
    }

    public static class BoardPrompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{MapShader.ALL_BOARDS, MapShader.EXC_BOARDS, MapShader.INC_BOARDS};
        }
    }

    public static class PatternPrompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{MapShader.TYPE_25_PERCENT, MapShader.TYPE_50_PERCENT, MapShader.TYPE_75_PERCENT, MapShader.TYPE_SOLID, MapShader.TYPE_IMAGE};
        }
    }

    public static class TypePrompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{MapShader.FG_TYPE, MapShader.BG_TYPE};
        }
    }
}

