/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.Decorator;
import VASSAL.counters.Embellishment;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.ToolBarComponent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MassKeyCommand
extends AbstractConfigurable {
    public static final String DEPRECATED_NAME = "text";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String HOTKEY = "buttonHotkey";
    public static final String KEY_COMMAND = "hotkey";
    public static final String AFFECTED_PIECE_NAMES = "names";
    public static final String PROPERTIES_FILTER = "filter";
    public static final String REPORT_SINGLE = "reportSingle";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String CONDITION = "condition";
    public static final String DECK_COUNT = "deckCount";
    private static final String IF_ACTIVE = "If layer is active";
    private static final String IF_INACTIVE = "If layer is inactive";
    private static final String ALWAYS = "Always";
    public static final String CHECK_PROPERTY = "property";
    public static final String CHECK_VALUE = "propValue";
    private LaunchButton launch;
    private KeyStroke stroke = KeyStroke.getKeyStroke(0, 0);
    private String[] names = new String[0];
    private String condition;
    protected String checkProperty;
    protected String checkValue;
    protected String propertiesFilter;
    protected PropertySource propertySource;
    protected boolean filterIsDynamic;
    protected PieceFilter filter;
    private Map map;
    protected GlobalCommand globalCommand = new GlobalCommand();
    protected FormattedString reportFormat = new FormattedString();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$VASSAL$build$module$map$MassKeyCommand$DeckPolicyConfig;
    static /* synthetic */ Class class$VASSAL$build$module$map$MassKeyCommand$IconConfig;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$VASSAL$build$module$map$MassKeyCommand$ReportFormatConfig;
    static /* synthetic */ Class class$VASSAL$build$module$map$MassKeyCommand$Prompt;

    public MassKeyCommand() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MassKeyCommand.this.apply();
            }
        };
        this.launch = new LaunchButton("CTRL", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
    }

    public void addTo(Buildable buildable) {
        if (buildable instanceof Map) {
            this.map = (Map)buildable;
        }
        if (buildable instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)buildable)).getToolBar().add(this.launch);
        }
        if (buildable instanceof PropertySource) {
            this.propertySource = (PropertySource)((Object)buildable);
        }
    }

    public void apply() {
        this.apply(this.map);
    }

    public void apply(Map map) {
        GameModule.getGameModule().sendAndLog(this.globalCommand.apply(map, this.getFilter()));
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String[] getAttributeDescriptions() {
        if (this.condition == null) {
            return new String[]{"Description", "Key Command", "Matching properties", "Apply to contents of Decks", "Tooltip text", "Button text", "Button Icon", "Hotkey", "Suppress individual reports", "Report Format"};
        }
        return new String[]{"Description", "Key Command", "Matching properties", "Apply to contents of Decks", "Tooltip text", "Button text", "Button Icon", "Hotkey", "Suppress individual reports", "Report Format", "Apply Command"};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, KEY_COMMAND, PROPERTIES_FILTER, DECK_COUNT, TOOLTIP, BUTTON_TEXT, ICON, HOTKEY, REPORT_SINGLE, REPORT_FORMAT, CONDITION, CHECK_VALUE, CHECK_PROPERTY, AFFECTED_PIECE_NAMES};
    }

    public Class[] getAttributeTypes() {
        if (this.condition == null) {
            return new Class[]{class$java$lang$String == null ? (class$java$lang$String = MassKeyCommand.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = MassKeyCommand.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$String == null ? (class$java$lang$String = MassKeyCommand.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$MassKeyCommand$DeckPolicyConfig == null ? (class$VASSAL$build$module$map$MassKeyCommand$DeckPolicyConfig = MassKeyCommand.class$("VASSAL.build.module.map.MassKeyCommand$DeckPolicyConfig")) : class$VASSAL$build$module$map$MassKeyCommand$DeckPolicyConfig, class$java$lang$String == null ? (class$java$lang$String = MassKeyCommand.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MassKeyCommand.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$MassKeyCommand$IconConfig == null ? (class$VASSAL$build$module$map$MassKeyCommand$IconConfig = MassKeyCommand.class$("VASSAL.build.module.map.MassKeyCommand$IconConfig")) : class$VASSAL$build$module$map$MassKeyCommand$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = MassKeyCommand.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MassKeyCommand.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$map$MassKeyCommand$ReportFormatConfig == null ? (class$VASSAL$build$module$map$MassKeyCommand$ReportFormatConfig = MassKeyCommand.class$("VASSAL.build.module.map.MassKeyCommand$ReportFormatConfig")) : class$VASSAL$build$module$map$MassKeyCommand$ReportFormatConfig};
        }
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = MassKeyCommand.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = MassKeyCommand.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$String == null ? (class$java$lang$String = MassKeyCommand.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$MassKeyCommand$DeckPolicyConfig == null ? (class$VASSAL$build$module$map$MassKeyCommand$DeckPolicyConfig = MassKeyCommand.class$("VASSAL.build.module.map.MassKeyCommand$DeckPolicyConfig")) : class$VASSAL$build$module$map$MassKeyCommand$DeckPolicyConfig, class$java$lang$String == null ? (class$java$lang$String = MassKeyCommand.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MassKeyCommand.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$MassKeyCommand$IconConfig == null ? (class$VASSAL$build$module$map$MassKeyCommand$IconConfig = MassKeyCommand.class$("VASSAL.build.module.map.MassKeyCommand$IconConfig")) : class$VASSAL$build$module$map$MassKeyCommand$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = MassKeyCommand.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MassKeyCommand.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$map$MassKeyCommand$ReportFormatConfig == null ? (class$VASSAL$build$module$map$MassKeyCommand$ReportFormatConfig = MassKeyCommand.class$("VASSAL.build.module.map.MassKeyCommand$ReportFormatConfig")) : class$VASSAL$build$module$map$MassKeyCommand$ReportFormatConfig, class$VASSAL$build$module$map$MassKeyCommand$Prompt == null ? (class$VASSAL$build$module$map$MassKeyCommand$Prompt = MassKeyCommand.class$("VASSAL.build.module.map.MassKeyCommand$Prompt")) : class$VASSAL$build$module$map$MassKeyCommand$Prompt};
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (KEY_COMMAND.equals(string)) {
            return HotKeyConfigurer.encode(this.stroke);
        }
        if (AFFECTED_PIECE_NAMES.equals(string)) {
            return this.names == null || this.names.length == 0 ? null : StringArrayConfigurer.arrayToString(this.names);
        }
        if (CHECK_PROPERTY.equals(string)) {
            return this.propertiesFilter != null ? null : this.checkProperty;
        }
        if (CHECK_VALUE.equals(string)) {
            return this.propertiesFilter != null ? null : this.checkValue;
        }
        if (PROPERTIES_FILTER.equals(string)) {
            return this.propertiesFilter;
        }
        if (CONDITION.equals(string)) {
            return ALWAYS.equals(this.condition) ? null : this.condition;
        }
        if (REPORT_SINGLE.equals(string)) {
            return String.valueOf(this.globalCommand.isReportSingle());
        }
        if (DECK_COUNT.equals(string)) {
            return String.valueOf(this.globalCommand.getSelectFromDeck());
        }
        if (REPORT_FORMAT.equals(string)) {
            return this.reportFormat.getFormat();
        }
        return this.launch.getAttributeValueString(string);
    }

    public static String getConfigureTypeName() {
        return "Global Key Command";
    }

    protected LaunchButton getLaunchButton() {
        return this.launch;
    }

    protected void setLaunchButton(LaunchButton launchButton) {
        this.launch = launchButton;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "GlobalKeyCommand");
    }

    public void removeFrom(Buildable buildable) {
        if (buildable instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)buildable)).getToolBar().remove(this.launch);
        }
    }

    public PieceFilter getFilter() {
        if (this.filterIsDynamic) {
            this.buildFilter();
        }
        return this.filter;
    }

    private void buildFilter() {
        if (this.checkValue != null) {
            this.propertiesFilter = this.checkProperty + "=" + this.checkValue;
        }
        if (this.propertiesFilter != null) {
            this.filter = PropertiesPieceFilter.parse(new FormattedString(this.propertiesFilter).getText(this.propertySource));
        }
        if (this.filter != null && this.condition != null) {
            this.filter = new BooleanAndPieceFilter(this.filter, new PieceFilter(){

                public boolean accept(GamePiece gamePiece) {
                    boolean bl = false;
                    if (MassKeyCommand.ALWAYS.equals(MassKeyCommand.this.condition)) {
                        bl = true;
                    } else if (MassKeyCommand.IF_ACTIVE.equals(MassKeyCommand.this.condition)) {
                        bl = Embellishment.getLayerWithMatchingActivateCommand(gamePiece, MassKeyCommand.this.stroke, true) != null;
                    } else if (MassKeyCommand.IF_INACTIVE.equals(MassKeyCommand.this.condition)) {
                        bl = Embellishment.getLayerWithMatchingActivateCommand(gamePiece, MassKeyCommand.this.stroke, false) != null;
                    }
                    return bl;
                }
            });
        }
    }

    public void setAttribute(String string, Object object) {
        if (DEPRECATED_NAME.equals(string)) {
            this.setAttribute(NAME, object);
            this.setAttribute(BUTTON_TEXT, object);
        } else if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            if (this.launch.getAttributeValueString(TOOLTIP) == null) {
                this.launch.setAttribute(TOOLTIP, (String)object);
            }
        } else if (KEY_COMMAND.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.stroke = (KeyStroke)object;
            this.globalCommand.setKeyStroke(this.stroke);
        } else if (AFFECTED_PIECE_NAMES.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.names = object;
            if (this.names.length == 0) {
                this.names = null;
            } else {
                this.filter = new PieceFilter(){

                    public boolean accept(GamePiece gamePiece) {
                        for (int i = 0; i < MassKeyCommand.this.names.length; ++i) {
                            if (!Decorator.getInnermost(gamePiece).getName().equals(MassKeyCommand.this.names[i])) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        } else if (CHECK_PROPERTY.equals(string)) {
            this.checkProperty = (String)object;
            this.buildFilter();
        } else if (CHECK_VALUE.equals(string)) {
            this.checkValue = (String)object;
            this.buildFilter();
        } else if (PROPERTIES_FILTER.equals(string)) {
            this.propertiesFilter = (String)object;
            this.filterIsDynamic = this.propertiesFilter != null && this.propertiesFilter.indexOf(36) >= 0;
            this.buildFilter();
        } else if (CONDITION.equals(string)) {
            this.condition = (String)object;
            this.buildFilter();
        } else if (REPORT_SINGLE.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.globalCommand.setReportSingle((Boolean)object);
        } else if (DECK_COUNT.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.globalCommand.setSelectFromDeck((Integer)object);
        } else if (REPORT_FORMAT.equals(string)) {
            this.reportFormat.setFormat((String)object);
            this.globalCommand.setReportFormat((String)object);
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DeckPolicyConfig
    extends Configurer
    implements ConfigurerFactory {
        private static final String FIXED = "Fixed number of pieces";
        private static final String NONE = "No pieces";
        private static final String ALL = "All pieces";
        private IntConfigurer intConfig;
        private StringEnumConfigurer typeConfig = new StringEnumConfigurer(null, "", new String[]{"All pieces", "No pieces", "Fixed number of pieces"});
        private Box controls;

        public DeckPolicyConfig() {
            super(null, "");
            this.intConfig = new IntConfigurer(null, "");
            this.controls = Box.createHorizontalBox();
            this.controls.add(new JLabel("Within a Deck, apply to:  "));
            this.controls.add(this.typeConfig.getControls());
            this.controls.add(this.intConfig.getControls());
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(this){
                private final /* synthetic */ DeckPolicyConfig this$0;
                {
                    this.this$0 = deckPolicyConfig;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DeckPolicyConfig.access$100(this.this$0).getControls().setVisible("Fixed number of pieces".equals(DeckPolicyConfig.access$000(this.this$0).getValueString()));
                    Window window = SwingUtilities.getWindowAncestor(DeckPolicyConfig.access$100(this.this$0).getControls());
                    if (window != null) {
                        window.pack();
                    }
                }
            };
            PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(this){
                private final /* synthetic */ DeckPolicyConfig this$0;
                {
                    this.this$0 = deckPolicyConfig;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.setValue(new Integer(this.this$0.getIntValue()));
                }
            };
            this.typeConfig.addPropertyChangeListener(propertyChangeListener);
            this.typeConfig.addPropertyChangeListener(propertyChangeListener2);
            this.intConfig.addPropertyChangeListener(propertyChangeListener2);
        }

        public Component getControls() {
            return this.controls;
        }

        public String getValueString() {
            return String.valueOf(this.getIntValue());
        }

        public int getIntValue() {
            String string = this.typeConfig.getValueString();
            if (ALL.equals(string)) {
                return -1;
            }
            if (NONE.equals(string)) {
                return 0;
            }
            return this.intConfig.getIntValue(1);
        }

        public void setValue(Object object) {
            if (this.typeConfig != null) {
                this.typeConfig.setFrozen(true);
                this.intConfig.setFrozen(true);
                if (object instanceof Integer) {
                    Integer n = (Integer)object;
                    switch (n) {
                        case 0: {
                            this.typeConfig.setValue(NONE);
                            this.intConfig.setValue(new Integer(1));
                            break;
                        }
                        case -1: {
                            this.typeConfig.setValue(ALL);
                            this.intConfig.setValue(new Integer(1));
                            break;
                        }
                        default: {
                            this.typeConfig.setValue(FIXED);
                            this.intConfig.setValue(n);
                        }
                    }
                    this.intConfig.getControls().setVisible(FIXED.equals(this.typeConfig.getValueString()));
                }
            }
            super.setValue(object);
            if (this.typeConfig != null) {
                this.typeConfig.setFrozen(false);
                this.intConfig.setFrozen(false);
            }
        }

        public void setValue(String string) {
            if (string != null) {
                this.setValue(new Integer(string));
            }
        }

        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            this.setName(string2);
            this.key = string;
            return this;
        }

        static /* synthetic */ StringEnumConfigurer access$000(DeckPolicyConfig deckPolicyConfig) {
            return deckPolicyConfig.typeConfig;
        }

        static /* synthetic */ IntConfigurer access$100(DeckPolicyConfig deckPolicyConfig) {
            return deckPolicyConfig.intConfig;
        }
    }

    public static class ReportFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[0]);
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/keyCommand.gif");
        }
    }

    public static class Prompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{MassKeyCommand.ALWAYS, MassKeyCommand.IF_ACTIVE, MassKeyCommand.IF_INACTIVE};
        }
    }
}

