/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.counters.Deck;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.KeyCommandSubMenu;
import VASSAL.counters.PieceFinder;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MenuDisplayer
extends MouseAdapter
implements Buildable {
    public static Font POPUP_MENU_FONT = new Font("Dialog", 0, 10);
    protected Map map;
    protected PieceFinder targetSelector;

    public void addTo(Buildable buildable) {
        this.targetSelector = this.createTargetSelector();
        this.map = (Map)buildable;
        this.map.addLocalMouseListener(this);
    }

    protected PieceFinder createTargetSelector() {
        return new PieceFinder.PieceInStack(){

            public Object visitDeck(Deck deck) {
                Point point = deck.getPosition();
                Point point2 = new Point(this.pt.x - point.x, this.pt.y - point.y);
                if (deck.getShape().contains(point2)) {
                    return deck;
                }
                return null;
            }
        };
    }

    public void add(Buildable buildable) {
    }

    public Element getBuildElement(Document document) {
        return document.createElement(this.getClass().getName());
    }

    public void build(Element element) {
    }

    public static JPopupMenu createPopup(GamePiece gamePiece) {
        return MenuDisplayer.createPopup(gamePiece, false);
    }

    public static JPopupMenu createPopup(GamePiece gamePiece, boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        KeyCommand[] keyCommandArray = (KeyCommand[])gamePiece.getProperty("KeyCommands");
        if (keyCommandArray != null) {
            Object object;
            Object object2;
            Object object3;
            Serializable serializable;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
            HashMap<KeyCommand, ArrayList<Object>> hashMap = new HashMap<KeyCommand, ArrayList<Object>>();
            HashMap<String, ArrayList<Object>> hashMap2 = new HashMap<String, ArrayList<Object>>();
            for (int i = 0; i < keyCommandArray.length; ++i) {
                keyCommandArray[i].setGlobal(bl);
                serializable = keyCommandArray[i].getKeyStroke();
                object3 = null;
                if (keyCommandArray[i] instanceof KeyCommandSubMenu) {
                    object2 = new JMenu(keyCommandArray[i].getName());
                    ((JComponent)object2).setFont(POPUP_MENU_FONT);
                    hashMap.put(keyCommandArray[i], (ArrayList<Object>)object2);
                    object3 = object2;
                    arrayList.add(object3);
                    arrayList2.add(KeyStroke.getKeyStroke('\u0000'));
                } else if (arrayList2.contains(serializable)) {
                    object2 = (JMenuItem)arrayList.get(arrayList2.indexOf(serializable));
                    object = (String)((AbstractButton)object2).getAction().getValue("Name");
                    if (object == null || ((String)object).length() < keyCommandArray[i].getName().length()) {
                        object3 = new JMenuItem(keyCommandArray[i]);
                        ((JComponent)object3).setFont(POPUP_MENU_FONT);
                        ((JMenuItem)object3).setEnabled(keyCommandArray[i].isEnabled());
                        arrayList.set(arrayList2.indexOf(serializable), object3);
                    }
                } else {
                    arrayList2.add(serializable != null ? serializable : KeyStroke.getKeyStroke('\u0000'));
                    object3 = new JMenuItem(keyCommandArray[i]);
                    ((JComponent)object3).setFont(POPUP_MENU_FONT);
                    ((JMenuItem)object3).setEnabled(keyCommandArray[i].isEnabled());
                    arrayList.add(object3);
                }
                if (keyCommandArray[i].getName() == null || keyCommandArray[i].getName().length() <= 0 || object3 == null) continue;
                object2 = (List)hashMap2.get(keyCommandArray[i].getName());
                if (object2 == null) {
                    object2 = new ArrayList<Object>();
                    hashMap2.put(keyCommandArray[i].getName(), (ArrayList<Object>)object2);
                }
                object2.add(object3);
            }
            Iterator<Object> iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                serializable = (KeyCommandSubMenu)iterator.next();
                object3 = (JMenu)hashMap.get(serializable);
                object2 = ((KeyCommandSubMenu)serializable).getCommands();
                while (object2.hasNext()) {
                    object = (List)hashMap2.get(object2.next());
                    if (object == null) continue;
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        JMenuItem jMenuItem = (JMenuItem)iterator2.next();
                        ((JMenu)object3).add(jMenuItem);
                        arrayList.remove(jMenuItem);
                    }
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                jPopupMenu.add((JMenuItem)iterator.next());
            }
        }
        return jPopupMenu;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        EventFilter eventFilter;
        GamePiece gamePiece;
        if (mouseEvent.isMetaDown() && (gamePiece = this.map.findPiece(mouseEvent.getPoint(), this.targetSelector)) != null && ((eventFilter = (EventFilter)gamePiece.getProperty("selectEventFilter")) == null || !eventFilter.rejectEvent(mouseEvent))) {
            JPopupMenu jPopupMenu = MenuDisplayer.createPopup(gamePiece, true);
            Point point = this.map.componentCoordinates(mouseEvent.getPoint());
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    MenuDisplayer.this.map.repaint();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    MenuDisplayer.this.map.repaint();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
            jPopupMenu.show(this.map.getView(), point.x, point.y);
            mouseEvent.consume();
        }
    }
}

