/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.PieceMover;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.Transparent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class MineaturesPieceMover
extends PieceMover
implements MouseMotionListener,
Drawable {
    protected GamePiece dragging;
    protected Transparent trans;
    protected Point anchor;
    protected Point arrow;
    protected Color lineColor = Color.black;

    public void addTo(Buildable buildable) {
        super.addTo(buildable);
        this.map.setDragGestureListener(null);
        ((Map)buildable).addDrawComponent(this);
        ((Map)buildable).getView().addMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        PieceIterator pieceIterator = DragBuffer.getBuffer().getIterator();
        if (pieceIterator.hasMoreElements()) {
            this.dragging = pieceIterator.nextPiece();
            this.anchor = this.map.componentCoordinates(this.dragging.getPosition());
            this.trans = new Transparent(this.dragging);
            this.trans.setAlpha(0.5);
            if (this.map.getHighlighter() instanceof ColoredBorder) {
                this.lineColor = ((ColoredBorder)this.map.getHighlighter()).getColor();
            }
            this.arrow = null;
        } else {
            this.clear();
        }
    }

    protected boolean isMultipleSelectionEvent(MouseEvent mouseEvent) {
        return false;
    }

    protected void clear() {
        this.anchor = null;
        this.arrow = null;
        this.trans = null;
    }

    public void draw(Graphics graphics, Map map) {
        if (this.anchor != null && this.arrow != null) {
            graphics.setColor(this.lineColor);
            Point point = this.getDragDestination(map.mapCoordinates(this.anchor), map.mapCoordinates(this.arrow));
            if (point != null) {
                point = map.componentCoordinates(point);
                graphics.drawLine(this.anchor.x, this.anchor.y, point.x, point.y);
                this.trans.draw(graphics, point.x, point.y, map.getView(), map.getZoom());
            }
        }
    }

    public boolean drawAboveCounters() {
        return true;
    }

    protected Point getDragDestination(Point point, Point point2) {
        int n;
        double d;
        Point point3 = point2;
        if (point2 != null && point != null && (d = Math.sqrt(Math.pow(point2.x - point.x, 2.0) + Math.pow(point2.y - point.y, 2.0))) > (double)(n = this.getMaxDragDistance(this.dragging))) {
            point3 = new Point(point.x + (int)Math.round((double)(n * (point2.x - point.x)) / d), point.y + (int)Math.round((double)(n * (point2.y - point.y)) / d));
        }
        return point3;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.arrow = mouseEvent.getPoint();
        this.map.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.anchor != null) {
            Point point = this.getDragDestination(this.map.mapCoordinates(this.anchor), mouseEvent.getPoint());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
        }
        super.mouseReleased(mouseEvent);
        this.clear();
    }

    protected int getMaxDragDistance(GamePiece gamePiece) {
        return Integer.MAX_VALUE;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

