/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.MovePiece;
import VASSAL.command.NullCommand;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.Stack;
import VASSAL.tools.FormattedString;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class MovementReporter {
    private FormattedString format = new FormattedString();
    private List movesToReport = new ArrayList();
    private List movesToMark = new ArrayList();

    public MovementReporter(Command command) {
        this.extractMoveCommands(command);
    }

    private void extractMoveCommands(Command command) {
        Command command2;
        MoveSummary moveSummary = null;
        if (command instanceof AddPiece) {
            command2 = (AddPiece)command;
            if (this.shouldReport((AddPiece)command2)) {
                moveSummary = new MoveSummary((AddPiece)command2);
            }
        } else if (command instanceof MovePiece && this.shouldReport((MovePiece)(command2 = (MovePiece)command))) {
            moveSummary = new MoveSummary((MovePiece)command2);
        }
        if (moveSummary != null) {
            int n = this.movesToReport.indexOf(moveSummary);
            if (n >= 0 && command instanceof MovePiece && this.shouldReport((MovePiece)command)) {
                MoveSummary moveSummary2 = (MoveSummary)this.movesToReport.get(n);
                moveSummary2.append((MovePiece)command);
            } else {
                this.movesToReport.add(moveSummary);
            }
            if (this.shouldMarkMoved(moveSummary)) {
                this.movesToMark.add(moveSummary);
            }
        }
        Command[] commandArray = command.getSubCommands();
        for (int i = 0; i < commandArray.length; ++i) {
            this.extractMoveCommands(commandArray[i]);
        }
    }

    public Command markMovedPieces() {
        NullCommand nullCommand = null;
        if (!this.movesToMark.isEmpty()) {
            nullCommand = new NullCommand();
            Iterator iterator = this.movesToMark.iterator();
            while (iterator.hasNext()) {
                MoveSummary moveSummary = (MoveSummary)iterator.next();
                Iterator iterator2 = moveSummary.pieces.iterator();
                while (iterator2.hasNext()) {
                    GamePiece gamePiece = (GamePiece)iterator2.next();
                    nullCommand.append(this.markMoved(gamePiece));
                }
            }
        }
        return nullCommand;
    }

    public Command markMoved(GamePiece gamePiece) {
        Command command = null;
        if (gamePiece instanceof Stack) {
            command = new NullCommand();
            Enumeration enumeration = ((Stack)gamePiece).getPieces();
            while (enumeration.hasMoreElements()) {
                command.append(this.markMoved((GamePiece)enumeration.nextElement()));
            }
        } else if (gamePiece.getProperty("Moved") != null && gamePiece.getId() != null) {
            ChangeTracker changeTracker = new ChangeTracker(gamePiece);
            gamePiece.setProperty("Moved", Boolean.TRUE);
            command = changeTracker.getChangeCommand();
        }
        return command;
    }

    protected boolean shouldMarkMoved(MoveSummary moveSummary) {
        String string = Map.getMapById(moveSummary.getNewMapId()).getAttributeValueString("markMoved");
        if (string == null) {
            string = GlobalOptions.getInstance().getAttributeValueString("markMoved");
        }
        if ("Always".equals(string)) {
            return true;
        }
        if ("Never".equals(string)) {
            return false;
        }
        return Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue("markMoved"));
    }

    protected boolean shouldReport(AddPiece addPiece) {
        GamePiece gamePiece = addPiece.getTarget();
        return gamePiece != null && !(gamePiece instanceof Stack) && !Boolean.TRUE.equals(gamePiece.getProperty("Invisible")) && !Boolean.TRUE.equals(gamePiece.getProperty("InvisibleToOthers"));
    }

    protected boolean shouldReport(MovePiece movePiece) {
        GamePiece gamePiece = GameModule.getGameModule().getGameState().getPieceForId(movePiece.getId());
        if (gamePiece == null) {
            return false;
        }
        if (gamePiece instanceof Stack) {
            GamePiece gamePiece2 = ((Stack)gamePiece).topPiece(null);
            return gamePiece2 != null;
        }
        return !Boolean.TRUE.equals(gamePiece.getProperty("Invisible")) && !Boolean.TRUE.equals(gamePiece.getProperty("InvisibleToOthers"));
    }

    public Command getReportCommand() {
        PieceAccess.GlobalAccess.hideAll();
        Command command = new NullCommand();
        Iterator iterator = this.movesToReport.iterator();
        while (iterator.hasNext()) {
            MoveSummary moveSummary = (MoveSummary)iterator.next();
            Map map = Map.getMapById(moveSummary.getOldMapId());
            Map map2 = Map.getMapById(moveSummary.getNewMapId());
            this.format.clearProperties();
            if (map == null) {
                this.format.setFormat(map2.getCreateFormat());
            } else if (map != map2) {
                this.format.setFormat(map2.getMoveToFormat());
            } else {
                this.format.setFormat(map2.getMoveWithinFormat());
            }
            if (this.format.getFormat().length() == 0) break;
            this.format.setProperty("pieceName", moveSummary.getPieceName());
            this.format.setProperty("location", map2.locationName(moveSummary.getNewPosition()));
            if (map != null) {
                this.format.setProperty("previousMap", map.getConfigureName());
                this.format.setProperty("previousLocation", map.locationName(moveSummary.getOldPosition()));
            }
            this.format.setProperty("mapName", map2.getConfigureName());
            String string = this.format.getText();
            if (string.length() <= 0) continue;
            command = command.append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + string));
        }
        PieceAccess.GlobalAccess.revertAll();
        return command;
    }

    public static class MoveSummary {
        private String oldMapId;
        private String newMapId;
        private Point oldPosition;
        private Point newPosition;
        private List pieces = new ArrayList();

        public MoveSummary(AddPiece addPiece) {
            GamePiece gamePiece = addPiece.getTarget();
            this.newMapId = gamePiece.getMap().getIdentifier();
            this.newPosition = gamePiece.getPosition();
            this.pieces.add(gamePiece);
        }

        public MoveSummary(MovePiece movePiece) {
            GamePiece gamePiece = GameModule.getGameModule().getGameState().getPieceForId(movePiece.getId());
            this.oldMapId = movePiece.getOldMapId();
            this.newMapId = movePiece.getNewMapId();
            this.oldPosition = movePiece.getOldPosition();
            this.newPosition = movePiece.getNewPosition();
            if (gamePiece != null) {
                this.pieces.add(gamePiece);
            }
        }

        public String getNewMapId() {
            return this.newMapId;
        }

        public Point getNewPosition() {
            return this.newPosition;
        }

        public String getOldMapId() {
            return this.oldMapId;
        }

        public Point getOldPosition() {
            return this.oldPosition;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MoveSummary)) {
                return false;
            }
            MoveSummary moveSummary = (MoveSummary)object;
            if (!this.newPosition.equals(moveSummary.newPosition)) {
                return false;
            }
            if (!this.newMapId.equals(moveSummary.newMapId)) {
                return false;
            }
            if (this.oldMapId != null ? !this.oldMapId.equals(moveSummary.oldMapId) : moveSummary.oldMapId != null) {
                return false;
            }
            return this.oldMapId == null || !(this.oldPosition != null ? !this.oldPosition.equals(moveSummary.oldPosition) : moveSummary.oldPosition != null);
        }

        public int hashCode() {
            int n = this.oldMapId != null ? this.oldMapId.hashCode() : 0;
            n = 29 * n + this.newMapId.hashCode();
            n = 29 * n + this.newPosition.hashCode();
            if (this.oldMapId != null) {
                n = 29 * n + (this.oldPosition != null ? this.oldPosition.hashCode() : 0);
            }
            return n;
        }

        public void append(MovePiece movePiece) {
            GamePiece gamePiece = GameModule.getGameModule().getGameState().getPieceForId(movePiece.getId());
            if (gamePiece != null && !this.pieces.contains(gamePiece)) {
                this.pieces.add(gamePiece);
            }
        }

        public String getPieceName() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.pieces.iterator();
            while (iterator.hasNext()) {
                GamePiece gamePiece = (GamePiece)iterator.next();
                stringBuffer.append(gamePiece.getName());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }
    }
}

