/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PieceSorter;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PieceMover
extends AbstractBuildable
implements MouseListener,
GameComponent,
Comparator {
    public static final String AUTO_REPORT = "autoReport";
    protected static final String OFFMAP = "offmap";
    protected Map map;
    protected Point dragBegin;
    private GamePiece dragging;
    protected JButton markUnmovedButton;
    public static final String ICON_NAME = "icon";
    private String iconName;
    protected PieceFinder dragTargetSelector;
    protected PieceFinder dropTargetSelector;
    protected PieceVisitorDispatcher selectionProcessor;
    protected Comparator pieceSorter = new PieceSorter();

    public void addTo(Buildable buildable) {
        this.dragTargetSelector = this.createDragTargetSelector();
        this.dropTargetSelector = this.createDropTargetSelector();
        this.selectionProcessor = this.createSelectionProcessor();
        this.map = (Map)buildable;
        this.map.addLocalMouseListener(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map.setDragGestureListener(DragHandler.getTheDragHandler());
    }

    protected MovementReporter createMovementReporter(Command command) {
        return new MovementReporter(command);
    }

    protected PieceFinder createDropTargetSelector() {
        return new PieceFinder.Movable(){

            public Object visitDeck(Deck deck) {
                Point point = deck.getPosition();
                Point point2 = new Point(this.pt.x - point.x, this.pt.y - point.y);
                if (deck.getShape().contains(point2)) {
                    return deck;
                }
                return null;
            }

            public Object visitDefault(GamePiece gamePiece) {
                GamePiece gamePiece2 = null;
                if (this.map.getStackMetrics().isStackingEnabled() && this.map.getPieceCollection().canMerge(PieceMover.this.dragging, gamePiece)) {
                    if (this.map.isLocationRestricted(this.pt)) {
                        Point point = this.map.snapTo(this.pt);
                        if (gamePiece.getPosition().equals(point)) {
                            gamePiece2 = gamePiece;
                        }
                    } else {
                        gamePiece2 = (GamePiece)super.visitDefault(gamePiece);
                    }
                }
                if (gamePiece2 != null && DragBuffer.getBuffer().contains(gamePiece2) && gamePiece2.getParent() != null && gamePiece2.getParent().topPiece() == gamePiece2) {
                    gamePiece2 = null;
                }
                return gamePiece2;
            }

            public Object visitStack(Stack stack) {
                GamePiece gamePiece = null;
                if (this.map.getStackMetrics().isStackingEnabled() && this.map.getPieceCollection().canMerge(PieceMover.this.dragging, stack) && !DragBuffer.getBuffer().contains(stack) && stack.topPiece() != null) {
                    gamePiece = this.map.isLocationRestricted(this.pt) && stack.getPosition().equals(this.map.snapTo(this.pt)) ? stack : (GamePiece)super.visitStack(stack);
                }
                return gamePiece;
            }
        };
    }

    protected PieceVisitorDispatcher createSelectionProcessor() {
        return new DeckVisitorDispatcher(new DeckVisitor(){

            public Object visitDeck(Deck deck) {
                DragBuffer.getBuffer().clear();
                PieceIterator pieceIterator = deck.drawCards();
                while (pieceIterator.hasMoreElements()) {
                    DragBuffer.getBuffer().add(pieceIterator.nextPiece());
                }
                return null;
            }

            public Object visitStack(Stack stack) {
                DragBuffer.getBuffer().clear();
                DragBuffer.getBuffer().add(stack);
                if (KeyBuffer.getBuffer().containsChild(stack)) {
                    KeyBuffer.getBuffer().sort(PieceMover.this);
                    Enumeration enumeration = KeyBuffer.getBuffer().getPieces();
                    while (enumeration.hasMoreElements()) {
                        GamePiece gamePiece = (GamePiece)enumeration.nextElement();
                        if (gamePiece.getParent() == stack) continue;
                        DragBuffer.getBuffer().add(gamePiece);
                    }
                }
                return null;
            }

            public Object visitDefault(GamePiece gamePiece) {
                DragBuffer.getBuffer().clear();
                if (KeyBuffer.getBuffer().contains(gamePiece)) {
                    KeyBuffer.getBuffer().sort(PieceMover.this);
                    Enumeration enumeration = KeyBuffer.getBuffer().getPieces();
                    while (enumeration.hasMoreElements()) {
                        GamePiece gamePiece2 = (GamePiece)enumeration.nextElement();
                        DragBuffer.getBuffer().add(gamePiece2);
                    }
                } else {
                    DragBuffer.getBuffer().clear();
                    DragBuffer.getBuffer().add(gamePiece);
                }
                return null;
            }
        });
    }

    protected PieceFinder createDragTargetSelector() {
        return new PieceFinder.Movable(){

            public Object visitDeck(Deck deck) {
                Point point = deck.getPosition();
                Point point2 = new Point(this.pt.x - point.x, this.pt.y - point.y);
                if (deck.getShape().contains(point2)) {
                    return deck;
                }
                return null;
            }
        };
    }

    public void setup(boolean bl) {
        if (bl) {
            this.initButton();
        }
    }

    public Command getRestoreCommand() {
        return null;
    }

    protected void initButton() {
        Object object;
        String string = this.getMarkOption();
        if ("Use Preferences Setting".equals(string)) {
            object = new BooleanConfigurer("markMoved", "Mark Moved Pieces", Boolean.TRUE);
            GameModule.getGameModule().getPrefs().addOption((Configurer)object);
        }
        if (!"Never".equals(string)) {
            if (this.markUnmovedButton == null) {
                this.markUnmovedButton = new JButton();
                if (this.iconName != null) {
                    try {
                        this.markUnmovedButton.setIcon(new ImageIcon(GameModule.getGameModule().getDataArchive().getCachedImage(this.iconName)));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (this.markUnmovedButton.getIcon() == null) {
                    block13: {
                        object = null;
                        try {
                            object = new ImageIcon(GameModule.getGameModule().getDataArchive().getCachedImage(this.map.getAttributeValueString("markUnmovedIcon")));
                        }
                        catch (IOException iOException) {
                            URL uRL = this.getClass().getResource("/images/unmoved.gif");
                            if (uRL == null) break block13;
                            object = new ImageIcon(uRL);
                        }
                    }
                    if (object != null) {
                        this.markUnmovedButton.setIcon((Icon)object);
                    } else {
                        this.markUnmovedButton.setText("Mark Unmoved");
                    }
                }
                this.markUnmovedButton.setAlignmentY(0.0f);
                this.markUnmovedButton.setToolTipText("Mark all pieces on this map as not moved");
                this.markUnmovedButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GamePiece[] gamePieceArray = PieceMover.this.map.getAllPieces();
                        NullCommand nullCommand = new NullCommand();
                        for (int i = 0; i < gamePieceArray.length; ++i) {
                            nullCommand.append(PieceMover.this.markMoved(gamePieceArray[i], false));
                        }
                        GameModule.getGameModule().sendAndLog(nullCommand);
                        PieceMover.this.map.repaint();
                    }
                });
                this.map.getToolBar().add(this.markUnmovedButton);
            }
        } else if (this.markUnmovedButton != null) {
            this.map.getToolBar().remove(this.markUnmovedButton);
            this.markUnmovedButton = null;
        }
    }

    private String getMarkOption() {
        String string = this.map.getAttributeValueString("markMoved");
        if (string == null) {
            string = GlobalOptions.getInstance().getAttributeValueString("markMoved");
        }
        return string;
    }

    public String[] getAttributeNames() {
        return new String[]{ICON_NAME};
    }

    public String getAttributeValueString(String string) {
        if (ICON_NAME.equals(string)) {
            return this.iconName;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (ICON_NAME.equals(string)) {
            this.iconName = (String)object;
        }
    }

    protected boolean isMultipleSelectionEvent(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown();
    }

    protected Command movedPiece(GamePiece gamePiece, Point point) {
        this.setOldLocation(gamePiece);
        Command command = null;
        if (!point.equals(gamePiece.getPosition())) {
            command = this.markMoved(gamePiece, true);
        }
        if (gamePiece.getParent() != null) {
            Command command2 = gamePiece.getParent().pieceRemoved(gamePiece);
            command = command == null ? command2 : command.append(command2);
        }
        return command;
    }

    protected void setOldLocation(GamePiece gamePiece) {
        if (gamePiece instanceof Stack) {
            for (int i = 0; i < ((Stack)gamePiece).getPieceCount(); ++i) {
                this.setOld(((Stack)gamePiece).getPieceAt(i));
            }
        } else {
            this.setOld(gamePiece);
        }
    }

    private void setOld(GamePiece gamePiece) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Map map = gamePiece.getMap();
        Point point = gamePiece.getPosition();
        if (map != null) {
            Zone zone;
            string = map.getConfigureName();
            Board board = map.findBoard(point);
            if (board != null) {
                string2 = board.getName();
            }
            if ((zone = map.findZone(point)) != null) {
                string3 = zone.getName();
            }
            string4 = map.locationName(point);
        }
        gamePiece.setProperty("OldX", point.x + "");
        gamePiece.setProperty("OldY", point.y + "");
        gamePiece.setProperty("OldMap", string);
        gamePiece.setProperty("OldBoard", string2);
        gamePiece.setProperty("OldZone", string3);
        gamePiece.setProperty("OldLocationName", string4);
    }

    public Command markMoved(GamePiece gamePiece, boolean bl) {
        if ("Never".equals(this.getMarkOption())) {
            bl = false;
        }
        Command command = new NullCommand();
        if (!bl || this.shouldMarkMoved()) {
            if (gamePiece instanceof Stack) {
                Enumeration enumeration = ((Stack)gamePiece).getPieces();
                while (enumeration.hasMoreElements()) {
                    command.append(this.markMoved((GamePiece)enumeration.nextElement(), bl));
                }
            } else if (gamePiece.getProperty("Moved") != null && gamePiece.getId() != null) {
                ChangeTracker changeTracker = new ChangeTracker(gamePiece);
                gamePiece.setProperty("Moved", bl ? Boolean.TRUE : Boolean.FALSE);
                command = changeTracker.getChangeCommand();
            }
        }
        return command;
    }

    protected boolean shouldMarkMoved() {
        String string = this.getMarkOption();
        if ("Always".equals(string)) {
            return true;
        }
        if ("Never".equals(string)) {
            return false;
        }
        return Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue("markMoved"));
    }

    public Command movePieces(Map map, Point point) {
        GamePiece[] gamePieceArray;
        PieceIterator pieceIterator = DragBuffer.getBuffer().getIterator();
        if (!pieceIterator.hasMoreElements()) {
            return null;
        }
        Point point2 = null;
        Command command = new NullCommand();
        BoundsTracker boundsTracker = new BoundsTracker();
        HashMap hashMap = new HashMap();
        while (pieceIterator.hasMoreElements()) {
            this.dragging = pieceIterator.nextPiece();
            boundsTracker.addPiece(this.dragging);
            if (this.dragging instanceof Stack) {
                int n = ((Stack)this.dragging).getPieceCount();
                gamePieceArray = new GamePiece[n];
                for (int i = 0; i < n; ++i) {
                    gamePieceArray[i] = ((Stack)this.dragging).getPieceAt(i);
                }
            } else {
                gamePieceArray = new GamePiece[]{this.dragging};
            }
            if (point2 != null) {
                point = new Point(this.dragging.getPosition().x + point2.x, this.dragging.getPosition().y + point2.y);
            }
            ArrayList<GamePiece> arrayList = (ArrayList<GamePiece>)hashMap.get(point);
            GamePiece gamePiece = null;
            if (arrayList != null) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    GamePiece gamePiece2 = (GamePiece)arrayList.get(i);
                    if (!map.getPieceCollection().canMerge(gamePiece2, this.dragging)) continue;
                    gamePiece = gamePiece2;
                    arrayList.set(i, this.dragging);
                    break;
                }
            }
            if (gamePiece == null) {
                gamePiece = map.findAnyPiece(point, this.dropTargetSelector);
                if (gamePiece == null && !Boolean.TRUE.equals(this.dragging.getProperty("IgnoreGrid"))) {
                    point = map.snapTo(point);
                }
                if (point2 == null) {
                    point2 = new Point(point.x - this.dragging.getPosition().x, point.y - this.dragging.getPosition().y);
                }
                if (gamePiece != null && map.getStackMetrics().isStackingEnabled()) {
                    arrayList = new ArrayList<GamePiece>();
                    arrayList.add(gamePiece);
                    hashMap.put(point, arrayList);
                }
            }
            if (gamePiece == null) {
                Stack stack;
                command = command.append(this.movedPiece(this.dragging, point));
                command = command.append(map.placeAt(this.dragging, point));
                if (!(this.dragging instanceof Stack) && !Boolean.TRUE.equals(this.dragging.getProperty("NoStack")) && (stack = map.getStackMetrics().createStack(this.dragging)) != null) {
                    command = command.append(map.placeAt(stack, point));
                }
            } else {
                command = command.append(this.movedPiece(this.dragging, gamePiece.getPosition()));
                command = command.append(map.getStackMetrics().merge(gamePiece, this.dragging));
            }
            if (map.getMoveKey() != null) {
                this.applyKeyAfterMove(gamePieceArray, command, map.getMoveKey());
            }
            boundsTracker.addPiece(this.dragging);
        }
        if (GlobalOptions.getInstance().autoReportEnabled()) {
            gamePieceArray = this.createMovementReporter(command).getReportCommand();
            gamePieceArray.execute();
            command = command.append((Command)gamePieceArray);
        }
        boundsTracker.repaint();
        return command;
    }

    protected void applyKeyAfterMove(GamePiece[] gamePieceArray, Command command, KeyStroke keyStroke) {
        for (int i = 0; i < gamePieceArray.length; ++i) {
            GamePiece gamePiece = gamePieceArray[i];
            if (gamePiece.getProperty("snapshot") == null) {
                gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
            }
            command.append(gamePiece.keyEvent(keyStroke));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.canHandleEvent(mouseEvent)) {
            this.selectMovablePieces(mouseEvent);
        }
    }

    protected void selectMovablePieces(MouseEvent mouseEvent) {
        GamePiece gamePiece = this.map.findPiece(mouseEvent.getPoint(), this.dragTargetSelector);
        this.dragBegin = mouseEvent.getPoint();
        if (gamePiece != null) {
            EventFilter eventFilter = (EventFilter)gamePiece.getProperty("moveEventFilter");
            if (eventFilter == null || !eventFilter.rejectEvent(mouseEvent)) {
                this.selectionProcessor.accept(gamePiece);
            } else {
                DragBuffer.getBuffer().clear();
            }
        } else {
            DragBuffer.getBuffer().clear();
        }
        this.map.repaint();
    }

    protected void selectMovablePieces(Point point) {
        GamePiece gamePiece = this.map.findPiece(point, this.dragTargetSelector);
        this.dragBegin = point;
        this.selectionProcessor.accept(gamePiece);
        this.map.repaint();
    }

    protected boolean canHandleEvent(MouseEvent mouseEvent) {
        return !mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !mouseEvent.isMetaDown() && mouseEvent.getClickCount() < 2 && !mouseEvent.isConsumed();
    }

    public boolean isClick(Point point) {
        boolean bl = false;
        if (this.dragBegin != null) {
            boolean bl2;
            Board board = this.map.findBoard(point);
            boolean bl3 = bl2 = board != null && board.getGrid() != null;
            if (bl2) {
                PieceIterator pieceIterator = DragBuffer.getBuffer().getIterator();
                GamePiece gamePiece = pieceIterator.hasMoreElements() ? pieceIterator.nextPiece() : null;
                boolean bl4 = bl2 = gamePiece != null && !Boolean.TRUE.equals(gamePiece.getProperty("IgnoreGrid")) && (gamePiece.getParent() == null || !gamePiece.getParent().isExpanded());
            }
            if (bl2) {
                if (this.map.equals(DragBuffer.getBuffer().getFromMap()) && this.map.snapTo(point).equals(this.map.snapTo(this.dragBegin))) {
                    bl = true;
                }
            } else if (Math.abs(point.x - this.dragBegin.x) <= 5 && Math.abs(point.y - this.dragBegin.y) <= 5) {
                bl = true;
            }
        }
        return bl;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.canHandleEvent(mouseEvent) && !this.isClick(mouseEvent.getPoint())) {
            this.performDrop(mouseEvent.getPoint());
        }
        this.dragBegin = null;
        this.map.getView().setCursor(null);
    }

    protected void performDrop(Point point) {
        Command command = this.movePieces(this.map, point);
        GameModule.getGameModule().sendAndLog(command);
        if (command != null) {
            DragBuffer.getBuffer().clear();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public int compare(Object object, Object object2) {
        return this.pieceSorter.compare(object, object2);
    }

    public static class DragHandler
    implements DragGestureListener,
    DragSourceListener,
    DragSourceMotionListener,
    DropTargetListener {
        final int CURSOR_ALPHA = 127;
        final int EXTRA_BORDER = 4;
        private static DragHandler theDragHandler = null;
        private JLabel dragCursor;
        private BufferedImage dragImage;
        private Point drawOffset = new Point();
        private Rectangle boundingBox;
        private int originalPieceOffsetX;
        private int originalPieceOffsetY;
        private double dragPieceOffCenterZoom = 1.0;
        private int currentPieceOffsetX;
        private int currentPieceOffsetY;
        private double dragCursorZoom = 1.0;
        Component dragWin;
        Component dropWin;
        JLayeredPane drawWin;
        java.util.Map dropTargetListeners = new HashMap();
        Point lastDragLocation = new Point();

        public static DragHandler getTheDragHandler() {
            if (theDragHandler == null) {
                theDragHandler = new DragHandler();
            }
            return theDragHandler;
        }

        public static DropTarget makeDropTarget(Component component, int n, DropTargetListener dropTargetListener) {
            if (dropTargetListener != null) {
                DragHandler.getTheDragHandler().dropTargetListeners.put(component, dropTargetListener);
            }
            DropTarget dropTarget = new DropTarget(component, n, DragHandler.getTheDragHandler());
            return dropTarget;
        }

        public static void removeDropTarget(Component component) {
            DragHandler.getTheDragHandler().dropTargetListeners.remove(component);
        }

        protected DropTargetListener getListener(DropTargetEvent dropTargetEvent) {
            Component component = dropTargetEvent.getDropTargetContext().getComponent();
            return (DropTargetListener)this.dropTargetListeners.get(component);
        }

        private DragHandler() {
            if (theDragHandler != null) {
                throw new RuntimeException("There can be no more than one DragHandler!");
            }
        }

        protected void moveDragCursor(int n, int n2) {
            if (this.drawWin != null) {
                this.dragCursor.setLocation(n - this.drawOffset.x, n2 - this.drawOffset.y);
            }
        }

        private void removeDragCursor() {
            if (this.drawWin != null) {
                if (this.dragCursor != null) {
                    this.dragCursor.setVisible(false);
                    this.drawWin.remove(this.dragCursor);
                }
                this.drawWin = null;
            }
        }

        private void calcDrawOffset() {
            if (this.drawWin != null) {
                this.drawOffset.x = -this.boundingBox.x - this.currentPieceOffsetX + 4;
                this.drawOffset.y = -this.boundingBox.y - this.currentPieceOffsetY + 4;
                SwingUtilities.convertPointToScreen(this.drawOffset, this.drawWin);
            }
        }

        private void setDrawWin(JLayeredPane jLayeredPane) {
            if (jLayeredPane != this.drawWin) {
                if (this.dragCursor.getParent() != null) {
                    this.dragCursor.getParent().remove(this.dragCursor);
                }
                if (this.drawWin != null) {
                    this.drawWin.repaint(this.dragCursor.getBounds());
                }
                this.drawWin = jLayeredPane;
                this.calcDrawOffset();
                this.dragCursor.setVisible(false);
                this.drawWin.add((Component)this.dragCursor, JLayeredPane.DRAG_LAYER);
            }
        }

        public void setDrawWinToOwnerOf(Component component) {
            JRootPane jRootPane;
            if (component != null && (jRootPane = SwingUtilities.getRootPane(component)) != null) {
                this.setDrawWin(jRootPane.getLayeredPane());
            }
        }

        private BufferedImage makeDragImage(double d) {
            Object object;
            Object object2;
            this.dragCursorZoom = d;
            this.currentPieceOffsetX = (int)((double)this.originalPieceOffsetX / this.dragPieceOffCenterZoom * d + 0.5);
            this.currentPieceOffsetY = (int)((double)this.originalPieceOffsetY / this.dragPieceOffCenterZoom * d + 0.5);
            PieceIterator pieceIterator = DragBuffer.getBuffer().getIterator();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            GamePiece gamePiece = pieceIterator.nextPiece();
            this.boundingBox = gamePiece.getShape().getBounds();
            this.boundingBox.width = (int)((double)this.boundingBox.width * d);
            this.boundingBox.height = (int)((double)this.boundingBox.height * d);
            this.boundingBox.x = (int)((double)this.boundingBox.x * d);
            this.boundingBox.y = (int)((double)this.boundingBox.y * d);
            arrayList.add(new Point(0, 0));
            while (pieceIterator.hasMoreElements()) {
                GamePiece gamePiece2 = pieceIterator.nextPiece();
                Rectangle rectangle = gamePiece2.getShape().getBounds();
                rectangle.width = (int)((double)rectangle.width * d);
                rectangle.height = (int)((double)rectangle.height * d);
                rectangle.x = (int)((double)rectangle.x * d);
                rectangle.y = (int)((double)rectangle.y * d);
                object2 = new Point((int)Math.round(d * (double)(gamePiece2.getPosition().x - gamePiece.getPosition().x)), (int)Math.round(d * (double)(gamePiece2.getPosition().y - gamePiece.getPosition().y)));
                rectangle.translate(((Point)object2).x, ((Point)object2).y);
                this.boundingBox.add(rectangle);
                arrayList.add(object2);
            }
            int n = this.boundingBox.width + 8;
            int n2 = this.boundingBox.height + 8;
            this.dragImage = new BufferedImage(n, n2, 6);
            object2 = this.dragImage.createGraphics();
            int n3 = 0;
            pieceIterator = DragBuffer.getBuffer().getIterator();
            while (pieceIterator.hasMoreElements()) {
                object = pieceIterator.nextPiece();
                Point point = (Point)arrayList.get(n3++);
                object.draw((Graphics)object2, 4 - this.boundingBox.x + point.x, 4 - this.boundingBox.y + point.y, null, d);
            }
            object = this.dragImage.getAlphaRaster();
            int n4 = n * n2;
            int[] nArray = new int[n4];
            nArray = ((Raster)object).getPixels(0, 0, n, n2, nArray);
            for (int i = 0; i < n4; ++i) {
                if (nArray[i] != 255) continue;
                nArray[i] = 127;
            }
            for (int i = 0; i < 4; ++i) {
                int n5;
                int n6 = 127 * (i + 1) / 4;
                int n7 = (i + 1) * n - i;
                for (n5 = i * (n + 1); n5 < n7; ++n5) {
                    if (nArray[n5] > 0) {
                        nArray[n5] = n6;
                    }
                    if (nArray[n4 - n5 - 1] <= 0) continue;
                    nArray[n4 - n5 - 1] = n6;
                }
                n5 = n4 - (i + 1) * n;
                for (int j = (i + 1) * n + i; j < n5; j += n) {
                    if (nArray[j] > 0) {
                        nArray[j] = n6;
                    }
                    if (nArray[n4 - j - 1] <= 0) continue;
                    nArray[n4 - j - 1] = n6;
                }
            }
            ((WritableRaster)object).setPixels(0, 0, n, n2, nArray);
            return this.dragImage;
        }

        private void makeDragCursor(double d) {
            Object object;
            Object object2;
            if (this.dragCursor == null) {
                this.dragCursor = new JLabel();
                this.dragCursor.setVisible(false);
            }
            this.dragCursorZoom = d;
            this.currentPieceOffsetX = (int)((double)this.originalPieceOffsetX / this.dragPieceOffCenterZoom * d + 0.5);
            this.currentPieceOffsetY = (int)((double)this.originalPieceOffsetY / this.dragPieceOffCenterZoom * d + 0.5);
            PieceIterator pieceIterator = DragBuffer.getBuffer().getIterator();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            GamePiece gamePiece = pieceIterator.nextPiece();
            this.boundingBox = gamePiece.getShape().getBounds();
            this.boundingBox.width = (int)((double)this.boundingBox.width * d);
            this.boundingBox.height = (int)((double)this.boundingBox.height * d);
            this.boundingBox.x = (int)((double)this.boundingBox.x * d);
            this.boundingBox.y = (int)((double)this.boundingBox.y * d);
            this.calcDrawOffset();
            arrayList.add(new Point(0, 0));
            while (pieceIterator.hasMoreElements()) {
                GamePiece gamePiece2 = pieceIterator.nextPiece();
                Rectangle rectangle = gamePiece2.getShape().getBounds();
                rectangle.width = (int)((double)rectangle.width * d);
                rectangle.height = (int)((double)rectangle.height * d);
                rectangle.x = (int)((double)rectangle.x * d);
                rectangle.y = (int)((double)rectangle.y * d);
                object2 = new Point((int)Math.round(d * (double)(gamePiece2.getPosition().x - gamePiece.getPosition().x)), (int)Math.round(d * (double)(gamePiece2.getPosition().y - gamePiece.getPosition().y)));
                rectangle.translate(((Point)object2).x, ((Point)object2).y);
                this.boundingBox.add(rectangle);
                arrayList.add(object2);
            }
            int n = this.boundingBox.width + 8;
            int n2 = this.boundingBox.height + 8;
            object2 = new BufferedImage(n, n2, 6);
            Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
            int n3 = 0;
            pieceIterator = DragBuffer.getBuffer().getIterator();
            while (pieceIterator.hasMoreElements()) {
                object = pieceIterator.nextPiece();
                Point point = (Point)arrayList.get(n3++);
                object.draw(graphics2D, 4 - this.boundingBox.x + point.x, 4 - this.boundingBox.y + point.y, this.dragCursor, d);
            }
            this.dragCursor.setSize(n, n2);
            object = ((BufferedImage)object2).getAlphaRaster();
            int n4 = n * n2;
            int[] nArray = new int[n4];
            nArray = ((Raster)object).getPixels(0, 0, n, n2, nArray);
            for (int i = 0; i < n4; ++i) {
                if (nArray[i] != 255) continue;
                nArray[i] = 127;
            }
            for (int i = 0; i < 4; ++i) {
                int n5;
                int n6 = 127 * (i + 1) / 4;
                int n7 = (i + 1) * n - i;
                for (n5 = i * (n + 1); n5 < n7; ++n5) {
                    if (nArray[n5] > 0) {
                        nArray[n5] = n6;
                    }
                    if (nArray[n4 - n5 - 1] <= 0) continue;
                    nArray[n4 - n5 - 1] = n6;
                }
                n5 = n4 - (i + 1) * n;
                for (int j = (i + 1) * n + i; j < n5; j += n) {
                    if (nArray[j] > 0) {
                        nArray[j] = n6;
                    }
                    if (nArray[n4 - j - 1] <= 0) continue;
                    nArray[n4 - j - 1] = n6;
                }
            }
            ((WritableRaster)object).setPixels(0, 0, n, n2, nArray);
            this.dragCursor.setIcon(new ImageIcon((Image)object2));
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (DragBuffer.getBuffer().getIterator().hasMoreElements()) {
                Object object;
                Point point;
                Map map = dragGestureEvent.getComponent() instanceof Map.View ? ((Map.View)dragGestureEvent.getComponent()).getMap() : null;
                GamePiece gamePiece = DragBuffer.getBuffer().getIterator().nextPiece();
                Point point2 = map == null ? dragGestureEvent.getDragOrigin() : map.componentCoordinates(dragGestureEvent.getDragOrigin());
                Point point3 = point = map == null ? gamePiece.getPosition() : map.componentCoordinates(gamePiece.getPosition());
                if (point.x <= 0 || point.y <= 0) {
                    point = point2;
                }
                if (gamePiece.getParent() != null && gamePiece.getParent().isExpanded() && map != null) {
                    object = gamePiece.getMap().getStackMetrics().relativePosition(gamePiece.getParent(), gamePiece);
                    point.translate(((Point)object).x, ((Point)object).y);
                }
                this.originalPieceOffsetX = point.x - point2.x;
                this.originalPieceOffsetY = point.y - point2.y;
                this.dragPieceOffCenterZoom = map == null ? 1.0 : map.getZoom();
                this.dragWin = dragGestureEvent.getComponent();
                this.drawWin = null;
                this.dropWin = null;
                if (!DragSource.isDragImageSupported()) {
                    this.makeDragCursor(this.dragPieceOffCenterZoom);
                    this.setDrawWinToOwnerOf(this.dragWin);
                    SwingUtilities.convertPointToScreen(point2, this.drawWin);
                    this.moveDragCursor(point2.x, point2.y);
                }
                object = this.makeDragImage(this.dragPieceOffCenterZoom);
                try {
                    Point point4 = new Point(0, 0);
                    point4.x = this.boundingBox.x + this.currentPieceOffsetX - 4;
                    point4.y = this.boundingBox.y + this.currentPieceOffsetY - 4;
                    dragGestureEvent.startDrag(Cursor.getPredefinedCursor(12), (Image)object, point4, new StringSelection(""), this);
                    dragGestureEvent.getDragSource().addDragSourceMotionListener(this);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    invalidDnDOperationException.printStackTrace();
                }
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (!DragSource.isDragImageSupported()) {
                this.removeDragCursor();
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
            if (!DragSource.isDragImageSupported() && !dragSourceDragEvent.getLocation().equals(this.lastDragLocation)) {
                this.lastDragLocation = dragSourceDragEvent.getLocation();
                this.moveDragCursor(dragSourceDragEvent.getX(), dragSourceDragEvent.getY());
                if (this.dragCursor != null && !this.dragCursor.isVisible()) {
                    this.dragCursor.setVisible(true);
                }
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            Object object;
            if (!DragSource.isDragImageSupported() && (object = dropTargetDragEvent.getDropTargetContext().getComponent()) != this.dropWin) {
                double d;
                double d2 = d = object instanceof Map.View ? ((Map.View)object).getMap().getZoom() : 1.0;
                if (Math.abs(d - this.dragCursorZoom) > 0.01) {
                    this.makeDragCursor(d);
                }
                this.setDrawWinToOwnerOf(dropTargetDragEvent.getDropTargetContext().getComponent());
                this.dropWin = object;
            }
            if ((object = this.getListener(dropTargetDragEvent)) != null) {
                object.dragEnter(dropTargetDragEvent);
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (!DragSource.isDragImageSupported()) {
                this.removeDragCursor();
            }
            dropTargetDropEvent.getLocation().translate(this.currentPieceOffsetX, this.currentPieceOffsetY);
            DropTargetListener dropTargetListener = this.getListener(dropTargetDropEvent);
            if (dropTargetListener != null) {
                dropTargetListener.drop(dropTargetDropEvent);
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            DropTargetListener dropTargetListener = this.getListener(dropTargetEvent);
            if (dropTargetListener != null) {
                dropTargetListener.dragExit(dropTargetEvent);
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            DropTargetListener dropTargetListener = this.getListener(dropTargetDragEvent);
            if (dropTargetListener != null) {
                dropTargetListener.dragOver(dropTargetDragEvent);
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            DropTargetListener dropTargetListener = this.getListener(dropTargetDragEvent);
            if (dropTargetListener != null) {
                dropTargetListener.dropActionChanged(dropTargetDragEvent);
            }
        }
    }
}

