/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.tools.LaunchButton;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PieceRecenterer
extends AbstractConfigurable
implements DeckVisitor {
    public static final String BUTTON_TEXT = "text";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String TOOLTIP = "tooltip";
    protected LaunchButton launch;
    protected Map map;
    protected DeckVisitorDispatcher dispatcher;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$PieceRecenterer$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;

    public PieceRecenterer() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameModule.getGameModule().sendAndLog(PieceRecenterer.this.recenter(PieceRecenterer.this.map));
            }
        };
        this.launch = new LaunchButton("Recenter", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.dispatcher = new DeckVisitorDispatcher(this);
    }

    public Command recenter(Map map) {
        int n;
        NullCommand nullCommand = new NullCommand();
        GamePiece[] gamePieceArray = map.getPieces();
        Rectangle rectangle = null;
        for (n = 0; n < gamePieceArray.length; ++n) {
            if (!Boolean.TRUE.equals(this.dispatcher.accept(gamePieceArray[n]))) continue;
            Point point = gamePieceArray[n].getPosition();
            Rectangle rectangle2 = gamePieceArray[n].getShape().getBounds();
            rectangle2.translate(point.x, point.y);
            rectangle = rectangle == null ? rectangle2 : rectangle.union(rectangle2);
        }
        if (rectangle != null) {
            n = map.mapSize().width / 2 - (rectangle.x + rectangle.width / 2);
            int n2 = map.mapSize().height / 2 - (rectangle.y + rectangle.height / 2);
            for (int i = 0; i < gamePieceArray.length; ++i) {
                if (!Boolean.TRUE.equals(this.dispatcher.accept(gamePieceArray[i]))) continue;
                ChangeTracker changeTracker = new ChangeTracker(gamePieceArray[i]);
                Point point = gamePieceArray[i].getPosition();
                point.translate(n, n2);
                gamePieceArray[i].setPosition(point);
                nullCommand.append(changeTracker.getChangeCommand());
            }
        }
        map.repaint();
        return nullCommand;
    }

    public Object visitDeck(Deck deck) {
        return Boolean.TRUE;
    }

    public Object visitDefault(GamePiece gamePiece) {
        return Boolean.TRUE;
    }

    public Object visitStack(Stack stack) {
        return stack.getPieceCount() > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getConfigureTypeName() {
        return "Recenter Pieces Button";
    }

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().add(this.launch);
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Tooltip text", "Button text", "Button icon", "Hotkey"};
    }

    public String[] getAttributeNames() {
        return new String[]{TOOLTIP, BUTTON_TEXT, ICON, HOTKEY};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = PieceRecenterer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PieceRecenterer.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$PieceRecenterer$IconConfig == null ? (class$VASSAL$build$module$map$PieceRecenterer$IconConfig = PieceRecenterer.class$("VASSAL.build.module.map.PieceRecenterer$IconConfig")) : class$VASSAL$build$module$map$PieceRecenterer$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = PieceRecenterer.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke};
    }

    public String getAttributeValueString(String string) {
        return this.launch.getAttributeValueString(string);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "PieceRecenterer");
    }

    public void removeFrom(Buildable buildable) {
        this.map.getToolBar().remove(this.launch);
    }

    public void setAttribute(String string, Object object) {
        this.launch.setAttribute(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/recenter.gif");
        }
    }
}

