/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.configure.BooleanConfigurer;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class Scroller
extends AbstractBuildable
implements KeyListener {
    public static final String USE_ARROWS = "useArrows";
    public static final String ALWAYS = "always";
    public static final String NEVER = "never";
    public static final String PROMPT = "prompt";
    protected String usingArrows = "prompt";
    private Map map;
    private char noEcho = '\u0000';
    protected int xStep = 100;
    protected int yStep = 100;

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getView().addKeyListener(this);
        BooleanConfigurer booleanConfigurer = new BooleanConfigurer(USE_ARROWS, "Use arrow keys to scroll", Boolean.FALSE);
        if (ALWAYS.equals(this.usingArrows)) {
            GameModule.getGameModule().getPrefs().addOption(null, booleanConfigurer);
            booleanConfigurer.setValue(Boolean.TRUE);
        } else if (PROMPT.equals(this.usingArrows)) {
            GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
        } else if (NEVER.equals(this.usingArrows)) {
            GameModule.getGameModule().getPrefs().addOption(null, booleanConfigurer);
            booleanConfigurer.setValue(Boolean.FALSE);
        }
    }

    public void add(Buildable buildable) {
    }

    public String[] getAttributeNames() {
        return new String[]{PROMPT};
    }

    public void setAttribute(String string, Object object) {
        if (USE_ARROWS.equals(string)) {
            this.usingArrows = (String)object;
        }
    }

    public String getAttributeValueString(String string) {
        if (USE_ARROWS.equals(string)) {
            return this.usingArrows;
        }
        return null;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(USE_ARROWS))) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.map.scroll(0, -this.yStep);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.map.scroll(0, this.yStep);
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.map.scroll(this.xStep, 0);
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    this.map.scroll(-this.xStep, 0);
                    keyEvent.consume();
                }
            }
        } else {
            switch (keyEvent.getKeyCode()) {
                case 97: {
                    this.noEcho = (char)49;
                    this.map.scroll(-this.xStep, this.yStep);
                    keyEvent.consume();
                    break;
                }
                case 98: {
                    this.noEcho = (char)50;
                    this.map.scroll(0, this.yStep);
                    keyEvent.consume();
                    break;
                }
                case 99: {
                    this.noEcho = (char)51;
                    this.map.scroll(this.xStep, this.yStep);
                    keyEvent.consume();
                    break;
                }
                case 100: {
                    this.noEcho = (char)52;
                    this.map.scroll(-this.xStep, 0);
                    keyEvent.consume();
                    break;
                }
                case 102: {
                    this.noEcho = (char)54;
                    this.map.scroll(this.xStep, 0);
                    keyEvent.consume();
                    break;
                }
                case 103: {
                    this.noEcho = (char)55;
                    this.map.scroll(-this.xStep, -this.yStep);
                    keyEvent.consume();
                    break;
                }
                case 104: {
                    this.noEcho = (char)56;
                    this.map.scroll(0, -this.yStep);
                    keyEvent.consume();
                    break;
                }
                case 105: {
                    this.noEcho = (char)57;
                    this.map.scroll(this.xStep, -this.yStep);
                    keyEvent.consume();
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getKeyChar() == this.noEcho) {
            keyEvent.consume();
            this.noEcho = '\u0000';
        }
    }
}

