/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.SelectionHighlighters;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.tools.FormattedString;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class SelectionHighlighter
extends AbstractConfigurable
implements Highlighter {
    public static final String NAME = "name";
    public static final String MATCH = "match";
    public static final String COLOR = "color";
    public static final String THICKNESS = "thickness";
    public static final String USE_IMAGE = "useImage";
    public static final String IMAGE = "image";
    public static final String X_OFFSET = "xoffset";
    public static final String Y_OFFSET = "yoffset";
    protected String matchProperties = "";
    protected Color color = Color.RED;
    protected int thickness = 3;
    protected boolean useImage = false;
    protected String imageName = "";
    protected int x = 0;
    protected int y = 0;
    protected VisibilityCondition visibilityCondition;
    protected Image image;
    protected PieceFilter filter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$VASSAL$build$module$map$SelectionHighlighter$IconConfig;

    public void draw(GamePiece gamePiece, Graphics graphics, int n, int n2, Component component, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.accept(gamePiece)) {
            if (this.useImage) {
                if (this.image != null) {
                    int n3 = n - (int)((double)this.image.getWidth(null) * d / 2.0);
                    int n4 = n2 - (int)((double)this.image.getHeight(null) * d / 2.0);
                    if (d == 1.0) {
                        graphics.drawImage(this.image, n3, n4, null);
                    } else {
                        graphics.drawImage(GameModule.getGameModule().getDataArchive().getScaledImage(this.image, d), n3, n4, null);
                    }
                }
            } else {
                if (this.color == null || this.thickness <= 0) {
                    return;
                }
                Shape shape = gamePiece.getShape();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(Math.max(1L, Math.round(d * (double)this.thickness))));
                graphics2D.setColor(this.color);
                AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
                affineTransform.translate((double)n / d, (double)n2 / d);
                graphics2D.draw(affineTransform.createTransformedShape(shape));
                graphics2D.setStroke(stroke);
            }
        }
    }

    public Rectangle boundingBox(GamePiece gamePiece) {
        Rectangle rectangle = gamePiece.getShape().getBounds();
        if (this.accept(gamePiece)) {
            if (this.useImage) {
                if (this.image != null) {
                    int n = this.image.getWidth(null);
                    int n2 = this.image.getHeight(null);
                    rectangle = rectangle.union(new Rectangle(-n / 2, -n2 / 2, n, n2));
                }
            } else {
                rectangle.translate(-this.thickness, -this.thickness);
                rectangle.setSize(rectangle.width + 2 * this.thickness, rectangle.height + 2 * this.thickness);
            }
        }
        return rectangle;
    }

    protected boolean accept(GamePiece gamePiece) {
        if (this.matchProperties.equals("") || this.filter == null) {
            return true;
        }
        return this.filter.accept(gamePiece);
    }

    public static String getConfigureTypeName() {
        return "Highlighter";
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Active if Properties Match:  ", "Use Image", "Border Color:  ", "Border Thickness:  ", "Image:  ", "X Offset:  ", "Y Offset:  "};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = SelectionHighlighter.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SelectionHighlighter.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SelectionHighlighter.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$awt$Color == null ? (class$java$awt$Color = SelectionHighlighter.class$("java.awt.Color")) : class$java$awt$Color, class$java$lang$Integer == null ? (class$java$lang$Integer = SelectionHighlighter.class$("java.lang.Integer")) : class$java$lang$Integer, class$VASSAL$build$module$map$SelectionHighlighter$IconConfig == null ? (class$VASSAL$build$module$map$SelectionHighlighter$IconConfig = SelectionHighlighter.class$("VASSAL.build.module.map.SelectionHighlighter$IconConfig")) : class$VASSAL$build$module$map$SelectionHighlighter$IconConfig, class$java$lang$Integer == null ? (class$java$lang$Integer = SelectionHighlighter.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = SelectionHighlighter.class$("java.lang.Integer")) : class$java$lang$Integer};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, MATCH, USE_IMAGE, COLOR, THICKNESS, IMAGE, X_OFFSET, Y_OFFSET};
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (COLOR.equals(string) || THICKNESS.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !SelectionHighlighter.this.useImage;
                }
            };
        }
        if (IMAGE.equals(string) || X_OFFSET.equals(string) || Y_OFFSET.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SelectionHighlighter.this.useImage;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    public void setAttribute(String string, Object object) {
        if (string.equals(NAME)) {
            this.setConfigureName((String)object);
        } else if (string.equals(MATCH)) {
            this.matchProperties = (String)object;
            this.filter = PropertiesPieceFilter.parse(new FormattedString(this.matchProperties).getText());
        } else if (string.equals(USE_IMAGE)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.useImage = (Boolean)object;
        } else if (string.equals(COLOR)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            if (object != null) {
                this.color = (Color)object;
            }
        } else if (string.equals(THICKNESS)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            try {
                this.thickness = (Integer)object;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equals(IMAGE)) {
            this.imageName = (String)object;
            if (this.imageName.equals("")) {
                this.image = null;
            } else {
                try {
                    this.image = GameModule.getGameModule().getDataArchive().getCachedImage(this.imageName);
                }
                catch (Exception exception) {
                    this.image = null;
                }
            }
        } else if (string.equals(X_OFFSET)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            try {
                this.x = (Integer)object;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equals(Y_OFFSET)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            try {
                this.y = (Integer)object;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String getAttributeValueString(String string) {
        if (string.equals(NAME)) {
            return this.getConfigureName();
        }
        if (string.equals(MATCH)) {
            return this.matchProperties;
        }
        if (string.equals(USE_IMAGE)) {
            return String.valueOf(this.useImage);
        }
        if (string.equals(COLOR)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (string.equals(THICKNESS)) {
            return String.valueOf(this.thickness);
        }
        if (string.equals(IMAGE)) {
            return this.imageName;
        }
        if (string.equals(X_OFFSET)) {
            return String.valueOf(this.x);
        }
        if (string.equals(Y_OFFSET)) {
            return String.valueOf(this.y);
        }
        return null;
    }

    public void removeFrom(Buildable buildable) {
        ((SelectionHighlighters)buildable).removeHighlighter(this);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "SelectionHighlighter");
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void addTo(Buildable buildable) {
        ((SelectionHighlighters)buildable).addHighlighter(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ((SelectionHighlighter)autoConfigurable).imageName);
        }
    }
}

