/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.NewGameIndicator;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringEnum;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.Stack;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.UniqueIdManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SetupStack
extends AbstractConfigurable
implements GameComponent,
UniqueIdManager.Identifyable {
    private static UniqueIdManager idMgr = new UniqueIdManager("SetupStack");
    public static final String COMMAND_PREFIX = "SETUP_STACK\t";
    protected Point pos = new Point();
    public static final String OWNING_BOARD = "owningBoard";
    public static final String X_POSITION = "x";
    public static final String Y_POSITION = "y";
    protected Map map;
    protected String owningBoardName;
    protected String id;
    public static final String NAME = "name";
    protected static NewGameIndicator indicator;
    protected StackConfigurer stackConfigurer;
    protected JButton configureButton;
    protected Configurer xConfig;
    protected Configurer yConfig;
    protected static final Dimension DEFAULT_SIZE;
    protected static final int DELTA = 1;
    protected static final int FAST = 10;
    protected static final int FASTER = 5;
    protected static final int DUMMY_SIZE = 50;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$SetupStack$OwningBoardPrompt;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$VASSAL$build$widget$PieceSlot;

    public void setup(boolean bl) {
        if (bl && indicator.isNewGame() && this.isOwningBoardActive()) {
            Stack stack = this.initializeContents();
            Point point = new Point(this.pos);
            if (this.owningBoardName != null) {
                Rectangle rectangle = this.map.getBoardByName(this.owningBoardName).bounds();
                point.translate(rectangle.x, rectangle.y);
            }
            if (this.placeNonStackingSeparately()) {
                for (int i = 0; i < stack.getPieceCount(); ++i) {
                    GamePiece gamePiece = stack.getPieceAt(i);
                    if (!Boolean.TRUE.equals(gamePiece.getProperty("NoStack"))) continue;
                    stack.remove(gamePiece);
                    this.map.placeAt(gamePiece, point);
                    --i;
                }
            }
            this.map.placeAt(stack, point);
        }
    }

    protected boolean placeNonStackingSeparately() {
        return true;
    }

    public Command getRestoreCommand() {
        return null;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "Belongs to Board", "X position", "Y position"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = SetupStack.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$SetupStack$OwningBoardPrompt == null ? (class$VASSAL$build$module$map$SetupStack$OwningBoardPrompt = SetupStack.class$("VASSAL.build.module.map.SetupStack$OwningBoardPrompt")) : class$VASSAL$build$module$map$SetupStack$OwningBoardPrompt, class$java$lang$Integer == null ? (class$java$lang$Integer = SetupStack.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = SetupStack.class$("java.lang.Integer")) : class$java$lang$Integer};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, OWNING_BOARD, X_POSITION, Y_POSITION};
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (OWNING_BOARD.equals(string)) {
            return this.owningBoardName;
        }
        if (X_POSITION.equals(string)) {
            return "" + this.pos.x;
        }
        if (Y_POSITION.equals(string)) {
            return "" + this.pos.y;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (OWNING_BOARD.equals(string)) {
            this.owningBoardName = "<any>".equals(object) ? null : (String)object;
            this.updateConfigureButton();
        } else if (X_POSITION.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.pos.x = (Integer)object;
        } else if (Y_POSITION.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.pos.y = (Integer)object;
        }
    }

    public void add(Buildable buildable) {
        super.add(buildable);
        this.updateConfigureButton();
    }

    public void addTo(Buildable buildable) {
        if (indicator == null) {
            indicator = new NewGameIndicator(COMMAND_PREFIX);
        }
        this.map = (Map)buildable;
        idMgr.add(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$widget$PieceSlot == null ? (class$VASSAL$build$widget$PieceSlot = SetupStack.class$("VASSAL.build.widget.PieceSlot")) : class$VASSAL$build$widget$PieceSlot};
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SetupStack.htm");
    }

    public static String getConfigureTypeName() {
        return "At-Start Stack";
    }

    public void removeFrom(Buildable buildable) {
        idMgr.remove(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    protected boolean isOwningBoardActive() {
        boolean bl = false;
        if (this.owningBoardName == null) {
            bl = true;
        } else if (this.map.getBoardByName(this.owningBoardName) != null) {
            bl = true;
        }
        return bl;
    }

    protected Stack initializeContents() {
        Stack stack = this.createStack();
        Configurable[] configurableArray = this.getConfigureComponents();
        for (int i = 0; i < configurableArray.length; ++i) {
            PieceSlot pieceSlot = (PieceSlot)configurableArray[i];
            GamePiece gamePiece = pieceSlot.getPiece();
            gamePiece = PieceCloner.getInstance().clonePiece(gamePiece);
            GameModule.getGameModule().getGameState().addPiece(gamePiece);
            stack.add(gamePiece);
        }
        GameModule.getGameModule().getGameState().addPiece(stack);
        return stack;
    }

    protected Stack createStack() {
        Stack stack = new Stack();
        return stack;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public Configurer getConfigurer() {
        this.config = null;
        Configurer configurer = super.getConfigurer();
        this.xConfig = ((AutoConfigurer)configurer).getConfigurer(X_POSITION);
        this.yConfig = ((AutoConfigurer)configurer).getConfigurer(Y_POSITION);
        this.updateConfigureButton();
        ((Container)configurer.getControls()).add(this.configureButton);
        return configurer;
    }

    protected void updateConfigureButton() {
        if (this.configureButton == null) {
            this.configureButton = new JButton("Reposition Stack");
            this.configureButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SetupStack.this.configureStack();
                }
            });
        }
        this.configureButton.setEnabled(this.getConfigureBoard() != null && this.buildComponents.size() > 0);
    }

    protected void configureStack() {
        this.stackConfigurer = new StackConfigurer(this);
        this.stackConfigurer.init();
        ((Component)this.stackConfigurer).setVisible(true);
    }

    protected Board getConfigureBoard() {
        String[] stringArray;
        Board board = null;
        if (this.map != null && !"<any>".equals(this.owningBoardName)) {
            board = this.map.getBoardPicker().getBoard(this.owningBoardName);
        }
        if (board == null && this.map != null && (stringArray = this.map.getBoardPicker().getAllowableBoardNames()).length > 0) {
            board = this.map.getBoardPicker().getBoard(stringArray[0]);
        }
        return board;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT_SIZE = new Dimension(800, 600);
    }

    public static class View
    extends JPanel
    implements DropTargetListener,
    DragGestureListener,
    DragSourceListener,
    DragSourceMotionListener {
        private static final long serialVersionUID = 1L;
        final int CURSOR_ALPHA = 127;
        final int EXTRA_BORDER = 4;
        protected Board myBoard;
        protected MapGrid myGrid;
        protected SetupStack myStack;
        protected GamePiece myPiece;
        protected PieceSlot slot;
        protected DragSource ds = DragSource.getDefaultDragSource();
        protected boolean isDragging = false;
        protected JLabel dragCursor;
        protected JLayeredPane drawWin;
        protected Point drawOffset = new Point();
        protected Rectangle boundingBox;
        protected int currentPieceOffsetX;
        protected int currentPieceOffsetY;
        protected int originalPieceOffsetX;
        protected int originalPieceOffsetY;
        protected Point lastDragLocation = new Point();

        public View(Board board, SetupStack setupStack) {
            this.myBoard = board;
            this.myGrid = board.getGrid();
            this.myStack = setupStack;
            this.slot = (PieceSlot)this.myStack.buildComponents.get(0);
            this.myPiece = this.slot.getPiece();
            new DropTarget(this, 2, this);
            this.ds.createDefaultDragGestureRecognizer(this, 2, this);
            this.setFocusTraversalKeysEnabled(false);
        }

        public void paint(Graphics graphics) {
            this.myBoard.draw(graphics, 0, 0, 1.0, this);
            Rectangle rectangle = new Rectangle(new Point(), this.myBoard.bounds().getSize());
            if (this.myGrid != null) {
                this.myGrid.draw(graphics, rectangle, rectangle, 1.0, false);
            }
            int n = this.myStack.pos.x;
            int n2 = this.myStack.pos.y;
            this.myStack.stackConfigurer.drawImage(graphics, n, n2, this, 1.0);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.myBoard.bounds().width, this.myBoard.bounds().height);
        }

        public void center(Point point) {
            Rectangle rectangle = this.getVisibleRect();
            if (rectangle.width == 0) {
                rectangle.width = SetupStack.DEFAULT_SIZE.width;
                rectangle.height = SetupStack.DEFAULT_SIZE.height;
            }
            int n = point.x - rectangle.width / 2;
            int n2 = point.y - rectangle.height / 2;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.scrollRectToVisible(new Rectangle(n, n2, rectangle.width, rectangle.height));
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.scrollAtEdge(dropTargetDragEvent.getLocation(), 15);
        }

        public void scrollAtEdge(Point point, int n) {
            JScrollPane jScrollPane = this.myStack.stackConfigurer.getScroll();
            Point point2 = new Point(point.x - jScrollPane.getViewport().getViewPosition().x, point.y - jScrollPane.getViewport().getViewPosition().y);
            int n2 = 0;
            int n3 = 0;
            if (point2.x < n && point2.x >= 0) {
                n2 = -1;
            }
            if (point2.x >= jScrollPane.getViewport().getSize().width - n && point2.x < jScrollPane.getViewport().getSize().width) {
                n2 = 1;
            }
            if (point2.y < n && point2.y >= 0) {
                n3 = -1;
            }
            if (point2.y >= jScrollPane.getViewport().getSize().height - n && point2.y < jScrollPane.getViewport().getSize().height) {
                n3 = 1;
            }
            if (n2 != 0 || n3 != 0) {
                Rectangle rectangle = new Rectangle(jScrollPane.getViewport().getViewRect());
                rectangle.translate(2 * n * n2, 2 * n * n3);
                rectangle = rectangle.intersection(new Rectangle(new Point(0, 0), this.getPreferredSize()));
                this.scrollRectToVisible(rectangle);
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this.removeDragCursor();
            Point point = dropTargetDropEvent.getLocation();
            point.translate(this.currentPieceOffsetX, this.currentPieceOffsetY);
            this.myStack.pos.x = point.x;
            this.myStack.pos.y = point.y;
            this.myStack.stackConfigurer.updateDisplay();
            this.repaint();
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            this.removeDragCursor();
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            Point point2 = new Point(this.myStack.pos);
            Rectangle rectangle = this.myStack.stackConfigurer.getPieceBoundingBox();
            rectangle.translate(point2.x, point2.y);
            if (!rectangle.contains(point)) {
                return;
            }
            this.originalPieceOffsetX = point2.x - point.x;
            this.originalPieceOffsetY = point2.y - point.y;
            this.drawWin = null;
            this.makeDragCursor();
            this.setDragCursor();
            SwingUtilities.convertPointToScreen(point, this.drawWin);
            this.moveDragCursor(point.x, point.y);
            try {
                dragGestureEvent.startDrag(Cursor.getPredefinedCursor(12), new StringSelection(""), this);
                dragGestureEvent.getDragSource().addDragSourceMotionListener(this);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                invalidDnDOperationException.printStackTrace();
            }
        }

        protected void setDragCursor() {
            JRootPane jRootPane = SwingUtilities.getRootPane(this);
            if (jRootPane != null) {
                if (this.dragCursor.getParent() != null) {
                    this.dragCursor.getParent().remove(this.dragCursor);
                }
                this.drawWin = jRootPane.getLayeredPane();
                this.calcDrawOffset();
                this.dragCursor.setVisible(true);
                this.drawWin.add((Component)this.dragCursor, JLayeredPane.DRAG_LAYER);
            }
        }

        protected void moveDragCursor(int n, int n2) {
            if (this.drawWin != null) {
                this.dragCursor.setLocation(n - this.drawOffset.x, n2 - this.drawOffset.y);
            }
        }

        private void removeDragCursor() {
            if (this.drawWin != null) {
                if (this.dragCursor != null) {
                    this.dragCursor.setVisible(false);
                    this.drawWin.remove(this.dragCursor);
                }
                this.drawWin = null;
            }
        }

        private void calcDrawOffset() {
            if (this.drawWin != null) {
                this.drawOffset.x = -this.boundingBox.x - this.currentPieceOffsetX + 4;
                this.drawOffset.y = -this.boundingBox.y - this.currentPieceOffsetY + 4;
                SwingUtilities.convertPointToScreen(this.drawOffset, this.drawWin);
            }
        }

        private void makeDragCursor() {
            if (this.dragCursor == null) {
                this.dragCursor = new JLabel();
                this.dragCursor.setVisible(false);
            }
            this.currentPieceOffsetX = this.originalPieceOffsetX;
            this.currentPieceOffsetY = this.originalPieceOffsetY;
            this.boundingBox = this.myStack.stackConfigurer.getPieceBoundingBox();
            this.calcDrawOffset();
            int n = this.boundingBox.width + 8;
            int n2 = this.boundingBox.height + 8;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.myStack.stackConfigurer.drawImage(graphics2D, 4 - this.boundingBox.x, 4 - this.boundingBox.y, this.dragCursor, 1.0);
            this.dragCursor.setSize(n, n2);
            WritableRaster writableRaster = bufferedImage.getAlphaRaster();
            int n3 = n * n2;
            int[] nArray = new int[n3];
            nArray = writableRaster.getPixels(0, 0, n, n2, nArray);
            for (int i = 0; i < n3; ++i) {
                if (nArray[i] != 255) continue;
                nArray[i] = 127;
            }
            for (int i = 0; i < 4; ++i) {
                int n4;
                int n5 = 127 * (i + 1) / 4;
                int n6 = (i + 1) * n - i;
                for (n4 = i * (n + 1); n4 < n6; ++n4) {
                    if (nArray[n4] > 0) {
                        nArray[n4] = n5;
                    }
                    if (nArray[n3 - n4 - 1] <= 0) continue;
                    nArray[n3 - n4 - 1] = n5;
                }
                n4 = n3 - (i + 1) * n;
                for (int j = (i + 1) * n + i; j < n4; j += n) {
                    if (nArray[j] > 0) {
                        nArray[j] = n5;
                    }
                    if (nArray[n3 - j - 1] <= 0) continue;
                    nArray[n3 - j - 1] = n5;
                }
            }
            writableRaster.setPixels(0, 0, n, n2, nArray);
            this.dragCursor.setIcon(new ImageIcon(bufferedImage));
        }

        public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
            if (!dragSourceDragEvent.getLocation().equals(this.lastDragLocation)) {
                this.lastDragLocation = dragSourceDragEvent.getLocation();
                this.moveDragCursor(dragSourceDragEvent.getX(), dragSourceDragEvent.getY());
                if (this.dragCursor != null && !this.dragCursor.isVisible()) {
                    this.dragCursor.setVisible(true);
                }
            }
        }
    }

    public class StackConfigurer
    extends JFrame
    implements ActionListener,
    KeyListener,
    MouseListener {
        private static final long serialVersionUID = 1L;
        protected Board board;
        protected View view;
        protected JScrollPane scroll;
        protected SetupStack myStack;
        protected PieceSlot mySlot;
        protected GamePiece myPiece;
        protected Point savePosition;

        public StackConfigurer(SetupStack setupStack2) {
            super("Adjust At-Start Stack");
            this.myStack = setupStack2;
            this.mySlot = (PieceSlot)this.myStack.buildComponents.get(0);
            this.myPiece = this.mySlot.getPiece();
            this.savePosition = new Point(this.myStack.pos);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ StackConfigurer this$1;
                {
                    this.this$1 = stackConfigurer;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.cancel();
                }
            });
        }

        protected void init() {
            this.board = SetupStack.this.getConfigureBoard();
            this.view = new View(this.board, this.myStack);
            this.view.addKeyListener(this);
            this.view.addMouseListener(this);
            this.view.setFocusable(true);
            this.scroll = new AdjustableSpeedScrollPane(this.view, 22, 32);
            this.scroll.setPreferredSize(DEFAULT_SIZE);
            this.getContentPane().add((Component)this.scroll, "Center");
            Box box = Box.createVerticalBox();
            box.add(new JLabel("Arrow Keys - Move Stack"));
            box.add(new JLabel("Ctrl/Shift Keys - Move Stack Faster  "));
            Box box2 = Box.createHorizontalBox();
            Box box3 = Box.createHorizontalBox();
            JButton jButton = new JButton("Snap to grid");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ StackConfigurer this$1;
                {
                    this.this$1 = stackConfigurer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.snap();
                    this.this$1.view.grabFocus();
                }
            });
            box3.add(jButton);
            JButton jButton2 = new JButton("Ok");
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ StackConfigurer this$1;
                {
                    this.this$1 = stackConfigurer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)this.this$1).setVisible(false);
                    StackConfigurer.access$100((StackConfigurer)this.this$1).xConfig.setValue(String.valueOf(this.this$1.myStack.pos.x));
                    StackConfigurer.access$100((StackConfigurer)this.this$1).yConfig.setValue(String.valueOf(this.this$1.myStack.pos.y));
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(jButton2);
            JButton jButton3 = new JButton("Cancel");
            jButton3.addActionListener(new ActionListener(this){
                private final /* synthetic */ StackConfigurer this$1;
                {
                    this.this$1 = stackConfigurer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cancel();
                    ((Component)this.this$1).setVisible(false);
                }
            });
            jPanel.add(jButton3);
            Box box4 = Box.createHorizontalBox();
            box4.add(box);
            box4.add(box2);
            box4.add(box3);
            Box box5 = Box.createVerticalBox();
            box5.add(box4);
            box5.add(jPanel);
            this.getContentPane().add((Component)box5, "South");
            this.board.fixImage();
            this.scroll.revalidate();
            this.updateDisplay();
            this.pack();
            this.repaint();
        }

        protected void cancel() {
            this.myStack.pos.x = this.savePosition.x;
            this.myStack.pos.y = this.savePosition.y;
        }

        public void updateDisplay() {
            if (!this.view.getVisibleRect().contains(this.myStack.pos)) {
                this.view.center(new Point(this.myStack.pos.x, this.myStack.pos.y));
            }
        }

        protected void snap() {
            MapGrid mapGrid = this.board.getGrid();
            if (mapGrid != null) {
                Point point = mapGrid.snapTo(SetupStack.this.pos);
                SetupStack.this.pos.x = point.x;
                SetupStack.this.pos.y = point.y;
                this.updateDisplay();
                this.repaint();
            }
        }

        public JScrollPane getScroll() {
            return this.scroll;
        }

        public BufferedImage getDummyImage() {
            BufferedImage bufferedImage = new BufferedImage(100, 100, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 50, 50);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, 50, 50);
            return bufferedImage;
        }

        public void drawDummyImage(Graphics graphics, int n, int n2) {
            this.drawDummyImage(graphics, n - 25, n2 - 25, null, 1.0);
        }

        public void drawDummyImage(Graphics graphics, int n, int n2, Component component, double d) {
            graphics.drawImage(this.getDummyImage(), n, n2, component);
        }

        public void drawImage(Graphics graphics, int n, int n2, Component component, double d) {
            Rectangle rectangle = this.myPiece.boundingBox();
            if (rectangle.width == 0 || rectangle.height == 0) {
                this.drawDummyImage(graphics, n, n2);
            } else {
                this.myPiece.draw(graphics, n, n2, component, d);
            }
        }

        public Rectangle getPieceBoundingBox() {
            Rectangle rectangle = this.myPiece.getShape().getBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                rectangle.y = rectangle.x = -25;
                rectangle.width = 50;
                rectangle.height = 50;
            }
            return rectangle;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.adjustY(-1, keyEvent);
                    break;
                }
                case 40: {
                    this.adjustY(1, keyEvent);
                    break;
                }
                case 37: {
                    this.adjustX(-1, keyEvent);
                    break;
                }
                case 39: {
                    this.adjustX(1, keyEvent);
                    break;
                }
                default: {
                    this.myPiece.keyEvent(KeyStroke.getKeyStrokeForEvent(keyEvent));
                }
            }
            this.updateDisplay();
            this.repaint();
            keyEvent.consume();
        }

        protected void adjustX(int n, KeyEvent keyEvent) {
            int n2;
            int n3 = n * 1;
            if (keyEvent.isShiftDown()) {
                n3 *= 10;
            }
            if (keyEvent.isControlDown()) {
                n3 *= 5;
            }
            if ((n2 = this.myStack.pos.x + n3) < 0) {
                n2 = 0;
            }
            if ((double)n2 >= this.board.getSize().getWidth()) {
                n2 = (int)this.board.getSize().getWidth() - 1;
            }
            this.myStack.pos.x = n2;
        }

        protected void adjustY(int n, KeyEvent keyEvent) {
            int n2;
            int n3 = n * 1;
            if (keyEvent.isShiftDown()) {
                n3 *= 10;
            }
            if (keyEvent.isControlDown()) {
                n3 *= 5;
            }
            if ((n2 = this.myStack.pos.y + n3) < 0) {
                n2 = 0;
            }
            if ((double)n2 >= this.board.getSize().getHeight()) {
                n2 = (int)this.board.getSize().getHeight() - 1;
            }
            this.myStack.pos.y = n2;
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle rectangle = this.getPieceBoundingBox();
            rectangle.translate(SetupStack.this.pos.x, SetupStack.this.pos.y);
            if (mouseEvent.isMetaDown() && rectangle.contains(mouseEvent.getPoint())) {
                JPopupMenu jPopupMenu = MenuDisplayer.createPopup(this.myPiece);
                jPopupMenu.addPopupMenuListener(new PopupMenuListener(this){
                    private final /* synthetic */ StackConfigurer this$1;
                    {
                        this.this$1 = stackConfigurer;
                    }

                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        this.this$1.view.repaint();
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        this.this$1.view.repaint();
                    }

                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }
                });
                jPopupMenu.show(this.view, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        static /* synthetic */ SetupStack access$100(StackConfigurer stackConfigurer) {
            return stackConfigurer.SetupStack.this;
        }
    }

    public static class OwningBoardPrompt
    extends StringEnum {
        public static final String ANY = "<any>";

        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            String[] stringArray;
            if (autoConfigurable instanceof SetupStack) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(ANY);
                Map map = ((SetupStack)autoConfigurable).map;
                if (map != null) {
                    arrayList.addAll(Arrays.asList(map.getBoardPicker().getAllowableBoardNames()));
                } else {
                    Iterator iterator = Map.getAllMaps();
                    while (iterator.hasNext()) {
                        map = (Map)iterator.next();
                        arrayList.addAll(Arrays.asList(map.getBoardPicker().getAllowableBoardNames()));
                    }
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            } else {
                stringArray = new String[]{ANY};
            }
            return stringArray;
        }
    }
}

