/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.module.map.PieceCollection;
import VASSAL.counters.GamePiece;

public class SimplePieceCollection
implements PieceCollection {
    private int capacity = 100;
    private int incr = 25;
    private GamePiece[] pieces = new GamePiece[this.capacity];
    private int pieceCount = 0;

    public int indexOf(GamePiece gamePiece) {
        for (int i = 0; i < this.pieceCount; ++i) {
            if (this.pieces[i] != gamePiece) continue;
            return i;
        }
        return -1;
    }

    public boolean canMerge(GamePiece gamePiece, GamePiece gamePiece2) {
        return true;
    }

    public void add(GamePiece gamePiece) {
        if (this.pieceCount >= this.capacity) {
            this.capacity += this.incr;
            GamePiece[] gamePieceArray = this.pieces;
            this.pieces = new GamePiece[this.capacity];
            System.arraycopy(gamePieceArray, 0, this.pieces, 0, this.pieceCount);
        }
        this.pieces[this.pieceCount++] = gamePiece;
    }

    public void clear() {
        this.pieceCount = 0;
    }

    public void remove(GamePiece gamePiece) {
        this.removePieceAt(this.indexOf(gamePiece));
    }

    public GamePiece[] getPieces() {
        GamePiece[] gamePieceArray = new GamePiece[this.pieceCount];
        System.arraycopy(this.pieces, 0, gamePieceArray, 0, this.pieceCount);
        return gamePieceArray;
    }

    public GamePiece[] getAllPieces() {
        return this.getPieces();
    }

    private void removePieceAt(int n) {
        if (n >= 0) {
            for (int i = n; i < this.pieceCount - 1; ++i) {
                this.pieces[i] = this.pieces[i + 1];
            }
            --this.pieceCount;
        }
    }

    public void reposition(GamePiece gamePiece, int n) {
        int n2 = this.indexOf(gamePiece);
        if (n2 >= 0) {
            int n3;
            for (n3 = n2; n3 < this.pieceCount - 1; ++n3) {
                this.pieces[n3] = this.pieces[n3 + 1];
            }
            for (n3 = this.pieceCount - 1; n3 > n; --n3) {
                this.pieces[n3] = this.pieces[n3 - 1];
            }
            this.pieces[n] = gamePiece;
        }
    }

    public void moveToBack(GamePiece gamePiece) {
        this.reposition(gamePiece, 0);
    }

    public void moveToFront(GamePiece gamePiece) {
        this.reposition(gamePiece, this.pieceCount - 1);
    }
}

