/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.tools.FileChooser;
import VASSAL.tools.LaunchButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;

public class TextSaver
extends AbstractConfigurable {
    protected static final String HOTKEY = "hotkey";
    protected static final String BUTTON_TEXT = "buttonText";
    protected static final String TOOLTIP = "tooltip";
    protected static final String ICON_NAME = "icon";
    protected Map map;
    protected LaunchButton launch;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$TextSaver$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;

    public TextSaver() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextSaver.this.apply();
            }
        };
        this.launch = new LaunchButton("Save Text", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON_NAME, actionListener);
        this.launch.setAttribute(TOOLTIP, "Save map contents as plain text file");
    }

    public String[] getAttributeNames() {
        return new String[]{TOOLTIP, BUTTON_TEXT, ICON_NAME, HOTKEY};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Tooltip Text", "Button Text", "Toolbar button icon", "Hotkey"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = TextSaver.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TextSaver.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$TextSaver$IconConfig == null ? (class$VASSAL$build$module$map$TextSaver$IconConfig = TextSaver.class$("VASSAL.build.module.map.TextSaver$IconConfig")) : class$VASSAL$build$module$map$TextSaver$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = TextSaver.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke};
    }

    public void setAttribute(String string, Object object) {
        this.launch.setAttribute(string, object);
    }

    public String getAttributeValueString(String string) {
        return this.launch.getAttributeValueString(string);
    }

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().add(this.launch);
    }

    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.getToolBar().remove(this.launch);
        this.map.getToolBar().revalidate();
    }

    public void apply() {
        switch (JOptionPane.showConfirmDialog(null, "Write contents as seen by opponents?", "", 0)) {
            case 1: {
                this.writeMapAsText();
                break;
            }
            case 0: {
                String string = GameModule.getUserId();
                GameModule.setUserId("yendoR117");
                this.writeMapAsText();
                GameModule.setUserId(string);
            }
        }
    }

    protected void writeMapAsText() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        if (fileChooser.showSaveDialog(this.map.getView()) != 0) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(fileChooser.getSelectedFile().getPath()));
            GamePiece[] gamePieceArray = this.map.getPieces();
            for (int i = 0; i < gamePieceArray.length; ++i) {
                String string = gamePieceArray[i].getName();
                if (string.length() <= 0) continue;
                printWriter.println(this.map.locationName(gamePieceArray[i].getPosition()) + ": " + string);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.getMessage());
        }
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "TextCapture");
    }

    public static String getConfigureTypeName() {
        return "Text Capture Tool";
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ((TextSaver)autoConfigurable).launch.getAttributeValueString(TextSaver.ICON_NAME));
        }
    }
}

