/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.tools.BackgroundTask;
import VASSAL.tools.LaunchButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class Zoomer
extends AbstractConfigurable
implements GameComponent {
    protected Map map;
    protected double zoomStep = 1.5;
    protected int zoomLevel = 0;
    protected int zoomStart = 1;
    protected double[] zoomFactor;
    protected int maxZoom = 3;
    protected LaunchButton zoomInButton;
    protected LaunchButton zoomOutButton;
    protected static final String FACTOR = "factor";
    protected static final String MAX = "max";
    protected static final String ZOOM_START = "zoomStart";
    protected static final String ZOOM_IN = "zoomInKey";
    protected static final String IN_TOOLTIP = "inTooltip";
    protected static final String IN_BUTTON_TEXT = "inButtonText";
    protected static final String IN_ICON_NAME = "inIconName";
    protected static final String IN_DEFAULT_ICON = "/images/zoomIn.gif";
    protected static final String ZOOM_OUT = "zoomOutKey";
    protected static final String OUT_TOOLTIP = "outTooltip";
    protected static final String OUT_BUTTON_TEXT = "outButtonText";
    protected static final String OUT_ICON_NAME = "outIconName";
    protected static final String OUT_DEFAULT_ICON = "/images/zoomOut.gif";
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$Zoomer$InIconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$VASSAL$build$module$map$Zoomer$OutIconConfig;

    public Zoomer() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Zoomer.this.zoomIn();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Zoomer.this.zoomLevel < Zoomer.this.zoomFactor.length - 1) {
                    JWindow jWindow = new JWindow(SwingUtilities.getWindowAncestor(Zoomer.this.map.getView()));
                    jWindow.getContentPane().setBackground(Color.white);
                    JLabel jLabel = new JLabel("Scaling Map ...");
                    jLabel.setFont(new Font("Dialog", 0, 48));
                    jLabel.setBackground(Color.white);
                    jLabel.setForeground(Color.black);
                    jLabel.setBorder(new BevelBorder(0, Color.lightGray, Color.darkGray));
                    jWindow.getContentPane().add(jLabel);
                    jWindow.pack();
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    ((Component)jWindow).setLocation(dimension.width / 2 - jWindow.getSize().width / 2, dimension.height / 2 - jWindow.getSize().height / 2);
                    Vector vector = new Vector();
                    Runnable runnable = new Runnable(this, vector, jWindow){
                        private final /* synthetic */ Vector val$finished;
                        private final /* synthetic */ JWindow val$w;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$finished = vector;
                            this.val$w = jWindow;
                        }

                        public void run() {
                            try {
                                Thread.sleep(100L);
                                if (!this.val$finished.contains(this.val$w)) {
                                    ((Component)this.val$w).setVisible(true);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    };
                    new Thread(runnable).start();
                    BackgroundTask backgroundTask = new BackgroundTask(this, vector, jWindow){
                        private final /* synthetic */ Vector val$finished;
                        private final /* synthetic */ JWindow val$w;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$finished = vector;
                            this.val$w = jWindow;
                        }

                        public void doFirst() {
                            Zoomer.access$100(2.access$000(this.this$1), 2.access$000(this.this$1).zoomFactor[2.access$000(this.this$1).zoomLevel + 1]);
                        }

                        public void doLater() {
                            2.access$000(this.this$1).zoomOut();
                            this.val$finished.add(this.val$w);
                            this.val$w.dispose();
                        }
                    };
                    backgroundTask.start();
                }
            }

            static /* synthetic */ Zoomer access$000(2 var0) {
                return var0.Zoomer.this;
            }
        };
        this.zoomInButton = new LaunchButton(null, IN_TOOLTIP, IN_BUTTON_TEXT, ZOOM_IN, IN_ICON_NAME, actionListener);
        this.zoomInButton.setAttribute(IN_TOOLTIP, "Zoom in");
        this.zoomInButton.setAttribute(IN_ICON_NAME, IN_DEFAULT_ICON);
        this.zoomOutButton = new LaunchButton(null, OUT_TOOLTIP, OUT_BUTTON_TEXT, ZOOM_OUT, OUT_ICON_NAME, actionListener2);
        this.zoomOutButton.setAttribute(OUT_TOOLTIP, "Zoom out");
        this.zoomOutButton.setAttribute(OUT_ICON_NAME, OUT_DEFAULT_ICON);
        this.setConfigureName(null);
    }

    public static String getConfigureTypeName() {
        return "Zoom capability";
    }

    public String[] getAttributeNames() {
        return new String[]{FACTOR, MAX, ZOOM_START, IN_TOOLTIP, IN_BUTTON_TEXT, IN_ICON_NAME, ZOOM_IN, OUT_TOOLTIP, OUT_BUTTON_TEXT, OUT_ICON_NAME, ZOOM_OUT};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Magnification factor", "Number of zoom levels", "Starting zoom level", "Zoom in tooltip text", "Zoom in button text", "Zoom in Icon", "Zoom in hotkey", "Zoom out tooltip text", "Zoom out button text", "Zoom out Icon", "Zoom out hotkey"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$Double == null ? (class$java$lang$Double = Zoomer.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Integer == null ? (class$java$lang$Integer = Zoomer.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Zoomer.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = Zoomer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Zoomer.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$Zoomer$InIconConfig == null ? (class$VASSAL$build$module$map$Zoomer$InIconConfig = Zoomer.class$("VASSAL.build.module.map.Zoomer$InIconConfig")) : class$VASSAL$build$module$map$Zoomer$InIconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = Zoomer.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$String == null ? (class$java$lang$String = Zoomer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Zoomer.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$Zoomer$OutIconConfig == null ? (class$VASSAL$build$module$map$Zoomer$OutIconConfig = Zoomer.class$("VASSAL.build.module.map.Zoomer$OutIconConfig")) : class$VASSAL$build$module$map$Zoomer$OutIconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = Zoomer.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke};
    }

    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map = (Map)buildable;
        this.validator = new SingleChildInstance(this.map, this.getClass());
        this.map.setZoomer(this);
        this.map.getToolBar().add(this.zoomInButton);
        this.map.getToolBar().add(this.zoomOutButton);
    }

    public String getAttributeValueString(String string) {
        if (MAX.equals(string)) {
            return "" + this.maxZoom;
        }
        if (ZOOM_START.equals(string)) {
            return "" + this.zoomStart;
        }
        if (FACTOR.equals(string)) {
            return "" + this.zoomStep;
        }
        if (this.zoomInButton.getAttributeValueString(string) != null) {
            return this.zoomInButton.getAttributeValueString(string);
        }
        return this.zoomOutButton.getAttributeValueString(string);
    }

    public void setAttribute(String string, Object object) {
        if (MAX.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                this.maxZoom = (Integer)object;
            }
            this.initZoomFactors();
        } else if (ZOOM_START.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                this.zoomStart = (Integer)object;
            }
            if (this.zoomStart < 1) {
                this.zoomStart = 1;
            }
            if (this.zoomStart > this.maxZoom) {
                this.zoomStart = this.maxZoom;
            }
            this.initZoomFactors();
        } else if (FACTOR.equals(string)) {
            if (object instanceof String) {
                object = new Double((String)object);
            }
            if (object != null) {
                this.zoomStep = (Double)object;
            }
            this.initZoomFactors();
        } else {
            this.zoomInButton.setAttribute(string, object);
            this.zoomOutButton.setAttribute(string, object);
        }
    }

    private void initZoomFactors() {
        this.zoomFactor = new double[this.maxZoom];
        this.zoomFactor[0] = 1.0;
        for (int i = 1; i < this.zoomFactor.length; ++i) {
            this.zoomFactor[i] = this.zoomFactor[i - 1] / this.zoomStep;
        }
        this.zoomLevel = this.zoomStart < 1 ? 0 : (this.zoomStart > this.maxZoom ? this.maxZoom - 1 : this.zoomStart - 1);
        this.zoomInButton.setEnabled(this.zoomLevel > 0);
        this.zoomOutButton.setEnabled(this.zoomLevel < this.maxZoom - 1);
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.setZoomer(null);
        this.map.getToolBar().remove(this.zoomInButton);
        this.map.getToolBar().remove(this.zoomOutButton);
    }

    public double getZoomFactor() {
        return this.zoomFactor[this.zoomLevel];
    }

    private void scaleBoards(double d) {
        Enumeration enumeration = this.map.getAllBoards();
        while (enumeration.hasMoreElements()) {
            Board board = (Board)enumeration.nextElement();
            board.getScaledImage(d, this.map.getView());
        }
    }

    public void zoomIn() {
        if (this.zoomInButton.isEnabled()) {
            Rectangle rectangle = this.map.getView().getVisibleRect();
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            point = this.map.mapCoordinates(point);
            --this.zoomLevel;
            this.zoomInButton.setEnabled(this.zoomLevel > 0);
            this.zoomOutButton.setEnabled(this.zoomLevel < this.maxZoom - 1);
            this.map.centerAt(point);
            this.map.repaint(true);
            this.map.getView().revalidate();
        }
    }

    public void zoomOut() {
        if (this.zoomOutButton.isEnabled()) {
            Rectangle rectangle = this.map.getView().getVisibleRect();
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            point = this.map.mapCoordinates(point);
            ++this.zoomLevel;
            this.zoomInButton.setEnabled(this.zoomLevel > 0);
            this.zoomOutButton.setEnabled(this.zoomLevel < this.maxZoom - 1);
            this.map.centerAt(point);
            this.map.repaint(true);
            this.map.getView().revalidate();
        }
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "Zoom");
    }

    public void setup(boolean bl) {
        if (!bl) {
            this.zoomLevel = this.zoomStart - 1;
            this.zoomInButton.setEnabled(this.zoomLevel > 0);
            this.zoomOutButton.setEnabled(this.zoomLevel < this.maxZoom - 1);
        }
    }

    public Command getRestoreCommand() {
        return null;
    }

    static /* synthetic */ void access$100(Zoomer zoomer, double d) {
        zoomer.scaleBoards(d);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class OutIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, Zoomer.OUT_DEFAULT_ICON);
        }
    }

    public static class InIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, Zoomer.IN_DEFAULT_ICON);
        }
    }
}

