/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.VisibilityCondition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Board
extends AbstractConfigurable
implements GridContainer {
    public static final String NAME = "name";
    public static final String IMAGE = "image";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String COLOR = "color";
    public static final String REVERSIBLE = "reversible";
    protected Image boardImage;
    protected Hashtable scaledCache = new Hashtable();
    protected Point pos = new Point(0, 0);
    protected Rectangle boundaries = new Rectangle(0, 0, 500, 500);
    protected String imageFile;
    protected String boardName = "Board 1";
    protected boolean reversible = false;
    protected boolean reversed = false;
    protected boolean fixedBoundaries = false;
    private Color color = null;
    private MapGrid grid = null;
    private Map map;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$MapGrid;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$HexGrid;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$SquareGrid;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$RegionGrid;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$ZonedGrid;

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public Board() {
        this.setConfigureName(this.boardName);
    }

    public String getName() {
        return this.boardName;
    }

    public void addTo(Buildable buildable) {
        this.validator = new SingleChildInstance(this, class$VASSAL$build$module$map$boardPicker$board$MapGrid == null ? (class$VASSAL$build$module$map$boardPicker$board$MapGrid = Board.class$("VASSAL.build.module.map.boardPicker.board.MapGrid")) : class$VASSAL$build$module$map$boardPicker$board$MapGrid);
    }

    public void removeFrom(Buildable buildable) {
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{NAME, IMAGE, REVERSIBLE, WIDTH, HEIGHT, COLOR};
        return stringArray;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Board name", "Board image", "Reversible", "Board width", "Board height", "Background color"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = Board.class$("java.lang.String")) : class$java$lang$String, class$java$awt$Image == null ? (class$java$awt$Image = Board.class$("java.awt.Image")) : class$java$awt$Image, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Board.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = Board.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Board.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$awt$Color == null ? (class$java$awt$Color = Board.class$("java.awt.Color")) : class$java$awt$Color};
    }

    public String getConfigureName() {
        return super.getConfigureName();
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (REVERSIBLE.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Board.this.imageFile != null;
                }
            };
        }
        if (WIDTH.equals(string) || HEIGHT.equals(string) || COLOR.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Board.this.imageFile == null;
                }
            };
        }
        return null;
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.boardName;
        }
        if (IMAGE.equals(string)) {
            return this.imageFile;
        }
        if (WIDTH.equals(string)) {
            return this.imageFile == null ? "" + this.boundaries.width : null;
        }
        if (HEIGHT.equals(string)) {
            return this.imageFile == null ? "" + this.boundaries.height : null;
        }
        if (COLOR.equals(string)) {
            return this.imageFile == null ? ColorConfigurer.colorToString(this.color) : null;
        }
        if (REVERSIBLE.equals(string)) {
            return "" + this.reversible;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.boardName = (String)object;
            this.setConfigureName(this.boardName);
        } else if (IMAGE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.imageFile = (String)object;
        } else if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                this.boundaries.setSize((Integer)object, this.boundaries.height);
            }
        } else if (HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (object != null) {
                this.boundaries.setSize(this.boundaries.width, (Integer)object);
            }
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.color = (Color)object;
        } else if (REVERSIBLE.equals(string)) {
            if (object instanceof String) {
                object = new Boolean("true".equals(object));
            }
            this.reversible = (Boolean)object;
        }
    }

    public Class[] getAllowableConfigureComponents() {
        Class[] classArray = new Class[]{class$VASSAL$build$module$map$boardPicker$board$HexGrid == null ? (class$VASSAL$build$module$map$boardPicker$board$HexGrid = Board.class$("VASSAL.build.module.map.boardPicker.board.HexGrid")) : class$VASSAL$build$module$map$boardPicker$board$HexGrid, class$VASSAL$build$module$map$boardPicker$board$SquareGrid == null ? (class$VASSAL$build$module$map$boardPicker$board$SquareGrid = Board.class$("VASSAL.build.module.map.boardPicker.board.SquareGrid")) : class$VASSAL$build$module$map$boardPicker$board$SquareGrid, class$VASSAL$build$module$map$boardPicker$board$RegionGrid == null ? (class$VASSAL$build$module$map$boardPicker$board$RegionGrid = Board.class$("VASSAL.build.module.map.boardPicker.board.RegionGrid")) : class$VASSAL$build$module$map$boardPicker$board$RegionGrid, class$VASSAL$build$module$map$boardPicker$board$ZonedGrid == null ? (class$VASSAL$build$module$map$boardPicker$board$ZonedGrid = Board.class$("VASSAL.build.module.map.boardPicker.board.ZonedGrid")) : class$VASSAL$build$module$map$boardPicker$board$ZonedGrid};
        return classArray;
    }

    public void draw(Graphics graphics, int n, int n2, double d, Component component) {
        this.fixImage();
        this.drawRegion(graphics, new Point(n, n2), new Rectangle(n, n2, Math.round((float)d * (float)this.boundaries.width), Math.round((float)d * (float)this.boundaries.height)), d, component);
    }

    public void drawRegion(Graphics graphics, Point point, Rectangle rectangle, double d, Component component) {
        this.fixImage();
        Rectangle rectangle2 = new Rectangle(point.x, point.y, Math.round((float)this.boundaries.width * (float)d), Math.round((float)this.boundaries.height * (float)d));
        if (rectangle.intersects(rectangle2)) {
            rectangle = rectangle.intersection(rectangle2);
            if (this.boardImage != null) {
                Image image = this.getScaledImage(d, component);
                graphics.drawImage(image, point.x, point.y, component);
            } else if (this.color != null) {
                graphics.setColor(this.color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (this.grid != null) {
                this.grid.draw(graphics, rectangle2, rectangle, d, this.reversed);
            }
        }
    }

    public synchronized Image getScaledImage(double d, Component component) {
        this.fixImage();
        return GameModule.getGameModule().getDataArchive().getScaledImage(this.boardImage, d, this.reversed, false);
    }

    public void setReversed(boolean bl) {
        if (this.reversible) {
            this.reversed = bl;
        }
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public Point localCoordinates(Point point) {
        if (this.reversed) {
            point = new Point(this.bounds().width - point.x, this.bounds().height - point.y);
        }
        return point;
    }

    public Point globalCoordinates(Point point) {
        return this.localCoordinates(point);
    }

    public void setGrid(MapGrid mapGrid) {
        this.grid = mapGrid;
    }

    public void removeGrid(MapGrid mapGrid) {
        if (this.grid == mapGrid) {
            this.grid = null;
        }
    }

    public Board getBoard() {
        return this;
    }

    public Dimension getSize() {
        return this.bounds().getSize();
    }

    public MapGrid getGrid() {
        return this.grid;
    }

    public Board copy() {
        Board board = new Board();
        board.build(this.getBuildElement(Builder.createNewDocument()));
        return board;
    }

    public void fixImage(Component component) {
        this.fixImage();
    }

    public void fixImage() {
        if (this.imageFile != null && this.boardImage == null) {
            try {
                Cleanup.init();
                Cleanup.getInstance().addBoard(this);
                try {
                    this.boardImage = GameModule.getGameModule().getDataArchive().getImage(this.imageFile);
                    ImageIcon imageIcon = new ImageIcon(this.boardImage);
                    this.boundaries.setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
                    this.fixedBoundaries = true;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "Error reading board image " + this.imageFile + " in " + GameModule.getGameModule().getDataArchive().getName(), "Not Found", 0);
                    return;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                JOptionPane.showMessageDialog(null, "Insufficient memory to load board " + this.getName() + "\nTry setting your display to use fewer colors", "Out of memory", 0);
            }
        }
    }

    public String locationName(Point point) {
        return this.grid == null ? null : this.grid.locationName(this.localCoordinates(point));
    }

    public Point snapTo(Point point) {
        return this.grid == null ? point : this.globalCoordinates(this.grid.snapTo(this.localCoordinates(point)));
    }

    public boolean isLocationRestricted(Point point) {
        return this.grid == null ? false : this.grid.isLocationRestricted(this.localCoordinates(point));
    }

    public String fileName() {
        return this.imageFile;
    }

    public Point relativePosition() {
        return this.pos;
    }

    public Rectangle bounds() {
        this.fixBounds();
        return new Rectangle(this.boundaries);
    }

    protected void fixBounds() {
        if (this.imageFile != null && this.boardImage == null && !this.fixedBoundaries) {
            try {
                this.boundaries.setSize(GameModule.getGameModule().getDataArchive().getImageSize(this.imageFile));
                this.fixedBoundaries = true;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Error reading board image " + this.imageFile + " in " + GameModule.getGameModule().getDataArchive().getName(), "Not Found", 0);
            }
        }
    }

    public void translate(int n, int n2) {
        this.boundaries.translate(n, n2);
    }

    public void setLocation(int n, int n2) {
        this.boundaries.setLocation(n, n2);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Board.htm");
    }

    public void cleanUp() {
        if (this.imageFile != null) {
            GameModule.getGameModule().getDataArchive().unCacheImage("images/" + this.imageFile);
        }
        if (this.boardImage != null) {
            GameModule.getGameModule().getDataArchive().unCacheImage(this.boardImage);
            this.boardImage = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Cleanup
    implements GameComponent {
        private static Cleanup instance;
        private HashSet toClean = new HashSet();
        private boolean gameStarted = false;

        public static void init() {
            if (instance == null) {
                instance = new Cleanup();
            }
        }

        private Cleanup() {
            GameModule.getGameModule().getGameState().addGameComponent(this);
        }

        public static Cleanup getInstance() {
            return instance;
        }

        public void addBoard(Board board) {
            this.toClean.add(board);
        }

        public Command getRestoreCommand() {
            return null;
        }

        public void setup(boolean bl) {
            if (this.gameStarted && !bl) {
                Iterator iterator = this.toClean.iterator();
                while (iterator.hasNext()) {
                    Board board = (Board)iterator.next();
                    board.cleanUp();
                    iterator.remove();
                }
            }
            this.gameStarted = bl;
            System.gc();
        }
    }
}

