/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.GeometricGrid;
import VASSAL.build.module.map.boardPicker.board.GridEditor;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.VisibilityCondition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;

public class HexGrid
extends AbstractConfigurable
implements GeometricGrid,
GridEditor.EditableGrid {
    protected Point origin = new Point(0, 32);
    protected double dx;
    protected double dy;
    protected GridContainer container;
    protected GridNumbering numbering;
    protected boolean visible = false;
    protected boolean dotsVisible = false;
    protected boolean edgesLegal = false;
    protected boolean cornersLegal = false;
    protected Color color = Color.black;
    protected boolean sideways = false;
    protected Map shapeCache = new HashMap();
    protected HexGridEditor gridEditor;
    public static final String X0 = "x0";
    public static final String Y0 = "y0";
    public static final String DY = "dy";
    public static final String DX = "dx";
    public static final String VISIBLE = "visible";
    public static final String DOTS_VISIBLE = "dotsVisible";
    public static final String CORNERS = "cornersLegal";
    public static final String EDGES = "edgesLegal";
    public static final String SIDEWAYS = "sideways";
    public static final String COLOR = "color";
    protected static final double sqrt3_2 = Math.sqrt(3.0) / 2.0;
    protected boolean alternate = false;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$HexGridNumbering;

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{SIDEWAYS, X0, Y0, DY, DX, EDGES, CORNERS, VISIBLE, DOTS_VISIBLE, COLOR};
        return stringArray;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Sideways (hexrows go horizontal)", "X offset", "Y offset", "Hex Height", "Hex Width", "Edges are legal locations", "Vertices are legal locations", "Show grid", "Draw center dots", "Color"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = HexGrid.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = HexGrid.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = HexGrid.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = HexGrid.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Double == null ? (class$java$lang$Double = HexGrid.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Boolean == null ? (class$java$lang$Boolean = HexGrid.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = HexGrid.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = HexGrid.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = HexGrid.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$awt$Color == null ? (class$java$awt$Color = HexGrid.class$("java.awt.Color")) : class$java$awt$Color};
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (COLOR.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return HexGrid.this.visible;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    public Configurer getConfigurer() {
        boolean bl = this.config != null;
        AutoConfigurer autoConfigurer = (AutoConfigurer)super.getConfigurer();
        final Configurer configurer = autoConfigurer.getConfigurer(DX);
        autoConfigurer.getConfigurer(DY).addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() != null) {
                    double d = (Double)propertyChangeEvent.getNewValue();
                    configurer.setValue(new Double(sqrt3_2 * d).toString());
                }
            }
        });
        if (!bl) {
            JButton jButton = new JButton("Edit Grid");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HexGrid.this.editGrid();
                }
            });
            ((Container)autoConfigurer.getControls()).add(jButton);
        }
        return this.config;
    }

    public HexGrid(double d, double d2, boolean bl) {
        this.dy = d;
        this.dx = d2;
        this.alternate = bl;
    }

    public HexGrid(double d, boolean bl) {
        this(d, sqrt3_2 * d, bl);
    }

    public HexGrid() {
        this(64.0, false);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEdgesLegal() {
        return this.edgesLegal;
    }

    public boolean isCornersLegal() {
        return this.cornersLegal;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setEdgesLegal(boolean bl) {
        this.edgesLegal = bl;
    }

    public boolean isSideways() {
        return this.sideways;
    }

    public void setSideways(boolean bl) {
        this.sideways = bl;
    }

    public void setCornersLegal(boolean bl) {
        this.cornersLegal = bl;
    }

    public void setHexSize(double d) {
        this.dy = d;
        this.dx = sqrt3_2 * d;
        this.shapeCache.clear();
    }

    public double getHexSize() {
        return this.dy;
    }

    public double getHexWidth() {
        return this.dx;
    }

    public void setHexWidth(double d) {
        this.dx = d;
    }

    public double getDx() {
        return this.getHexWidth();
    }

    public void setDx(double d) {
        this.setHexWidth(d);
    }

    public double getDy() {
        return this.getHexSize();
    }

    public void setDy(double d) {
        this.dy = d;
    }

    public GridContainer getContainer() {
        return this.container;
    }

    public void addTo(Buildable buildable) {
        this.container = (GridContainer)((Object)buildable);
        this.container.setGrid(this);
    }

    public void removeFrom(Buildable buildable) {
        ((GridContainer)((Object)buildable)).removeGrid(this);
    }

    public static String getConfigureTypeName() {
        return "Hex Grid";
    }

    public String getGridName() {
        return HexGrid.getConfigureTypeName();
    }

    public String getConfigureName() {
        return null;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HexGrid.htm");
    }

    public String getAttributeValueString(String string) {
        if (X0.equals(string)) {
            return "" + this.origin.x;
        }
        if (Y0.equals(string)) {
            return "" + this.origin.y;
        }
        if (DY.equals(string)) {
            return "" + this.dy;
        }
        if (DX.equals(string)) {
            return "" + this.dx;
        }
        if (CORNERS.equals(string)) {
            return "" + this.cornersLegal;
        }
        if (EDGES.equals(string)) {
            return "" + this.edgesLegal;
        }
        if (SIDEWAYS.equals(string)) {
            return "" + this.sideways;
        }
        if (VISIBLE.equals(string)) {
            return "" + this.visible;
        }
        if (DOTS_VISIBLE.equals(string)) {
            return "" + this.dotsVisible;
        }
        if (COLOR.equals(string)) {
            return this.visible ? ColorConfigurer.colorToString(this.color) : null;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (X0.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.origin.x = (Integer)object;
        } else if (Y0.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.origin.y = (Integer)object;
        } else if (DY.equals(string)) {
            if (object instanceof String) {
                object = new Double((String)object);
            }
            this.dy = (Double)object;
            if (this.dx == sqrt3_2 * 64.0) {
                this.dx = sqrt3_2 * this.dy;
            }
        } else if (DX.equals(string)) {
            if (object instanceof String) {
                object = new Double((String)object);
            }
            this.dx = (Double)object;
        } else if (CORNERS.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.cornersLegal = (Boolean)object;
        } else if (EDGES.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.edgesLegal = (Boolean)object;
        } else if (SIDEWAYS.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.sideways = (Boolean)object;
        } else if (VISIBLE.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.visible = (Boolean)object;
        } else if (DOTS_VISIBLE.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.dotsVisible = (Boolean)object;
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.color = (Color)object;
        }
        this.shapeCache.clear();
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$module$map$boardPicker$board$mapgrid$HexGridNumbering == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$HexGridNumbering = HexGrid.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.HexGridNumbering")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$HexGridNumbering};
    }

    public String locationName(Point point) {
        return this.numbering == null ? null : this.numbering.locationName(point);
    }

    public Point getLocation(String string) throws MapGrid.BadCoords {
        throw new MapGrid.BadCoords("No naming scheme specified");
    }

    public Point snapTo(Point point) {
        if (this.edgesLegal && this.cornersLegal) {
            Point point2 = this.snapToHexSide(point);
            Point point3 = this.snapToHexVertex(point);
            if ((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y) < (point.x - point3.x) * (point.x - point3.x) + (point.y - point3.y) * (point.y - point3.y)) {
                return point2;
            }
            return point3;
        }
        if (this.edgesLegal) {
            return this.snapToHexSide(point);
        }
        if (this.cornersLegal) {
            return this.snapToHexVertex(point);
        }
        return this.snapToHex(point);
    }

    public boolean isLocationRestricted(Point point) {
        return true;
    }

    public Point snapToHex(Point point) {
        point = new Point(point);
        this.rotateIfSideways(point);
        point.setLocation(this.hexX(point.x, point.y), this.hexY(point.x, point.y));
        this.rotateIfSideways(point);
        return point;
    }

    public Point snapToHexSide(Point point) {
        point = new Point(point);
        this.rotateIfSideways(point);
        point.setLocation(this.sideX(point.x, point.y), this.sideY(point.x, point.y));
        this.rotateIfSideways(point);
        return point;
    }

    public Point snapToHexVertex(Point point) {
        point = new Point(point);
        this.rotateIfSideways(point);
        point.setLocation(this.vertexX(point.x, point.y), this.vertexY(point.x, point.y));
        this.rotateIfSideways(point);
        return point;
    }

    public void rotate(Point point) {
        int n = point.x;
        point.x = point.y;
        point.y = n;
    }

    public void rotateIfSideways(Point point) {
        if (this.sideways) {
            this.rotate(point);
        }
    }

    public Area getGridShape(Point point, int n) {
        Area area = (Area)this.shapeCache.get(new Integer(n));
        if (area == null) {
            Point point2 = new Point(0, 0);
            area = this.getSingleHexShape(point2.x, point2.y, false);
            for (int i = -n; i <= n; ++i) {
                int n2 = point2.x + (int)((double)i * this.dx);
                int n3 = n * 2 + 1 - Math.abs(i);
                int n4 = 0;
                n4 = n3 % 2 == 1 ? point2.y - (int)(this.dy * (double)(n3 - 1) / 2.0) : point2.y - (int)(this.dy * (0.5 + (double)((n3 - 2) / 2)));
                int n5 = n4;
                for (int j = 0; j < n3; ++j) {
                    Point point3 = new Point(n2, n5);
                    this.rotateIfSideways(point3);
                    area.add(this.getSingleHexShape(point3.x, point3.y, false));
                    n5 = (int)((double)n5 + this.dy);
                }
            }
            this.rotateIfSideways(point2);
            area.transform(AffineTransform.getTranslateInstance(0 - point2.x, 0 - point2.y));
            this.shapeCache.put(new Integer(n), area);
        }
        area = new Area(AffineTransform.getTranslateInstance(point.x, point.y).createTransformedShape(area));
        return area;
    }

    protected Area getSingleHexShape(int n, int n2, boolean bl) {
        Polygon polygon = new Polygon();
        float f = this.sideways ? n2 : n;
        float f2 = this.sideways ? n : n2;
        float f3 = (float)this.dx;
        float f4 = (float)this.dy;
        float f5 = 2.0f * f3 / 3.0f;
        Point point = new Point();
        Point point2 = new Point();
        Point point3 = new Point();
        Point point4 = new Point();
        Point point5 = new Point();
        Point point6 = new Point();
        float f6 = f - f5;
        float f7 = f2;
        point.setLocation(Math.round(f6), Math.round(f7));
        float f8 = f - 0.5f * f5;
        float f9 = bl ? f2 + 0.5f * f4 : f2 - 0.5f * f4;
        point2.setLocation(Math.round(f8), Math.round(f9));
        float f10 = f + 0.5f * f5;
        float f11 = f9;
        point3.setLocation(Math.round(f10) + 1, Math.round(f11));
        float f12 = f + f5;
        float f13 = f2;
        point4.setLocation(Math.round(f12) + 1, Math.round(f13));
        float f14 = f10;
        float f15 = bl ? f2 - 0.5f * f4 : f2 + 0.5f * f4;
        point5.setLocation(Math.round(f14) + 1, Math.round(f15) + 1);
        float f16 = f8;
        float f17 = f15;
        point6.setLocation(Math.round(f16), Math.round(f17) + 1);
        if (this.sideways) {
            this.rotate(point);
            this.rotate(point2);
            this.rotate(point3);
            this.rotate(point4);
            this.rotate(point5);
            this.rotate(point6);
        }
        polygon.addPoint(point.x, point.y);
        polygon.addPoint(point2.x, point2.y);
        polygon.addPoint(point3.x, point3.y);
        polygon.addPoint(point4.x, point4.y);
        polygon.addPoint(point5.x, point5.y);
        polygon.addPoint(point6.x, point6.y);
        polygon.addPoint(point.x, point.y);
        return new Area(polygon);
    }

    public int range(Point point, Point point2) {
        double d;
        point = new Point(point);
        this.rotateIfSideways(point);
        point2 = new Point(point2);
        this.rotateIfSideways(point2);
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        for (d = Math.atan2(-n, -n2) + Math.PI; d > 1.0471975511965976; d -= 1.0471975511965976) {
        }
        d = 0.5235987755982988 - d;
        double d2 = Math.sqrt(n * n + n2 * n2);
        return (int)((d2 *= Math.cos(d)) / (this.dy * sqrt3_2) + 0.5);
    }

    protected int hexX(int n, int n2) {
        return (int)(this.dx * (double)((int)Math.floor(((double)(n - this.origin.x) + this.dx / 2.0) / this.dx)) + (double)this.origin.x);
    }

    protected int hexY(int n, int n2) {
        int n3 = (int)Math.floor(((double)(n - this.origin.x) + this.dx / 2.0) / this.dx);
        if (n3 % 2 == 0) {
            return (int)(this.dy * (double)((int)Math.floor(((double)(n2 - this.origin.y) + this.dy / 2.0) / this.dy)) + (double)this.origin.y);
        }
        return (int)(this.dy * (double)((int)Math.floor((double)(n2 - this.origin.y) / this.dy)) + (double)((int)(this.dy / 2.0)) + (double)this.origin.y);
    }

    protected int sideX(int n, int n2) {
        return (int)(this.dx / 2.0 * (double)((int)Math.floor(((double)(n - this.origin.x) + this.dx / 4.0) * 2.0 / this.dx)) + (double)this.origin.x);
    }

    protected int sideY(int n, int n2) {
        int n3 = (int)Math.floor(((double)(n - this.origin.x) + this.dx / 4.0) * 2.0 / this.dx);
        if (n3 % 2 == 0) {
            return (int)(this.dy / 2.0 * (double)((int)Math.floor(((double)(n2 - this.origin.y) + this.dy / 4.0) * 2.0 / this.dy)) + (double)this.origin.y);
        }
        return (int)(this.dy / 2.0 * (double)((int)Math.floor((double)((n2 - this.origin.y) * 2) / this.dy)) + (double)((int)(this.dy / 4.0)) + (double)this.origin.y);
    }

    protected int vertexX(int n, int n2) {
        int n3 = (int)Math.floor(((double)(n2 - this.origin.y) + this.dy / 4.0) * 2.0 / this.dy);
        if (n3 % 2 == 0) {
            return (int)(2.0 * this.dx / 3.0 * (double)((int)(Math.floor((double)(n - this.origin.x) + this.dx / 3.0) * 3.0 / (2.0 * this.dx))) + (double)this.origin.x);
        }
        return (int)(2.0 * this.dx / 3.0 * (double)((int)(Math.floor((double)(n - this.origin.x) + this.dx / 3.0 + this.dx / 3.0) * 3.0 / (2.0 * this.dx))) - (double)((int)(this.dx / 3.0)) + (double)this.origin.x);
    }

    protected int vertexY(int n, int n2) {
        return (int)(this.dy / 2.0 * (double)((int)Math.floor(((double)(n2 - this.origin.y) + this.dy / 4.0) * 2.0 / this.dy)) + (double)this.origin.y);
    }

    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (this.visible) {
            this.forceDraw(graphics, rectangle, rectangle2, d, bl);
        }
        if (this.numbering != null) {
            this.numbering.draw(graphics, rectangle, rectangle2, d, bl);
        }
    }

    public void forceDraw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        graphics.setColor(this.color == null ? Color.black : this.color);
        float f = (float)(this.dx * d);
        float f2 = (float)(this.dy * d);
        float f3 = 2.0f * f / 3.0f;
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        Shape shape = graphics.getClip();
        if (shape != null) {
            Area area = new Area(shape);
            area.intersect(new Area(rectangle3));
            graphics.setClip(area);
        }
        if (this.sideways) {
            rectangle = new Rectangle(rectangle.y, rectangle.x, rectangle.height, rectangle.width);
            rectangle3 = new Rectangle(rectangle3.y, rectangle3.x, rectangle3.height, rectangle3.width);
        }
        float f4 = bl ? (float)rectangle.x + (float)d * (float)this.origin.x + (float)rectangle.width - 2.0f * f * (float)Math.ceil(((double)rectangle.x + d * (double)this.origin.x + (double)rectangle.width - (double)rectangle3.x) / (double)(2.0f * f)) : (float)rectangle.x + (float)d * (float)this.origin.x + 2.0f * f * (float)Math.floor(((double)(rectangle3.x - rectangle.x) - d * (double)this.origin.x) / (double)(2.0f * f));
        float f5 = (float)(rectangle3.x + rectangle3.width) + 2.0f * f;
        float f6 = bl ? (float)rectangle.y + (float)d * (float)this.origin.y + (float)rectangle.height - f2 * (float)Math.ceil(((double)rectangle.y + d * (double)this.origin.y + (double)rectangle.height - (double)rectangle3.y) / (double)f2) : (float)rectangle.y + (float)d * (float)this.origin.y + f2 * (float)Math.floor(((double)(rectangle3.y - rectangle.y) - d * (double)this.origin.y) / (double)f2);
        float f7 = (float)(rectangle3.y + rectangle3.height) + f2;
        Point point = new Point();
        Point point2 = new Point();
        Point point3 = new Point();
        Point point4 = new Point();
        Point point5 = new Point();
        float f8 = f4;
        while (f8 < f5) {
            float f9 = f6;
            while (f9 < f7) {
                float f10 = f8 - f3;
                float f11 = f9;
                point2.setLocation(Math.round(f10), Math.round(f11));
                float f12 = f8 - 0.5f * f3;
                float f13 = bl ? f9 + 0.5f * f2 : f9 - 0.5f * f2;
                point3.setLocation(Math.round(f12), Math.round(f13));
                float f14 = f8 + 0.5f * f3;
                float f15 = f13;
                point4.setLocation(Math.round(f14), Math.round(f15));
                float f16 = f8 + f3;
                float f17 = f9;
                point5.setLocation(Math.round(f16), Math.round(f17));
                if (this.sideways) {
                    this.rotate(point2);
                    this.rotate(point3);
                    this.rotate(point4);
                    this.rotate(point5);
                }
                graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
                graphics.drawLine(point3.x, point3.y, point4.x, point4.y);
                graphics.drawLine(point4.x, point4.y, point5.x, point5.y);
                if (this.dotsVisible) {
                    point.setLocation(Math.round(f8), Math.round(f9));
                    this.rotateIfSideways(point);
                    graphics.fillRect(point.x, point.y, 2, 2);
                    point.setLocation(Math.round(f8 + f), Math.round(f9 + f2 / 2.0f));
                    this.rotateIfSideways(point);
                    graphics.fillRect(point.x, point.y, 2, 2);
                }
                point2.setLocation(Math.round(f10 += f), Math.round(f11 += 0.5f * f2));
                point3.setLocation(Math.round(f12 += f), Math.round(f13 += 0.5f * f2));
                point4.setLocation(Math.round(f14 += f), Math.round(f15 += 0.5f * f2));
                point5.setLocation(Math.round(f16 += f), Math.round(f17 += 0.5f * f2));
                if (this.sideways) {
                    this.rotate(point2);
                    this.rotate(point3);
                    this.rotate(point4);
                    this.rotate(point5);
                }
                graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
                graphics.drawLine(point3.x, point3.y, point4.x, point4.y);
                graphics.drawLine(point4.x, point4.y, point5.x, point5.y);
                if (f8 == f4) {
                    point2.setLocation(Math.round(f8 - f3), Math.round(f9));
                    point3.setLocation(Math.round(f8 - f3 / 2.0f), Math.round(f9 + f2 / 2.0f));
                    if (this.sideways) {
                        this.rotate(point2);
                        this.rotate(point3);
                    }
                    graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
                }
                f9 = (float)((double)f9 + d * this.dy);
            }
            f8 = (float)((double)f8 + d * 2.0 * this.dx);
        }
        graphics.setClip(shape);
    }

    public void setGridNumbering(GridNumbering gridNumbering) {
        this.numbering = gridNumbering;
    }

    public GridNumbering getGridNumbering() {
        return this.numbering;
    }

    public Point getOrigin() {
        return new Point(this.origin);
    }

    public void setOrigin(Point point) {
        this.origin.x = point.x;
        this.origin.y = point.y;
    }

    public void editGrid() {
        this.gridEditor = new HexGridEditor(this);
        ((Component)this.gridEditor).setVisible(true);
        double d = this.dx;
        AutoConfigurer autoConfigurer = (AutoConfigurer)this.getConfigurer();
        autoConfigurer.getConfigurer(DY).setValue(String.valueOf(this.dy));
        this.dx = d;
        autoConfigurer.getConfigurer(DX).setValue(String.valueOf(this.dx));
        autoConfigurer.getConfigurer(X0).setValue(String.valueOf(this.origin.x));
        autoConfigurer.getConfigurer(Y0).setValue(String.valueOf(this.origin.y));
        autoConfigurer.getConfigurer(SIDEWAYS).setValue(String.valueOf(this.sideways));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class HexGridEditor
    extends GridEditor {
        public HexGridEditor(GridEditor.EditableGrid editableGrid) {
            super(editableGrid);
        }

        public void calculate() {
            if (this.isPerpendicular(this.hp1, this.hp2)) {
                this.calculate_step2(this.hp1, this.hp2, this.hp3);
            } else if (this.isPerpendicular(this.hp1, this.hp3)) {
                this.calculate_step2(this.hp1, this.hp3, this.hp2);
            } else if (this.isPerpendicular(this.hp2, this.hp3)) {
                this.calculate_step2(this.hp2, this.hp3, this.hp1);
            } else {
                this.reportShapeError();
            }
        }

        protected void calculate_step2(Point point, Point point2, Point point3) {
            if (!this.isPerpendicular(point, point3) && !this.isPerpendicular(point2, point3)) {
                if (this.isHorizontal(point, point2)) {
                    if (point3.x < point.x && point3.x < point2.x || point3.x > point.x && point3.x > point2.x) {
                        this.check(false, point, point2, point3);
                    } else {
                        this.checkEnd(true, point, point2, point3);
                    }
                } else if (point3.y < point.y && point3.y < point2.y || point3.y > point.y && point3.y > point2.y) {
                    this.check(true, this.reverse(point), this.reverse(point2), this.reverse(point3));
                } else {
                    this.checkEnd(false, this.reverse(point), this.reverse(point2), this.reverse(point3));
                }
            } else {
                this.reportShapeError();
            }
        }

        protected Point reverse(Point point) {
            return new Point(point.y, point.x);
        }

        protected void check(boolean bl, Point point, Point point2, Point point3) {
            int n = Math.abs(point.x - point2.x);
            int n2 = n * 3 / 2;
            int n3 = Math.abs(point3.y - point2.y) * 2;
            int n4 = Math.min(point.x, point2.x) % n2 + n / 2;
            int n5 = Math.min(point.x, point2.x) / n2;
            int n6 = Math.min(point.y, point2.y) % n3 - (n5 % 2 == 1 ? 0 : n3 / 2);
            if (n6 < 0) {
                n6 += n3;
            }
            this.setMetrics(n2, n3, n4, n6, bl);
        }

        protected void checkEnd(boolean bl, Point point, Point point2, Point point3) {
            if (Math.abs((point.x + point2.x) / 2 - point3.x) > 5) {
                this.reportShapeError();
                return;
            }
            int n = Math.abs(point3.y - point.y) * 2;
            int n2 = n * 3 / 2;
            int n3 = Math.abs(point3.x - point2.x) * 2;
            int n4 = point.y - (point3.y < point.y ? 0 : n);
            int n5 = n4 % n2 + n / 2;
            int n6 = n4 / n2;
            int n7 = Math.min(point.x, point2.x) % n3 - (n6 % 2 == 1 ? 0 : n3 / 2);
            this.setMetrics(n2, n3, n5, n7, bl);
        }

        protected void setMetrics(int n, int n2, int n3, int n4, boolean bl) {
            this.grid.setDx(n);
            this.grid.setDy(n2);
            this.grid.setOrigin(new Point(n3, n4));
            this.grid.setSideways(bl);
        }
    }
}

