/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.counters.Labeler;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.JComponent;

public class Region
extends AbstractConfigurable {
    private String name = "";
    private Point origin = new Point(0, 0);
    private RegionGrid myGrid;
    private Rectangle selectionRect = new Rectangle();
    private boolean selected = false;
    public static final String NAME = "name";
    public static final String X = "originx";
    public static final String Y = "originy";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public Region() {
    }

    public Region(Point point) {
        this.origin = point;
    }

    public String getName() {
        return this.name;
    }

    public Rectangle getSelectionRect() {
        return this.selectionRect;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point point) {
        this.origin = point;
    }

    public void moveOrigin(int n, int n2) {
        this.origin.translate(n, n2);
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{NAME, X, Y};
        return stringArray;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "X Co-ord", "Y Co-ord"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = Region.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = Region.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Region.class$("java.lang.Integer")) : class$java$lang$Integer};
    }

    public void addTo(Buildable buildable) {
        this.myGrid = (RegionGrid)buildable;
        this.myGrid.addRegion(this);
    }

    public void removeFrom(Buildable buildable) {
        ((RegionGrid)buildable).removeRegion(this);
    }

    public static String getConfigureTypeName() {
        return "Region";
    }

    public String getConfigureName() {
        return this.name;
    }

    public boolean contains(Point point) {
        return this.selectionRect.contains(point);
    }

    public HelpFile getHelpFile() {
        return null;
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return "" + this.name;
        }
        if (X.equals(string)) {
            return "" + this.origin.x;
        }
        if (Y.equals(string)) {
            return "" + this.origin.y;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (NAME.equals(string)) {
            this.name = (String)object;
            this.setConfigureName(this.name);
            if (this.myGrid != null) {
                this.myGrid.addRegion(this);
            }
        } else if (X.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.origin.x = (Integer)object;
        } else if (Y.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.origin.y = (Integer)object;
        }
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String locationName() {
        return this.name;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void move(int n, int n2, JComponent jComponent) {
        Rectangle rectangle = this.selectionRect;
        rectangle.translate(n, n2);
        if (jComponent.getVisibleRect().contains(rectangle)) {
            this.moveOrigin(n, n2);
        }
    }

    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        int n = (int)(d * (double)this.myGrid.getFontSize() + 0.5);
        Font font = new Font("Dialog", 0, n);
        Color color = this.selected ? Color.white : Color.black;
        Color color2 = this.selected ? Color.black : Color.white;
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        Shape shape = graphics.getClip();
        if (shape != null) {
            Area area = new Area(shape);
            area.intersect(new Area(rectangle3));
            graphics.setClip(area);
        }
        int n2 = (int)(d * (double)this.origin.x + 0.5) + rectangle.x - 1;
        int n3 = (int)(d * (double)this.origin.y + 0.5) + rectangle.y - 1;
        Color color3 = graphics.getColor();
        graphics.setColor(color2);
        graphics.fillRect(n2, n3, 3, 3);
        graphics.setColor(color);
        graphics.drawRect(n2, n3, 3, 3);
        graphics.setColor(color3);
        Labeler.drawLabel(graphics, this.name, n2, n3 + 7, font, 0, 3, color, color2, color);
        graphics.setClip(shape);
        int n4 = graphics.getFontMetrics().stringWidth(this.name + "  ");
        int n5 = graphics.getFontMetrics().getHeight();
        this.selectionRect.setLocation(n2 - n4 / 2, n3 - 1);
        this.selectionRect.setSize(n4, n5 + 7 + 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

