/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.configure.Configurer;
import VASSAL.configure.EditPropertiesAction;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.AdjustableSpeedScrollPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class RegionGrid
extends AbstractConfigurable
implements MapGrid {
    private Hashtable regionList = new Hashtable();
    private GridContainer container;
    private boolean visible = false;
    private static boolean inConfig = false;
    private int fontSize = 9;
    private boolean snapTo = true;
    private Config regionConfigurer;
    private GridNumbering gridNumbering;
    RegionGrid me = this;
    public static final String SNAPTO = "snapto";
    public static final String VISIBLE = "visible";
    public static final String FONT_SIZE = "fontsize";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$Region;

    public void addRegion(Region region) {
        this.regionList.put(region.getOrigin(), region);
        if (inConfig) {
            this.regionConfigurer.view.repaint();
        }
    }

    public void removeRegion(Region region) {
        this.regionList.remove(region.getOrigin());
    }

    public GridNumbering getGridNumbering() {
        return this.gridNumbering;
    }

    public void setGridNumbering(GridNumbering gridNumbering) {
        this.gridNumbering = gridNumbering;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String[] getAttributeNames() {
        return new String[]{SNAPTO, VISIBLE, FONT_SIZE};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Snap to defined point?", "Draw region names", "Font Size"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = RegionGrid.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = RegionGrid.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = RegionGrid.class$("java.lang.Integer")) : class$java$lang$Integer};
    }

    public Configurer getConfigurer() {
        boolean bl = this.config != null;
        Configurer configurer = super.getConfigurer();
        if (!bl) {
            JButton jButton = new JButton("Define Regions");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RegionGrid.this.configureRegions();
                }
            });
            ((Container)configurer.getControls()).add(jButton);
        }
        return configurer;
    }

    public void addTo(Buildable buildable) {
        this.container = (GridContainer)((Object)buildable);
        this.container.setGrid(this);
    }

    public void removeFrom(Buildable buildable) {
        this.container.removeGrid(this);
        this.container = null;
    }

    public static String getConfigureTypeName() {
        return "Irregular Grid";
    }

    public String getConfigureName() {
        return null;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("IrregularGrid.htm");
    }

    public String getAttributeValueString(String string) {
        if (VISIBLE.equals(string)) {
            return "" + this.visible;
        }
        if (FONT_SIZE.equals(string)) {
            return "" + this.fontSize;
        }
        if (SNAPTO.equals(string)) {
            return "" + this.snapTo;
        }
        return null;
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (FONT_SIZE.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return RegionGrid.this.visible;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (VISIBLE.equals(string)) {
            if (object instanceof Boolean) {
                this.visible = (Boolean)object;
            } else if (object instanceof String) {
                this.visible = "true".equals(object);
            }
        } else if (FONT_SIZE.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.fontSize = (Integer)object;
        } else if (SNAPTO.equals(string)) {
            if (object instanceof Boolean) {
                this.snapTo = (Boolean)object;
            } else if (object instanceof String) {
                this.snapTo = "true".equals(object);
            }
        }
    }

    public void configureRegions() {
        inConfig = true;
        this.regionConfigurer = new Config(this);
        ((Component)this.regionConfigurer).setVisible(true);
    }

    public boolean isVisible() {
        return this.visible || inConfig;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$module$map$boardPicker$board$Region == null ? (class$VASSAL$build$module$map$boardPicker$board$Region = RegionGrid.class$("VASSAL.build.module.map.boardPicker.board.Region")) : class$VASSAL$build$module$map$boardPicker$board$Region};
    }

    public Point getLocation(String string) throws MapGrid.BadCoords {
        throw new MapGrid.BadCoords("No naming scheme specified");
    }

    public int range(Point point, Point point2) {
        return (int)Math.round(point.distance(point2));
    }

    public Point snapTo(Point point) {
        if (!this.snapTo || this.regionList.isEmpty()) {
            return point;
        }
        return this.doSnap(point);
    }

    public boolean isLocationRestricted(Point point) {
        return this.snapTo;
    }

    protected Point doSnap(Point point) {
        double d = 9.99999999E8;
        Point point2 = point;
        Enumeration enumeration = this.regionList.keys();
        while (enumeration.hasMoreElements()) {
            Point point3 = (Point)enumeration.nextElement();
            double d2 = (point.x - point3.x) * (point.x - point3.x) + (point.y - point3.y) * (point.y - point3.y);
            if (!(d2 < d)) continue;
            d = d2;
            point2 = point3;
        }
        return new Point(point2);
    }

    public String locationName(Point point) {
        if (this.regionList.isEmpty()) {
            return null;
        }
        Point point2 = this.snapTo ? point : this.doSnap(point);
        Region region = (Region)this.regionList.get(point2);
        return region != null ? region.getName() : null;
    }

    public Region getRegion(Point point) {
        Region region = null;
        Enumeration enumeration = this.regionList.elements();
        while (enumeration.hasMoreElements()) {
            Region region2 = (Region)enumeration.nextElement();
            if (!region2.contains(point)) continue;
            return region2;
        }
        return region;
    }

    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (this.visible) {
            this.forceDraw(graphics, rectangle, rectangle2, d, bl);
        }
    }

    public void forceDraw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        Enumeration enumeration = this.regionList.elements();
        while (enumeration.hasMoreElements()) {
            Region region = (Region)enumeration.nextElement();
            region.draw(graphics, rectangle, rectangle2, d, bl);
        }
    }

    public void unSelectAll() {
        Enumeration enumeration = this.regionList.elements();
        while (enumeration.hasMoreElements()) {
            this.unSelect((Region)enumeration.nextElement());
        }
    }

    public void unSelect(Region region) {
        region.setSelected(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$202(boolean bl) {
        inConfig = bl;
        return inConfig;
    }

    public static class Config
    extends JFrame
    implements MouseListener,
    MouseMotionListener,
    ActionListener,
    KeyListener {
        protected RegionGrid grid;
        protected Board board;
        protected JPanel view;
        protected JScrollPane scroll;
        protected JPopupMenu myPopup;
        private Region selectedRegion = null;
        private Point lastClick;

        public Config(RegionGrid regionGrid) {
            super("Regions for " + regionGrid.container.getBoard().getName());
            this.board = regionGrid.container.getBoard();
            this.grid = regionGrid;
            this.initComponents();
        }

        private void initComponents() {
            this.setDefaultCloseOperation(0);
            this.view = new View(this.board, this.grid);
            this.view.addMouseListener(this);
            this.view.addMouseMotionListener(this);
            this.view.addKeyListener(this);
            this.view.setFocusable(true);
            this.scroll = new AdjustableSpeedScrollPane(this.view, 22, 32);
            this.scroll.setPreferredSize(new Dimension(800, 600));
            this.getContentPane().add((Component)this.scroll, "Center");
            JButton jButton = new JButton("Ok");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Config this$0;
                {
                    this.this$0 = config;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    RegionGrid.access$202(false);
                    ((Component)this.this$0).setVisible(false);
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(jButton);
            this.getContentPane().add((Component)jPanel, "South");
            this.board.fixImage();
            this.scroll.revalidate();
            this.pack();
            this.repaint();
        }

        public void doScroll(int n, int n2) {
            Rectangle rectangle = new Rectangle(this.scroll.getViewport().getViewRect());
            rectangle.translate(n, n2);
            rectangle = rectangle.intersection(new Rectangle(new Point(0, 0), this.view.getPreferredSize()));
            this.view.scrollRectToVisible(rectangle);
        }

        public void scrollAtEdge(Point point, int n) {
            Point point2 = new Point(point.x - this.scroll.getViewport().getViewPosition().x, point.y - this.scroll.getViewport().getViewPosition().y);
            int n2 = 0;
            int n3 = 0;
            Dimension dimension = this.scroll.getViewport().getSize();
            if (point2.x < n && point2.x >= 0) {
                n2 = -1;
            }
            if (point2.x >= dimension.width - n && point2.x < dimension.width) {
                n2 = 1;
            }
            if (point2.y < n && point2.y >= 0) {
                n3 = -1;
            }
            if (point2.y >= dimension.height - n && point2.y < dimension.height) {
                n3 = 1;
            }
            if (n2 != 0 || n3 != 0) {
                this.doScroll(2 * n * n2, 2 * n * n3);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            EditPropertiesAction editPropertiesAction;
            Point point;
            this.lastClick = point = mouseEvent.getPoint();
            Region region = this.grid.getRegion(point);
            this.unselect(this.selectedRegion);
            if (region != null) {
                this.select(region);
            }
            if (mouseEvent.isMetaDown()) {
                this.doPopupMenu(mouseEvent, region);
            } else if (region != null && mouseEvent.getClickCount() >= 2 && region.getConfigurer() != null && (editPropertiesAction = new EditPropertiesAction(region, null, this)) != null) {
                editPropertiesAction.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, "Edit"));
            }
            this.view.repaint();
        }

        public void doPopupMenu(MouseEvent mouseEvent, Region region) {
            this.myPopup = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Add Region");
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(this.selectedRegion == null);
            this.myPopup.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete Region");
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(this.selectedRegion != null);
            this.myPopup.add(jMenuItem);
            this.myPopup.addSeparator();
            jMenuItem = new JMenuItem("Properties");
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(this.selectedRegion != null);
            this.myPopup.add(jMenuItem);
            Point point = mouseEvent.getPoint();
            this.myPopup.addPopupMenuListener(new PopupMenuListener(this){
                private final /* synthetic */ Config this$0;
                {
                    this.this$0 = config;
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.this$0.view.repaint();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    this.this$0.view.repaint();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
            this.myPopup.show(mouseEvent.getComponent(), point.x, point.y);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditPropertiesAction editPropertiesAction;
            String string = actionEvent.getActionCommand();
            if (string.equals("close")) {
                ((Component)this).setVisible(false);
            } else if (string.equals("showhide")) {
                this.grid.setVisible(!this.grid.isVisible());
                this.view.repaint();
            } else if (string.equals("Add Region")) {
                Region region = new Region(this.lastClick);
                region.addTo(this.grid);
                this.grid.add(region);
                this.select(region);
                EditPropertiesAction editPropertiesAction2 = new EditPropertiesAction(this.selectedRegion, null, this);
                if (editPropertiesAction2 != null) {
                    editPropertiesAction2.actionPerformed(new ActionEvent(actionEvent.getSource(), 1001, "Edit"));
                }
                this.view.repaint();
            } else if (string.equals("Delete Region")) {
                this.selectedRegion.removeFrom(this.grid);
                this.grid.remove(this.selectedRegion);
                this.selectedRegion = null;
            } else if (string.equals("Properties") && this.selectedRegion != null && (editPropertiesAction = new EditPropertiesAction(this.selectedRegion, null, this)) != null) {
                editPropertiesAction.actionPerformed(new ActionEvent(actionEvent.getSource(), 1001, "Edit"));
            }
        }

        public void select(Region region) {
            region.setSelected(true);
            this.selectedRegion = region;
            this.view.repaint(region.getSelectionRect());
        }

        public void unselect(Region region) {
            if (region != null && region == this.selectedRegion) {
                region.setSelected(false);
                this.selectedRegion = null;
                this.view.repaint(region.getSelectionRect());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!mouseEvent.isMetaDown()) {
                this.scrollAtEdge(mouseEvent.getPoint(), 15);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (this.selectedRegion == null || !keyEvent.isControlDown()) {
                return;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            if (keyEvent.isShiftDown()) {
                n3 = 5;
            }
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    n2 = -n3;
                    break;
                }
                case 40: {
                    n2 = n3;
                    break;
                }
                case 37: {
                    n = -n3;
                    break;
                }
                case 39: {
                    n = n3;
                    break;
                }
                default: {
                    return;
                }
            }
            this.selectedRegion.move(n, n2, this.view);
            this.view.repaint();
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public static class View
        extends JPanel {
            protected Board myBoard;
            protected RegionGrid grid;

            public View(Board board, RegionGrid regionGrid) {
                this.myBoard = board;
                this.grid = regionGrid;
                this.setFocusTraversalKeysEnabled(false);
            }

            public void paint(Graphics graphics) {
                Rectangle rectangle = this.getVisibleRect();
                graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.myBoard.draw(graphics, 0, 0, 1.0, this);
                Rectangle rectangle2 = new Rectangle(new Point(), this.myBoard.bounds().getSize());
                this.grid.forceDraw(graphics, rectangle2, rectangle2, 1.0, false);
            }

            public void update(Graphics graphics) {
                this.paint(graphics);
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.myBoard.bounds().width, this.myBoard.bounds().height);
            }
        }
    }
}

