/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.FormattedString;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;

public abstract class RegularGridNumbering
extends AbstractConfigurable
implements GridNumbering {
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected char first = (char)72;
    protected String sep = "";
    protected char hType = (char)78;
    protected char vType = (char)78;
    protected int hLeading = 1;
    protected int vLeading = 1;
    protected int hOff = 1;
    protected int vOff = 1;
    protected boolean hDescending = false;
    protected boolean vDescending = false;
    protected boolean visible = false;
    protected int fontSize = 9;
    protected Color color = Color.black;
    protected int rotateTextDegrees = 0;
    protected int hDrawOff = 0;
    protected int vDrawOff = 0;
    protected JComponent visualizer;
    protected String locationFormat = "$gridLocation$";
    protected FormattedString format = new FormattedString();
    public static final String FIRST = "first";
    public static final String SEP = "sep";
    public static final String H_TYPE = "hType";
    public static final String V_TYPE = "vType";
    public static final String H_LEADING = "hLeading";
    public static final String V_LEADING = "vLeading";
    public static final String H_OFF = "hOff";
    public static final String V_OFF = "vOff";
    public static final String V_DESCEND = "vDescend";
    public static final String H_DESCEND = "hDescend";
    public static final String FONT_SIZE = "fontSize";
    public static final String COLOR = "color";
    public static final String VISIBLE = "visible";
    public static final String ROTATE_TEXT = "rotateText";
    public static final String H_DRAW_OFF = "hDrawOff";
    public static final String V_DRAW_OFF = "vDrawOff";
    public static final String LOCATION_FORMAT = "locationFormat";
    public static final String GRID_LOCATION = "gridLocation";
    public static final String ROW = "row";
    public static final String COLUMN = "column";
    public static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$F;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$T;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$LocationFormatConfig;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$R;

    public String getAttributeValueString(String string) {
        if (FIRST.equals(string)) {
            return "" + this.first;
        }
        if (SEP.equals(string)) {
            return this.sep;
        }
        if (H_TYPE.equals(string)) {
            return "" + this.hType;
        }
        if (V_TYPE.equals(string)) {
            return "" + this.vType;
        }
        if (H_LEADING.equals(string)) {
            return "" + this.hLeading;
        }
        if (V_LEADING.equals(string)) {
            return "" + this.vLeading;
        }
        if (H_OFF.equals(string)) {
            return "" + this.hOff;
        }
        if (V_OFF.equals(string)) {
            return "" + this.vOff;
        }
        if (H_DESCEND.equals(string)) {
            return "" + this.hDescending;
        }
        if (V_DESCEND.equals(string)) {
            return "" + this.vDescending;
        }
        if (FONT_SIZE.equals(string)) {
            return "" + this.fontSize;
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (VISIBLE.equals(string)) {
            return "" + this.visible;
        }
        if (LOCATION_FORMAT.equals(string)) {
            return this.locationFormat;
        }
        if (ROTATE_TEXT.equals(string)) {
            return "" + this.rotateTextDegrees;
        }
        if (H_DRAW_OFF.equals(string)) {
            return "" + this.hDrawOff;
        }
        if (V_DRAW_OFF.equals(string)) {
            return "" + this.vDrawOff;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (FIRST.equals(string)) {
            this.first = ((String)object).charAt(0);
        } else if (SEP.equals(string)) {
            this.sep = (String)object;
        } else if (H_TYPE.equals(string)) {
            this.hType = ((String)object).charAt(0);
        } else if (V_TYPE.equals(string)) {
            this.vType = ((String)object).charAt(0);
        } else if (H_LEADING.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.hLeading = (Integer)object;
        } else if (V_LEADING.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.vLeading = (Integer)object;
        } else if (H_OFF.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.hOff = (Integer)object;
        } else if (V_OFF.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.vOff = (Integer)object;
        } else if (H_DESCEND.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.hDescending = (Boolean)object;
        } else if (V_DESCEND.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.vDescending = (Boolean)object;
        } else if (FONT_SIZE.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.fontSize = (Integer)object;
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.color = (Color)object;
        } else if (VISIBLE.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.visible = (Boolean)object;
        } else if (LOCATION_FORMAT.equals(string)) {
            this.locationFormat = (String)object;
        } else if (ROTATE_TEXT.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.rotateTextDegrees = (Integer)object;
        } else if (H_DRAW_OFF.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.hDrawOff = (Integer)object;
        } else if (V_DRAW_OFF.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.vDrawOff = (Integer)object;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public abstract int getRow(Point var1);

    public abstract int getColumn(Point var1);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String[] getAttributeNames() {
        return new String[]{FIRST, SEP, H_TYPE, H_LEADING, H_OFF, H_DESCEND, V_TYPE, V_LEADING, V_OFF, V_DESCEND, LOCATION_FORMAT, VISIBLE, FONT_SIZE, COLOR, ROTATE_TEXT, H_DRAW_OFF, V_DRAW_OFF};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Order", "Separator", "Horizontal numbering", "Leading zeros in horizontal", "Starting number in horizontal", "Horizontal numbering descending", "Vertical numbering", "Leading zeros in vertical", "Starting number in vertical", "Vertical numbering descending", "Location format", "Draw Numbering", "Font size", "Color", "Rotate text (Degrees)", "Text X offset", "Text Y offset"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$F == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$F = RegularGridNumbering.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering$F")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$F, class$java$lang$String == null ? (class$java$lang$String = RegularGridNumbering.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$T == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$T = RegularGridNumbering.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering$T")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$T, class$java$lang$Integer == null ? (class$java$lang$Integer = RegularGridNumbering.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = RegularGridNumbering.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = RegularGridNumbering.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$T == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$T = RegularGridNumbering.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering$T")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$T, class$java$lang$Integer == null ? (class$java$lang$Integer = RegularGridNumbering.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = RegularGridNumbering.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = RegularGridNumbering.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$LocationFormatConfig == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$LocationFormatConfig = RegularGridNumbering.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering$LocationFormatConfig")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$LocationFormatConfig, class$java$lang$Boolean == null ? (class$java$lang$Boolean = RegularGridNumbering.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = RegularGridNumbering.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$awt$Color == null ? (class$java$awt$Color = RegularGridNumbering.class$("java.awt.Color")) : class$java$awt$Color, class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$R == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$R = RegularGridNumbering.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering$R")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$RegularGridNumbering$R, class$java$lang$Integer == null ? (class$java$lang$Integer = RegularGridNumbering.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = RegularGridNumbering.class$("java.lang.Integer")) : class$java$lang$Integer};
    }

    protected abstract JComponent getGridVisualizer();

    public VisibilityCondition getAttributeVisibility(String string) {
        if (FONT_SIZE.equals(string) || COLOR.equals(string)) {
            VisibilityCondition visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return RegularGridNumbering.this.visible;
                }
            };
            return visibilityCondition;
        }
        if (H_LEADING.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return RegularGridNumbering.this.hType == 'N';
                }
            };
        }
        if (V_LEADING.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return RegularGridNumbering.this.vType == 'N';
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    public Configurer getConfigurer() {
        AutoConfigurer autoConfigurer = (AutoConfigurer)super.getConfigurer();
        String[] stringArray = this.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            autoConfigurer.getConfigurer(stringArray[i]).addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RegularGridNumbering.this.visualizer.repaint();
                }
            });
        }
        ((Container)autoConfigurer.getControls()).add(this.getGridVisualizer());
        return autoConfigurer;
    }

    public static String getConfigureTypeName() {
        return "Grid Numbering";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GridNumbering.htm");
    }

    protected String getName(int n, int n2) {
        String string = this.getName(n + this.vOff, this.vType, this.vLeading);
        String string2 = this.getName(n2 + this.hOff, this.hType, this.hLeading);
        switch (this.first) {
            case 'H': {
                return string2 + this.sep + string;
            }
        }
        return string + this.sep + string2;
    }

    public String locationName(Point point) {
        int n = this.getRow(point);
        int n2 = this.getColumn(point);
        this.format.setFormat(this.locationFormat);
        this.format.setProperty(GRID_LOCATION, this.getName(n, n2));
        this.format.setProperty(ROW, this.getName(n + this.vOff, this.vType, this.vLeading));
        this.format.setProperty(COLUMN, this.getName(n2 + this.hOff, this.hType, this.hLeading));
        return this.format.getText();
    }

    protected String getName(int n, char c, int n2) {
        String string = n < 0 ? "-" : "";
        n = Math.abs(n);
        switch (c) {
            case 'A': {
                do {
                    string = string + ALPHABET.charAt(n % 26);
                } while ((n -= 26) >= 0);
                return string;
            }
        }
        while (n2 > 0) {
            int n3 = n2--;
            if (!((double)n < Math.pow(10.0, n3))) break;
            string = string + "0";
        }
        return string + n;
    }

    public Point offsetLabelCenter(Point point, double d) {
        return this.offsetLabelCenter(point.x, point.y, d);
    }

    public Point offsetLabelCenter(int n, int n2, double d) {
        Point point = new Point(n, n2);
        switch (this.rotateTextDegrees) {
            case 0: {
                break;
            }
            case 90: {
                point.x = n2;
                point.y = -n;
                break;
            }
            case 180: {
                point.x = -n;
                point.y = -n2;
                break;
            }
            case 270: {
                point.x = -n2;
                point.y = n;
                break;
            }
        }
        point.x = (int)((double)point.x + (double)this.hDrawOff * d);
        point.y = (int)((double)point.y + (double)this.vDrawOff * d);
        return point;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public abstract /* synthetic */ void draw(Graphics var1, Rectangle var2, Rectangle var3, double var4, boolean var6);

    public static class R
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{"0", "90", "180", "270"};
        }
    }

    public static class LocationFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{RegularGridNumbering.GRID_LOCATION, RegularGridNumbering.ROW, RegularGridNumbering.COLUMN});
        }
    }

    public static class T
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{"Numerical", "Alphabetic"};
        }
    }

    public static class F
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{"Horizontal first", "Vertical first"};
        }
    }
}

