/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.Buildable;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering;
import VASSAL.counters.Labeler;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SquareGridNumbering
extends RegularGridNumbering {
    private SquareGrid grid;

    public void addTo(Buildable buildable) {
        this.grid = (SquareGrid)buildable;
        this.grid.setGridNumbering(this);
    }

    protected JComponent getGridVisualizer() {
        if (this.visualizer == null) {
            this.visualizer = new JPanel(){

                public void paint(Graphics graphics) {
                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    SquareGridNumbering.this.grid.forceDraw(graphics, rectangle, rectangle, 1.0, false);
                    SquareGridNumbering.this.forceDraw(graphics, rectangle, rectangle, 1.0, false);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(3 * (int)SquareGridNumbering.this.grid.getDx(), 3 * (int)SquareGridNumbering.this.grid.getDy());
                }
            };
        }
        return this.visualizer;
    }

    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (this.visible) {
            this.forceDraw(graphics, rectangle, rectangle2, d, bl);
        }
    }

    public void forceDraw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        int n = (int)(d * (double)this.fontSize + 0.5);
        if (n < 5 || !rectangle.intersects(rectangle2)) {
            return;
        }
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        Shape shape = graphics.getClip();
        if (shape != null) {
            Area area = new Area(shape);
            area.intersect(new Area(rectangle3));
            graphics.setClip(area);
        }
        double d2 = d * this.grid.getDx();
        double d3 = d * this.grid.getDy();
        Point point = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d4 = 0.0;
        if (this.rotateTextDegrees != 0) {
            d4 = Math.toRadians(this.rotateTextDegrees);
            graphics2D.rotate(d4);
        }
        int n2 = bl ? (int)Math.ceil(((double)rectangle.x - d * (double)this.grid.getOrigin().x + (double)rectangle.width - (double)rectangle3.x) / d2) : (int)Math.floor(((double)(rectangle3.x - rectangle.x) - d * (double)this.grid.getOrigin().x) / d2);
        double d5 = bl ? (double)rectangle.x - d * (double)this.grid.getOrigin().x + (double)rectangle.width - d2 * (double)n2 : (double)rectangle.x + d * (double)this.grid.getOrigin().x + d2 * (double)n2;
        double d6 = (double)(rectangle3.x + rectangle3.width) + d2;
        int n3 = bl ? (int)Math.ceil(((double)rectangle.y - d * (double)this.grid.getOrigin().y + (double)rectangle.height - (double)rectangle3.y) / d3) : (int)Math.floor(((double)(rectangle3.y - rectangle.y) - d * (double)this.grid.getOrigin().y) / d3);
        double d7 = bl ? (double)rectangle.y - d * (double)this.grid.getOrigin().y + (double)rectangle.height - d3 * (double)n3 : (double)rectangle.y + d * (double)this.grid.getOrigin().y + d3 * (double)n3;
        double d8 = (double)(rectangle3.y + rectangle3.height) + d3;
        Font font = new Font("Dialog", 0, n);
        int n4 = n2;
        double d9 = d5;
        while (d9 < d6) {
            int n5 = n3;
            double d10 = d7;
            while (d10 < d8) {
                int n6 = n5;
                int n7 = n4;
                if (this.vDescending) {
                    n6 = this.getMaxRows() - n5;
                }
                if (this.hDescending) {
                    n7 = this.getMaxColumns() - n4;
                }
                int n8 = 0;
                int n9 = 0;
                switch (this.rotateTextDegrees) {
                    case 90: {
                        n8 = (int)(d9 + d2 / 2.0);
                        n9 = (int)d10;
                        break;
                    }
                    case 180: {
                        n8 = (int)d9;
                        n9 = (int)(d10 + d3 / 2.0);
                        break;
                    }
                    case 270: {
                        n8 = (int)(d9 - d2 / 2.0);
                        n9 = (int)d10;
                        break;
                    }
                    default: {
                        n8 = (int)d9;
                        n9 = (int)(d10 - d3 / 2.0);
                    }
                }
                point = this.offsetLabelCenter(n8, n9, d);
                Labeler.drawLabel(graphics, this.getName(n6, n7), point.x, point.y, font, 0, 3, this.color, null, null);
                d10 += d3;
                n5 += bl ? -1 : 1;
            }
            d9 += d2;
            n4 += bl ? -1 : 1;
        }
        if (this.rotateTextDegrees != 0) {
            graphics2D.rotate(-d4);
        }
        graphics.setClip(shape);
    }

    public int getColumn(Point point) {
        int n = (int)Math.floor((double)(point.x - this.grid.getOrigin().x) / this.grid.getDx() + 0.5);
        if (this.hDescending) {
            return this.getMaxColumns() - n;
        }
        return n;
    }

    public int getRow(Point point) {
        int n = (int)((double)(point.y - this.grid.getOrigin().y) / this.grid.getDy() + 0.5);
        if (this.vDescending) {
            return this.getMaxRows() - n;
        }
        return n;
    }

    public void removeFrom(Buildable buildable) {
        this.grid.setGridNumbering(null);
    }

    protected int getMaxRows() {
        return (int)((double)this.grid.getContainer().getSize().height / this.grid.getDy() + 0.5);
    }

    protected int getMaxColumns() {
        return (int)((double)this.grid.getContainer().getSize().width / this.grid.getDx() + 0.5);
    }
}

