/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.PolygonEditor;
import VASSAL.build.module.map.boardPicker.board.mapgrid.ZoneHighlight;
import VASSAL.build.module.properties.GlobalPropertiesContainer;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.FormattedString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Zone
extends AbstractConfigurable
implements GridContainer,
GlobalPropertiesContainer,
PropertySource,
GameComponent {
    public static final String NAME = "name";
    public static final String PATH = "path";
    public static final String USE_PARENT_GRID = "useParentGrid";
    public static final String LOCATION_FORMAT = "locationFormat";
    public static final String GRID_LOCATION = "gridLocation";
    public static final String USE_HIGHLIGHT = "useHighlight";
    public static final String HIGHLIGHT_PROPERTY = "highlightProperty";
    protected static final Dimension DEFAULT_SIZE = new Dimension(600, 600);
    protected String locationFormat = "$name$";
    protected FormattedString format = new FormattedString();
    protected Polygon myPolygon;
    protected MapGrid grid = null;
    protected ZonedGrid parentGrid;
    protected boolean useParentGrid;
    protected java.util.Map globalProperties = new HashMap();
    protected PropertyChangeListener globalPropertyListener;
    protected int lastBoundsX = -1;
    protected int lastBoundsY = -1;
    protected double lastScale = -1.0;
    protected Shape lastScaledShape = null;
    protected Shape lastTransformedShape = null;
    protected Polygon lastPolygon = null;
    protected ZoneHighlight highlighter = null;
    protected boolean useHighlight = false;
    protected String highlightPropertyName = "";
    protected GlobalProperty highlightProperty = null;
    protected PropertyChangeListener highlightPropertyChangeListener = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$Zone$LocationFormatConfig;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$Zone$ShapeEditor;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$VASSAL$build$module$properties$ZoneProperty;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$HexGrid;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$SquareGrid;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$RegionGrid;
    static /* synthetic */ Class class$VASSAL$build$module$properties$GlobalProperty;

    public Zone() {
        this.myPolygon = new Polygon();
    }

    public String getName() {
        return this.name;
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, LOCATION_FORMAT, PATH, USE_PARENT_GRID, USE_HIGHLIGHT, HIGHLIGHT_PROPERTY};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Location Format:  ", "Shape", "Use board's grid?", "Use Highlighting?", "Highlight Property:  "};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = Zone.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$map$boardPicker$board$mapgrid$Zone$LocationFormatConfig == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$Zone$LocationFormatConfig = Zone.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.Zone$LocationFormatConfig")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$Zone$LocationFormatConfig, class$VASSAL$build$module$map$boardPicker$board$mapgrid$Zone$ShapeEditor == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$Zone$ShapeEditor = Zone.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.Zone$ShapeEditor")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$Zone$ShapeEditor, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Zone.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Zone.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = Zone.class$("java.lang.String")) : class$java$lang$String};
    }

    public void addTo(Buildable buildable) {
        this.parentGrid = (ZonedGrid)buildable;
        this.parentGrid.addZone(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public void repaint() {
        if (this.getMap() != null) {
            this.getMap().repaint();
        }
    }

    public void removeFrom(Buildable buildable) {
        ((ZonedGrid)buildable).removeZone(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    public static String getConfigureTypeName() {
        return "Zone";
    }

    public HelpFile getHelpFile() {
        return null;
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (PATH.equals(string)) {
            return PolygonEditor.polygonToString(this.myPolygon);
        }
        if (LOCATION_FORMAT.equals(string)) {
            return this.locationFormat;
        }
        if (USE_PARENT_GRID.equals(string)) {
            return String.valueOf(this.useParentGrid);
        }
        if (USE_HIGHLIGHT.equals(string)) {
            return String.valueOf(this.useHighlight);
        }
        if (HIGHLIGHT_PROPERTY.equals(string)) {
            return this.highlightPropertyName;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (PATH.equals(string)) {
            PolygonEditor.reset(this.myPolygon, (String)object);
        } else if (LOCATION_FORMAT.equals(string)) {
            this.locationFormat = (String)object;
        } else if (USE_PARENT_GRID.equals(string)) {
            this.useParentGrid = "true".equals(object) || Boolean.TRUE.equals(object);
        } else if (USE_HIGHLIGHT.equals(string)) {
            this.useHighlight = "true".equals(object) || Boolean.TRUE.equals(object);
        } else if (HIGHLIGHT_PROPERTY.equals(string)) {
            this.highlightPropertyName = (String)object;
        }
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (HIGHLIGHT_PROPERTY.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Zone.this.useHighlight;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    public Class[] getAllowableConfigureComponents() {
        Class[] classArray;
        if (this.useParentGrid) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = class$VASSAL$build$module$properties$ZoneProperty == null ? (class$VASSAL$build$module$properties$ZoneProperty = Zone.class$("VASSAL.build.module.properties.ZoneProperty")) : class$VASSAL$build$module$properties$ZoneProperty;
        } else {
            Class[] classArray3 = new Class[4];
            classArray3[0] = class$VASSAL$build$module$map$boardPicker$board$HexGrid == null ? (class$VASSAL$build$module$map$boardPicker$board$HexGrid = Zone.class$("VASSAL.build.module.map.boardPicker.board.HexGrid")) : class$VASSAL$build$module$map$boardPicker$board$HexGrid;
            classArray3[1] = class$VASSAL$build$module$map$boardPicker$board$SquareGrid == null ? (class$VASSAL$build$module$map$boardPicker$board$SquareGrid = Zone.class$("VASSAL.build.module.map.boardPicker.board.SquareGrid")) : class$VASSAL$build$module$map$boardPicker$board$SquareGrid;
            classArray3[2] = class$VASSAL$build$module$map$boardPicker$board$RegionGrid == null ? (class$VASSAL$build$module$map$boardPicker$board$RegionGrid = Zone.class$("VASSAL.build.module.map.boardPicker.board.RegionGrid")) : class$VASSAL$build$module$map$boardPicker$board$RegionGrid;
            classArray = classArray3;
            classArray3[3] = class$VASSAL$build$module$properties$ZoneProperty == null ? (class$VASSAL$build$module$properties$ZoneProperty = Zone.class$("VASSAL.build.module.properties.ZoneProperty")) : class$VASSAL$build$module$properties$ZoneProperty;
        }
        return classArray;
    }

    public PropertyChangeListener getPropertyListener() {
        if (this.globalPropertyListener == null) {
            this.globalPropertyListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Zone.this.globalProperties.put(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
                    Zone.this.repaint();
                }
            };
        }
        return this.globalPropertyListener;
    }

    public String locationName(Point point) {
        this.format.setFormat(this.locationFormat);
        this.format.setProperty(NAME, this.getConfigureName());
        String string = null;
        if (this.getGrid() != null) {
            string = this.getGrid().locationName(point);
        }
        this.format.setProperty(GRID_LOCATION, string);
        return this.format.getText();
    }

    public boolean contains(Point point) {
        return this.myPolygon.contains(point);
    }

    public Point snapTo(Point point) {
        Point point2 = point;
        if (this.getGrid() != null) {
            point2 = this.getGrid().snapTo(point);
        }
        return point2;
    }

    public Dimension getSize() {
        return this.myPolygon.getBounds().getSize();
    }

    public void removeGrid(MapGrid mapGrid) {
        if (this.grid == mapGrid) {
            mapGrid = null;
        }
    }

    public Board getBoard() {
        return this.parentGrid == null ? null : this.parentGrid.getBoard();
    }

    public Map getMap() {
        return this.parentGrid == null ? null : this.parentGrid.getBoard().getMap();
    }

    public ZonedGrid getParentGrid() {
        return this.parentGrid;
    }

    public void setGrid(MapGrid mapGrid) {
        this.grid = mapGrid;
    }

    public MapGrid getGrid() {
        if (this.useParentGrid) {
            return this.parentGrid != null ? this.parentGrid.getBackgroundGrid() : null;
        }
        return this.grid;
    }

    public boolean isUseParentGrid() {
        return this.useParentGrid;
    }

    public Shape getShape() {
        return this.myPolygon;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = this.myPolygon.getBounds();
        return rectangle;
    }

    public void setHighlight(ZoneHighlight zoneHighlight) {
        this.highlighter = zoneHighlight;
    }

    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (this.getGrid() != null && this.getGrid().isVisible() || this.highlighter != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Shape shape = graphics2D.getClip();
            Area area = new Area(rectangle2);
            Shape shape2 = this.getCachedShape(this.myPolygon, rectangle.x, rectangle.y, d);
            area.intersect(new Area(shape2));
            graphics2D.setClip(area);
            if (this.getGrid() != null && this.getGrid().isVisible()) {
                this.getGrid().draw(graphics, rectangle, rectangle2, d, bl);
            }
            if (this.highlighter != null) {
                this.highlighter.draw(graphics2D, shape2, d);
            }
            graphics2D.setClip(shape);
        }
    }

    protected Shape getScaledShape(Polygon polygon, double d) {
        if (d == this.lastScale && this.lastPolygon == polygon && this.lastScaledShape != null) {
            return this.lastScaledShape;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        this.lastScaledShape = affineTransform.createTransformedShape(polygon);
        this.lastScale = d;
        this.lastPolygon = polygon;
        return this.lastScaledShape;
    }

    protected Shape getCachedShape(Polygon polygon, int n, int n2, double d) {
        if (polygon.equals(this.lastPolygon) && n == this.lastBoundsX && n2 == this.lastBoundsY && d == this.lastScale) {
            return this.lastTransformedShape;
        }
        Shape shape = this.getScaledShape(this.myPolygon, d);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
        this.lastTransformedShape = affineTransform.createTransformedShape(shape);
        this.lastPolygon = this.myPolygon;
        this.lastBoundsX = n;
        this.lastBoundsY = n2;
        this.lastScale = d;
        return this.lastTransformedShape;
    }

    public Object getProperty(Object object) {
        Object object2 = null;
        object2 = this.globalProperties.get(object);
        if (object2 == null) {
            object2 = this.getMap().getProperty(object);
        }
        return object2;
    }

    public GlobalProperty getGlobalProperty(String string) {
        GlobalProperty globalProperty = null;
        Enumeration enumeration = this.getAllDescendantComponents(class$VASSAL$build$module$properties$GlobalProperty == null ? (class$VASSAL$build$module$properties$GlobalProperty = Zone.class$("VASSAL.build.module.properties.GlobalProperty")) : class$VASSAL$build$module$properties$GlobalProperty);
        while (enumeration.hasMoreElements() && globalProperty == null) {
            GlobalProperty globalProperty2 = (GlobalProperty)enumeration.nextElement();
            if (!globalProperty2.getConfigureName().equals(string)) continue;
            globalProperty = globalProperty2;
        }
        return globalProperty;
    }

    public void setup(boolean bl) {
        if (bl) {
            if (this.useHighlight && this.highlightPropertyName.length() > 0) {
                this.highlightProperty = GlobalProperty.findGlobalProperty(this.highlightPropertyName, Arrays.asList(this, this.getMap(), GameModule.getGameModule()));
                if (this.highlightProperty != null) {
                    if (this.highlightPropertyChangeListener == null) {
                        this.highlightPropertyChangeListener = new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                Zone.this.setHighlighter((String)propertyChangeEvent.getNewValue());
                            }
                        };
                    }
                    this.highlightProperty.addPropertyChangeListener(this.highlightPropertyChangeListener);
                    this.setHighlighter(this.highlightProperty.getPropertyValue());
                }
            }
        } else if (this.highlightProperty != null && this.highlightPropertyChangeListener != null) {
            this.highlightProperty.removePropertyChangeListener(this.highlightPropertyChangeListener);
            this.highlightProperty = null;
        }
    }

    public void setHighlighter(String string) {
        this.highlighter = this.parentGrid.getZoneHighlight(string);
        this.repaint();
    }

    public Command getRestoreCommand() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Editor
    extends Configurer {
        private JButton button = new JButton("Define Shape");
        private PolygonEditor editor;
        private Board board;
        private JDialog frame;
        protected AdjustableSpeedScrollPane scroll;

        public Editor(Zone zone) {
            super(Zone.PATH, null);
            this.button.addActionListener(new ActionListener(this, zone){
                private final /* synthetic */ Zone val$zone;
                private final /* synthetic */ Editor this$0;
                {
                    this.this$0 = editor;
                    this.val$zone = zone;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.access$000(this.this$0, this.val$zone);
                }
            });
            this.editor = new PolygonEditor(this, new Polygon(zone.myPolygon.xpoints, zone.myPolygon.ypoints, zone.myPolygon.npoints)){
                private final /* synthetic */ Editor this$0;
                {
                    this.this$0 = editor;
                }

                protected void paintBackground(Graphics graphics) {
                    if (Editor.access$100(this.this$0) != null) {
                        Rectangle rectangle = this.getVisibleRect();
                        graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        Editor.access$100(this.this$0).draw(graphics, 0, 0, 1.0, Editor.access$200(this.this$0));
                    } else {
                        super.paintBackground(graphics);
                    }
                }
            };
            this.frame = new JDialog((Frame)null, zone.getConfigureName(), true);
            this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(2, 2));
            jPanel.add(new JLabel("Drag to create initial shape"));
            jPanel.add(new JLabel("Right-click to add point"));
            jPanel.add(new JLabel("Left-click to move points"));
            jPanel.add(new JLabel("DEL to remove point"));
            jPanel.setAlignmentX(0.0f);
            this.frame.getContentPane().add(jPanel);
            JButton jButton = new JButton("Set Coordinates directly");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Editor this$0;
                {
                    this.this$0 = editor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(Editor.access$300(this.this$0), "Enter x,y coordinates of polygon vertices,\nseparated by spaces", PolygonEditor.polygonToString(Editor.access$200(this.this$0).getPolygon()).replace(';', ' '));
                    if (string != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        while (stringTokenizer.hasMoreTokens()) {
                            stringBuffer.append(stringTokenizer.nextToken());
                            if (!stringTokenizer.hasMoreTokens()) continue;
                            stringBuffer.append(';');
                        }
                        string = stringBuffer.toString();
                        PolygonEditor.reset(Editor.access$200(this.this$0).getPolygon(), string);
                        Editor.access$200(this.this$0).repaint();
                    }
                }
            });
            jButton.setAlignmentX(0.0f);
            this.frame.getContentPane().add(jButton);
            this.scroll = new AdjustableSpeedScrollPane(this.editor);
            this.editor.setScroll(this.scroll);
            this.frame.getContentPane().add(this.scroll);
            JPanel jPanel2 = new JPanel();
            JButton jButton2 = new JButton("Ok");
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ Editor this$0;
                {
                    this.this$0 = editor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.setValue((Object)this.this$0.getValueString());
                    ((Component)Editor.access$300(this.this$0)).setVisible(false);
                    GameModule.getGameModule().getDataArchive().clearScaledImageCache();
                }
            });
            jPanel2.add(jButton2);
            this.frame.getContentPane().add(jPanel2);
        }

        private void init(Zone zone) {
            this.board = zone.getBoard();
            if (this.board != null) {
                this.board.fixImage();
            }
            this.editor.setPreferredSize(this.board != null ? this.board.getSize() : DEFAULT_SIZE);
            Rectangle rectangle = this.editor.getPolygon().getBounds();
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            if (!this.editor.getVisibleRect().contains(point)) {
                this.editor.center(point);
            }
            this.frame.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this.frame).setSize(Math.min(this.frame.getWidth(), dimension.width * 2 / 3), Math.min(this.frame.getHeight(), dimension.height * 2 / 3));
            ((Component)this.frame).setVisible(true);
        }

        public Component getControls() {
            return this.button;
        }

        public String getValueString() {
            return PolygonEditor.polygonToString(this.editor.getPolygon());
        }

        public void setValue(String string) {
            PolygonEditor.reset(this.editor.getPolygon(), string);
        }

        static /* synthetic */ void access$000(Editor editor, Zone zone) {
            editor.init(zone);
        }

        static /* synthetic */ Board access$100(Editor editor) {
            return editor.board;
        }

        static /* synthetic */ PolygonEditor access$200(Editor editor) {
            return editor.editor;
        }

        static /* synthetic */ JDialog access$300(Editor editor) {
            return editor.frame;
        }
    }

    public static class ShapeEditor
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new Editor((Zone)autoConfigurable);
        }
    }

    public static class LocationFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{Zone.NAME, Zone.GRID_LOCATION});
        }
    }
}

