/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.mapgrid.ZonedGridHighlighter;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ZoneHighlight
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String COLOR = "color";
    public static final String COVERAGE = "coverage";
    public static final String WIDTH = "width";
    public static final String STYLE = "style";
    public static final String IMAGE = "image";
    public static final String OPACITY = "opacity";
    public static final String COVERAGE_FULL = "Entire Zone";
    public static final String COVERAGE_BORDER = "Zone Border";
    public static final String STYLE_PLAIN = "Plain";
    public static final String STYLE_STRIPES = "Striped";
    public static final String STYLE_CROSS = "Crosshatched";
    public static final String STYLE_IMAGE = "Tiled Image";
    protected Color color = null;
    protected String coverage = "Entire Zone";
    protected int width = 1;
    protected String style = "Plain";
    protected String imageName = null;
    protected int opacity = 100;
    protected TexturePaint paint;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$Coverage;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$Style;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$OpacityConfig;

    public ZoneHighlight() {
        this.setConfigureName("");
    }

    public void draw(Graphics2D graphics2D, Shape shape, double d) {
        if (this.color != null && this.opacity > 0 || STYLE_IMAGE.equals(this.style)) {
            Stroke stroke = graphics2D.getStroke();
            Color color = graphics2D.getColor();
            Composite composite = graphics2D.getComposite();
            Paint paint = graphics2D.getPaint();
            if (!STYLE_PLAIN.equals(this.style)) {
                graphics2D.setPaint(this.getPaint());
            } else {
                graphics2D.setColor(this.color);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.opacity / 100.0f));
            graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            if (COVERAGE_FULL.equals(this.coverage)) {
                graphics2D.fill(shape);
            } else {
                BasicStroke basicStroke = new BasicStroke((float)((double)this.width * d), 1, 1);
                graphics2D.setStroke(basicStroke);
                graphics2D.draw(shape);
            }
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
        }
    }

    protected Paint getPaint() {
        if (this.paint == null) {
            if (this.style.equals(STYLE_IMAGE)) {
                try {
                    ImageIcon imageIcon = new ImageIcon(GameModule.getGameModule().getDataArchive().getCachedImage(this.imageName));
                    BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
                    this.paint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
                }
                catch (IOException iOException) {
                    System.err.println("Unable to locate image " + this.imageName);
                }
            } else {
                BufferedImage bufferedImage = new BufferedImage(6, 6, 6);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(this.color);
                if (this.style.equals(STYLE_STRIPES)) {
                    graphics2D.drawLine(0, 5, 5, 0);
                } else if (this.style.equals(STYLE_CROSS)) {
                    graphics2D.drawLine(0, 5, 5, 0);
                    graphics2D.drawLine(1, 0, 5, 4);
                }
                Rectangle rectangle = new Rectangle(0, 0, 6, 6);
                this.paint = new TexturePaint(bufferedImage, rectangle);
            }
        }
        return this.paint;
    }

    public String getName() {
        return this.getConfigureName();
    }

    public Color getColor() {
        return this.color;
    }

    public void setOpacity(int n) {
        this.opacity = n;
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{NAME, COLOR, COVERAGE, WIDTH, STYLE, IMAGE, OPACITY};
        return stringArray;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Color:  ", "Coverage:  ", "Width:  ", "Style:  ", "Image:  ", "Opacity(%):  "};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = ZoneHighlight.class$("java.lang.String")) : class$java$lang$String, class$java$awt$Color == null ? (class$java$awt$Color = ZoneHighlight.class$("java.awt.Color")) : class$java$awt$Color, class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$Coverage == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$Coverage = ZoneHighlight.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.ZoneHighlight$Coverage")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$Coverage, class$java$lang$Integer == null ? (class$java$lang$Integer = ZoneHighlight.class$("java.lang.Integer")) : class$java$lang$Integer, class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$Style == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$Style = ZoneHighlight.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.ZoneHighlight$Style")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$Style, class$javax$swing$Icon == null ? (class$javax$swing$Icon = ZoneHighlight.class$("javax.swing.Icon")) : class$javax$swing$Icon, class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$OpacityConfig == null ? (class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$OpacityConfig = ZoneHighlight.class$("VASSAL.build.module.map.boardPicker.board.mapgrid.ZoneHighlight$OpacityConfig")) : class$VASSAL$build$module$map$boardPicker$board$mapgrid$ZoneHighlight$OpacityConfig};
    }

    public void addTo(Buildable buildable) {
        ((ZonedGridHighlighter)buildable).addHighlight(this);
    }

    public void removeFrom(Buildable buildable) {
        ((ZonedGridHighlighter)buildable).removeHighlight(this);
    }

    public static String getConfigureTypeName() {
        return "Zone Highlight";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ZonedGrid.htm", "ZoneHighlighter");
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (COVERAGE.equals(string)) {
            return this.coverage;
        }
        if (WIDTH.equals(string)) {
            return String.valueOf(this.width);
        }
        if (STYLE.equals(string)) {
            return this.style;
        }
        if (OPACITY.equals(string)) {
            return String.valueOf(this.opacity);
        }
        if (IMAGE.equals(string)) {
            return this.imageName;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            if (object != null) {
                this.color = (Color)object;
            }
        } else if (COVERAGE.equals(string)) {
            this.coverage = (String)object;
        } else if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.width = (Integer)object;
        } else if (STYLE.equals(string)) {
            this.style = (String)object;
            this.paint = null;
        } else if (OPACITY.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.opacity = (Integer)object;
        } else if (IMAGE.equals(string)) {
            this.imageName = (String)object;
        }
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (IMAGE.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return ZoneHighlight.STYLE_IMAGE.equals(ZoneHighlight.this.style);
                }
            };
        }
        if (WIDTH.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return ZoneHighlight.COVERAGE_BORDER.equals(ZoneHighlight.this.coverage);
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PercentageConfigurer
    extends Configurer {
        public PercentageConfigurer(String string, String string2, Object object) {
            super(string, string2, object);
            ZoneHighlight.this.opacity = (Integer)object;
        }

        public String getValueString() {
            return String.valueOf(ZoneHighlight.this.opacity);
        }

        public void setValue(String string) {
            ZoneHighlight.this.opacity = new Integer(string);
        }

        public Component getControls() {
            JSlider jSlider = new JSlider(0, 0, 100, ZoneHighlight.this.opacity);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(new Integer(0), new JLabel("Transparent"));
            hashtable.put(new Integer(100), new JLabel("Opaque"));
            jSlider.setMajorTickSpacing(10);
            jSlider.setPaintTicks(true);
            jSlider.setLabelTable(hashtable);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createTitledBorder(this.name));
            jSlider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ PercentageConfigurer this$1;
                {
                    this.this$1 = percentageConfigurer;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        PercentageConfigurer.access$000((PercentageConfigurer)this.this$1).opacity = jSlider.getValue();
                    }
                }
            });
            return jSlider;
        }

        static /* synthetic */ ZoneHighlight access$000(PercentageConfigurer percentageConfigurer) {
            return percentageConfigurer.ZoneHighlight.this;
        }
    }

    public static class OpacityConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            ZoneHighlight zoneHighlight = (ZoneHighlight)autoConfigurable;
            zoneHighlight.getClass();
            return zoneHighlight.new PercentageConfigurer(string, string2, new Integer(((ZoneHighlight)autoConfigurable).opacity));
        }
    }

    public static class Style
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{ZoneHighlight.STYLE_PLAIN, ZoneHighlight.STYLE_STRIPES, ZoneHighlight.STYLE_CROSS, ZoneHighlight.STYLE_IMAGE};
        }
    }

    public static class Coverage
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{ZoneHighlight.COVERAGE_FULL, ZoneHighlight.COVERAGE_BORDER};
        }
    }
}

