/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.noteswindow;

import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.noteswindow.PrivateText;
import VASSAL.build.module.noteswindow.SetPrivateTextCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.TextConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JLabel;

public class PrivateNotesController
implements GameComponent,
CommandEncoder,
SetPrivateTextCommand.Interface {
    public static final String COMMAND_PREFIX = "PNOTE\t";
    private HashSet notes = new HashSet();
    private String myLastSavedNotes;
    private Component controls;
    private TextConfigurer text;

    public Component getControls() {
        if (this.controls == null) {
            Box box = Box.createVerticalBox();
            box.add(new JLabel("Invisible to others"));
            this.text = new TextConfigurer(null, null);
            box.add(this.text.getControls());
            this.controls = box;
        }
        return this.controls;
    }

    public void addPrivateText(PrivateText privateText) {
        this.notes.add(privateText);
        if (privateText.getOwner().equals(GameModule.getUserId())) {
            this.text.setValue(privateText.getText());
        }
    }

    public Command decode(String string) {
        Command command = null;
        if (string.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(COMMAND_PREFIX.length()), '\t');
            String string2 = decoder.nextToken();
            String string3 = decoder.hasMoreTokens() ? TextConfigurer.restoreNewlines(decoder.nextToken()) : "";
            return new SetPrivateTextCommand(this, new PrivateText(string2, string3));
        }
        return command;
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof SetPrivateTextCommand) {
            PrivateText privateText = ((SetPrivateTextCommand)command).getPrivateText();
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            string = COMMAND_PREFIX + sequenceEncoder.append(privateText.getOwner()).append(TextConfigurer.escapeNewlines(privateText.getText())).getValue();
        }
        return string;
    }

    public Command getRestoreCommand() {
        SetPrivateTextCommand setPrivateTextCommand = null;
        Iterator iterator = this.notes.iterator();
        while (iterator.hasNext()) {
            PrivateText privateText = (PrivateText)iterator.next();
            SetPrivateTextCommand setPrivateTextCommand2 = new SetPrivateTextCommand(this, privateText);
            if (setPrivateTextCommand == null) {
                setPrivateTextCommand = setPrivateTextCommand2;
                continue;
            }
            setPrivateTextCommand.append(setPrivateTextCommand2);
        }
        return setPrivateTextCommand;
    }

    public void setup(boolean bl) {
        if (!bl) {
            this.notes.clear();
            this.text.setValue("");
        }
    }

    public Command save() {
        SetPrivateTextCommand setPrivateTextCommand = null;
        if (!this.myLastSavedNotes.equals(this.text.getValue())) {
            setPrivateTextCommand = new SetPrivateTextCommand(this, new PrivateText(GameModule.getUserId(), (String)this.text.getValue()));
            setPrivateTextCommand.execute();
        }
        return setPrivateTextCommand;
    }

    public void captureState() {
        this.myLastSavedNotes = (String)this.text.getValue();
    }

    public void restoreState() {
        this.text.setValue((Object)this.myLastSavedNotes);
    }
}

