/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.noteswindow;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.noteswindow.AddSecretNoteCommand;
import VASSAL.build.module.noteswindow.SecretNote;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class SecretNotesController
implements GameComponent,
CommandEncoder,
AddSecretNoteCommand.Interface {
    public static final String COMMAND_PREFIX = "SNOTE\t";
    private Controls controls;
    private JPanel panel;
    private ArrayList notes = new ArrayList();
    private List lastSavedNotes;
    public static final int COL_HANDLE = 0;
    public static final int COL_DTM = 1;
    public static final int COL_NAME = 2;
    public static final int COL_REVEALED = 3;
    public static final DateFormat INTERNAL_DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 3, Locale.US);
    public static final DateFormat LOCAL_DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    static /* synthetic */ Class class$java$awt$Dialog;
    static /* synthetic */ Class class$java$awt$Frame;

    public SecretNotesController() {
        this.controls = new Controls();
    }

    public Command getRestoreCommand() {
        AddSecretNoteCommand addSecretNoteCommand = null;
        Iterator iterator = ((AbstractList)this.notes).iterator();
        while (iterator.hasNext()) {
            SecretNote secretNote = (SecretNote)iterator.next();
            AddSecretNoteCommand addSecretNoteCommand2 = new AddSecretNoteCommand(this, secretNote);
            if (addSecretNoteCommand == null) {
                addSecretNoteCommand = addSecretNoteCommand2;
                continue;
            }
            addSecretNoteCommand.append(addSecretNoteCommand2);
        }
        return addSecretNoteCommand;
    }

    public void setup(boolean bl) {
        if (!bl) {
            this.notes.clear();
            this.controls.refresh();
        }
    }

    public Command decode(String string) {
        AddSecretNoteCommand addSecretNoteCommand = null;
        if (string.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(COMMAND_PREFIX.length()), '\t');
            String string2 = decoder.nextToken();
            String string3 = decoder.nextToken();
            boolean bl = "true".equals(decoder.nextToken());
            String string4 = TextConfigurer.restoreNewlines(decoder.nextToken());
            String string5 = "";
            Date date = null;
            if (decoder.hasMoreTokens()) {
                try {
                    date = INTERNAL_DATE_FORMATTER.parse(decoder.nextToken());
                }
                catch (Exception exception) {
                    date = null;
                }
            }
            if (decoder.hasMoreTokens()) {
                string5 = decoder.nextToken();
            }
            SecretNote secretNote = new SecretNote(string2, string3, string4, bl, date, string5);
            addSecretNoteCommand = new AddSecretNoteCommand(this, secretNote);
        }
        return addSecretNoteCommand;
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof AddSecretNoteCommand) {
            SecretNote secretNote = ((AddSecretNoteCommand)command).getNote();
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            String string2 = secretNote.getDate() == null ? "" : INTERNAL_DATE_FORMATTER.format(secretNote.getDate());
            string = COMMAND_PREFIX + sequenceEncoder.append(secretNote.getName()).append(secretNote.getOwner()).append(secretNote.isHidden()).append(TextConfigurer.escapeNewlines(secretNote.getText())).append(string2).append(secretNote.getHandle()).getValue();
        }
        return string;
    }

    public void addSecretNote(SecretNote secretNote) {
        int n = this.notes.indexOf(secretNote);
        if (n >= 0) {
            this.notes.set(n, secretNote);
        } else {
            this.notes.add(0, secretNote);
        }
        this.controls.refresh();
    }

    public JComponent getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            JLabel jLabel = new JLabel("Visible once revealed");
            jLabel.setAlignmentX(0.0f);
            this.panel.add(jLabel);
            this.panel.add(this.controls);
        }
        return this.panel;
    }

    public Command save() {
        AddSecretNoteCommand addSecretNoteCommand = null;
        Iterator iterator = ((AbstractList)this.notes).iterator();
        while (iterator.hasNext()) {
            SecretNote secretNote = (SecretNote)iterator.next();
            int n = this.lastSavedNotes.indexOf(secretNote);
            if (n >= 0 && ((SecretNote)this.lastSavedNotes.get(n)).isHidden() == secretNote.isHidden()) continue;
            Command command = new AddSecretNoteCommand(this, secretNote);
            if (addSecretNoteCommand == null) {
                addSecretNoteCommand = command;
            } else {
                addSecretNoteCommand.append(command);
            }
            String string = n < 0 ? "* " + GlobalOptions.getInstance().getPlayerId() + " has created message '" + secretNote.getName() + "' *" : "* " + GlobalOptions.getInstance().getPlayerId() + " has revealed message '" + secretNote.getName() + "' *";
            command = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string);
            command.execute();
            addSecretNoteCommand.append(command);
        }
        return addSecretNoteCommand;
    }

    public void captureState() {
        this.lastSavedNotes = (List)this.notes.clone();
    }

    public void restoreState() {
        this.notes.clear();
        this.notes.addAll(this.lastSavedNotes);
        this.controls.refresh();
    }

    public SecretNote getNoteForName(String string) {
        ListIterator listIterator = ((AbstractList)this.notes).listIterator();
        while (listIterator.hasNext()) {
            SecretNote secretNote = (SecretNote)listIterator.next();
            if (!secretNote.getName().equals(string)) continue;
            return secretNote;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Controls
    extends JPanel
    implements ItemListener {
        private JTextArea text;
        private JTable table;
        private JButton revealButton;
        private String[] columnNames = new String[]{"Player", "Date/Time", "Note Name", "Revealed"};

        public Controls() {
            this.setLayout(new BoxLayout(this, 1));
            this.table = new JTable(new MyTableModel());
            this.initColumns(this.table);
            this.table.setSelectionMode(0);
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ Controls this$1;
                {
                    this.this$1 = controls;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (!listSelectionModel.isSelectionEmpty()) {
                        Controls.access$000(this.this$1);
                    }
                }
            });
            ScrollPane scrollPane = new ScrollPane(this.table);
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.add(scrollPane);
            Box box = Box.createHorizontalBox();
            box.setAlignmentX(0.0f);
            JButton jButton = new JButton("New");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Controls this$1;
                {
                    this.this$1 = controls;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.createNewNote();
                }
            });
            box.add(jButton);
            this.revealButton = new JButton("Reveal");
            this.revealButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Controls this$1;
                {
                    this.this$1 = controls;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Controls.access$100(this.this$1);
                }
            });
            this.revealButton.setEnabled(false);
            box.add(this.revealButton);
            this.add(box);
            this.text = new JTextArea(6, 20);
            this.text.setEditable(false);
            ScrollPane scrollPane2 = new ScrollPane(this.text);
            scrollPane2.setBorder(new TitledBorder("Text"));
            this.add(scrollPane2);
        }

        private void initColumns(JTable jTable) {
            TableColumn tableColumn = null;
            for (int i = 0; i < this.columnNames.length; ++i) {
                int n;
                tableColumn = jTable.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        n = 60;
                        break;
                    }
                    case 1: {
                        n = 100;
                        break;
                    }
                    case 2: {
                        n = 280;
                        break;
                    }
                    case 3: {
                        n = 60;
                        break;
                    }
                    default: {
                        n = 100;
                    }
                }
                tableColumn.setPreferredWidth(n);
            }
        }

        public void refresh() {
            this.table.setModel(new MyTableModel());
            this.initColumns(this.table);
            this.displaySelected();
        }

        private void revealSelectedNote() {
            int n = this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            String string = (String)this.table.getValueAt(n, 2);
            SecretNote secretNote = SecretNotesController.this.getNoteForName(string);
            if (secretNote.getOwner().equals(GameModule.getUserId()) && (secretNote = new SecretNote(secretNote.getName(), secretNote.getOwner(), secretNote.getText(), false, secretNote.getDate(), secretNote.getHandle())) != null) {
                int n2 = SecretNotesController.this.notes.indexOf(secretNote);
                SecretNotesController.this.notes.set(n2, secretNote);
                this.refresh();
            }
        }

        public void createNewNote() {
            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = SecretNotesController.class$("java.awt.Dialog")) : class$java$awt$Dialog, this);
            JDialog jDialog = null;
            jDialog = dialog != null ? new JDialog(dialog, true) : new JDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = SecretNotesController.class$("java.awt.Frame")) : class$java$awt$Frame, this), true);
            JDialog jDialog2 = jDialog;
            jDialog2.setTitle("Delayed Note");
            StringConfigurer stringConfigurer = new StringConfigurer(null, "Name");
            TextConfigurer textConfigurer = new TextConfigurer(null, "Text");
            jDialog2.getContentPane().setLayout(new BoxLayout(jDialog2.getContentPane(), 1));
            jDialog2.getContentPane().add(stringConfigurer.getControls());
            jDialog2.getContentPane().add(textConfigurer.getControls());
            Box box = Box.createHorizontalBox();
            JButton jButton = new JButton("Ok");
            jButton.addActionListener(new ActionListener(this, stringConfigurer, textConfigurer, jDialog2){
                private final /* synthetic */ StringConfigurer val$name;
                private final /* synthetic */ TextConfigurer val$text;
                private final /* synthetic */ JDialog val$d;
                private final /* synthetic */ Controls this$1;
                {
                    this.this$1 = controls;
                    this.val$name = stringConfigurer;
                    this.val$text = textConfigurer;
                    this.val$d = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SecretNote secretNote = new SecretNote(this.val$name.getValueString(), GameModule.getUserId(), (String)this.val$text.getValue(), true);
                    if (SecretNotesController.access$400(Controls.access$300(this.this$1)).contains(secretNote)) {
                        JOptionPane.showMessageDialog(this.this$1, "A note of this name already exists");
                    } else {
                        SecretNotesController.access$400(Controls.access$300(this.this$1)).add(0, secretNote);
                        this.this$1.refresh();
                        this.val$d.dispose();
                    }
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(this, jButton, stringConfigurer, textConfigurer){
                private final /* synthetic */ JButton val$okButton;
                private final /* synthetic */ StringConfigurer val$name;
                private final /* synthetic */ TextConfigurer val$text;
                private final /* synthetic */ Controls this$1;
                {
                    this.this$1 = controls;
                    this.val$okButton = jButton;
                    this.val$name = stringConfigurer;
                    this.val$text = textConfigurer;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$okButton.setEnabled(this.val$name.getValueString() != null && this.val$name.getValueString().length() > 0 && this.val$text.getValueString() != null && this.val$text.getValueString().length() > 0);
                }
            };
            stringConfigurer.addPropertyChangeListener(propertyChangeListener);
            textConfigurer.addPropertyChangeListener(propertyChangeListener);
            jButton.setEnabled(false);
            box.add(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(this, jDialog2){
                private final /* synthetic */ JDialog val$d;
                private final /* synthetic */ Controls this$1;
                {
                    this.this$1 = controls;
                    this.val$d = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$d.dispose();
                }
            });
            jDialog2.getContentPane().add(box);
            jDialog2.pack();
            jDialog2.setLocationRelativeTo(jDialog2.getOwner());
            ((Component)jDialog2).setVisible(true);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.displaySelected();
        }

        private void displaySelected() {
            this.revealButton.setEnabled(false);
            this.text.setText("");
            int n = this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            String string = (String)this.table.getValueAt(n, 2);
            SecretNote secretNote = SecretNotesController.this.getNoteForName(string);
            if (secretNote != null) {
                if (secretNote.getOwner().equals(GameModule.getUserId())) {
                    this.text.setText(secretNote.getText());
                    this.revealButton.setEnabled(secretNote.isHidden());
                } else {
                    this.text.setText(secretNote.isHidden() ? "<message not revealed>" : secretNote.getText());
                }
            }
        }

        static /* synthetic */ void access$000(Controls controls) {
            controls.displaySelected();
        }

        static /* synthetic */ void access$100(Controls controls) {
            controls.revealSelectedNote();
        }

        public class MyTableModel
        extends AbstractTableModel {
            public String getColumnName(int n) {
                return Controls.this.columnNames[n].toString();
            }

            public int getRowCount() {
                return SecretNotesController.this.notes.size();
            }

            public int getColumnCount() {
                return Controls.this.columnNames.length;
            }

            public Object getValueAt(int n, int n2) {
                SecretNote secretNote = (SecretNote)SecretNotesController.this.notes.get(n);
                switch (n2) {
                    case 0: {
                        return secretNote.getHandle();
                    }
                    case 1: {
                        return secretNote.getDate() == null ? "" : LOCAL_DATE_FORMATTER.format(secretNote.getDate());
                    }
                    case 2: {
                        return secretNote.getName();
                    }
                    case 3: {
                        return new Boolean(!secretNote.isHidden());
                    }
                }
                return null;
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
            }
        }
    }
}

