/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ChangePropertyButton
extends AbstractConfigurable
implements PropertyChangerConfigurer.Constraints {
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String PROPERTY_CHANGER = "propChanger";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String OLD_VALUE_FORMAT = "oldValue";
    public static final String NEW_VALUE_FORMAT = "newValue";
    public static final String DESCRIPTION_FORMAT = "description";
    protected LaunchButton launch;
    protected FormattedString report = new FormattedString();
    protected GlobalProperty property;
    protected PropertyChangerConfigurer propChangeConfig = new PropertyChangerConfigurer(null, null, this);
    protected FormattedString format = new FormattedString();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$VASSAL$build$module$properties$ChangePropertyButton$ReportFormatConfig;
    static /* synthetic */ Class class$VASSAL$build$module$properties$ChangePropertyButton$PropChangerOptions;

    public ChangePropertyButton() {
        this.launch = new LaunchButton("Change", BUTTON_TEXT, HOTKEY, BUTTON_ICON, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangePropertyButton.this.launch();
            }
        });
    }

    public void launch() {
        String string = this.property.getPropertyValue();
        String string2 = this.getNewValue();
        if (string2 != null && !string2.equals(string)) {
            Command command = this.property.setPropertyValue(string2);
            if (this.report.getFormat().length() > 0) {
                this.report.setProperty(OLD_VALUE_FORMAT, string);
                this.report.setProperty(NEW_VALUE_FORMAT, this.property.getPropertyValue());
                this.report.setProperty(DESCRIPTION_FORMAT, this.property.getDescription());
                Chatter.DisplayText displayText = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + this.report.getText());
                displayText.execute();
                command.append(displayText);
            }
            GameModule.getGameModule().sendAndLog(command);
        }
    }

    protected String getNewValue() {
        String string = this.getPropertyChanger().getNewValue(this.property.getPropertyValue());
        this.format.setFormat(string);
        string = this.format.getText(this.property);
        return string;
    }

    public PropertyChanger getPropertyChanger() {
        return this.propChangeConfig.getPropertyChanger();
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Button text", "Button icon", "Hotkey", "Report format", "Options"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = ChangePropertyButton.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$Icon == null ? (class$javax$swing$Icon = ChangePropertyButton.class$("javax.swing.Icon")) : class$javax$swing$Icon, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = ChangePropertyButton.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$VASSAL$build$module$properties$ChangePropertyButton$ReportFormatConfig == null ? (class$VASSAL$build$module$properties$ChangePropertyButton$ReportFormatConfig = ChangePropertyButton.class$("VASSAL.build.module.properties.ChangePropertyButton$ReportFormatConfig")) : class$VASSAL$build$module$properties$ChangePropertyButton$ReportFormatConfig, class$VASSAL$build$module$properties$ChangePropertyButton$PropChangerOptions == null ? (class$VASSAL$build$module$properties$ChangePropertyButton$PropChangerOptions = ChangePropertyButton.class$("VASSAL.build.module.properties.ChangePropertyButton$PropChangerOptions")) : class$VASSAL$build$module$properties$ChangePropertyButton$PropChangerOptions};
    }

    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, BUTTON_ICON, HOTKEY, REPORT_FORMAT, PROPERTY_CHANGER};
    }

    public void setAttribute(String string, Object object) {
        if (PROPERTY_CHANGER.equals(string)) {
            if (object instanceof String) {
                this.propChangeConfig.setValue((String)object);
            } else {
                this.propChangeConfig.setValue(object);
            }
        } else if (REPORT_FORMAT.equals(string)) {
            this.report.setFormat((String)object);
        } else {
            if (BUTTON_TEXT.equals(string)) {
                this.setConfigureName((String)object);
            }
            this.launch.setAttribute(string, object);
        }
    }

    public String getAttributeValueString(String string) {
        if (PROPERTY_CHANGER.equals(string)) {
            return this.propChangeConfig.getValueString();
        }
        if (REPORT_FORMAT.equals(string)) {
            return this.report.getFormat();
        }
        return this.launch.getAttributeValueString(string);
    }

    public void removeFrom(Buildable buildable) {
        this.property.getToolBar().remove(this.launch);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalProperties.htm", "ChangePropertyToolbarButton");
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void addTo(Buildable buildable) {
        this.property = (GlobalProperty)buildable;
        this.property.getToolBar().add(this.launch);
    }

    public static String getConfigureTypeName() {
        return "Change-property Toolbar Button";
    }

    public Component getComponent() {
        return this.launch.getTopLevelAncestor();
    }

    public int getMaximumValue() {
        return this.property.getMaxValue();
    }

    public int getMinimumValue() {
        return this.property.getMinValue();
    }

    public boolean isNumeric() {
        return this.property.isNumeric();
    }

    public boolean isWrap() {
        return this.property.isWrap();
    }

    public Object getProperty(Object object) {
        return this.property.getProperty(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class PropChangerOptions
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return ((ChangePropertyButton)autoConfigurable).propChangeConfig;
        }
    }

    public static class ReportFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{ChangePropertyButton.OLD_VALUE_FORMAT, ChangePropertyButton.NEW_VALUE_FORMAT, ChangePropertyButton.DESCRIPTION_FORMAT});
        }
    }
}

