/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.GlobalPropertiesContainer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.TemporaryToolBar;
import VASSAL.tools.ToolBarComponent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import javax.swing.JToolBar;

public class GlobalProperty
extends AbstractConfigurable
implements ToolBarComponent,
GameComponent,
CommandEncoder,
PropertySource {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String NAME = "name";
    public static final String INITIAL_VALUE = "initialValue";
    public static final String DESCRIPTION = "description";
    public static final String NUMERIC = "isNumeric";
    public static final String MIN_VALUE = "min";
    public static final String MAX_VALUE = "max";
    public static final String WRAP = "wrap";
    protected static final String COMMAND_PREFIX = "GlobalProperty\t";
    protected TemporaryToolBar tempToolbar = new TemporaryToolBar();
    protected String propertyValue;
    protected String description;
    protected String initialValue;
    protected boolean numeric;
    protected String minValue;
    protected String maxValue;
    protected boolean wrap;
    protected VisibilityCondition numericVisibility;
    protected FormattedString format = new FormattedString();
    protected PropertySource propertySource;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$VASSAL$build$module$properties$ChangePropertyButton;

    public GlobalProperty() {
        this.numericVisibility = new VisibilityCondition(){

            public boolean shouldBeVisible() {
                return GlobalProperty.this.isNumeric();
            }
        };
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "Initial value:  ", "Description:  ", "Is Numeric", "Minimum value:  ", "Maximum value:  ", "Wrap around"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = GlobalProperty.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = GlobalProperty.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = GlobalProperty.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = GlobalProperty.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = GlobalProperty.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = GlobalProperty.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = GlobalProperty.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, INITIAL_VALUE, DESCRIPTION, NUMERIC, MIN_VALUE, MAX_VALUE, WRAP};
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            String string2 = this.getConfigureName();
            this.propertyChangeSupport.firePropertyChange(string2, this.propertyValue, null);
            this.setConfigureName((String)object);
            this.propertyChangeSupport.firePropertyChange(this.getConfigureName(), null, this.propertyValue);
        } else if (INITIAL_VALUE.equals(string)) {
            this.initialValue = (String)object;
            if (this.initialValue == null) {
                this.initialValue = "";
            }
            this.setPropertyValue(this.initialValue);
        } else if (DESCRIPTION.equals(string)) {
            this.description = (String)object;
        } else if (NUMERIC.equals(string)) {
            this.numeric = Boolean.TRUE.equals(object) || "true".equals(object);
        } else if (MIN_VALUE.equals(string)) {
            this.minValue = (String)object;
        } else if (MAX_VALUE.equals(string)) {
            this.maxValue = (String)object;
        } else if (WRAP.equals(string)) {
            this.wrap = Boolean.TRUE.equals(object) || "true".equals(object);
        }
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (INITIAL_VALUE.equals(string)) {
            return this.initialValue;
        }
        if (DESCRIPTION.equals(string)) {
            return this.description;
        }
        if (NUMERIC.equals(string)) {
            return String.valueOf(this.numeric);
        }
        if (MIN_VALUE.equals(string)) {
            return String.valueOf(this.minValue);
        }
        if (MAX_VALUE.equals(string)) {
            return String.valueOf(this.maxValue);
        }
        if (WRAP.equals(string)) {
            return String.valueOf(this.wrap);
        }
        return null;
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (MIN_VALUE.equals(string) || MAX_VALUE.equals(string) || WRAP.equals(string)) {
            return this.numericVisibility;
        }
        return super.getAttributeVisibility(string);
    }

    public void removeFrom(Buildable buildable) {
        this.propertyChangeSupport.firePropertyChange(this.getConfigureName(), this.propertyValue, null);
        this.propertyChangeSupport.removePropertyChangeListener(((GlobalPropertiesContainer)((Object)buildable)).getPropertyListener());
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalProperties.htm");
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$module$properties$ChangePropertyButton == null ? (class$VASSAL$build$module$properties$ChangePropertyButton = GlobalProperty.class$("VASSAL.build.module.properties.ChangePropertyButton")) : class$VASSAL$build$module$properties$ChangePropertyButton};
    }

    public void addTo(Buildable buildable) {
        this.setPropertyValue(this.initialValue);
        this.propertyChangeSupport.addPropertyChangeListener(((GlobalPropertiesContainer)((Object)buildable)).getPropertyListener());
        this.propertyChangeSupport.firePropertyChange(this.getConfigureName(), null, this.propertyValue);
        this.tempToolbar.setDelegate((ToolBarComponent)((Object)buildable));
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.propertySource = (PropertySource)((Object)buildable);
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public Command setPropertyValue(String string) {
        String string2 = this.propertyValue;
        this.propertyValue = string;
        this.propertyChangeSupport.firePropertyChange(this.getConfigureName(), string2, this.propertyValue);
        return new SetGlobalProperty(this, string2, string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public JToolBar getToolBar() {
        return this.tempToolbar.getToolBar();
    }

    public void setup(boolean bl) {
        if (!bl) {
            this.setPropertyValue(this.initialValue);
        }
    }

    public Command getRestoreCommand() {
        return new SetGlobalProperty(this, "", this.getPropertyValue());
    }

    public Command decode(String string) {
        String string2;
        SetGlobalProperty setGlobalProperty = null;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        String string3 = decoder.nextToken("");
        if (string3.equals(COMMAND_PREFIX) && (string2 = decoder.nextToken("")).equals(this.getPropertyId())) {
            setGlobalProperty = new SetGlobalProperty(this, this.getPropertyValue(), decoder.nextToken(""));
        }
        return setGlobalProperty;
    }

    protected String getPropertyId() {
        return this.getConfigureName();
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof SetGlobalProperty && ((SetGlobalProperty)command).getTargetName().equals(this.getPropertyId())) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(COMMAND_PREFIX, ';');
            sequenceEncoder.append(this.getPropertyId());
            sequenceEncoder.append(((SetGlobalProperty)command).newValue);
            string = sequenceEncoder.getValue();
        }
        return string;
    }

    public int getMaxValue() {
        int n = 100;
        if (this.maxValue != null) {
            this.format.setFormat(this.maxValue);
            try {
                n = Integer.parseInt(this.format.getText(this));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public int getMinValue() {
        int n = 0;
        if (this.minValue != null) {
            this.format.setFormat(this.minValue);
            try {
                n = Integer.parseInt(this.format.getText(this));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getProperty(Object object) {
        return this.propertySource == null ? null : this.propertySource.getProperty(object);
    }

    public static String getConfigureTypeName() {
        return "Global Property";
    }

    public static GlobalProperty findGlobalProperty(String string, List list) {
        GlobalProperty globalProperty = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && globalProperty == null) {
            GlobalPropertiesContainer globalPropertiesContainer = (GlobalPropertiesContainer)iterator.next();
            globalProperty = globalPropertiesContainer == null ? null : globalPropertiesContainer.getGlobalProperty(string);
        }
        return globalProperty;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SetGlobalProperty
    extends Command {
        protected String newValue;
        protected String oldValue;
        protected GlobalProperty target;
        protected String targetName;

        public SetGlobalProperty(GlobalProperty globalProperty, String string, String string2) {
            this.oldValue = string;
            this.newValue = string2;
            this.target = globalProperty;
        }

        public String getTargetName() {
            return this.target == null ? "" : this.target.getPropertyId();
        }

        protected void executeCommand() {
            this.target.setPropertyValue(this.newValue);
        }

        protected Command myUndoCommand() {
            return new SetGlobalProperty(this.target, this.newValue, this.oldValue);
        }
    }
}

