/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlChart
extends Widget
implements MouseListener {
    public static final String NAME = "chartName";
    public static final String FILE = "fileName";
    private String fileName;
    private JScrollPane scroller;
    private JEditorPane htmlWin;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;

    private boolean isURL() {
        return this.htmlWin.getDocument().getProperty("stream") != null;
    }

    private void setText(String string) {
        this.htmlWin.setText(string);
        this.htmlWin.getDocument().putProperty("stream", null);
        this.htmlWin.revalidate();
    }

    private void setFile(String string) {
        this.setText(this.getFile(string));
    }

    private String getFile(String string) {
        if (string == null) {
            return null;
        }
        try {
            InputStream inputStream = GameModule.getGameModule().getDataArchive().getFileStream(string);
            byte[] byArray = new byte[inputStream.available()];
            int n = inputStream.available();
            int n2 = 0;
            for (int i = 0; i < n && (n2 = inputStream.read(byArray, i, n - i)) > 0; i += n2) {
            }
            inputStream.close();
            return new String(byArray, "UTF-8");
        }
        catch (IOException iOException) {
            return "Page " + string + " not found";
        }
    }

    public Component getComponent() {
        if (this.htmlWin == null) {
            this.htmlWin = new JEditorPane();
            this.htmlWin.setEditable(false);
            this.htmlWin.setContentType("text/html");
            XTMLEditorKit xTMLEditorKit = new XTMLEditorKit();
            this.htmlWin.setEditorKit(xTMLEditorKit);
            this.htmlWin.addHyperlinkListener(new HtmlChartHyperlinkListener());
            this.htmlWin.addMouseListener(this);
            this.setFile(this.fileName);
            this.scroller = new ScrollPane(this.htmlWin);
            this.scroller.getViewport().setPreferredSize(this.htmlWin.getPreferredSize());
            this.scroller.getViewport().setAlignmentY(0.0f);
        }
        return this.scroller;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void addTo(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return "HTML Chart";
    }

    public void removeFrom(Buildable buildable) {
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChartWindow.htm", "HtmlChart");
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (FILE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.fileName = (String)object;
            if (this.htmlWin != null) {
                this.setFile(this.fileName);
            }
        }
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, FILE};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "HTML File"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = HtmlChart.class$("java.lang.String")) : class$java$lang$String, class$java$io$File == null ? (class$java$io$File = HtmlChart.class$("java.io.File")) : class$java$io$File};
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (FILE.equals(string)) {
            return this.fileName;
        }
        return null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Return to default page");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HtmlChart.this.setFile(HtmlChart.this.fileName);
                }
            });
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class XTMLEditorKit
    extends HTMLEditorKit {
        public ViewFactory getViewFactory() {
            return new XTMLFactory();
        }

        public class XTMLFactory
        extends HTMLEditorKit.HTMLFactory
        implements ViewFactory {
            public View create(Element element) {
                String string;
                HTML.Tag tag = (HTML.Tag)element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (tag instanceof HTML.Tag && element.getName().equals("img") && (string = (String)element.getAttributes().getAttribute(HTML.Attribute.SRC)).indexOf("/") < 0) {
                    return new ImageComponentView(element);
                }
                return super.create(element);
            }

            public class ImageComponentView
            extends ComponentView {
                protected String imageName;

                public ImageComponentView(Element element) {
                    super(element);
                    this.imageName = (String)element.getAttributes().getAttribute(HTML.Attribute.SRC);
                }

                protected Component createComponent() {
                    try {
                        JLabel jLabel = new JLabel();
                        ImageIcon imageIcon = new ImageIcon(GameModule.getGameModule().getDataArchive().getCachedImage(this.imageName));
                        jLabel.setIcon(imageIcon);
                        return jLabel;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
        }
    }

    public class HtmlChartHyperlinkListener
    implements HyperlinkListener {
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (!HtmlChart.this.isURL() && hyperlinkEvent.getDescription().indexOf("/") < 0 || hyperlinkEvent.getURL() == null) {
                    HtmlChart.this.setFile(hyperlinkEvent.getDescription());
                } else {
                    try {
                        HtmlChart.this.htmlWin.setPage(hyperlinkEvent.getURL());
                    }
                    catch (IOException iOException) {
                        HtmlChart.this.setText("Can't open " + hyperlinkEvent.getURL() + " : " + iOException.getMessage());
                    }
                    HtmlChart.this.htmlWin.revalidate();
                }
            }
        }
    }
}

