/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.configure.VisibilityCondition;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PanelWidget
extends Widget {
    private JPanel panel;
    private Vector widgets = new Vector();
    private int nColumns = 3;
    private boolean vertical = false;
    private boolean fixed = false;
    public static final String FIXED = "fixed";
    public static final String COLS = "nColumns";
    public static final String VERTICAL = "vert";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    public static String getConfigureTypeName() {
        return "Panel";
    }

    public Component getComponent() {
        if (this.panel == null) {
            this.rebuild();
            this.panel = new JPanel();
            this.panel.setLayout(this.getLayout(this.panel));
            for (int i = 0; i < this.widgets.size(); ++i) {
                Component component = ((Widget)this.widgets.elementAt(i)).getComponent();
                if (component instanceof JComponent) {
                    ((JComponent)component).setAlignmentX(0.0f);
                    ((JComponent)component).setAlignmentY(0.0f);
                }
                this.panel.add(component);
            }
        }
        return this.panel;
    }

    private LayoutManager getLayout(Container container) {
        if (this.fixed) {
            return new GridLayout(0, this.nColumns);
        }
        return new BoxLayout(container, this.vertical ? 1 : 0);
    }

    public void add(Buildable buildable) {
        if (buildable instanceof Widget) {
            Widget widget = (Widget)buildable;
            this.widgets.addElement(widget);
            if (this.panel != null) {
                Component component = widget.getComponent();
                if (component instanceof JComponent) {
                    ((JComponent)component).setAlignmentX(0.0f);
                    ((JComponent)component).setAlignmentY(0.0f);
                }
                this.panel.add(component);
                this.panel.revalidate();
            }
        }
        super.add(buildable);
    }

    public void remove(Buildable buildable) {
        if (buildable instanceof Widget) {
            Widget widget = (Widget)buildable;
            if (this.panel != null) {
                this.panel.remove(widget.getComponent());
            }
            this.widgets.removeElement(widget);
        }
        super.remove(buildable);
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{"entryName", FIXED, COLS, VERTICAL};
        return stringArray;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "Fixed cell size", "Number of columns", "Vertical layout"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = PanelWidget.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PanelWidget.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PanelWidget.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PanelWidget.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (COLS.equals(string)) {
            VisibilityCondition visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return PanelWidget.this.fixed;
                }
            };
            return visibilityCondition;
        }
        if (VERTICAL.equals(string)) {
            VisibilityCondition visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !PanelWidget.this.fixed;
                }
            };
            return visibilityCondition;
        }
        return super.getAttributeVisibility(string);
    }

    public void setAttribute(String string, Object object) {
        if ("entryName".equals(string)) {
            this.setConfigureName((String)object);
        } else if (FIXED.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.fixed = (Boolean)object;
        } else if (COLS.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.nColumns = (Integer)object;
        } else if (VERTICAL.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.vertical = (Boolean)object;
        }
        if (this.panel != null) {
            this.panel.setLayout(this.getLayout(this.panel));
            this.panel.revalidate();
        }
    }

    public String getAttributeValueString(String string) {
        if ("entryName".equals(string)) {
            return this.getConfigureName();
        }
        if (FIXED.equals(string)) {
            return "" + this.fixed;
        }
        if (COLS.equals(string)) {
            return "" + this.nColumns;
        }
        if (VERTICAL.equals(string)) {
            return "" + this.vertical;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

