/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.documentation.HelpWindowExtension;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.PieceMover;
import VASSAL.command.AddPiece;
import VASSAL.configure.Configurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceDefiner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PieceSlot
extends Widget
implements MouseListener,
KeyListener {
    private GamePiece c;
    private String name;
    private String pieceDefinition;
    protected static Font FONT = new Font("Dialog", 0, 12);
    private JPanel panel = new Panel();
    private int width;
    private int height;

    public PieceSlot() {
        this.panel.addMouseListener(this);
        this.panel.addKeyListener(this);
    }

    public PieceSlot(GamePiece gamePiece) {
        this();
        this.setPiece(gamePiece);
    }

    public void setPiece(GamePiece gamePiece) {
        this.c = gamePiece;
        if (this.c != null) {
            this.c.setPosition(new Point(this.panel.getSize().width / 2, this.panel.getSize().height / 2));
            this.name = Decorator.getInnermost(this.c).getName();
        }
        this.panel.revalidate();
        this.panel.repaint();
        this.pieceDefinition = this.c == null ? null : GameModule.getGameModule().encode(new AddPiece(this.c));
    }

    public GamePiece getPiece() {
        if (this.c == null && this.pieceDefinition != null) {
            AddPiece addPiece = (AddPiece)GameModule.getGameModule().decode(this.pieceDefinition);
            if (addPiece == null) {
                System.err.println("Couldn't build piece " + this.pieceDefinition);
                this.pieceDefinition = null;
            } else {
                this.c = addPiece.getTarget();
                this.c.setState(addPiece.getState());
                this.c.setPosition(new Point(this.panel.getSize().width / 2, this.panel.getSize().height / 2));
            }
        }
        return this.c;
    }

    public void paint(Graphics graphics) {
        graphics.clearRect(0, 0, this.panel.getSize().width, this.panel.getSize().height);
        if (this.getPiece() == null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawRect(0, 0, this.panel.getSize().width - 1, this.panel.getSize().height - 1);
            graphics.setFont(FONT);
            graphics.drawString(" nil ", this.panel.getSize().width / 2 - fontMetrics.stringWidth(" nil ") / 2, this.panel.getSize().height / 2);
        } else {
            this.getPiece().draw(graphics, this.panel.getSize().width / 2, this.panel.getSize().height / 2, this.panel, 1.0);
            if (Boolean.TRUE.equals(this.getPiece().getProperty("Selected"))) {
                BasicPiece.getHighlighter().draw(this.getPiece(), graphics, this.panel.getSize().width / 2, this.panel.getSize().height / 2, this.panel, 1.0);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.c != null && this.panel.getGraphics() != null) {
            return this.c.boundingBox().getSize();
        }
        return new Dimension(this.width, this.height);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        KeyBuffer.getBuffer().clear();
        if (this.getPiece() != null) {
            KeyBuffer.getBuffer().add(this.getPiece());
        }
        this.panel.requestFocus();
        this.panel.repaint();
    }

    protected void startDrag() {
        this.getPiece().setPosition(new Point(this.panel.getSize().width / 2, this.panel.getSize().height / 2));
        this.getPiece().setProperty("Selected", null);
        this.panel.repaint();
        if (this.getPiece() != null) {
            KeyBuffer.getBuffer().clear();
            DragBuffer.getBuffer().clear();
            GamePiece gamePiece = PieceCloner.getInstance().clonePiece(this.getPiece());
            DragBuffer.getBuffer().add(gamePiece);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getPiece() != null && mouseEvent.isMetaDown()) {
            JPopupMenu jPopupMenu = MenuDisplayer.createPopup(this.getPiece());
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    PieceSlot.this.panel.repaint();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    PieceSlot.this.panel.repaint();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
            jPopupMenu.show(this.panel, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        KeyBuffer.getBuffer().remove(this.getPiece());
        this.panel.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        KeyBuffer.getBuffer().keyCommand(KeyStroke.getKeyStrokeForEvent(keyEvent));
        keyEvent.consume();
        this.panel.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
        KeyBuffer.getBuffer().keyCommand(KeyStroke.getKeyStrokeForEvent(keyEvent));
        keyEvent.consume();
        this.panel.repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
        KeyBuffer.getBuffer().keyCommand(KeyStroke.getKeyStrokeForEvent(keyEvent));
        keyEvent.consume();
        this.panel.repaint();
    }

    public static String getConfigureTypeName() {
        return "Single piece";
    }

    public Component getComponent() {
        return this.panel;
    }

    public void build(Element element) {
        if (element != null) {
            this.name = element.getAttribute("entryName");
            if (this.name.length() == 0) {
                this.name = null;
            }
            try {
                this.width = Integer.parseInt(element.getAttribute("width"));
                this.height = Integer.parseInt(element.getAttribute("height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.width = 60;
                this.height = 60;
            }
            this.pieceDefinition = Builder.getText(element);
        }
    }

    public void addTo(Buildable buildable) {
        this.panel.setDropTarget(PieceMover.DragHandler.makeDropTarget(this.panel, 2, null));
        DragGestureListener dragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                PieceSlot.this.startDrag();
                PieceMover.DragHandler.getTheDragHandler().dragGestureRecognized(dragGestureEvent);
            }
        };
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.panel, 2, dragGestureListener);
    }

    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        String string = this.getConfigureName();
        if (string != null) {
            element.setAttribute("entryName", string);
        }
        element.setAttribute("width", this.getPreferredSize().width + "");
        element.setAttribute("height", this.getPreferredSize().height + "");
        element.appendChild(document.createTextNode(this.c == null ? this.pieceDefinition : GameModule.getGameModule().encode(new AddPiece(this.c))));
        return element;
    }

    public void removeFrom(Buildable buildable) {
    }

    public String getConfigureName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.getPiece() != null) {
            return Decorator.getInnermost(this.getPiece()).getName();
        }
        return null;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePiece.htm");
    }

    public String[] getAttributeNames() {
        return null;
    }

    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    public Class[] getAttributeTypes() {
        return new Class[0];
    }

    public void setAttribute(String string, Object object) {
    }

    public String getAttributeValueString(String string) {
        return null;
    }

    public Configurer[] getAttributeConfigurers() {
        return new Configurer[0];
    }

    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public Configurer getConfigurer() {
        return new MyConfigurer(this);
    }

    private static class MyConfigurer
    extends Configurer
    implements HelpWindowExtension {
        private PieceDefiner definer = new PieceDefiner();

        public MyConfigurer(PieceSlot pieceSlot) {
            super(null, pieceSlot.getConfigureName(), pieceSlot);
            this.definer.setPiece(pieceSlot.getPiece());
        }

        public void setBaseWindow(HelpWindow helpWindow) {
            this.definer.setBaseWindow(helpWindow);
        }

        public String getValueString() {
            return null;
        }

        public void setValue(String string) {
            throw new RuntimeException("Cannot set from String");
        }

        public Object getValue() {
            PieceSlot pieceSlot = (PieceSlot)super.getValue();
            if (pieceSlot != null) {
                pieceSlot.setPiece(this.definer.getPiece());
            }
            return pieceSlot;
        }

        public Component getControls() {
            return this.definer;
        }
    }

    private class Panel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public Panel() {
            this.setFocusTraversalKeysEnabled(false);
        }

        public void paint(Graphics graphics) {
            PieceSlot.this.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return PieceSlot.this.getPreferredSize();
        }
    }
}

