/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TimeZone;

public class CgiServerStatus
implements ServerStatus {
    private static long DAY = 86400000L;
    public static final String LAST_DAY = "Last 24 hours";
    public static final String LAST_WEEK = "Last Week";
    public static final String LAST_MONTH = "Last Month";
    private Map timeRanges = new HashMap();
    private String[] times = new String[]{"Last 24 hours", "Last Week", "Last Month"};
    private HttpRequestWrapper request = new HttpRequestWrapper("http://www.vassalengine.org/util/");
    private List cachedQuery;

    public CgiServerStatus() {
        this.timeRanges.put(LAST_DAY, new Long(DAY));
        this.timeRanges.put(LAST_WEEK, new Long(DAY * 7L));
        this.timeRanges.put(LAST_MONTH, new Long(DAY * 30L));
    }

    public ServerStatus.ModuleSummary[] getStatus() {
        ServerStatus.ModuleSummary[] moduleSummaryArray;
        HashMap<String, ServerStatus.ModuleSummary> hashMap = new HashMap<String, ServerStatus.ModuleSummary>();
        try {
            moduleSummaryArray = this.request.doGet("getCurrentConnections", new Properties());
            while (moduleSummaryArray.hasMoreElements()) {
                String string = (String)moduleSummaryArray.nextElement();
                SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
                try {
                    String string2 = decoder.nextToken();
                    String string3 = decoder.nextToken();
                    String string4 = decoder.nextToken();
                    ServerStatus.ModuleSummary moduleSummary = (ServerStatus.ModuleSummary)hashMap.get(string2);
                    if (moduleSummary == null) {
                        hashMap.put(string2, this.createEntry(string2, string3, string4));
                        continue;
                    }
                    this.updateEntry(moduleSummary, string3, string4);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.cachedQuery = null;
        this.retrieveHistory();
        moduleSummaryArray = hashMap.values().toArray(new ServerStatus.ModuleSummary[hashMap.size()]);
        return moduleSummaryArray;
    }

    public ServerStatus.ModuleSummary[] getHistory(String string) {
        Long l = (Long)this.timeRanges.get(string);
        if (l != null) {
            return this.getHistory(l);
        }
        return new ServerStatus.ModuleSummary[0];
    }

    public String[] getSupportedTimeRanges() {
        return this.times;
    }

    private ServerStatus.ModuleSummary[] getHistory(long l) {
        if (l <= 0L) {
            return this.getStatus();
        }
        long l2 = System.currentTimeMillis();
        l2 += (long)TimeZone.getDefault().getOffset(0, 1, 2, 6, 7, 14);
        HashMap<String, ServerStatus.ModuleSummary> hashMap = new HashMap<String, ServerStatus.ModuleSummary>();
        ServerStatus.ModuleSummary[] moduleSummaryArray = this.retrieveHistory().iterator();
        while (moduleSummaryArray.hasNext()) {
            String string = (String)moduleSummaryArray.next();
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
            try {
                String string2 = decoder.nextToken();
                String string3 = decoder.nextToken();
                String string4 = decoder.nextToken();
                long l3 = Long.parseLong(decoder.nextToken());
                if (l2 - l3 > l) continue;
                ServerStatus.ModuleSummary moduleSummary = (ServerStatus.ModuleSummary)hashMap.get(string2);
                if (moduleSummary == null) {
                    hashMap.put(string2, this.createEntry(string2, string3, string4));
                    continue;
                }
                this.updateEntry(moduleSummary, string3, string4);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
        moduleSummaryArray = hashMap.values().toArray(new ServerStatus.ModuleSummary[hashMap.size()]);
        return moduleSummaryArray;
    }

    private List retrieveHistory() {
        if (this.cachedQuery == null) {
            this.cachedQuery = new ArrayList();
            try {
                Enumeration enumeration = this.request.doGet("getConnectionHistory", new Properties());
                while (enumeration.hasMoreElements()) {
                    this.cachedQuery.add(enumeration.nextElement());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.cachedQuery;
    }

    private ServerStatus.ModuleSummary updateEntry(ServerStatus.ModuleSummary moduleSummary, String string, String string2) {
        SimpleRoom simpleRoom = moduleSummary.getRoom(string);
        if (simpleRoom == null) {
            simpleRoom = new SimpleRoom(string);
            simpleRoom.setPlayers(new Player[]{new SimplePlayer(string2)});
            moduleSummary.addRoom(simpleRoom);
        } else {
            simpleRoom.addPlayer(new SimplePlayer(string2));
        }
        return moduleSummary;
    }

    private ServerStatus.ModuleSummary createEntry(String string, String string2, String string3) {
        SimpleRoom simpleRoom = new SimpleRoom(string2);
        simpleRoom.setPlayers(new Player[]{new SimplePlayer(string3)});
        return new ServerStatus.ModuleSummary(string, new Room[]{simpleRoom});
    }
}

