/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.DummyClient;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.HybridClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DynamicClient
extends HybridClient {
    private String serverConfigURL;

    public DynamicClient() {
        this("http://www.vassalengine.org/util/getServerImpl");
    }

    public DynamicClient(String string) {
        this.serverConfigURL = string;
    }

    protected ChatServerConnection buildDelegate() {
        ChatServerConnection chatServerConnection = null;
        try {
            Properties properties = this.getServerConfig();
            chatServerConnection = ChatServerFactory.build(properties);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.fireStatus("Unable to initiate connection to server");
        }
        return chatServerConnection;
    }

    private Properties getServerConfig() throws IOException {
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper(this.serverConfigURL);
        Properties properties = new Properties();
        ((Hashtable)properties).put("module", GameModule.getGameModule() == null ? "Test" : GameModule.getGameModule().getGameName());
        ((Hashtable)properties).put("vassalVersion", Info.getVersion());
        Enumeration enumeration = httpRequestWrapper.doGet(properties);
        if (!enumeration.hasMoreElements()) {
            throw new IOException("Empty response");
        }
        properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement()).append('\n');
        }
        properties.load(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
        return properties;
    }

    public void setConnected(boolean bl) {
        if (bl && !this.isConnected()) {
            this.setDelegate(this.buildDelegate());
        }
        super.setConnected(bl);
        if (!bl && !this.isConnected()) {
            this.setDelegate(new DummyClient());
        }
    }
}

