/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.build.GameModule;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class HttpMessageServer
implements MessageBoard,
WelcomeMessageServer {
    private HttpRequestWrapper welcomeURL;
    private HttpRequestWrapper getMessagesURL;
    private HttpRequestWrapper postMessageURL;
    private PeerPoolInfo info;

    public HttpMessageServer(PeerPoolInfo peerPoolInfo) {
        this("http://www.vassalengine.org/util/getMessages", "http://www.vassalengine.org/util/postMessage", "http://www.vassalengine.org/util/motd", peerPoolInfo);
    }

    public HttpMessageServer(String string, String string2, String string3, PeerPoolInfo peerPoolInfo) {
        this.getMessagesURL = new HttpRequestWrapper(string);
        this.welcomeURL = new HttpRequestWrapper(string3);
        this.postMessageURL = new HttpRequestWrapper(string2);
        this.info = peerPoolInfo;
    }

    public Command getWelcomeMessage() {
        Command command = new NullCommand();
        try {
            if (GameModule.getGameModule() != null) {
                Enumeration enumeration = this.welcomeURL.doGet(this.prepareInfo());
                while (enumeration.hasMoreElements()) {
                    command = command.append(GameModule.getGameModule().decode((String)enumeration.nextElement()));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return command;
    }

    public Message[] getMessages() {
        Message[] messageArray;
        ArrayList<Message> arrayList = new ArrayList<Message>();
        try {
            messageArray = this.getMessagesURL.doGet(this.prepareInfo());
            while (messageArray.hasMoreElements()) {
                String string = (String)messageArray.nextElement();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.substring(string2.indexOf("=") + 1);
                String string4 = stringTokenizer.nextToken();
                string4 = string4.substring(string4.indexOf("=") + 1);
                string2 = stringTokenizer.nextToken("");
                SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string2.substring(string2.indexOf("=") + 1), '|');
                String string5 = "";
                while (decoder.hasMoreTokens()) {
                    string5 = string5 + decoder.nextToken();
                    if (!decoder.hasMoreTokens()) continue;
                    string5 = string5 + "\n";
                }
                string5 = this.restorePercent(string5);
                Date date = null;
                try {
                    long l = Long.parseLong(string4);
                    TimeZone timeZone = TimeZone.getDefault();
                    date = new Date(l += (long)timeZone.getOffset(0, 1, 2, 6, 7, 14));
                }
                catch (NumberFormatException numberFormatException) {
                    date = new Date();
                }
                arrayList.add(new Message(string3, string5, date));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        messageArray = arrayList.toArray(new Message[arrayList.size()]);
        return messageArray;
    }

    private Properties prepareInfo() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("module", this.info.getModuleName());
        return properties;
    }

    private String removePercent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "%#", true);
        block4: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case '%': {
                    stringBuffer.append("/#/");
                    continue block4;
                }
                case '#': {
                    stringBuffer.append("/##/");
                    continue block4;
                }
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String restorePercent(String string) {
        int n = string.indexOf("/#/");
        while (n >= 0) {
            string = string.substring(0, n) + "%" + string.substring(n + 3);
            n = string.indexOf("/#/");
        }
        n = string.indexOf("/##/");
        while (n >= 0) {
            string = string.substring(0, n) + "#" + string.substring(n + 4);
            n = string.indexOf("/##/");
        }
        return string;
    }

    public void postMessage(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        string = this.removePercent(string);
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            sequenceEncoder.append(stringTokenizer.nextToken());
        }
        Properties properties = this.prepareInfo();
        ((Hashtable)properties).put("sender", this.info.getUserName());
        ((Hashtable)properties).put("content", sequenceEncoder.getValue());
        try {
            this.postMessageURL.doPost(properties);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

