/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PrivateChatter;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PrivateChatManager {
    private ChatServerConnection client;
    private Vector chatters = new Vector();
    private Vector banned = new Vector();

    public PrivateChatManager(ChatServerConnection chatServerConnection) {
        this.client = chatServerConnection;
    }

    public PrivateChatter getChatterFor(final Player player) {
        if (this.banned.contains(player)) {
            return null;
        }
        PrivateChatter privateChatter = null;
        int n = this.chatters.indexOf(new Entry(player, null));
        if (n >= 0) {
            privateChatter = ((Entry)this.chatters.elementAt(n)).chatter;
        }
        if (privateChatter == null) {
            privateChatter = new PrivateChatter(player, this.client);
            this.chatters.addElement(new Entry(player, privateChatter));
            JFrame jFrame = new JFrame();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PrivateChatManager.this.promptToBan(player);
                }
            });
            jFrame.setTitle(player.getName() + " private channel");
            jFrame.getContentPane().add(privateChatter);
            jFrame.pack();
            ((Component)jFrame).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - jFrame.getSize().width / 2, 0);
        }
        return privateChatter;
    }

    private void promptToBan(Player player) {
        if (0 == JOptionPane.showConfirmDialog(null, "Ignore all messages from " + player.getName() + " for this session?", null, 0)) {
            this.banned.addElement(player);
        }
    }

    private static class Entry {
        private Player player;
        private PrivateChatter chatter;

        private Entry(Player player, PrivateChatter privateChatter) {
            if (player == null) {
                throw new NullPointerException();
            }
            this.player = player;
            this.chatter = privateChatter;
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                return this.player.equals(((Entry)object).player);
            }
            return false;
        }
    }
}

