/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.jabber.JabberPlayer;
import VASSAL.chat.jabber.JabberRoom;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;

public class JabberClient
implements ChatServerConnection,
PacketListener,
ServerStatus {
    private MessageBoard msgSvr;
    private XMPPConnection conn;
    private String username;
    private String password;
    private String host;
    private int port = 5222;
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private JabberPlayer me = new JabberPlayer("Rodney Kinney" + System.currentTimeMillis(), null);
    private String conferenceService;
    private MonitorRooms monitor;
    private CommandEncoder encoder;
    private final JabberRoom defaultRoom;
    private MultiUserChat currentChat;

    public JabberClient(CommandEncoder commandEncoder, String string, int n, String string2, String string3) {
        this.host = string;
        this.conferenceService = "conference." + string;
        this.username = string2;
        this.password = string3;
        this.encoder = commandEncoder;
        this.defaultRoom = JabberRoom.createLocal(this, "Main Room");
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public boolean isConnected() {
        return this.conn != null && this.conn.isConnected();
    }

    public void sendToOthers(Command command) {
        if (this.currentChat != null) {
            try {
                this.currentChat.sendMessage(this.encoder.encode(command));
            }
            catch (XMPPException xMPPException) {
                this.reportXMPPException(xMPPException);
            }
        }
    }

    public void setConnected(boolean bl) {
        if (bl) {
            if (!this.isConnected()) {
                if (this.conn != null) {
                    this.conn.close();
                }
                try {
                    ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration(this.host, this.port);
                    connectionConfiguration.setTLSEnabled(false);
                    connectionConfiguration.setCompressionEnabled(true);
                    connectionConfiguration.setSASLAuthenticationEnabled(false);
                    connectionConfiguration.setDebuggerEnabled(XMPPConnection.DEBUG_ENABLED);
                    this.conn = new XMPPConnection(connectionConfiguration);
                    this.conn.loginAnonymously();
                    this.me = new JabberPlayer(this.me.getName(), this.conn.getUser());
                    this.monitor = new MonitorRooms();
                    this.setRoom(this.defaultRoom);
                    this.propSupport.firePropertyChange("Connected", null, Boolean.TRUE);
                }
                catch (XMPPException xMPPException) {
                    this.reportXMPPException(xMPPException);
                    this.setConnected(false);
                }
            }
        } else if (this.isConnected()) {
            this.leaveCurrentRoom();
            if (this.monitor != null) {
                this.monitor.disconnect();
            }
            this.conn.close();
            this.conn = null;
            this.monitor = null;
            this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
        }
    }

    private void leaveCurrentRoom() {
        if (this.currentChat != null) {
            this.currentChat.leave();
            this.currentChat.removeMessageListener((PacketListener)this);
        }
    }

    public void processPacket(Packet packet) {
        Message message = (Message)packet;
        if (!message.getFrom().equals(this.currentChat.getRoom() + "/" + this.currentChat.getNickname())) {
            this.propSupport.firePropertyChange("Msg", null, message.getBody());
        }
    }

    public Room getRoom() {
        return this.monitor.getCurrentRoom();
    }

    public String getCurrentRoomJID() {
        return this.currentChat == null ? null : this.currentChat.getRoom();
    }

    public void setRoom(Room room) {
        this.leaveCurrentRoom();
        String string = this.getCurrentRoomJID();
        JabberRoom jabberRoom = null;
        try {
            jabberRoom = room instanceof JabberRoom ? (JabberRoom)room : JabberRoom.createLocal(this, room.getName());
            this.currentChat = jabberRoom.join(this, this.me);
            this.monitor.sendRoomChanged(string, jabberRoom.getJID());
        }
        catch (XMPPException xMPPException) {
            this.reportXMPPException(xMPPException);
            this.propSupport.firePropertyChange("Status", null, "Failed to join room");
        }
    }

    public Room[] getAvailableRooms() {
        return this.monitor.getAvailableRooms();
    }

    protected void fireRoomsUpdated() {
        this.propSupport.firePropertyChange("AvailableRooms", null, this.getAvailableRooms());
    }

    public Player getUserInfo() {
        return this.me;
    }

    public void setUserInfo(Player player) {
    }

    public void sendTo(Player player, Command command) {
        Chat chat = this.conn.createChat(((JabberPlayer)player).getJid());
        try {
            chat.sendMessage(this.encoder.encode(command));
        }
        catch (XMPPException xMPPException) {
            this.reportXMPPException(xMPPException);
        }
    }

    private void reportXMPPException(XMPPException xMPPException) {
        xMPPException.printStackTrace();
        if (GameModule.getGameModule() != null) {
            GameModule.getGameModule().warn(xMPPException.getMessage());
        }
    }

    public MessageBoard getMessageServer() {
        return this.msgSvr;
    }

    public ServerStatus getStatusServer() {
        return this;
    }

    public XMPPConnection getConnection() {
        return this.conn;
    }

    public String getModule() {
        return "JabberTestModule";
    }

    public String getConferenceService() {
        return this.conferenceService;
    }

    public static String escapeNode(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
        int n = string.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\22");
                    continue block11;
                }
                case '&': {
                    stringBuffer.append("\\26");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\27");
                    continue block11;
                }
                case '/': {
                    stringBuffer.append("\\2f");
                    continue block11;
                }
                case ':': {
                    stringBuffer.append("\\3a");
                    continue block11;
                }
                case '<': {
                    stringBuffer.append("\\3c");
                    continue block11;
                }
                case '>': {
                    stringBuffer.append("\\3e");
                    continue block11;
                }
                case '@': {
                    stringBuffer.append("\\40");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\5c");
                    continue block11;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        stringBuffer.append("\\20");
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String unescapeNode(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n = cArray.length;
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i + 2 < n) {
                char c2 = cArray[i + 1];
                char c3 = cArray[i + 2];
                if (c2 == '2') {
                    switch (c3) {
                        case '0': {
                            stringBuffer.append(' ');
                            i += 2;
                            continue block12;
                        }
                        case '2': {
                            stringBuffer.append('\"');
                            i += 2;
                            continue block12;
                        }
                        case '6': {
                            stringBuffer.append('&');
                            i += 2;
                            continue block12;
                        }
                        case '7': {
                            stringBuffer.append('\'');
                            i += 2;
                            continue block12;
                        }
                        case 'f': {
                            stringBuffer.append('/');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '3') {
                    switch (c3) {
                        case 'a': {
                            stringBuffer.append(':');
                            i += 2;
                            continue block12;
                        }
                        case 'c': {
                            stringBuffer.append('<');
                            i += 2;
                            continue block12;
                        }
                        case 'e': {
                            stringBuffer.append('>');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '4') {
                    if (c3 == '0') {
                        stringBuffer.append("@");
                        i += 2;
                        continue;
                    }
                } else if (c2 == '5' && c3 == 'c') {
                    stringBuffer.append("\\");
                    i += 2;
                    continue;
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public CommandEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(CommandEncoder commandEncoder) {
        this.encoder = commandEncoder;
    }

    public ServerStatus.ModuleSummary[] getHistory(String string) {
        return new ServerStatus.ModuleSummary[0];
    }

    public ServerStatus.ModuleSummary[] getStatus() {
        ArrayList arrayList = new ArrayList();
        try {
            Iterator iterator = MultiUserChat.getHostedRooms((XMPPConnection)this.conn, (String)this.conferenceService).iterator();
            while (iterator.hasNext()) {
                HostedRoom hostedRoom = (HostedRoom)iterator.next();
                MultiUserChat.getRoomInfo((XMPPConnection)this.conn, (String)hostedRoom.getJid());
            }
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return arrayList.toArray(new ServerStatus.ModuleSummary[arrayList.size()]);
    }

    public String[] getSupportedTimeRanges() {
        return new String[0];
    }

    private class MonitorRooms
    implements PacketListener,
    ParticipantStatusListener {
        private static final String PLAYER_CHANGED_ROOMS = "PLAYER_CHANGED_ROOMS";
        private static final String SEND_ROOM = "SEND_ROOM";
        private static final String NEW_ROOM = "newRoom";
        private static final String OLD_ROOM = "oldRoom";
        private MultiUserChat monitorRoom;
        private Map playerToRoom;
        private Map jidToRoom;
        private Map jidToPlayer;
        private Comparator roomSortOrder;

        public MonitorRooms() throws XMPPException {
            block3: {
                this.playerToRoom = new HashMap();
                this.jidToRoom = new HashMap();
                this.jidToPlayer = new HashMap();
                this.roomSortOrder = new Comparator(this){
                    private final /* synthetic */ MonitorRooms this$1;
                    {
                        this.this$1 = monitorRooms;
                    }

                    public int compare(Object object, Object object2) {
                        JabberRoom jabberRoom = (JabberRoom)object;
                        JabberRoom jabberRoom2 = (JabberRoom)object2;
                        if (((Object)jabberRoom).equals(JabberClient.access$100(MonitorRooms.access$000(this.this$1))) && !((Object)jabberRoom2).equals(JabberClient.access$100(MonitorRooms.access$000(this.this$1)))) {
                            return -1;
                        }
                        if (((Object)jabberRoom2).equals(JabberClient.access$100(MonitorRooms.access$000(this.this$1))) && !((Object)jabberRoom).equals(JabberClient.access$100(MonitorRooms.access$000(this.this$1)))) {
                            return 1;
                        }
                        return jabberRoom.getName().compareTo(jabberRoom2.getName());
                    }
                };
                this.monitorRoom = new MultiUserChat(JabberClient.this.conn, JabberClient.escapeNode(JabberClient.this.getModule()) + "@" + JabberClient.this.getConferenceService());
                this.monitorRoom.join(JabberClient.this.me.getName());
                try {
                    this.monitorRoom.sendConfigurationForm(new Form("submit"));
                }
                catch (XMPPException xMPPException) {
                    if (xMPPException.getXMPPError().getCode() == 403) break block3;
                    throw xMPPException;
                }
            }
            Iterator iterator = this.monitorRoom.getOccupants();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.updateRooms(string);
            }
            this.monitorRoom.addMessageListener((PacketListener)this);
            this.monitorRoom.addParticipantStatusListener((ParticipantStatusListener)this);
        }

        public Room[] getAvailableRooms() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            HashSet hashSet = new HashSet(this.playerToRoom.values());
            Room[] roomArray = hashSet.iterator();
            while (roomArray.hasNext()) {
                String string = (String)roomArray.next();
                Object v = this.jidToRoom.get(string);
                if (v == null) continue;
                arrayList.add(v);
            }
            if (!arrayList.contains(JabberClient.this.defaultRoom)) {
                arrayList.add(JabberClient.this.defaultRoom);
            }
            roomArray = arrayList.toArray(new Room[arrayList.size()]);
            Arrays.sort(roomArray, this.roomSortOrder);
            return roomArray;
        }

        public JabberRoom getCurrentRoom() {
            String string = JabberClient.this.getCurrentRoomJID();
            return (JabberRoom)this.jidToRoom.get(string);
        }

        public void sendRoomChanged(String string, String string2) throws XMPPException {
            Message message = this.monitorRoom.createMessage();
            if (string != null) {
                message.setProperty(OLD_ROOM, (Object)string);
            }
            if (string2 != null) {
                message.setProperty(NEW_ROOM, (Object)string2);
            }
            message.setBody(PLAYER_CHANGED_ROOMS);
            this.monitorRoom.sendMessage(message);
        }

        public void disconnect() {
            this.monitorRoom.leave();
        }

        public void updateRooms(String string) throws XMPPException {
            this.removeFromCurrentRoom(string);
            JabberPlayer jabberPlayer = this.getPlayer(string);
            String string2 = null;
            Iterator iterator = MultiUserChat.getJoinedRooms((XMPPConnection)JabberClient.this.conn, (String)string);
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string3.equals(this.monitorRoom.getRoom())) continue;
                string2 = string3;
            }
            if (string2 != null) {
                this.addToRoom(string, string2);
            }
        }

        private void addToRoom(String string, String string2) throws XMPPException {
            JabberPlayer jabberPlayer = this.getPlayer(string);
            JabberRoom jabberRoom = this.getRoom(string2);
            jabberRoom.addPlayer(jabberPlayer);
            this.playerToRoom.put(string, string2);
        }

        private JabberRoom getRoom(String string) throws XMPPException {
            JabberRoom jabberRoom = (JabberRoom)this.jidToRoom.get(string);
            if (jabberRoom == null) {
                jabberRoom = JabberRoom.createFromJID(JabberClient.this, string);
                this.jidToRoom.put(string, jabberRoom);
            }
            return jabberRoom;
        }

        public void processPacket(Packet packet) {
            Message message = (Message)packet;
            if (message.getProperty(NEW_ROOM) != null) {
                try {
                    this.processRoomChange(packet.getFrom(), (String)message.getProperty(NEW_ROOM));
                    JabberClient.this.fireRoomsUpdated();
                    this.updateCurrentRoom((String)message.getProperty(NEW_ROOM));
                    this.updateCurrentRoom((String)message.getProperty(OLD_ROOM));
                }
                catch (XMPPException xMPPException) {
                    JabberClient.this.reportXMPPException(xMPPException);
                }
            }
        }

        public void joined(String string) {
        }

        public void left(String string) {
            String string2 = (String)this.playerToRoom.get(string);
            this.removeFromCurrentRoom(string);
            JabberClient.this.fireRoomsUpdated();
            this.updateCurrentRoom(string2);
        }

        private void updateCurrentRoom(String string) {
            String string2 = JabberClient.this.getCurrentRoomJID();
            if (string2 != null && string2.equals(string)) {
                JabberClient.this.propSupport.firePropertyChange("Room", null, this.getCurrentRoom());
            }
        }

        private void processRoomChange(String string, String string2) throws XMPPException {
            this.removeFromCurrentRoom(string);
            if (string2 != null) {
                this.addToRoom(string, string2);
            }
            this.updateCurrentRoom(string2);
        }

        private void removeFromCurrentRoom(String string) {
            JabberRoom jabberRoom;
            JabberPlayer jabberPlayer = this.getPlayer(string);
            String string2 = (String)this.playerToRoom.remove(string);
            if (string2 != null && (jabberRoom = (JabberRoom)this.jidToRoom.get(string2)) != null) {
                jabberRoom.removePlayer(jabberPlayer);
                if (jabberRoom.getPlayerList().size() == 0) {
                    this.jidToRoom.remove(string2);
                }
            }
        }

        private JabberPlayer getPlayer(String string) {
            JabberPlayer jabberPlayer = (JabberPlayer)this.jidToPlayer.remove(string);
            if (jabberPlayer == null) {
                jabberPlayer = new JabberPlayer(StringUtils.parseResource((String)string), string);
                this.jidToPlayer.put(string, jabberPlayer);
            }
            return jabberPlayer;
        }

        public void kicked(String string, String string2, String string3) {
        }

        public void voiceGranted(String string) {
        }

        public void voiceRevoked(String string) {
        }

        public void banned(String string, String string2, String string3) {
        }

        public void membershipGranted(String string) {
        }

        public void membershipRevoked(String string) {
        }

        public void moderatorGranted(String string) {
        }

        public void moderatorRevoked(String string) {
        }

        public void ownershipGranted(String string) {
        }

        public void ownershipRevoked(String string) {
        }

        public void adminGranted(String string) {
        }

        public void adminRevoked(String string) {
        }

        public void nicknameChanged(String string, String string2) {
        }

        static /* synthetic */ JabberClient access$000(MonitorRooms monitorRooms) {
            return monitorRooms.JabberClient.this;
        }
    }
}

