/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.chat.LockableRoom;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.JabberPlayer;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;

public class JabberRoom
extends SimpleRoom
implements LockableRoom {
    private String jid;
    private RoomInfo info;

    private JabberRoom(JabberClient jabberClient, String string, String string2, RoomInfo roomInfo) {
        super(string);
        this.jid = string2;
        this.info = roomInfo;
    }

    public String getJID() {
        return this.jid;
    }

    public boolean isLocked() {
        return this.info != null && this.info.isMembersOnly();
    }

    public MultiUserChat join(JabberClient jabberClient, JabberPlayer jabberPlayer) throws XMPPException {
        MultiUserChat multiUserChat;
        block4: {
            multiUserChat = new MultiUserChat(jabberClient.getConnection(), this.getJID());
            multiUserChat.join(jabberPlayer.getName());
            try {
                multiUserChat.sendConfigurationForm(new Form("submit"));
            }
            catch (XMPPException xMPPException) {
                if (xMPPException.getXMPPError().getCode() == 403) break block4;
                throw xMPPException;
            }
        }
        try {
            multiUserChat.changeSubject(this.getName());
        }
        catch (XMPPException xMPPException) {
            // empty catch block
        }
        multiUserChat.addMessageListener((PacketListener)jabberClient);
        return multiUserChat;
    }

    public boolean equals(Object object) {
        if (object instanceof JabberRoom) {
            JabberRoom jabberRoom = (JabberRoom)object;
            return jabberRoom.jid.equals(this.jid);
        }
        return false;
    }

    public int hashCode() {
        return this.jid.hashCode();
    }

    public static JabberRoom createFromJID(JabberClient jabberClient, String string) throws XMPPException {
        RoomInfo roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)jabberClient.getConnection(), (String)string);
        String string2 = roomInfo.getSubject();
        if (string2 == null) {
            string2 = "<no name>";
        }
        return new JabberRoom(jabberClient, string2, string, roomInfo);
    }

    public static JabberRoom createLocal(JabberClient jabberClient, String string) {
        String string2 = JabberClient.escapeNode(jabberClient.getModule() + "/" + string).toLowerCase() + "@" + jabberClient.getConferenceService();
        return new JabberRoom(jabberClient, string, string2, null);
    }
}

