/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.messageboard;

import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.messageboard.MessageViewer;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MessageBoardControls {
    private MessageBoard server;
    private String serverName;
    private Action checkMessagesAction;
    private Action postMessageAction;
    private MessageViewer viewer;
    private JFrame msgFrame;
    private JFrame msgComposer;

    public MessageBoardControls() {
        this.initComponents();
        this.setServer(null, null);
    }

    public void setServer(MessageBoard messageBoard, String string) {
        this.server = messageBoard;
        this.serverName = string;
        this.checkMessagesAction.setEnabled(this.server != null);
        this.postMessageAction.setEnabled(this.server != null);
    }

    public void showMessages(Message[] messageArray) {
        Vector<Message> vector = new Vector<Message>();
        for (int i = 0; i < messageArray.length; ++i) {
            vector.addElement(messageArray[i]);
        }
        this.viewer.setMessages(vector.elements());
    }

    private void initComponents() {
        this.viewer = new MessageViewer();
        this.msgFrame = new JFrame("Message Board");
        this.msgFrame.setDefaultCloseOperation(1);
        this.msgFrame.getContentPane().setLayout(new BoxLayout(this.msgFrame.getContentPane(), 1));
        this.msgFrame.getContentPane().add(this.viewer);
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Refresh");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageBoardControls.this.msgFrame.setTitle(MessageBoardControls.this.serverName != null ? MessageBoardControls.this.serverName + " Message Board" : "Message Board");
                MessageBoardControls.this.showMessages(MessageBoardControls.this.server.getMessages());
            }
        });
        box.add(jButton);
        jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)MessageBoardControls.this.msgFrame).setVisible(false);
            }
        });
        box.add(jButton);
        this.msgFrame.getContentPane().add(box);
        this.msgComposer = new Comp();
        this.checkMessagesAction = new AbstractAction("Check Messages"){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageBoardControls.this.msgFrame.setTitle(MessageBoardControls.this.serverName != null ? MessageBoardControls.this.serverName + " Message Board" : "Message Board");
                MessageBoardControls.this.showMessages(MessageBoardControls.this.server.getMessages());
                ((Component)MessageBoardControls.this.msgFrame).setVisible(true);
            }
        };
        URL uRL = this.getClass().getResource("/images/getMessages.gif");
        if (uRL != null) {
            this.checkMessagesAction.putValue("ShortDescription", this.checkMessagesAction.getValue("Name"));
            this.checkMessagesAction.putValue("Name", "");
            this.checkMessagesAction.putValue("SmallIcon", new ImageIcon(uRL));
        }
        this.postMessageAction = new AbstractAction("Post Message"){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)MessageBoardControls.this.msgComposer).setVisible(true);
            }
        };
        uRL = this.getClass().getResource("/images/postMessage.gif");
        if (uRL != null) {
            this.postMessageAction.putValue("ShortDescription", this.postMessageAction.getValue("Name"));
            this.postMessageAction.putValue("Name", "");
            this.postMessageAction.putValue("SmallIcon", new ImageIcon(uRL));
        }
        this.msgFrame.pack();
        ((Component)this.msgFrame).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.msgFrame.getSize().width / 2, 0);
    }

    public Action getCheckMessagesAction() {
        return this.checkMessagesAction;
    }

    public Action getPostMessageAction() {
        return this.postMessageAction;
    }

    private class Comp
    extends JFrame {
        private Comp() {
            super("Message Composer");
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setDefaultCloseOperation(1);
            JTextArea jTextArea = new JTextArea(15, 60);
            Box box = Box.createHorizontalBox();
            JButton jButton = new JButton("Send");
            jButton.addActionListener(new ActionListener(this, jTextArea){
                private final /* synthetic */ JTextArea val$msgArea;
                private final /* synthetic */ Comp this$1;
                {
                    this.this$1 = comp;
                    this.val$msgArea = jTextArea;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    MessageBoardControls.access$200(Comp.access$500(this.this$1)).postMessage(this.val$msgArea.getText());
                    ((Component)this.this$1).setVisible(false);
                    this.val$msgArea.setText("");
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(this, jTextArea){
                private final /* synthetic */ JTextArea val$msgArea;
                private final /* synthetic */ Comp this$1;
                {
                    this.this$1 = comp;
                    this.val$msgArea = jTextArea;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)this.this$1).setVisible(false);
                    this.val$msgArea.setText("");
                }
            });
            box.add(jButton);
            box.add(jButton2);
            this.getContentPane().add(new JScrollPane(jTextArea));
            this.getContentPane().add(box);
            this.pack();
            ((Component)this).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getSize().width / 2, 0);
        }

        static /* synthetic */ MessageBoardControls access$500(Comp comp) {
            return comp.MessageBoardControls.this;
        }
    }
}

