/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.messageboard;

import VASSAL.chat.messageboard.Message;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class MessageViewer
extends JPanel {
    private JTable msgTable;
    private DefaultTableModel model;
    private JTextArea msgText;
    private Vector msgList = new Vector();

    public MessageViewer() {
        this.initComponents();
    }

    public void setMessages(Enumeration enumeration) {
        this.msgList.removeAllElements();
        this.msgText.setText("");
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("Sender");
        vector2.addElement("Date");
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            this.msgList.addElement(message);
            Vector<String> vector3 = new Vector<String>();
            vector3.addElement(message.getSender());
            vector3.addElement(message.getDate().toString());
            vector.addElement(vector3);
        }
        this.model = new DefaultTableModel(vector, vector2);
        this.msgTable.setModel(this.model);
        if (this.msgList.size() > 0) {
            this.msgTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void initComponents() {
        JSplitPane jSplitPane = new JSplitPane(1);
        this.model = new DefaultTableModel(new Object[]{"Sender", "Date"}, 0);
        this.msgTable = new JTable(this.model);
        this.msgTable.getSelectionModel().addListSelectionListener(new ShowMsgText());
        JScrollPane jScrollPane = new JScrollPane(this.msgTable);
        jSplitPane.add(jScrollPane);
        this.msgText = new JTextArea(10, 25);
        this.msgText.setLineWrap(true);
        this.msgText.setWrapStyleWord(true);
        this.msgText.setEditable(false);
        jScrollPane = new JScrollPane(this.msgText);
        jScrollPane.setBorder(new TitledBorder("Message"));
        jSplitPane.add(jScrollPane);
        this.add(jSplitPane);
    }

    private class ShowMsgText
    implements ListSelectionListener {
        private ShowMsgText() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = MessageViewer.this.msgTable.getSelectedRow();
            if (n >= 0 && n < MessageViewer.this.msgList.size()) {
                Message message = (Message)MessageViewer.this.msgList.elementAt(n);
                MessageViewer.this.msgText.setText(message.getText());
            } else {
                MessageViewer.this.msgText.setText("");
            }
        }
    }
}

