/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.ServerNode;
import VASSAL.chat.node.StatusReporter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;

public class AsynchronousServerNode
extends ServerNode {
    private static Logger logger = Logger.getLogger((class$VASSAL$chat$node$AsynchronousServerNode == null ? (class$VASSAL$chat$node$AsynchronousServerNode = AsynchronousServerNode.class$("VASSAL.chat.node.AsynchronousServerNode")) : class$VASSAL$chat$node$AsynchronousServerNode).getName());
    private StatusReporter statusReporter;
    private ReportContentsThread contentsReporter;
    static /* synthetic */ Class class$VASSAL$chat$node$AsynchronousServerNode;

    public AsynchronousServerNode(String string) {
        this.init(string);
    }

    protected void init(String string) {
        this.statusReporter = new StatusReporter(string == null ? null : new HttpRequestWrapper(string), this);
        this.contentsReporter = new ReportContentsThread(this);
    }

    protected synchronized void sendContents(Node node) {
        this.contentsReporter.markChanged(node);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ReportContentsThread
    extends Thread {
        private AsynchronousServerNode server;
        private HashSet changed;
        private long lastGlobalUpdate;
        private static final long GLOBAL_UPDATE_INTERVAL = 120000L;

        public ReportContentsThread(AsynchronousServerNode asynchronousServerNode) {
            this.server = asynchronousServerNode;
            this.changed = new HashSet();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ReportContentsThread reportContentsThread = this;
                        synchronized (reportContentsThread) {
                            this.wait();
                            this.sendContents();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private synchronized void sendContents() {
            Iterator<Object> iterator;
            this.server.statusReporter.updateContents(this.server.getLeafDescendants());
            long l = System.currentTimeMillis();
            if (l - this.lastGlobalUpdate < 120000L) {
                iterator = Arrays.asList(this.server.getChildren()).iterator();
                this.lastGlobalUpdate = l;
            } else {
                iterator = this.changed.iterator();
            }
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                logger.fine("Sending contents of " + node.getId());
                Node[] nodeArray = node.getLeafDescendants();
                Node[] nodeArray2 = node.getChildren();
                String string = Protocol.encodeListCommand(nodeArray);
                logger.finer(string);
                node.send(string);
                String string2 = Protocol.encodeRoomsInfo(nodeArray2);
                node.send(string2);
            }
            this.changed.clear();
        }

        public synchronized void markChanged(Node node) {
            logger.fine(node + " has changed");
            this.changed.add(node);
            this.notifyAll();
        }
    }
}

