/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.build.GameModule;
import VASSAL.chat.Base64;
import VASSAL.chat.CgiServerStatus;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Compressor;
import VASSAL.chat.MainRoomChecker;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.PrivateChatEncoder;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.SoundEncoder;
import VASSAL.chat.SynchEncoder;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.NodePlayer;
import VASSAL.chat.node.NodeRoom;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.LockableRoomControls;
import VASSAL.chat.ui.LockableRoomTreeRenderer;
import VASSAL.chat.ui.MessageBoardControlsInitializer;
import VASSAL.chat.ui.PrivateMessageAction;
import VASSAL.chat.ui.RoomInteractionControlsInitializer;
import VASSAL.chat.ui.SendSoundAction;
import VASSAL.chat.ui.ServerStatusControlsInitializer;
import VASSAL.chat.ui.ShowProfileAction;
import VASSAL.chat.ui.SimpleStatusControlsInitializer;
import VASSAL.chat.ui.SynchAction;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Properties;

public abstract class NodeClient
implements ChatServerConnection,
PlayerEncoder,
ChatControlsInitializer {
    public static final String ZIP_HEADER = "!ZIP!";
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected NodePlayer me;
    protected SimpleRoom currentRoom;
    protected String defaultRoomName = "Main Room";
    protected NodeRoom[] allRooms = new NodeRoom[0];
    protected MessageBoard msgSvr;
    protected WelcomeMessageServer welcomer;
    protected ServerStatus serverStatus;
    protected String moduleName;
    protected String playerId;
    protected MainRoomChecker checker = new MainRoomChecker();
    protected int compressionLimit = 1000;
    protected CommandEncoder encoder;
    protected MessageBoardControlsInitializer messageBoardControls;
    protected RoomInteractionControlsInitializer roomControls;
    protected ServerStatusControlsInitializer serverStatusControls;
    protected SimpleStatusControlsInitializer playerStatusControls;
    protected SoundEncoder soundEncoder;
    protected PrivateChatEncoder privateChatEncoder;
    protected SynchEncoder synchEncoder;
    protected PropertyChangeListener nameChangeListener;
    protected PropertyChangeListener profileChangeListener;

    public NodeClient(String string, String string2, CommandEncoder commandEncoder, MessageBoard messageBoard, WelcomeMessageServer welcomeMessageServer) {
        this.encoder = commandEncoder;
        this.msgSvr = messageBoard;
        this.welcomer = welcomeMessageServer;
        this.playerId = string2;
        this.moduleName = string;
        this.serverStatus = new CgiServerStatus();
        this.me = new NodePlayer(string2);
        this.messageBoardControls = new MessageBoardControlsInitializer("Messages", messageBoard);
        this.roomControls = new LockableRoomControls(this);
        this.roomControls.addPlayerActionFactory(ShowProfileAction.factory());
        this.roomControls.addPlayerActionFactory(SynchAction.factory(this));
        this.roomControls.addPlayerActionFactory(PrivateMessageAction.factory(this, new PrivateChatManager(this)));
        this.roomControls.addPlayerActionFactory(SendSoundAction.factory(this, "Send Wake-up", "wakeUpSound", "phone1.wav"));
        this.serverStatusControls = new ServerStatusControlsInitializer(this.serverStatus);
        this.playerStatusControls = new SimpleStatusControlsInitializer(this);
        this.synchEncoder = new SynchEncoder(this, this);
        this.privateChatEncoder = new PrivateChatEncoder(this, new PrivateChatManager(this));
        this.soundEncoder = new SoundEncoder();
        this.nameChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SimplePlayer simplePlayer = (SimplePlayer)NodeClient.this.getUserInfo();
                simplePlayer.setName((String)propertyChangeEvent.getNewValue());
                NodeClient.this.setUserInfo(simplePlayer);
            }
        };
        this.profileChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SimplePlayer simplePlayer = (SimplePlayer)NodeClient.this.getUserInfo();
                SimpleStatus simpleStatus = (SimpleStatus)simplePlayer.getStatus();
                simpleStatus = new SimpleStatus(simpleStatus.isLooking(), simpleStatus.isAway(), (String)propertyChangeEvent.getNewValue());
                simplePlayer.setStatus(simpleStatus);
                NodeClient.this.setUserInfo(simplePlayer);
            }
        };
    }

    public void setConnected(boolean bl) {
        if (bl) {
            if (!this.isConnected()) {
                try {
                    NodePlayer nodePlayer = this.me;
                    this.me = new NodePlayer(this.playerId);
                    this.setUserInfo(nodePlayer);
                    this.initializeConnection();
                    Command command = this.welcomer.getWelcomeMessage();
                    if (command != null) {
                        command.execute();
                    }
                    this.registerNewConnection();
                }
                catch (IOException iOException) {
                    this.propSupport.firePropertyChange("Status", null, "Unable to establish connection to server:  " + iOException.getMessage());
                }
            }
        } else {
            if (this.isConnected()) {
                this.closeConnection();
            }
            this.currentRoom = null;
            this.allRooms = new NodeRoom[0];
        }
        this.propSupport.firePropertyChange("Connected", null, this.isConnected() ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void registerNewConnection() {
        String string;
        String string2 = new SequenceEncoder(this.moduleName, '/').append(this.defaultRoomName).getValue();
        this.send(Protocol.encodeRegisterCommand(this.me.getId(), string2, new PropertiesEncoder(this.me.toProperties()).getStringValue()));
        if (GameModule.getGameModule() != null && (string = (String)GameModule.getGameModule().getPrefs().getValue("Login")) != null) {
            this.send(Protocol.encodeLoginCommand(string));
        }
    }

    protected abstract void closeConnection();

    protected abstract void initializeConnection() throws IOException;

    public abstract void send(String var1);

    public void setDefaultRoomName(String string) {
        this.defaultRoomName = string;
    }

    protected void sendStats() {
        if (this.isConnected()) {
            this.send(Protocol.encodeStatsCommand(new PropertiesEncoder(this.me.toProperties()).getStringValue()));
        }
    }

    public void sendToOthers(Command command) {
        this.sendToOthers(this.encoder.encode(command));
    }

    public void sendToAll(String string) {
        if (this.currentRoom != null) {
            String string2 = new SequenceEncoder(this.moduleName, '/').append(this.currentRoom.getName()).getValue();
            this.forward(string2, string);
        }
    }

    public void forward(String string, String string2) {
        if (this.isConnected() && this.currentRoom != null && string2 != null) {
            if ((string2 = this.checker.filter(string2, this.defaultRoomName, this.currentRoom.getName())).length() > this.compressionLimit) {
                try {
                    string2 = ZIP_HEADER + Base64.encodeBytes(Compressor.compress(string2.getBytes("UTF-8")), false);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.send(Protocol.encodeForwardCommand(string, string2));
        }
    }

    public void sendToOthers(String string) {
        if (this.currentRoom != null) {
            String string2 = new SequenceEncoder(this.moduleName, '/').append(this.currentRoom.getName()).append("~" + this.me.getId()).getValue();
            this.forward(string2, string);
        }
    }

    public void sendTo(Player player, Command command) {
        String string = new SequenceEncoder(this.moduleName, '/').append("*").append(((NodePlayer)player).getId()).getValue();
        this.forward(string, this.encoder.encode(command));
    }

    public Room getRoom() {
        return this.currentRoom;
    }

    public Room[] getAvailableRooms() {
        return this.allRooms;
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public Player getUserInfo() {
        return this.me;
    }

    public NodePlayer getMyInfo() {
        return this.me;
    }

    public void setUserInfo(Player player) {
        this.me.setName(player.getName());
        this.me.setStatus(player.getStatus());
        this.sendStats();
        this.propSupport.firePropertyChange("Player", null, this.me);
    }

    public void lockRoom(NodeRoom nodeRoom) {
        if (nodeRoom.getOwner().equals(this.me.getId())) {
            nodeRoom.lock();
            this.sendRoomInfo(nodeRoom);
        }
    }

    public void sendRoomInfo(NodeRoom nodeRoom) {
        Node node = new Node(null, nodeRoom.getName(), new PropertiesEncoder(nodeRoom.getInfo()).getStringValue());
        if (this.isConnected()) {
            String string = Protocol.encodeRoomsInfo(new Node[]{node});
            this.send(string);
        }
    }

    public void setRoom(Room room) {
        if (this.isConnected()) {
            String string = room.getName();
            String string2 = new SequenceEncoder(this.moduleName, '/').append(string).getValue();
            String string3 = Protocol.encodeJoinCommand(string2);
            this.send(string3);
        }
    }

    public void handleMessageFromServer(String string) {
        Node node = Protocol.decodeListCommand(string);
        if (node != null) {
            Node node2 = node.getChild(this.moduleName);
            if (node2 != null) {
                this.updateRooms(node2);
            }
        } else {
            Properties properties = Protocol.decodeRoomsInfo(string);
            if (properties != null) {
                for (int i = 0; i < this.allRooms.length; ++i) {
                    String string2 = properties.getProperty(this.allRooms[i].getName());
                    if (string2 == null || string2.length() <= 0) continue;
                    try {
                        Properties properties2 = new PropertiesEncoder(string2).getProperties();
                        this.allRooms[i].setInfo(properties2);
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.propSupport.firePropertyChange("Room", null, this.currentRoom);
                this.propSupport.firePropertyChange("AvailableRooms", null, this.allRooms);
            } else if (Protocol.decodeRegisterRequest(string)) {
                this.registerNewConnection();
            } else {
                if (string.startsWith(ZIP_HEADER)) {
                    try {
                        string = new String(Compressor.decompress(Base64.decode(string.substring(ZIP_HEADER.length()))), "UTF-8");
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.propSupport.firePropertyChange("Msg", null, string);
            }
        }
    }

    protected void updateRooms(Node node) {
        Node[] nodeArray = node.getChildren();
        NodeRoom[] nodeRoomArray = new NodeRoom[nodeArray.length];
        int n = -1;
        for (int i = 0; i < nodeArray.length; ++i) {
            Node[] nodeArray2 = nodeArray[i].getChildren();
            Player[] playerArray = new NodePlayer[nodeArray2.length];
            boolean bl = false;
            for (int j = 0; j < nodeArray2.length; ++j) {
                playerArray[j] = new NodePlayer(nodeArray2[j].getId());
                if (((NodePlayer)playerArray[j]).equals(this.me)) {
                    bl = true;
                }
                try {
                    Properties properties = new PropertiesEncoder(nodeArray2[j].getInfo()).getProperties();
                    ((NodePlayer)playerArray[j]).setInfo(properties);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            nodeRoomArray[i] = new NodeRoom(nodeArray[i].getId(), playerArray);
            try {
                if (nodeArray[i].getInfo() != null) {
                    nodeRoomArray[i].setInfo(new PropertiesEncoder(nodeArray[i].getInfo()).getProperties());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bl) {
                this.currentRoom = nodeRoomArray[i];
            }
            if (!this.defaultRoomName.equals(nodeRoomArray[i].getName())) continue;
            n = i;
        }
        if (n < 0) {
            this.allRooms = new NodeRoom[nodeRoomArray.length + 1];
            System.arraycopy(nodeRoomArray, 0, this.allRooms, 1, nodeRoomArray.length);
            this.allRooms[0] = new NodeRoom(this.defaultRoomName);
        } else {
            this.allRooms = nodeRoomArray;
            NodeRoom nodeRoom = this.allRooms[0];
            this.allRooms[0] = this.allRooms[n];
            this.allRooms[n] = nodeRoom;
        }
        this.propSupport.firePropertyChange("Room", null, this.currentRoom);
        this.propSupport.firePropertyChange("AvailableRooms", null, this.allRooms);
    }

    public MessageBoard getMessageServer() {
        return this.msgSvr;
    }

    public Message[] getMessages() {
        return this.msgSvr.getMessages();
    }

    public void postMessage(String string) {
        this.msgSvr.postMessage(string);
    }

    public Player stringToPlayer(String string) {
        NodePlayer nodePlayer = null;
        try {
            PropertiesEncoder propertiesEncoder = new PropertiesEncoder(string);
            nodePlayer = new NodePlayer(null);
            nodePlayer.setInfo(propertiesEncoder.getProperties());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return nodePlayer;
    }

    public String playerToString(Player player) {
        Properties properties = ((NodePlayer)player).toProperties();
        return new PropertiesEncoder(properties).getStringValue();
    }

    public void initializeControls(ChatServerControls chatServerControls) {
        this.playerStatusControls.initializeControls(chatServerControls);
        this.messageBoardControls.initializeControls(chatServerControls);
        this.roomControls.initializeControls(chatServerControls);
        this.serverStatusControls.initializeControls(chatServerControls);
        GameModule.getGameModule().addCommandEncoder(this.synchEncoder);
        GameModule.getGameModule().addCommandEncoder(this.privateChatEncoder);
        GameModule.getGameModule().addCommandEncoder(this.soundEncoder);
        this.me.setName((String)GameModule.getGameModule().getPrefs().getValue("RealName"));
        GameModule.getGameModule().getPrefs().getOption("RealName").addPropertyChangeListener(this.nameChangeListener);
        SimpleStatus simpleStatus = (SimpleStatus)this.me.getStatus();
        simpleStatus = new SimpleStatus(simpleStatus.isLooking(), simpleStatus.isAway(), (String)GameModule.getGameModule().getPrefs().getValue("Profile"));
        this.me.setStatus(simpleStatus);
        GameModule.getGameModule().getPrefs().getOption("Profile").addPropertyChangeListener(this.profileChangeListener);
        chatServerControls.getRoomTree().setCellRenderer(new LockableRoomTreeRenderer());
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        this.messageBoardControls.uninitializeControls(chatServerControls);
        this.roomControls.uninitializeControls(chatServerControls);
        this.serverStatusControls.uninitializeControls(chatServerControls);
        this.playerStatusControls.uninitializeControls(chatServerControls);
        GameModule.getGameModule().removeCommandEncoder(this.synchEncoder);
        GameModule.getGameModule().removeCommandEncoder(this.privateChatEncoder);
        GameModule.getGameModule().removeCommandEncoder(this.soundEncoder);
        GameModule.getGameModule().getPrefs().getOption("RealName").removePropertyChangeListener(this.nameChangeListener);
        GameModule.getGameModule().getPrefs().getOption("Profile").removePropertyChangeListener(this.profileChangeListener);
    }

    public abstract /* synthetic */ boolean isConnected();
}

